// windowtable.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#ifdef __GNUG__
#pragma implementation
#endif

#include <math.h>
#include "localdefs.h"
#include "windowtable.h"

void
WindowingTable::applyTo(float* frame) {
	double* tab = table;
	for(int i = 0; i < size(); i++)
		*frame++ *= *tab++;
}

void
WindowingTable::applyTo(double* frame) {
	double* tab = table;
	for(int i = 0; i < size(); i++)
		*frame++ *= *tab++;
}

//********

HanningWindow::HanningWindow(int size) : WindowingTable(size) {
	int tsize = size - 1;
	static const double TwoPi = 2.0 * M_PI;
	for(int loc = 1; loc < tsize; loc++) {
		table[loc] = 0.5 - 0.5 * cos(TwoPi * double(loc-1)/(tsize-1));
	}
}

//********

HammingWindow::HammingWindow(int size) : WindowingTable(size) {
	int tsize = size - 1;
	double tmp = M_PI / double(tsize);
	for(int loc = 1; loc < tsize; loc++) {
		table[loc] = .54 + .46 * cos(tmp * (loc + .5));
	}
}

