/*
 * stream.c
 *
 * 
 *
 * Copyright (c) 1988, 89, 90, 91, 92, 93 Miguel Santana
 * Copyright (c) 1995, 96, 97, 98 Akim Demaille, Miguel Santana
 */

/*
 * This file is part of a2ps.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * $Id: stream.c,v 1.6 1998/03/04 16:20:33 demaille Exp $
 */

#include "a2ps.h"
#include "stream.h"
#include "routines.h"

/*
 * Open for reading
 */
static inline struct stream *
_stream_ropen (const char * command, boolean is_file)
{
  NEW (struct stream, res);

  res->is_file = is_file;
  if (!res->is_file)
    res->fp = xrpopen (command);
  else
    {
      if (!IS_EMPTY (command))
	res->fp = xrfopen (command);
      else
	res->fp  = stdin;
    }
  return res;
}

/*
 * Inline wrapper
 */
struct stream *
stream_ropen (const char * command, boolean is_file)
{
  return _stream_ropen (command, is_file);
}

/*
 * Open for writing
 */
static inline struct stream *
_stream_wopen (const char * command, boolean is_file)
{
  NEW (struct stream, res);

  res->is_file = is_file;
  if (!res->is_file)
    res->fp = xwpopen (command);
  else
    {
      if (!IS_EMPTY (command))
	res->fp = xwfopen (command);
      else
	res->fp  = stdout;
    }
  return res;
}

/*
 * Inline wrapper
 */
struct stream *
stream_wopen (const char * command, boolean is_file)
{
  return _stream_wopen (command, is_file);
}

/*
 * Uses the perl convention to know whether file or pipe
 * I.e., command starts by '>', or '|'
 */
struct stream *
stream_perl_open (const char * perl_command)
{
  char const * command;
  char * cp;
  int len;

  command = perl_command + strspn (perl_command, "\t >|");

  switch (*perl_command) {
  case '|':
    return _stream_wopen (command, TRUE);

  case '>':
    return _stream_wopen (command, FALSE);

  default:
    len = strlen (perl_command);
    switch (perl_command [len - 1]) {
    case '|':
      cp = ALLOCA (char, len);
      strncpy (cp, command, len - 1);
      return _stream_ropen (cp, TRUE);
      
    default:
      return _stream_ropen (command, FALSE);
    }
  }
}

/*
 * Closes and frees.
 */
void
stream_close (struct stream * stream)
{
  if (stream->is_file)
    fclose (stream->fp);
  else
    pclose (stream->fp);
  FREE (stream);
}
