#! /usr/bin/perl

# FILE:   wlc.pl
# DOEL:   correction of wordlist files based on wordlist correction files
# AUTEUR: Erick Branderhorst

$version = 1.0;# VERSIE: 0.0 (augustus 1996)
# COPYRIGHT: GPL

use Getopt::Long;
use English;

$version= '0.0'; # This line modified by Makefile
sub version 
{
    return "wlc - NTG dutch $version";
}

sub show_version
{
    print version, "\n";
    exit 0;
}

sub license {
    print <<END;
wlc - NTG dutch $version  Copyright (C) 1996 Erick Branderhorst.
This is free software; see the GNU General Public Licence version 2 or
later for copying conditions.  There is NO warranty.
END
}

sub usage {
    print <<END;
This usage message isn't up to date.
usage: wlc [--version] [--help] [--debug] [--maxwidth=nnn]
             [--section regexp title] [--infodir=xxx] [--align=nnn]
             [--calign=nnn] [--quiet] [--menuentry=xxx] [--keep-old]
             [--description=xxx] [--test] [--remove] [--] filename
END
}

sub usage1
{
    return "Try `wlc --help' for more information.\n";
}

&GetOptions('help', \&usage,
	   'version', \&show_version,
	   'license|licence', \&license,
	   'foo=s', \$foo, 
	   'bar=i', 'ar=s', \@ar) or die &usage1;

while (@ARGV) {
    $filename= shift(@ARGV);
    -f $filename || die "$0: Can't find file \`$filename'\n";
    open(WLC,"<$filename") || die "$0: Can't read file \`$filename'\n";
    while (<WLC>) {
	$_ =~ m/^([^:]*):([^ ]*) <([^ >]*) *>([^ ]*) *$/;
	$from= $3;
	$from= "$from.wl" if ! -f $from;
	-f $from || die "$0: Can't find file \`$from'\n";
	$to= $4;
	$to= "$to.wl" if ! -f $to;
	print $from, $to;
	-f $to || die "$0: Can't find file \`$to'\n";
	print $from, $to;
	open(FROM,"<$from") || die "$0: Can't read file \`$from'\n";
	while (<FROM>) {
	    print $_ if m/^$1[ \n\t]*$/;
	}
	print $1, " ", $2, " ", $3, " ", $4, "";
    }
} 

sub apply_correction {
    print "nothing yet\n";
}

