/*
 * dfile.c - Linux file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.6 98/03/06 08:22:59 abe Exp $";
#endif


#include "lsof.h"


/*
 * is_file_named() - is this file named?
 */

int
is_file_named(p, ty)
	char *p;			/* path name; NULL = search by device
					 * and inode (from *Lf) */
	umode_t ty;			/* inode mode */
{
	int f;
	struct sfile *s;
/*
 * Search the file chain.
 */
	for (f = 0, s = Sfile; s; s = s->next) {

	/*
	 * Search by path name, as requested.
	 */
		if (p != NULL) {
			if (strcmp(p, s->aname) == 0
			||  strcmp(p, s->name)  == 0)
			{
				f = 2;
				break;
			}
			continue;
		}
	/*
	 * Check for a regular file or directory -- the device and
	 * inode numbers must match.
	 */
		if (s->type) {
			if (Lf->dev == s->dev && (ino_t)Lf->inode == s->i) {
				f = 1;
				break;
			}
			continue;
		}
	/*
	 * Check for a file system match.
	 * Try to avoid matching character files to non-character devices.
	 */
		if (Lf->dev == s->dev) {
			if ( ! (ty == S_IFCHR && s->mode != S_IFCHR)) {
				f = 1;
				break;
			}
		}
	}
/*
 * Convert the name if a match occurred.
 */
	if (f) {
		if (f == 2)
			(void) strcpy(Namech, p);
		else {
			(void) strcpy(Namech, s->name);
			if (s->devnm)
				(void) sprintf(endnm(), " (%s)", s->devnm);
		}
		s->f = 1;
		return(1);
	}
	return(0);
}


/*
 * process_file() - process file
 */

void
process_file(fp)
	KA_T fp;		/* kernel file structure address */
{

#if	defined(HASDENTRY)
	struct dentry de;
#endif	/* defined(HASDENTRY) */

	int flag;

	Lf->off = (SZOFFTYPE)((struct file *)fp)->f_pos;
	if (((struct file *)fp)->f_count) {

	/*
	 * Construct access code.
	 */
		if ((flag = (((struct file *)fp)->f_mode & 3)) == 1)
			Lf->access = 'r';
		else if (flag == 2)
			Lf->access = 'w';
		else if (flag == 3)
			Lf->access = 'u';
	/*
	 * Process inode.
	 */

#if	defined(HASDENTRY)
		if (((struct file *)fp)->f_dentry
		&&  !kread((KA_T)((struct file *)fp)->f_dentry, (char *)&de,
		    sizeof(de))
		&&  de.d_inode)
			process_inode(de.d_inode, ((struct file *)fp)->f_op);
		else
			(void) enter_nm("no more information");
#else	/* !defined(HASDENTRY) */
		process_inode(((struct file *)fp)->f_inode,
		    ((struct file *)fp)->f_op);
#endif	/* defined(HASDENTRY) */

	}
}
