// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1994
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        inetsocket.h
// 
// Purpose:     
// 
// Created:     4 May 95   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#ifndef hg_utils_inetsocket_h
#define hg_utils_inetsocket_h

#include "socket.h"


class INETAddress ;
class INETSocketPtr ;
struct sockaddr_in ;

// <class> 
//  
// Name:             INETSocket
// 
// Purpose:          
// 
// an Internet domain socket (no na)
// 
// Public Interface: 
// 
// - INETSocket()
//   default constructor. the underlying file number is invalid, no operations 
//   will work. (see class File.)
// - INETSocket (int fd, boolean close)
//   assign me the file number fd which has to be closed on destruction if close 
//   is true.
// - INETSocket (const char* host, int port)
//   connect to the specified internet host. if the connection fails, the file 
//   number will be invalid.
// - INETSocket (int port)
//   opens an Internet port and starts listening on it immediately.
// - void attach (int fd, boolean close)
// - boolean connect (const char* host, int port) 
// - boolean listen (int port=0) 
//   these do the same as the corresponding constructors.
//   listen() takes an arbitrary port number if port is zero.
// - int port() const
//   the port number if listening, else -1.
// 
// </class> 
class INETSocket : public Socket {
public:
   INETSocket() ;
   INETSocket (int fd, boolean close) ;
   INETSocket (const char* host, int port, unsigned long timeout=0) ; // connect to ...
   INETSocket (const INETAddress&, unsigned long timeout=0) ; // connect to ...
   INETSocket (int port) ; // listen at ...
   virtual ~INETSocket() ;

   virtual boolean close() ;

   void attach (int fd) ;

   boolean connect (const char* host, int port, unsigned long timeout=0) ;
   boolean connect (const INETAddress&, unsigned long timeout=0) ;

   boolean thisAddress (INETAddress&) const ;
   boolean thatAddress (INETAddress&) const ;

   const INETAddress* thisAddress() const ;
   const INETAddress* thatAddress() const ;

   boolean listen (int port=0) ;
   boolean accept (int& fd) ;
   boolean accept (INETSocketPtr&, INETAddress& peer) ;
   boolean accept (INETSocketPtr&) ;
   boolean accept (SocketPtr&) ;
   int port() const ;

private:
   // dont need a length field. sockaddr_in is of constant length.
   int accept_(sockaddr_in*) ;

private:
   INETAddress* this_addr_ ;
   INETAddress* that_addr_ ;

private:
   INETSocket (const INETSocket&) {}
   INETSocket& operator = (const INETSocket&) { return *this; }

public:
   static const char* version1 ;
} ;

static const char* hg_utils_inetsocket_version = INETSocket::version1 ;

SmartPtrdeclare (INETSocketPtr, INETSocket) 



#endif
