dnl
dnl Execute arbitrary emacs lisp
dnl
AC_DEFUN(AC_EMACS_LISP, [
elisp="$2"
if test -z "$3"; then
	AC_MSG_CHECKING(for $1)
fi
AC_CACHE_VAL(EMACS_cv_SYS_$1,[
	OUTPUT=./conftest-$$
	${EMACS} -batch -eval "(let ((x ${elisp})) (write-region (if (stringp x) (princ x) (prin1-to-string x)) nil \"${OUTPUT}\"))"  > /dev/null 2>&1 
	retval=`cat ${OUTPUT}`
	rm -f ${OUTPUT}
	EMACS_cv_SYS_$1=$retval
])
$1=${EMACS_cv_SYS_$1}
if test -z "$3"; then
	AC_MSG_RESULT($$1)
fi
])

dnl
dnl Determine the emacs version we are running.
dnl Automatically substitutes @EMACS_VERSION@ with this number.
dnl
AC_DEFUN(AC_EMACS_VERSION, [
AC_MSG_CHECKING(for emacs version)
AC_EMACS_LISP(version,(and (boundp 'emacs-major-version) (format \"%d.%d\" emacs-major-version emacs-minor-version)),"noecho")

EMACS_VERSION=${EMACS_cv_SYS_version}
AC_SUBST(EMACS_VERSION)
AC_MSG_RESULT(${EMACS_VERSION})
])

dnl
dnl Determine whether the specified version of Emacs supports packages
dnl or not.  Currently, only XEmacs 20.3 does, but this is a general
dnl check.
dnl
AC_DEFUN(AC_EMACS_PACKAGES, [
AC_MSG_CHECKING(for package directory)
AC_EMACS_LISP(package_dir,(or (and (boundp 'package-path) (expand-file-name (car package-path))) \"no\"),"noecho")
if test "${EMACS_cv_SYS_package_dir}" = "no"; then
   EMACS_cv_SYS_package_dir=`cd ; pwd`/emacs
fi
AC_ARG_WITH(package-dir,      --with-package-dir        Package root, [ EMACS_cv_SYS_package_dir="${withval}"])
EMACS_PACKAGE_DIR=${EMACS_cv_SYS_package_dir}
AC_MSG_RESULT(${EMACS_PACKAGE_DIR})
])

dnl
dnl Check whether a function exists in a library
dnl All '_' characters in the first argument are converted to '-'
dnl
AC_DEFUN(AC_EMACS_CHECK_LIB, [
if test -z "$3"; then
	AC_MSG_CHECKING(for $2 in $1)
fi
library=`echo $1 | tr _ -`
AC_EMACS_LISP($1,(progn (fmakunbound '$2) (condition-case nil (progn (require '$library) (fboundp '$2)) (error nil))),"noecho")
if test "${EMACS_cv_SYS_$1}" = "nil"; then
	EMACS_cv_SYS_$1=no
fi
HAVE_$1=${EMACS_cv_SYS_$1}
AC_SUBST(HAVE_$1)
if test -z "$3"; then
	AC_MSG_RESULT($HAVE_$1)
fi
])

dnl
dnl Check whether a variable exists in a library
dnl All '_' characters in the first argument are converted to '-'
dnl
AC_DEFUN(AC_EMACS_CHECK_VAR, [
AC_MSG_CHECKING(for $2 in $1)
library=`echo $1 | tr _ -`
AC_EMACS_LISP($1,(progn (makunbound '$2) (condition-case nil (progn (require '$library) (boundp '$2)) (error nil))),"noecho")
if test "${EMACS_cv_SYS_$1}" = "nil"; then
	EMACS_cv_SYS_$1=no
fi
HAVE_$1=${EMACS_cv_SYS_$1}
AC_SUBST(HAVE_$1)
AC_MSG_RESULT($HAVE_$1)
])

dnl
dnl Perform sanity checking and try to locate the custom and widget packages
dnl
AC_DEFUN(AC_CHECK_CUSTOM, [
AC_MSG_CHECKING(for acceptable custom library)
AC_CACHE_VAL(EMACS_cv_ACCEPTABLE_CUSTOM,[
AC_EMACS_CHECK_LIB(widget,widget-convert-text,"noecho")
AC_EMACS_CHECK_LIB(wid_edit,widget-convert-text,"noecho")
if test "${HAVE_widget}" = "yes"; then
	EMACS_cv_ACCEPTABLE_CUSTOM=yes
else
	if test "${HAVE_wid_edit}" != "no"; then
		EMACS_cv_ACCEPTABLE_CUSTOM=yes
	else
		EMACS_cv_ACCEPTABLE_CUSTOM=no
	fi
fi
if test "${EMACS_cv_ACCEPTABLE_CUSTOM}" = "yes"; then
	AC_EMACS_LISP(widget_dir,(file-name-directory (locate-library \"widget\")),"noecho")
	EMACS_cv_ACCEPTABLE_CUSTOM=$EMACS_cv_SYS_widget_dir
fi
])
   AC_ARG_WITH(custom,           --with-custom             Specify where to find the custom package, [ EMACS_cv_ACCEPTABLE_CUSTOM="$withval" ])
   CUSTOM=${EMACS_cv_ACCEPTABLE_CUSTOM}
   AC_MSG_RESULT("${CUSTOM}")
])

dnl
dnl Figure out how we can rebuild the auto-autoloads.el files
dnl
AC_DEFUN(AC_CHECK_AUTOLOADS, [
AC_MSG_CHECKING(how to rebuild autoloads)
AC_CACHE_VAL(EMACS_cv_REBUILD_AUTOLOADS,[
AC_EMACS_CHECK_LIB(autoload,batch-update-directory,"noecho")
EMACS_cv_REBUILD_AUTOLOADS=${HAVE_autoload}
])
if test "${EMACS_cv_REBUILD_AUTOLOADS}" != "no"; then
   REBUILD_AUTOLOADS='$(EMACS) $(BATCHFLAGS) -eval "(setq autoload-package-name \"w3\")" -l autoload -f batch-update-directory .'
else
   REBUILD_AUTOLOADS='touch auto-autoloads.el'
fi
AC_MSG_RESULT("${REBUILD_AUTOLOADS}")
AC_SUBST(REBUILD_AUTOLOADS)
])

dnl
dnl Figure out how we can rebuild the auto-autoloads.el files
dnl
AC_DEFUN(AC_CHECK_CUSTOMLOADS, [
AC_MSG_CHECKING(how to rebuild custom autoloads)
AC_CACHE_VAL(EMACS_cv_REBUILD_CUSTOMLOADS,[
AC_EMACS_CHECK_LIB(cus_dep,Custom-make-dependencies,"noecho")
EMACS_cv_REBUILD_CUSTOMLOADS=${HAVE_cus_dep}
])
if test "${EMACS_cv_REBUILD_CUSTOMLOADS}" != "no"; then
   REBUILD_CUSTOMLOADS='$(EMACS) $(BATCHFLAGS) -l cus-dep -f Custom-make-dependencies .'
else
   REBUILD_CUSTOMLOADS='touch custom-load.el'
fi
AC_MSG_RESULT("${REBUILD_CUSTOMLOADS}")
AC_SUBST(REBUILD_CUSTOMLOADS)
])
