/* dialog.c - dialog windows for internal use
 * 
 *  WindowMaker window manager
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "wconfig.h"

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>


#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>

#include "generic/wwmlib.h"
#include "WindowMaker.h"
#include "GNUstep.h"
#include "screen.h"
#include "dialog.h"
#include "funcs.h"
#include "framewin.h"
#include "window.h"

typedef struct {
    int done;
    int result;
} pair;


static void
handler(pid_t pid, unsigned int status, void *cdata)
{
    ((pair*)cdata)->result = (char)status;
    ((pair*)cdata)->done = 1;
}


int
wMessageDialog(WScreen *scr, char *title, char *message, int type)
{
    WWindow *wwin;
    int result;
    Window parent;
    
    
    parent = XCreateSimpleWindow(dpy, scr->root_win, 0, 0, 400, 180, 0, 0, 0);

    wwin = wManageInternalWindow(scr, parent, None, NULL, 
				 (scr->scr_width - 400)/2, 
				 (scr->scr_height - 180)/2, 400, 180);

    switch (type) {
     case WD_CONFIRMATION:
	result = WMRunAlertPanel(scr->wmscreen, parent, title, message,
				 _("OK"), _("Cancel"), NULL);
	break;
	
     case WD_EXIT_CONFIRM:
	result = WMRunAlertPanel(scr->wmscreen, parent, title, message, 
				 _("Exit"), _("Cancel"), NULL);
	break;
	
     case WD_INFORMATION:
     case WD_ERROR:
     default:
	result = WMRunAlertPanel(scr->wmscreen, parent, title, message, 
				 _("OK"), NULL, NULL);
	break;
    }
    
    wUnmanageWindow(wwin, False);
    
    switch (type) {
     case WD_CONFIRMATION:
	if (result==WAPRDefault)
	    result = WDB_OK;
	else
	    result = WDB_CANCEL;
	break;
	    
     case WD_EXIT_CONFIRM:
	if (result==WAPRDefault)
	    result = WDB_EXIT;
	else
	    result = WDB_CANCEL;
	break;
	
     case WD_INFORMATION:
     case WD_ERROR:
     default:
	result = WDB_OK;
	break;
    }
    
    return result;
}



int
wInputDialog(WScreen *scr, char *title, char *message, char **text)
{
    WWindow *wwin;
    Window parent;
    char *result;

    
    parent = XCreateSimpleWindow(dpy, scr->root_win, 0, 0, 300, 150, 0, 0, 0);

    wwin = wManageInternalWindow(scr, parent, None, NULL, 
				 (scr->scr_width - 300)/2,
				 (scr->scr_height - 150)/2, 300, 150);

    result = WMInputBox(scr->wmscreen, parent, title, message, *text,
			_("OK"), _("Cancel"));
        
    wUnmanageWindow(wwin, False);
    
    if (result==NULL)
	return WDB_CANCEL;
    else {
	free(*text);
	*text = result;
	
	return WDB_OK;
    }
}



