/*
 *  WindowMaker window manager
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef WMICON_H_
#define WMICON_H_

#include "wcore.h"
#include "window.h"


typedef struct _WIconLabel {
    int x, y;
    char *text;
} WIconLabel;


typedef struct WIcon {
    WCoreWindow 	*core;
    WWindow 		*owner;	       /* owner window */
    char 		*icon_name;    /* the icon name hint */
    
    Window 		icon_win;      /* client suplied icon window */
    RImage 		*image;
    WIconLabel		*label;

    unsigned int 	show_title:1;
    unsigned int 	has_titlebar:1;
    unsigned int 	force_paint:1;

    Pixmap 		pixmap;
} WIcon;


WIcon *wIconCreateWithImage(WScreen *scr, RImage *image);
WIcon *wIconCreate(WWindow *wwin, RImage *image);
void wIconDestroy(WIcon *icon);
void wIconPaint(WIcon *icon);
void wIconUpdate(WIcon *icon);
void wIconChangeTitle(WIcon *icon, char *new_title);
void wIconChangeImage(WIcon *icon, RImage *new_image);

#endif /* WMICON_H_ */
