/*
 *  WindowMaker window manager
 * 
 *  Copyright (c) 1997 Alfredo K. Kojima
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "wconfig.h"

#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>

#include "generic/wwmlib.h"
#include "WindowMaker.h"
#include "window.h"
#include "client.h"
#include "funcs.h"
#include "properties.h"
#include "winspector.h"


extern Atom _XA_WM_DELETE_WINDOW;
extern Time LastTimestamp;

/*
 *----------------------------------------------------------------------
 * RestoreDesktop--
 * 	Puts the desktop in a usable state when exiting.
 * 
 * Side effects:
 * 	All frame windows are removed and windows are reparented
 * back to root. Windows that are outside the screen are 
 * brought to a viable place. 
 * 
 *---------------------------------------------------------------------- 
 */
void
RestoreDesktop(WScreen *scr)
{
    XGrabServer(dpy);
    wDestroyInspectorPanels();
    while (scr->focused_window) {
	scr->focused_window->flags.mapped=1;
	wUnmanageWindow(scr->focused_window, !scr->focused_window->flags.internal_window);
    }
    XUngrabServer(dpy);
    XSetInputFocus(dpy, PointerRoot, RevertToParent, CurrentTime);
    InstallWindowColormaps(NULL);
    PropCleanUp(scr->root_win);
    XSync(dpy, 0);
}


/*
 *----------------------------------------------------------------------
 * WipeDesktop--
 * 	Kills all windows in a screen. Send DeleteWindow to all windows
 * that support it and KillClient on all windows that don't.
 * 
 * Side effects:
 * 	All managed windows are closed.
 * 
 * TODO: change to XQueryTree()
 *---------------------------------------------------------------------- 
 */
void
WipeDesktop(WScreen *scr)
{
    WWindow *wwin;
    
    wwin = scr->focused_window;
    while (wwin) {
	if (wwin->protocols.DELETE_WINDOW)
	  wClientSendProtocol(wwin, _XA_WM_DELETE_WINDOW, LastTimestamp);
	else
	  wClientKill(wwin);
	wwin = wwin->prev;
    }
    XSync(dpy, False);
}

