/*****************************************************************************/
/*                                                                           */
/*  wmmail - WindowMaker Mail                                                */
/*                                                                           */
/*  Copyright (c) 1996, 1997, 1998  Per Liden                                */
/*  Copyright (c) 1997, 1998  Bryan Chan                                     */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/*                                                                           */ 
/*    util.c: utility functions                                              */
/*                                                                           */
/*****************************************************************************/

#include "wmmail.h"

#define MAX_ERRORMSG_LENGTH  256

void *safe_malloc (unsigned msize)
{
  void *memory;

  if (memory = (void *) calloc (1, msize))
    return memory;

  croak("out of memory");
  exit (ERR_MEM);
}


void *safe_realloc (void *memory, unsigned msize)
{
  if (memory = (void *) realloc (memory, msize))
    return memory;

  croak("out of memory");
  exit (ERR_MEM);
}


void *safe_free (void *memory)
{
  free (memory);
  return (void *) NULL;
}

void croak(char *fmt,...)
{
  va_list arg_ptr;
  static char error_msg[MAX_ERRORMSG_LENGTH];

  va_start(arg_ptr, fmt);
  vsprintf(error_msg, fmt, arg_ptr);
  fprintf(stderr, "%s: %s\n", app_name, error_msg);
  va_end(arg_ptr);
}

void unescape(char *s)
{
  int i, j;

  for (i = 0, j = 0; s[j] != '\0'; i++, j++)
  {
    if (s[j] != '\\') 
      s[i] = s[j];
    else 
      s[i] = s[++j];
  } 

  s[i] = '\0';
}

#ifdef NEED_STRDUP
char *strdup(char *s)
{
  char *p;
  p = (char *) safe_malloc(strlen(s) + 1);
  strcpy(p, s);
  return p;
}
#endif
