/* xkeycaps, Copyright (c) 1991, 1992, 1993 Jamie Zawinski <jwz@netscape.com>
 *
 * This file describes the key surfaces of the Apple Extended Keyboard II.
 * By John Knox <johnx@exlog.com> and Chris Jones, Baker Hughes
 * Inteq DEAP Support, Aberdeen.
 */

static const struct key_strings mac_caps [] = {

  /* Row 0 */

  {"Esc", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"F9", 0},
  {"F10", 0},
  {"F11", 0},
  {"F12", 0},
  {"Print", "Screen", 0},
  {"Scroll", "lock", 0},
  {"Pause", 0},

  /* Row 2 */

  {"\247", 0},
  {"!", "1", 0},
  {"@", "2", 0},
  {"#", "3", 0},
  {"$", "4", 0},
  {"%", "5", 0},
  {"^", "6", 0},
  {"&", "7", 0},
  {"*", "8", 0},
  {"(", "9", 0},
  {")", "0", 0},
  {"_", "-", 0},
  {"+", "=", 0},
  {"Backspace", 0},
  {"Insert", 0},
  {"Home", 0},
  {"Prior", 0},
  {"Num ", "Lock", 0},
  {"=", 0},
  {"/", 0},
  {"-", 0},

  /* Row 3 */

  {"Tab", 0},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Y", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"{", "[", 0},
  {"}", "]", 0},
  {"Return", 0},
  {"Delete", 0},
  {"End", 0},
  {"Next", 0},
  {"7", 0},
  {"8", 0},
  {"9", 0},
  {"-", 0},

  /* Row 4 */

  {"Caps", "lock", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {":", ";", 0},
  {"\"", "'", 0},
  {"|", "\\", 0},
  {"4", 0},
  {"5", 0},
  {"6", 0},
  {"+", 0},

  /* Row 5 */

  {"Shift", 0},
  {"~", "\\", 0},
  {"Z", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {"<", ",", 0},
  {">", ".", 0},
  {"?", "/", 0},
  {"Shift", 0},
  {"UpArrow", 0},
  {"1", 0},
  {"2", 0},
  {"3", 0},
  {"Enter", 0},

  /* Row 6 */

  {"Ctrl", 0},
  {"alt", 0},
  {"%", 0},	/* that silly clover symbol */
  {" ", 0},
  {"%", 0},	/* that silly clover symbol */
  {"alt", 0},
  {"Ctrl", 0},
  {"LeftArrow", 0},
  {"DownArrow", 0},
  {"RightArrow", 0},
  {"0", 0},
  {".", 0}
};
