/*
 * Addresses 
 */
#ifndef __CHOS_ADDRESS_H
#define __CHOS_ADDRESS_H

#define BOOT_SEG	0x07c0
#define BSECT_OFF	0x7c00
#define STAGE2_SEG	0x0000
#define STAGE2_OFF	0x8000
#define STAGE2_SIZE	2560	//2048+512
#define FN_TABLE_OFF	STAGE2_OFF+	2048+256	//1024+512+450
#define DATA_OFF	STAGE2_OFF+	2048+512
#define IMAGES_OFF	DATA_OFF+	512
#define MAP_OFF		IMAGES_OFF+	512
#define MAP_SEG		0x8e0
#define LOADER_OFF	MAP_OFF+	512

#define STACK_SEG	0x9a00
#define STACK_SIZE	0x1000

#ifdef __ASSEMBLY__

#define  __OFF		DATA_OFF+8 // 8 for the header
#define chos_delay 	0+__OFF
#define chos_images	1+__OFF
#define chos_default	2+__OFF
#define chos_color	3+__OFF

#define chos_sel	4+__OFF
#define chos_autoboot	5+__OFF
#define chos_singleshot	6+__OFF
#define chos_nloaders	7+__OFF

#define chos_timex	8+__OFF
#define chos_timey	9+__OFF
#define chos_timestrx	10+__OFF
#define chos_loady	11+__OFF

#define chos_map_drive	12+__OFF
#define chos_bg_drive	13+__OFF

#define chos_map_sect1	16+__OFF
#define chos_bg_sects	20+__OFF
#define chos_passwd	chos_bg_sects+32
#define chos_loaders 	chos_passwd+MAX_PASSWD_LEN+1
#define boot_images	IMAGES_OFF

#endif /* __ASSEMBLY__ */

#endif