; sockets.scm
; functions for sockets in Scheme, using some foreign C functions
; tested for bigloo 1.9 under Solaris 2.4 and 2.5
; Sven Hartrumpf (C) 1997


;;


;

(define *socket-buffer-size* 2000)


; accept(s) =
;   c   if socket s accepted a connection from socket c;
;   #f  if an error occurred.

(define accept-socket (lambda (socket)
  (let  ((result (c_accept_socket socket)))
  (cond ((= result -1)
         #f)
        (else
         result)))))


; bind-result(s, p) =
;   #t   if socket s was successfully bound to port p;
;   #f   otherwise.

(define bind-socket (lambda (socket port)
  (let  ((result (c_bind_socket socket port)))
  (= result 0))))


; close-socket(s) =
;   #t   if socket s was sucessfully closed;
;   #f   otherwise.

(define close-socket (lambda (socket)
  (let  ((result (c_close_socket socket)))
  (= result 0))))


; connect-socket(s, ip, p) =
;   #t   if socket s was successfully connected to port o on the host with IP
;        number ip;
;   #f   otherwise.

(define connect-socket (lambda (socket ip-number port)
  (let  ((result (c_connect_socket socket ip-number port)))
  (= result 0))))


; listen-socket(s, m) =
;   #t   if socket s listens now (i.e. is ready to accept connections) with
;        a maximal backlog of m connections;
;   #f  if an error occurred.

(define listen-socket (lambda (socket max-connections)
  (let  ((result (c_listen_socket socket max-connections)))
  (= result 0))))


; open-datagram-socket =
;   s   if s is a new datagram socket with domain INET on the local machine;
;   #f  if an error occurred.

(define open-datagram-socket (lambda ()
  (let ((result (c_open_datagram_socket)))
  (cond ((= result -1)
         #f)
        (else
         result)))))


; open-stream-socket =
;   s   if s is a new stream socket with domain INET on the local machine;
;   #f  if an error occurred.

(define open-stream-socket (lambda ()
  (let ((result (c_open_stream_socket)))
  (cond ((= result -1)
         #f)
        (else
         result)))))


; receive-socket(s) =
;   m   if m is a string message received on socket s;
;   #f  if an error occurred.

(define receive-socket (lambda (socket)
  (let* ((buffer (make-string *socket-buffer-size* #\x))
         (result (c_receive_socket socket buffer *socket-buffer-size*)))
  (cond ((= result -1)
         #f)
        (else
         (substring buffer 0 result))))))


; send-socket(s, m) =
;   #t  if message m was successfully send using socket s;
;   #f  otherwise.

(define send-socket (lambda (socket message)
  (let ((result (c_send_socket socket message (string-length message))))
  (cond ((= result -1)
         #f)
        (else
         result)))))


; shutdown-socket(s) =
;   #t  if socket s was successfully shutdown for receiving and sending;
;   #f  otherwise.

(define shutdown-socket (lambda (socket)
  (let  ((result (c_shutdown_socket socket)))
  (= result 0))))


; shutdown-socket-receive(s) =
;   #t  if socket s was successfully shutdown for receiving;
;   #f  otherwise.

(define shutdown-socket-receive (lambda (socket)
  (let  ((result (c_shutdown_socket_receive socket)))
  (= result 0))))


; shutdown-socket-send(s) =
;   #t  if socket s was successfully shutdown for sending;
;   #f  otherwise.

(define shutdown-socket-send (lambda (socket)
  (let  ((result (c_shutdown_socket_receive socket)))
  (= result 0))))
