;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/runtime1.9/Rgc/transition.scm        */
;*                                                                     */
;*    Auteur      :  Manuel SERRANO                                    */
;*    Creation    :  Thu Jun 20 12:42:54 1991                          */
;*    Last change :  Tue Feb 18 16:12:23 1997 (serrano)                */
;*                                                                     */
;*    Les declarations de toutes les transitions                       */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*     le module                                                       */
;*---------------------------------------------------------------------*/
(module __rgc_transition
   
   (import  (__error                   "Llib/error.scm")
	    (__bigloo                  "Llib/bigloo.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__structure               "Llib/struct.scm")
	    (__tvector                 "Llib/tvector.scm")
	    (__r4_numbers_6_5          "Ieee/number.scm")
	    (__r4_numbers_6_5_fixnum   "Ieee/fixnum.scm")
	    (__r4_numbers_6_5_flonum   "Ieee/flonum.scm")
	    (__r4_characters_6_6       "Ieee/char.scm")
	    (__r4_equivalence_6_2      "Ieee/equiv.scm")
	    (__r4_booleans_6_1         "Ieee/boolean.scm")
	    (__r4_symbols_6_4          "Ieee/symbol.scm")
	    (__r4_strings_6_7          "Ieee/string.scm")
	    (__r4_pairs_and_lists_6_3  "Ieee/pair-list.scm")
	    (__r4_input_6_10_2         "Ieee/input.scm")
	    (__r4_control_features_6_9 "Ieee/control.scm")
	    (__r4_vectors_6_8          "Ieee/vector.scm")
	    (__r4_ports_6_10_1         "Ieee/port.scm")
	    (__r4_output_6_10_3        "Ieee/output.scm")
	    (__rgc                     "Rgc/runtime.scm")
	    (__rgc_grammar             "Rgc/grammar.scm")
	    (__rgc_tree                "Rgc/tree.scm")
	    (__rgc_dfa                 "Rgc/dfa.scm")
	    (__rgc_rule                "Rgc/rules.scm")
	    (__rgc_automata            "Rgc/automata.scm")
	    (__rgc_trap                "Rgc/trap.scm")
	    (__rgc_optimize            "Rgc/optimize.scm"))
   
   (use     (__type                    "Llib/type.scm")
	    (__evenv                   "Eval/evenv.scm"))
  
   (export  (code-> sn c a)))

;*---------------------------------------------------------------------*/
;*     code-> ... (codage des transitions)                             */
;*     code->: state x (test x new-state) x (state -> accept) -> code  */
;*---------------------------------------------------------------------*/
(define (code-> state-num cell accept?)
   (let ((new-state (cadr cell)))
      (let ((a* (accept? new-state)))
	 (if (not (null? a*))
	     (if (accept? 'leave-out?)
		 (accept-and-go state-num a* new-state accept?)
		 (accept state-num a*))
	     (if (accept? 'leave-out?)
		 (go state-num new-state)
		 (error "regular-grammar" "Badly formed state" state-num))))))

;*---------------------------------------------------------------------*/
;*     accept-and-go ...                                               */
;*     -----------------------------------------------------------     */
;*     Ce type de transition est un peu complique car c'est ici qu'on  */
;*     fait l'optimisation sur les loopings...                         */
;*---------------------------------------------------------------------*/
(define (accept-and-go state-num a* new-state accept?)
   (if (not (trapped? (car a*)))
       ;; Ouf, la 1ere regle n'est pas trappee. Il n'y a rien a faire
       (begin
	  (if (looping? new-state accept?)
	      `(,(state->symbol new-state))
	      `(begin
		  (input-port-remember-ref input-port)
		  (,(state->symbol new-state) ,(car a*))) ))
       ;; m.. elle l'est.   
       `(cond
	   ,@(let loop ((a* a*))
		(cond
		   ((null? a*)
		    `((else (,(state->symbol new-state) mr))))
		   ((not (trapped? (car a*)))
		    `((else
		       (input-port-remember-ref input-port)
		       (,(state->symbol new-state) ,(car a*)))))
		   (else
		    (let ((trap (trapped? (car a*))))
		       (cons `(,(test-trap (car a*))
			       (input-port-remember-ref input-port)
			       ,(if (eq? trap 'eof)
				    (car a*)
				    `(,(state->symbol new-state)
				      ,(car a*))))
			     (loop (cdr a*))))))) ) ) )

;*---------------------------------------------------------------------*/
;*     accept ...                                                      */
;*---------------------------------------------------------------------*/
(define (accept state-num a*)
   (if (not (trapped? (car a*)))
       ;; Ouf, la 1ere regle n'est pas trappee. Il n'y a rien a faire
       `(begin
	   (input-port-remember-ref input-port)
	   ,(car a*))
       ;; m.. elle l'est.
       `(cond
	   ,@(let loop ( (a* a*) )
		(cond
		   ((null? a*)
		    `((else mr)))
		   ((not (trapped? (car a*)))
		    `((else
		       (input-port-remember-ref input-port)
		       ,(car a*))))
		   (else (cons `(,(test-trap (car a*))
				 (input-port-remember-ref input-port)
				 ,(car a*))
			       (loop (cdr a*))))) ) ) ) )

;*---------------------------------------------------------------------*/
;*     go ...                                                          */
;*---------------------------------------------------------------------*/
(define (go state-num new-state)
   `(,(state->symbol new-state) mr) )
