/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
**  constants.h
*/

/*
 * This is constants.h from Mike Smith's Win32 port of lclint.
 * Modified by Herbert 04/19/97:
 * added conditional 'OS2' to conditional 'MSDOS'
 */

# ifndef CONSTANTS_H
# define CONSTANTS_H


/*@constant observer char *INITFILENAME; @*/
# define INITFILENAME	"lclinit.lci"

/*@constant observer char *RCFILE; @*/
# if defined(MSDOS) || defined(OS2)
# define RCFILE         "lclint.rc"
# else
# define RCFILE         ".lclintrc"
# endif

/*@constant observer char *LCL_SUFFIX; @*/
# define LCL_SUFFIX		".lcl"

/*@constant observer char *LCLINIT_SUFFIX; @*/
# define LCLINIT_SUFFIX 	".lci"

/*@constant observer char *IO_SUFFIX; @*/
# define IO_SUFFIX              ".lcs"

/*@constant observer char *C_SUFFIX; @*/
# define C_SUFFIX               ".c"

/*@constant observer char *LH_SUFFIX; @*/
# define LH_SUFFIX              ".lh"

/*@constant observer char *LARCH_PATH; @*/
# define LARCH_PATH		"LARCH_PATH"

/*@constant observer char *LCLIMPORTDIR; @*/
# define LCLIMPORTDIR           "LCLIMPORTDIR"

/*@constant observer char *CTRAITSYMSNAME; @*/
# define CTRAITSYMSNAME         "CTrait.syms"

/*@constant observer char *CTRAITSPECNAME; @*/
# define CTRAITSPECNAME         "CTrait.lsl"

/*@constant observer char *CTRAITFILENAMEN; @*/
# define CTRAITFILENAMEN        "CTrait"

/*@constant observer char *LLSTDLIBS_NAME; @*/
# define LLSTDLIBS_NAME          "ansi"

/*@constant observer char *LLSTRICTLIBS_NAME; @*/
# define LLSTRICTLIBS_NAME      "ansistrict"

/*@constant observer char *LLUNIXLIBS_NAME; @*/
# define LLUNIXLIBS_NAME        "unix"

/*@constant observer char *LLUNIXSTRICTLIBS_NAME; @*/
# define LLUNIXSTRICTLIBS_NAME  "unixstrict"

/*@constant observer char *LLPOSIXLIBS_NAME; @*/
# define LLPOSIXLIBS_NAME       "posix"

/*@constant observer char *LLPOSIXSTRICTLIBS_NAME; @*/
# define LLPOSIXSTRICTLIBS_NAME "posixstrict"

/*@constant observer cstring REFSNAME; @*/
# define REFSNAME               cstring_makeLiteralTemp ("refs")

/*
** Used to be .lldmp.  Truncated to .lcd to fix within
** MS-DOS filename limitations.
*/

/*@constant observer char *DUMP_SUFFIX; @*/
# define DUMP_SUFFIX ".lcd"

/*@constant int MAX_NAME_LENGTH; @*/
# define MAX_NAME_LENGTH 256

/*@constant int MAX_LINE_LENGTH; @*/
# define MAX_LINE_LENGTH 1024

/*@constant int MAX_DUMP_LINE_LENGTH; @*/
# define MAX_DUMP_LINE_LENGTH 8192

/*@constant int MINLINELEN; @*/
# define MINLINELEN 20

/*
** WARNING: Can't use macros in token for cgrammar.l -->
**   must keep these consistent!
*/

/*@constant observer char *LLMRCODE; @*/
# define LLMRCODE "@QLMRX"  /* MUST be 6 chars = define */

/*@constant observer char *PPMRCODE; @*/
# define PPMRCODE "@@MR@@"  

/* localIncludePath:  pathname used for # include "file.h"
**   not a constant, default to ".:/usr/include",
**   directories in -I<dir> are added after ".:"
*/

/*@constant observer char *BASEPATH; @*/
# define BASEPATH "/usr/include"

/*@constant observer char *DEFAULT_SYSTEMDIR; @*/
# define DEFAULT_SYSTEMDIR "/usr/include/"

# ifdef P_tmpdir
/*@constant observer char *DEFAULT_TMPDIR; @*/
# if defined(OS2) && defined(__IBMC__)
# define DEFAULT_TMPDIR "."
# else
# define DEFAULT_TMPDIR P_tmpdir
# endif
# else
/*@constant observer char *DEFAULT_TMPDIR; @*/
# define DEFAULT_TMPDIR "/tmp/"
# endif

/*@constant char DEFAULT_COMMENTCHAR; @*/
# define DEFAULT_COMMENTCHAR '@'

/*@constant int DEFAULT_LINELEN; @*/
# define DEFAULT_LINELEN 80

/*
** These constants are based on implementation limits in ANSI standard,
** Section 3.1. 
*/

/*@constant int DEFAULT_EXTERNALNAMELEN; @*/
# define DEFAULT_EXTERNALNAMELEN 6

/*@constant int DEFAULT_INTERNALNAMELEN; @*/
# define DEFAULT_INTERNALNAMELEN 31

/*@constant int DEFAULT_CONTROLNESTDEPTH; @*/
# define DEFAULT_CONTROLNESTDEPTH 15

/*@constant int DEFAULT_STRINGLITERALLEN; @*/
# define DEFAULT_STRINGLITERALLEN 509

/*@constant int DEFAULT_INCLUDENEST; @*/
# define DEFAULT_INCLUDENEST 8

/*@constant int DEFAULT_NUMSTRUCTFIELDS; @*/
# define DEFAULT_NUMSTRUCTFIELDS 127

/*@constant int DEFAULT_NUMENUMMEMBERS; @*/
# define DEFAULT_NUMENUMMEMBERS 127

/*@constant int DEFAULT_LIMIT; @*/
# define DEFAULT_LIMIT -1    /* unlimited messages */

/*@constant char PFX_UPPERCASE; @*/
# define PFX_UPPERCASE '^'

/*@constant char PFX_LOWERCASE; @*/
# define PFX_LOWERCASE '&'

/*@constant char PFX_ANY; @*/
# define PFX_ANY '?'

/*@constant char PFX_DIGIT; @*/
# define PFX_DIGIT '#'

/*@constant char PFX_NOTUPPER; @*/
# define PFX_NOTUPPER '%'

/*@constant char PFX_NOTLOWER; @*/
# define PFX_NOTLOWER '~'

/*@constant char PFX_ANYLETTER; @*/
# define PFX_ANYLETTER '$'

/*@constant char PFX_ANYLETTERDIGIT; @*/
# define PFX_ANYLETTERDIGIT '/'

/*@constant observer char *PRAGMA_EXPAND; @*/
# define PRAGMA_EXPAND "expand"

/*@constant int PRAGMA_LEN_EXPAND; @*/
# define PRAGMA_LEN_EXPAND 6

/*@constant int MAX_PRAGMA_LEN; @*/
# define MAX_PRAGMA_LEN PRAGMA_LEN_EXPAND

/*
** Minimum version with compatible libraries.
*/

/*@constant float LCL_MIN_VERSION; @*/
# define LCL_MIN_VERSION 2.2

# else
# error "Multiple include"
# endif
