/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** typeExpr.h
*/

typedef enum 
{
  TEXPR_BASE, TEXPR_PTR, TEXPR_ARRAY, TEXPR_FCN
  } typeExprKind;

struct _typeExpr 
{
  int wrapped; /* number of balanced parentheses around this program node */
  typeExprKind kind; /* different kinds of type constructors */
  union {
    ltoken base;
    /*@null@*/ typeExpr pointer;
    struct {
      /*@null@*/ typeExpr elementtype;
      /*@null@*/ termNode size;
      } array;
    struct {
      /*@null@*/ typeExpr returntype; /* not really ... return-part maybe */
      paramNodeList args;
    } function;
  } content;
  sort sort;
} ; 

extern void typeExpr_free (/*@only@*/ /*@null@*/ typeExpr p_x);
extern /*@only@*/ cstring typeExpr_unparse (/*@null@*/ typeExpr p_x);
extern /*@only@*/ cstring typeExpr_unparseNoBase (/*@null@*/ typeExpr p_x);

/* like a declaratorNode but without varId */
typedef typeExpr abstDeclaratorNode;

extern void abstDeclaratorNode_free (/*@only@*/ /*@null@*/ abstDeclaratorNode p_x);
# define abstDeclaratorNode_free(x) typeExpr_free(x);


