/*
** Copyright (c) Massachusetts Institute of Technology 1994-1997.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@larch.lcs.mit.edu).
*/
/*
** sRefTable.c
**
** based on table_template.c
**
** where T has T_equal (or change this) and T_unparse
*/

# include "lclintMacros.nf"
# include "basic.h"
# include "sRefTable.h"

static /*@notnull@*/ /*@only@*/ sRefTable
sRefTable_new (void)
{
  sRefTable s = (sRefTable) dmalloc (sizeof (*s));

  s->entries = 0;
  s->nspace = sRefTableBASESIZE;
  s->elements = (sRef *) dmalloc (sizeof (*s->elements) * sRefTableBASESIZE);

  return (s);
}

static void
sRefTable_grow (/*@notnull@*/ sRefTable s)
{
  int i;
  sRef *newelements; 

  s->nspace = sRefTableBASESIZE;
  newelements = (sRef *) dmalloc (sizeof (*newelements) * (s->entries + s->nspace));

  for (i = 0; i < s->entries; i++)
    {
      newelements[i] = s->elements[i];
    }

  sfree (s->elements);
  s->elements = newelements;
}

sRefTable
sRefTable_add (sRefTable s, /*@owned@*/ sRef el)
{
  if (sRefTable_isNull (s))
    {
      s = sRefTable_new ();
    }

  if (s->nspace <= 0)
    {
      sRefTable_grow (s);
    }

  s->nspace--;
  
  llassert (s->elements != NULL);
  s->elements[s->entries] = el;
  
  s->entries++;

  return s;
}

void
sRefTable_clear (sRefTable s)
{
  if (sRefTable_isDefined (s))
    {
      int i;
      
      for (i = 0; i < s->entries; i++)
	{
	  DPRINTF (("free: [%ld] %s", s->elements[i], sRef_unparse (s->elements[i])));
	  sRef_free (s->elements[i]);  
	}

      s->nspace += s->entries;
      s->entries = 0;
    }
}

static int sRefTable_size (sRefTable s)
{
  if (sRefTable_isNull (s)) return 0;
  return s->entries;
}

/*@only@*/ cstring
sRefTable_unparse (sRefTable s)
{
  int i;
  cstring st = cstring_undefined;

  if (sRefTable_isDefined (s))
    {
      for (i = 0; i < sRefTable_size (s); i++)
	{
	  if (i == 0)
	    st = message ("%4d. %q\n", i, sRef_unparse (s->elements[i]));
	  else
	    st = message ("%q%4d. %q\n", st, i, sRef_unparse (s->elements[i]));
	}
    }
  return st;
}

void
sRefTable_free (/*@only@*/ sRefTable s)
{
  if (sRefTable_isDefined (s))
    {
      int i;

      for (i = 0; i < s->entries; i++)
	{
	  sRef_free (s->elements[i]);
	}

      sfree (s->elements); 
      sfree (s);
    }
}

