/* Copyright (C) 1979-1996 TcX AB & Monty Program KB & Detron HB

   This software is distributed with NO WARRANTY OF ANY KIND.  No author or
   distributor accepts any responsibility for the consequences of using it, or
   for whether it serves any particular purpose or works at all, unless he or
   she says so in writing.  Refer to the Free Public License (the "License")
   for full details.

   Every copy of this file must include a copy of the License, normally in a
   plain ASCII text file named PUBLIC.	The License grants you the right to
   copy, modify and redistribute this file, but only under certain conditions
   described in the License.  Among other things, the License requires that
   the copyright notice and this notice be preserved on all copies. */

/* YACC and LEX Definitions */

// The following hack is neaded because mysql_yacc.cc does not define
// YYSTYPE before including this file

#ifdef MYSQL_YACC
#define LEX_YYSTYPE void *
#else
#include "sql_yacc.h"
#define LEX_YYSTYPE YYSTYPE *
#endif

enum enum_sql_command {
  SQL_SELECT,SQL_CREATE_TABLE,SQL_CREATE_INDEX,SQL_ALTER_TABLE,
  SQL_UPDATE,SQL_INSERT,SQL_INSERT_SELECT,SQL_DELETE,
  SQL_DROP_TABLE,SQL_DROP_INDEX,SQL_SHOW_DATABASES,
  SQL_SHOW_TABLES,SQL_SHOW_FIELDS,SQL_SHOW_KEYS,
  SQL_LOAD,SQL_SET_OPTION,SQL_LOCK_TABLES,SQL_UNLOCK_TABLES,SQL_GRANT,
  SQL_CHANGE_DB, SQL_CREATE_DB, SQL_DROP_DB, SQL_REPLACE,
  SQL_REPLACE_SELECT, SQL_SHOW_VARIABLES, SQL_SHOW_STATUS, SQL_CREATE_FUNCTION,
  SQL_DROP_FUNCTION};

enum lex_states { STATE_START, STATE_CHAR, STATE_IDENT,
		  STATE_IDENT_SEP,
		  STATE_IDENT_START,
		  STATE_FOUND_IDENT,
		  STATE_SIGNED_NUMBER,
		  STATE_REAL,
		  STATE_CMP_OP,
		  STATE_STRING,
		  STATE_COMMENT,
		  STATE_END,
		  STATE_OPERATOR_OR_IDENT,
		  STATE_NUMBER_IDENT,
		  STATE_INT_OR_REAL,
		  STATE_REAL_OR_POINT,
		  STATE_BOOL,
		  STATE_EOL,
		  STATE_ESCAPE,
		  STATE_LONG_COMMENT
};


typedef struct st_lex {
  uint	 yylineno,yytoklen;			/* Simulate lex */
  LEX_YYSTYPE yylval;
  uchar *ptr,*tok_start,*tok_end,*end_of_query;
  ulong  select_limit,offset_limit;
  bool	 create_refs,drop_primary;
  enum_sql_command sql_command;
  enum lex_states next_state;
  uint type,options;
  char	 *length,*db,*dec,*change,*name;
  String *wild;
  sql_exchange *exchange;
  List<List_item> expr_list;
  List<key_part_spec> col_list;
  List<Alter_drop>    drop_list;
  List<Alter_column>  alter_list;
  List<String>        interval_list;
  TYPELIB 	      *interval;
  Item *where,*having;
  bool unique_flag;
  enum enum_duplicates duplicates;
  CONVERT *convert_set;
  char *table1,*table2;			/* For outer join using .. */
  gptr yacc_yyss,yacc_yyvs;
  THD *thd;
  udf_func udf;
} LEX;


void lex_init(void);
void lex_free(void);
LEX *lex_start(uchar *buf,uint length);
void lex_end(LEX *lex);

extern pthread_key(LEX*,THR_LEX);

inline LEX *_current_lex(void)
{
  return my_pthread_getspecific_ptr(LEX *,THR_LEX);
}
#define current_lex _current_lex()
