.\" Copyright (c) 1997 Donald Burr <dburr@POBoxes.com>
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"	$Id$
.\"
.\" Note: The date here should be updated whenever a non-trivial
.\" change is made to the manual page.
.Dd November 25 1997
.Dt XMAME 6
.\" Note: Only specify the operating system when the command
.\" is FreeBSD specific, otherwise use the .Os macro with no
.\" arguments.
.Os
.Sh NAME
.Nm xmame
.Nd Arcade game machine emulator for UNIX/X
.Sh SYNOPSIS
.Nm xmame
.Ar game
.Op options...
.Sh DESCRIPTION
.Nm
is an arcade game machine emulator for UNIX/X11.  It will emulate the hardware,
video, sound, and other services, of many classic arcade game machines.
.Pp
Most games allow you to specify one or more options to control the behavior
of
.Nm
and that particular game.  Many of these options can be preceded
with ``no'', which acts to disable the option in question.
Here are the most common ones:
.Bl -tag -width Fl
.It Fl help
Displays a help screen, summarizing the command line options.
.It Fl joy
Allows you to use the joystick driver to control the game.  (Specific to
Linux.)
.It Fl mouse
Activates mouse.  When this option is used, moving the mouse in a particular
direction (within the
.Nm
window changes the direction you're moving in (i.e. acts as if you've
pressed the corresponding arrow key).
.It Fl trak
Enables the use of a trackball (i.e. the mouse).  Used for certain games
where a trackball is more appropriate as the controller (e.g. Missile Command,
Centipede).
.It Fl pad
Enables the use of the Linux FM-TOWNS Game Pad driver, so that you may use
your game pad to control the game.  (Specific to Linux.)
.It Fl swapjoyaxis
Swaps the X and Y axes of your joystick.
.It Fl joyfilter Ar value
Activates the joystick ``noise filter'', and sets it to
.Ar value .
Default value is 5.
.It Fl x11joyname Ar name
Sets the name of the X-based (e.g. XInput) joystick device to
.Ar name .
.It Fl paddevname Ar name
Sets the name of the FM-TOWNS game pad device to
.Ar name .
The default is /dev/pad00.
.It Fl mapkey Ar xcode , Ar mamecode
Sets up a keyboard mapping that maps X character code
.Ar xcode 
to
.Nm
character code
.Ar mamecode . 
.It Fl cheat
Enables ``cheat mode''.  In cheat mode, pressing the TAB key and selecting
the ``Cheat'' menu will allow you to enable or disable certain ``cheats''
in games (e.g. invincibility, infinite weapons, etc.).
.It Fl heightscale Ar scale
Sets the height scale (Y axis) to
.Ar scale x.
For example, a value of 2 will make the screen twice as high as it normally
is.
.It Fl widthscale Ar scale
Sets the width scale (X axis) to
.Ar scale x. 
For example, a value of 2 will make the screen twice as long as it normally
is. 
.It Fl scale Ar scale
Sets both height (Y) and width (X-axis) to
.Ar scale x.
The same as setting both -heightscale and -widthscale to the same value.
.It Fl frameskip Ar nframes
Skips
.Ar nframes
frames between video refreshes.  Useful for making slowish games run
faster on slow video hardware or CPU's.
.It Fl mitshm
Activates MIT shared memory X server extension support.  The default
XFree86 servers support this, so you should probably use it.  If enabled,
will provide a significant speed advantage.  This is the default behavior.  
.It Fl xsync
Enables the XFlush/Xsync screen refresh method.
.It Fl privatecmap
Uses a private colormap entry for the
.Nm
window.  Makes colors look more
realistic (especially on 8-bit X servers) with the disadvantage that moving
the mouse cursor between windows causes your screen to change colors in a
dramatic way.
.It Fl videomode Ar mode
Selects the SVGAlib video mode
.Ar mode .
Only applicable to the Linux/SVGALIB version of
.Nm
.
.It Fl forcetruecolor
This option will cause
.Nm
to attempt to use PseudoColor X visuals.
.It Fl ror
Rotates the
.Nm
display 90 degrees right.
.It Fl rol
Rotates the
.Nm
display 90 degrees left.
.It Fl flipx
Flips the
.Nm
display about the X-axis.
.It Fl flipy
Flips the
.Nm
display about the Y-axis.
.It Fl usedsp
Selects /dev/dsp as the sound device.  (Linux only.)
.It Fl useaudio
Selects /dev/audio as the sound device.  (Linux only.)
.It Fl sound
Activates sound (requires a soundcard supported by your kernel's sound
drivers, and the sound drivers to be compiled into your kernel).
.It Fl fm
Activates use of your sound cards FM synthesizer for sound output.
.It Fl samplefreq Ar freq
Sets the game sounds sample frequency to
.Ar freq .
.It Fl timerfreq Ar freq
Sets the timer-based audio's frequency (if enabled) to
.Ar freq .
.It Fl mamedir Ar dir
Uses
.Ar dir
as the directory that contains the arcade ROM files, instead of the default.
.It Fl spooldir Ar dir
Uses
.Ar dir
as the directory to store high score files in, instead of the default.
.It Fl showconfig
Displays the running parameters in a style suitable for insertion into an
xmamerc file.
.It Fl list
Lists all of the games supported by this version of
.Nm
.
.It Fl listfull
Lists all of the games supported by this version of
.Nm
, with full descriptions.
.It Fl listroms
Lists the names of the ROM files that a particular game uses.
.It Fl listsamples
Shows the names of the audio sample files used by a particular game.
.It Fl log
Logs debugging information.
.It Ar game
The name of the
.ar game
you wish to play.  (Required.)
.El
.Sh KEYBOARD COMMANDS
While playing a game, there are certain keyboard commands available for
you to use.
.Bl -tag -width XXXXX -compact
.It Pa <1>
(the number ``one'')  Start a 1-player game.
.It Pa <2>
(the number ``two'')  Start a 2-player game.
.It Pa <3>
(the number ``three'')  ``Insert'' a ``quarter'' into the game.
.It Pa <TAB>
Enter configuration menu.  Using this, you can configure the game,
the keyboard commands, and even the ``DIP switches'' that you would
normally find on the game's motherboard.
.It Pa <P>
Pauses the game.  Press <P> again to resume.
.It Pa <F3>
Resets the game.  Basically akin to pressing the RESET switch on your PC.
.It Pa <F4>
Shows the game's graphics.  Use cursor keys (arrows) to change and/or set
the colors.
.It Pa <F8>
Changes the frameskip value on the fly.  (e.g. the ``-frameskip'' option)
.It Pa <F9>
Changes the volume of the sound.  Possible values are 0%, 25%, 50%, 75%, and
100% of full volume.
.It Pa <F10>
Toggles speed throttling.
.It Pa <F11>
Toggles fps counter.  (Displays a count of the # of frames per second being
displayed.)
.It Pa <F12>
Saves a snapshot of the current game screen.  Useful to send to your friends
to boast about the new high score you got.
.It Pa <ESC>
Exits the emulator.
.El
.Sh LEGAL NOTICE
Before you download any games ROM images from the Internet, or make your
own ROM images (if you happen to be lucky enough to own one of these games),
please be aware of the fact that these games are COPYRIGHTED by their
respective companies.  Therefore, if you download these files off of the
Internet, you are in violation of copyright, and can get into some serious
trouble.

PLEASE BE AWARE OF THE POSSIBLE LEGAL RAMIFICATIONS OF DOWNLOADING ROM
IMAGES, BEFORE YOU ACTUALLY DO SO!!!  YOU HAVE BEEN WARNED, AND I TAKE NO
RESPONSIBILITY FOR YOUR ACTIONS -- YOU ARE ON YOUR OWN!!!

Also, the
.Nm
authors ask that you DO NOT distribute any ROM images with
either source code or binaries of their
.Nm
emulator.
.Sh INSTALLING GAMES
If you own an actual arcade machine of the game you wish to play, or own
the motherboard to one, you can ``burn'' your own ROM images from the ROM
chips on that board.  How to do this is beyond the scope of this manual
page; read the instructions for your ROM burner and/or consult people on
the Internet.

Probably the easiest way to get usable game ROM images is off of the
Internet.  An excellent site to get these is at:

http://www.xs4all.nl/~delite/arcade_mame.html

PLEASE BE AWARE OF THE POSSIBLE LEGAL RAMIFICATIONS OF DOWNLOADING ROM
IMAGES, BEFORE YOU ACTUALLY DO SO!!!  YOU HAVE BEEN WARNED, AND I TAKE NO
RESPONSIBILITY FOR YOUR ACTIONS -- YOU ARE ON YOUR OWN!!!
(see the LEGAL NOTICE section for more details.)

The game ROM images come in ZIP files.  Download the ZIP files for the games
you want, and move them to the /usr/local/games/lib/mame directory.  For
each game, unzip it into its own directory (i.e. if you want to install
PacMan, get ``pacman.zip,'' make a directory called ``pacman'' (under the
/usr/local/games/lib/mame hierarchy), and unzip the pacman.zip file INSIDE
that directory.

Some games require the game ROM files to be in an unusually-named directory.
For example, Dig Dug uses the directory name ``digdugnm.''  Read the file
/usr/local/games/lib/mame/readme.txt to find out the names of the directories
for particular games.
.Sh PLAYING GAMES
Okay, so you've got your games installed.  Now what?

Well, the simplest way to run a game is to simply type:

.Nm
<game name>  (e.g. ``
.Nm
pacman'')

Some games may run rather slowly on your hardware.  if this is the case,
the ``-frameskip'' option will be of help.
Usually ``-frameskip 1'' is sufficient.
In this case, put the argument AFTER the game name.  Ex:
.Nm
pacman -frameskip 1

Type ``
.Nm
-help'' to see other possible command-line options.

First you will be shown two screens: one with a copyright message, and one
showing credits for wrote the driver for that particular game.
Press any key to go to the next screen.

The game will then go through a ``hardware self-test'' (remember, this program
is emulating actual video game HARDWARE, and, just like your computer,
video game hardware goes through a self-test when you first turn the power
on!).

After the self-test, you are actually in the video game.  It will run
through its display sequence (where it asks you to feed it quarters,
displays the high score list, shows a sample game, whatnot).  At this
point, if you were in a real arcade, you would feed it quarters and push
the appropriate ``start'' button for 1- or 2-player games.

Since this program emulates video game hardware, you will, in a sense,
have to do this as well.  (no, don't go grabbing quarters and shoving them
in your PC's floppy drive slot. :) )  To ``drop'' a ``quarter'' into your
``machine,'' press the <3> key (that's the number ``three'').  Do this once for
every quarter you want to insert -- for example, to play a 2-player game
typically requires 2 quarters, so press the <3> button twice.  Now, press
the <1> (number ``one'') to start a 1-player game, and <2> (number ``two'')
for a 2-player game.

Now, you will be playing the game!  Use the keyboard to play -- the arrow
keys typically move you around, and the <ctrl> key acts as a ``fire'' or
``special action'' type button (i.e. in Mario Bros., <ctrl> causes the
Mario character to JUMP).

Some games use slightly different keys, and some 2-player games use a
second set of keys for the 2nd player.  For example, the Defender game
has MANY controls for shields, warp speed, whatnot; while the Mario Bros.
game uses a second set of keys to control the Luigi player (2nd player).
If you want to find out what keys a particular game uses, look at the
/usr/local/games/lib/mame/readme.txt file.

HAVE FUN!!!
.Sh ENVIRONMENT
.Bl -tag -width Ev
.It Ev HOME
The user's home directory.  (normally set by the login process.)
.It Ev MAMEDIR
The directory where the arcade game ROM images can be found.  Each game's
ROMs must be kept in a directory named after the game (e.g. all Pacman
roms go in MAMEDIR/pacman).
.It Ev DISPLAY
X server to display in.
.El
.Sh FILES
.Bl -tag -width /usr/local/games/lib/mame/readme.txt -compact
.It Pa /usr/local/games/lib/mame
Directory containing arcade game ROM files
(the ROMs for each game live in a subdirectory with the same name as
the game, e.g. ``/usr/local/games/lib/mame/pacman''.
.It Pa /usr/local/games/lib/mame/readme.txt
File containing list of supported games, keyboard commands for each
game, and bugs and other incompatibilities with certain games.
.It Pa /usr/local/games/lib/mame/xmamerc
System-wide configuration file for
.Nm
.It Pa ${HOME}/xmame/xmamerc
Per-user configuration file for
.Nm
(overrides system configuration if exists).
.It Pa ${HOME}/xmame/<game>.cnf
Per-user configuration file of a particular game.
.El
.Sh EXAMPLES
The following is an example of a typical usage
of the
.Nm
command:
.Pp
.Dl %
.Nm
pacman
plays Pacman with all default options
.Dl %
.Nm
dkong -frameskip 1
plays Donkey Kong using frameskip of 1.  Useful for slower computers,
if the game is running really slowly.
.Dl %
.Nm
superpac -scale 2
plays Super PacMan with a double-sized screen (note that this slows the
game down).
.Dl %
.Nm
superpac -heightscale 2 -widthscale 2
Same as above, but using separate -heightscale and -widthscale arguments.
.Sh SEE ALSO
.Xr X 1
.Sh STANDARDS
Usage is similar to that of the DOS version of
.Nm
except that DOS-specific
video options (e.g. -vesa, etc.) do not apply in this case, obviously.
.Sh DIAGNOSTICS
.Nm
will print a message and exit with a non-zero return status if some
sort of error occurred.  The error messages should be fairly
self-explanatory.
.Sh HISTORY
In the beginning of 1997, an Italian programmer, Nicola Salmoria, started
programming emulators, which were first seen on The Repository, a site
dedicated to new emulator projects.  The first emulator seen from him
emulated Rally X, and later, many more standalone emulators surfaced.
Nicola Salmoria even wrote several multi game emulators (ex. Multi PacMan,
which ran all of the PacMan clones).  Unfortunately, nobody really paid
much attention to his efforts, since Sparcade (another arcade game emulator,
presumably for the Sun SPARC architecture) had just come out, and it had
many cool, fully-functional games emulated on it, unlike Nicola's
efforts.

Time passed, and Nicola started work on his Multi Arcade Machine Emulator
(MAME), which provided an architecture for combining many different game
emulators into one executable program.

Today, MAME has become THE de-facto arcade emulator standard around,
and is being ported to many different architectures, including the
Macintosh, Amiga, UNIX/X11, and even Acorn machines.  A very loyal,
hard-core fan base has also developed for this emulator.
.Sh AUTHOR
The original author of
.Nm
is
.An Nicola Salmoria Aq MC6489@mclink.it .
The current version is maintained by
.An Mirko Buffoni Aq mix@lim.dsi.unimi.it ,
who also serves as the coordinator for the MAME project.
Drivers for game hardware have been written and contributed by many
people, too many to list in this man page.
The UNIX/X11 port of MAME is maintained by
.An Juan Antonio Marinez Aq jantonio@dit.upm.es .
This manual page was written by
.An Donald Burr Aq dburr@POBoxes.com .
.Sh BUGS
Some game hardware isn't completely emulated, especially sound.
Probably other bugs, too.
See the readme.txt file for more bugs.
