/****************************************************************************

Kung Fu Master memory map (Doc by Ishmair)

ROMS mapping

KF1 ?

KF2yKF3   Adpcm  4bit samples

0000h->KF4      Z80   IM 1.   It doesn't use NMIs.
4000h->KF5      Z80


Gfx KF6,7,8->Background CharSet 1024 Chars.3 planes 8 colors.
    KF9,11,14->Sprites 1   ;3 planes
    KF10,12,13->Sprites 2  ;3 planes

    Sprites are in the same easy format that chars.

; Video RAM  (Char window)
D000h-D7FFh character number (0-255)  64x32 Size (two screens for scroll)

                              HFlip
                               |
D800h-DFFFh character ATTR   11000000
                             \/
                             banco
;                            char

;sprites
4096 char sprites (16 veces 256) de 8 colores.


SCROLL ;  Scroll Byte 1  AT (A000h) -> two's complement.
          Scroll Byte 2  AT (B000h) -> This seems to be scroll related,
                                       but i don't know how it works.

SPRITES
           00   01   02   03   04   05   06   07
           |         Y     ?   AnL  AnH  X     ?
           |              YH    |             Parte alta de XH?
           |                         |
           0F color                 03h bank
                                     |
           F0 ? 1 en silvia         40h Flip

All the X and Y are two's complements , i think.

Start at C000h
I use 256 sprites.      Maybe all my sprites handle is wrong.



Ports IN ;                    ;(0=On 1=Off)
              (00) INTERFACE 0          7 6 5 4 3 2 1 0
                                                | | | |
                                                | | | 1Up Start
                                                | | 2Up Start
                                                | Coin
                                                Coin
                                        Fire1
                                        |
              (01) INTERFACE 1          7 6 5 4 3 2 1 0
                                            |   | | | |
                                            |   | | | Right
                                            |   | | Left
                                            |   | Down
                                            |   Up
                                            Fire2

              (02) INTERFACE 2          7 6 5 4 3 2 1 0
                                        2nd player controls

              (03) DSW 1                7 6 5 4 3 2 1 0

              (04) DSW 2                7 6 5 4 3 2 1 0
                                        |
                                        Test Mode

Puertos OUT;  (00)      ;Sound related. (Look at subrutine 0DE5h)
                        ;Bit 7 at 1 , 7 low bits  .. sound number.
                        ;digital sound will be easy to implement.
              (01)       ?

****************************************************************************/

#include "driver.h"
#include "Z80/Z80.h"
#include "sndhrdw/8910intf.h"
#include "vidhrdw/generic.h"


extern unsigned char *kungfum_scroll_low;
extern unsigned char *kungfum_scroll_high;
void kungfum_vh_convert_color_prom(unsigned char *palette, unsigned char *colortable,const unsigned char *color_prom);
int kungfum_vh_start(void);
void kungfum_vh_stop(void);
void kungfum_vh_screenrefresh(struct osd_bitmap *bitmap);

extern unsigned char *mpatrol_io_ram;
extern unsigned char *mpatrol_sample_data;
extern unsigned char *mpatrol_sample_table;
int mpatrol_sh_init(const char *);
int mpatrol_sh_start(void);
int mpatrol_sh_interrupt(void);
void mpatrol_io_w(int offset, int value);
int mpatrol_io_r(int offset);
void mpatrol_sample_trigger_w(int offset,int value);
void mpatrol_sound_cmd_w(int offset, int value);


static struct MemoryReadAddress readmem[] =
{
	{ 0xe000, 0xefff, MRA_RAM },
	{ 0xd000, 0xdfff, MRA_RAM },         /* Video and Color ram */
	{ 0x0000, 0x7fff, MRA_ROM },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress writemem[] =
{
	{ 0xe000, 0xefff, MWA_RAM },
	{ 0xd000, 0xd7ff, videoram_w, &videoram, &videoram_size },
	{ 0xd800, 0xdfff, colorram_w, &colorram },
	{ 0xc020, 0xc0df, MWA_RAM, &spriteram, &spriteram_size },
	{ 0xa000, 0xa000, MWA_RAM, &kungfum_scroll_low },
	{ 0xb000, 0xb000, MWA_RAM, &kungfum_scroll_high },
	{ 0x0000, 0x7fff, MWA_ROM },
	{ -1 }	/* end of table */
};


static struct IOReadPort readport[] =
{
	{ 0x00, 0x00, input_port_0_r },   /* coin */
	{ 0x01, 0x01, input_port_1_r },   /* player 1 control */
	{ 0x02, 0x02, input_port_2_r },   /* player 2 control */
	{ 0x03, 0x03, input_port_3_r },   /* DSW 1 */
	{ 0x04, 0x04, input_port_4_r },   /* DSW 2 */
	{ -1 }	/* end of table */
};

static struct IOWritePort writeport[] =
{
	{ 0x00, 0x00, mpatrol_sound_cmd_w },
	{ -1 }	/* end of table */
};


static struct MemoryReadAddress sound_readmem[] =
{
	{ 0x0000, 0x001f, mpatrol_io_r, &mpatrol_io_ram },
	{ 0x0080, 0x00ff, MRA_RAM },
	{ 0xa000, 0xffff, MRA_ROM },
	{ 0xe900, 0xe93f, MRA_ROM, &mpatrol_sample_table },
	{ -1 }	/* end of table */
};

static struct MemoryWriteAddress sound_writemem[] =
{
	{ 0x0000, 0x001f, mpatrol_io_w },
	{ 0x00c3, 0x00ca, mpatrol_sample_trigger_w, &mpatrol_sample_data },
	{ 0x0080, 0x00ff, MWA_RAM },
	{ 0x0801, 0x0802, MWA_NOP },
	{ 0x9000, 0x9000, MWA_NOP },    /* IACK */
	{ 0xa000, 0xffff, MWA_ROM },
	{ -1 }	/* end of table */
};


static struct InputPort input_ports[] =
{
	{	/* IN0 */
		0xff,
		{ OSD_KEY_1, OSD_KEY_2, OSD_KEY_3, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* IN1 */
		0xff,
		{ OSD_KEY_RIGHT, OSD_KEY_LEFT, OSD_KEY_DOWN, OSD_KEY_UP,
				0, OSD_KEY_LCONTROL, 0, OSD_KEY_ALT },
		{ OSD_JOY_RIGHT, OSD_JOY_LEFT, OSD_JOY_DOWN, OSD_JOY_UP,
				0, OSD_JOY_FIRE1, 0, OSD_JOY_FIRE2 }
	},
	{	/* IN2 */
		0xff,
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* DSW1 */
		0xff,
		{ 0, 0, 0, 0, 0, 0, 0, 0 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{	/* DSW2 */
		0xfd,
		{ 0, 0, 0, 0, 0, 0, 0, OSD_KEY_F1 },
		{ 0, 0, 0, 0, 0, 0, 0, 0 }
	},
	{ -1 }	/* end of table */
};

static struct TrakPort trak_ports[] =
{
        { -1 }
};


static struct KEYSet keys[] =
{
	{ 1, 3, "JUMP" },
	{ 1, 1, "MOVE LEFT"  },
	{ 1, 0, "MOVE RIGHT" },
	{ 1, 2, "CROUCH" },
	{ 1, 5, "PUNCH" },
	{ 1, 7, "KICK" },
	{ -1 }
};


static struct DSW dsw[] =
{
	{ 3, 0x0c, "LIVES", { "5", "4", "2", "3" }, 1 },
	{ 3, 0x01, "DIFFICULTY", { "HARD", "EASY" }, 1 },
	{ 3, 0x02, "TIMER", { "FAST", "SLOW" }, 1 },
	{ 4, 0x40, "DEMO MODE", { "ON", "OFF" }, 1 },
	{ 4, 0x20, "LEVEL SELECT", { "ON", "OFF" }, 1 },
	{ 4, 0x08, "SW4B", { "ON", "OFF" }, 1 },
	{ 4, 0x10, "SW5B", { "ON", "OFF" }, 1 },
	{ -1 }
};



static struct GfxLayout charlayout =
{
	8,8,	/* 8*8 characters */
	1024,	/* 1024 characters */
	3,	/* 2 bits per pixel */
	{ 2*1024*8*8, 1024*8*8, 0 },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 8*0, 8*1, 8*2, 8*3, 8*4, 8*5, 8*6, 8*7 },
	8*8	/* every char takes 8 consecutive bytes */
};
static struct GfxLayout spritelayout =
{
	16,16,	/* 16*16 sprites */
	256,	/* 256 sprites */
	3,	/* 3 bits per pixel */
	{ 0x10000*8, 0x8000*8, 0 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 16*8+0, 16*8+1, 16*8+2, 16*8+3, 16*8+4, 16*8+5, 16*8+6, 16*8+7},
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8, 8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8},
	32*8	/* every sprite takes 32 consecutive bytes */
};



static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ 1, 0x00000, &charlayout,           0, 32 },
	{ 1, 0x06000, &spritelayout,      32*8, 32 },
	{ 1, 0x08000, &spritelayout,      32*8, 32 },
	{ 1, 0x0a000, &spritelayout,      32*8, 32 },
	{ 1, 0x0c000, &spritelayout,      32*8, 32 },
	{ -1 } /* end of array */
};



static unsigned char color_prom[] =
{
	/* G-1J - character palette red component */
	0x00,0x0F,0x00,0x0F,0x00,0x0F,0x00,0x0F,0x0A,0x0E,0x0D,0x0F,0x0E,0x0B,0x0C,0x0E,
	0x0B,0x0F,0x08,0x0C,0x06,0x0D,0x0B,0x0A,0x00,0x0B,0x0F,0x0A,0x0F,0x0C,0x0A,0x0F,
	0x0A,0x0C,0x0F,0x0F,0x00,0x0E,0x0B,0x0C,0x0C,0x00,0x0D,0x0D,0x0E,0x0A,0x0C,0x0F,
	0x0A,0x0D,0x00,0x0D,0x0F,0x0C,0x07,0x0C,0x0E,0x00,0x0F,0x0F,0x00,0x0B,0x0F,0x0F,
	0x0F,0x0B,0x0F,0x0C,0x0D,0x0F,0x00,0x0D,0x0A,0x0F,0x0C,0x0B,0x0B,0x0E,0x0E,0x0F,
	0x0B,0x0F,0x0D,0x0E,0x0D,0x00,0x0C,0x07,0x0A,0x0F,0x0F,0x0F,0x0A,0x0C,0x00,0x0F,
	0x0A,0x00,0x00,0x0F,0x09,0x0C,0x0C,0x0E,0x0F,0x0B,0x0C,0x0E,0x09,0x0A,0x00,0x0B,
	0x09,0x0B,0x00,0x0F,0x09,0x0C,0x00,0x0B,0x09,0x0F,0x00,0x0F,0x0F,0x0C,0x0D,0x0B,
	0x09,0x0F,0x0B,0x0E,0x00,0x0D,0x0B,0x0B,0x0A,0x00,0x0C,0x0E,0x0B,0x0F,0x00,0x0B,
	0x0A,0x00,0x0C,0x0E,0x0C,0x0F,0x0A,0x0B,0x0A,0x0A,0x0C,0x0E,0x0C,0x0F,0x0C,0x0B,
	0x00,0x0F,0x0F,0x0A,0x0F,0x0F,0x0C,0x0E,0x00,0x00,0x0F,0x0A,0x0F,0x0C,0x0A,0x0B,
	0x0A,0x09,0x0C,0x0E,0x00,0x0E,0x0B,0x0C,0x0F,0x0F,0x0A,0x0F,0x00,0x0F,0x0F,0x0F,
	0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0A,0x0F,0x0A,0x0F,0x0F,0x0F,0x00,0x0F,
	0x0A,0x0F,0x0A,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0A,0x00,0x0F,0x0F,0x0F,0x0D,0x0E,
	0x06,0x0F,0x0F,0x0D,0x0C,0x08,0x0F,0x0E,0x0A,0x0F,0x0F,0x0E,0x06,0x0E,0x0D,0x0B,
	0x06,0x0B,0x0F,0x0D,0x00,0x0E,0x0F,0x0F,0x0F,0x0F,0x09,0x0B,0x0A,0x08,0x0D,0x0E,
	/* B-1M - sprite palette red component */
	0x00,0x0A,0x0C,0x0F,0x0F,0x0C,0x09,0x0F,0x00,0x0F,0x0C,0x0F,0x0F,0x0A,0x0C,0x0F,
	0x00,0x0C,0x09,0x0F,0x0F,0x0A,0x00,0x0F,0x00,0x0F,0x0C,0x0F,0x00,0x0A,0x0B,0x0F,
	0x00,0x09,0x0B,0x0C,0x0D,0x0E,0x0F,0x0F,0x00,0x00,0x0B,0x0C,0x0D,0x0E,0x0F,0x0F,
	0x00,0x0C,0x0A,0x0E,0x09,0x0B,0x0F,0x0F,0x00,0x0F,0x0F,0x0E,0x0F,0x0E,0x0A,0x0B,
	0x00,0x0F,0x0F,0x0D,0x0C,0x0A,0x08,0x0B,0x00,0x0E,0x0F,0x0D,0x0C,0x0A,0x08,0x0F,
	0x00,0x0D,0x07,0x0E,0x00,0x0F,0x07,0x0F,0x00,0x0F,0x08,0x0F,0x07,0x0F,0x0C,0x0F,
	0x00,0x0F,0x07,0x0F,0x07,0x0F,0x0B,0x0F,0x00,0x0D,0x0F,0x0F,0x00,0x0E,0x08,0x0F,
	0x00,0x0F,0x0B,0x00,0x08,0x0C,0x0D,0x0F,0x00,0x0F,0x0B,0x0F,0x0F,0x0C,0x0D,0x0F,
	0x00,0x0F,0x0B,0x0F,0x08,0x0C,0x0D,0x0F,0x00,0x0D,0x09,0x0B,0x00,0x0E,0x0B,0x0F,
	0x00,0x0D,0x0B,0x0F,0x09,0x0E,0x0D,0x0F,0x00,0x0D,0x0F,0x0E,0x0A,0x0B,0x0B,0x0E,
	0x00,0x0D,0x08,0x0C,0x0A,0x0B,0x0B,0x0E,0x00,0x0F,0x07,0x0F,0x00,0x0F,0x0C,0x0F,
	0x00,0x0A,0x0A,0x0D,0x09,0x0F,0x0C,0x0E,0x00,0x0D,0x0A,0x0F,0x09,0x0F,0x0C,0x0E,
	0x00,0x0F,0x0D,0x0F,0x0B,0x0F,0x0D,0x0E,0x00,0x0F,0x0C,0x0F,0x0B,0x0E,0x0E,0x0D,
	0x00,0x0F,0x0A,0x0F,0x0B,0x0E,0x0B,0x0D,0x00,0x0F,0x0D,0x0E,0x00,0x0F,0x0A,0x0F,
	0x00,0x0F,0x0D,0x0E,0x0D,0x0F,0x0C,0x0F,0x00,0x0F,0x0C,0x0D,0x0C,0x0F,0x0F,0x0F,
	0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
	/* G-1F - character palette green component */
	0x00,0x00,0x0F,0x0F,0x00,0x00,0x0F,0x0F,0x08,0x0B,0x0A,0x00,0x0E,0x08,0x0A,0x0E,
	0x0B,0x0F,0x0C,0x0E,0x06,0x09,0x09,0x0A,0x00,0x08,0x0F,0x0C,0x0F,0x09,0x0A,0x0E,
	0x08,0x03,0x08,0x0B,0x00,0x0E,0x08,0x0A,0x0A,0x0C,0x0F,0x09,0x0E,0x08,0x0C,0x0C,
	0x08,0x0F,0x0E,0x09,0x0C,0x0C,0x07,0x0A,0x0E,0x0F,0x0C,0x0D,0x0F,0x08,0x0F,0x00,
	0x00,0x08,0x0F,0x0A,0x09,0x0C,0x0E,0x0F,0x0C,0x0C,0x0A,0x08,0x08,0x0D,0x0E,0x0F,
	0x08,0x0C,0x09,0x0E,0x0F,0x0E,0x0C,0x07,0x08,0x0F,0x0F,0x00,0x08,0x00,0x00,0x0F,
	0x08,0x0B,0x00,0x0C,0x09,0x0A,0x0C,0x0E,0x0F,0x08,0x0A,0x0E,0x09,0x0C,0x0D,0x0F,
	0x09,0x08,0x0E,0x0D,0x09,0x0A,0x0D,0x0F,0x09,0x0B,0x0E,0x0D,0x0F,0x0A,0x0D,0x0B,
	0x09,0x0B,0x08,0x0E,0x0D,0x0D,0x0F,0x0B,0x08,0x00,0x0A,0x0E,0x08,0x0C,0x0D,0x0A,
	0x08,0x00,0x0A,0x0E,0x09,0x0C,0x0C,0x08,0x08,0x08,0x0A,0x0E,0x09,0x0C,0x0A,0x08,
	0x00,0x0F,0x09,0x0A,0x0F,0x0F,0x0C,0x0E,0x00,0x0F,0x00,0x0A,0x0F,0x0C,0x0A,0x0B,
	0x08,0x09,0x0F,0x0E,0x00,0x0B,0x0E,0x0A,0x0F,0x0F,0x08,0x0F,0x00,0x0F,0x0F,0x0F,
	0x0F,0x0F,0x00,0x0F,0x00,0x0F,0x0F,0x0F,0x08,0x0F,0x08,0x0F,0x00,0x0F,0x00,0x0F,
	0x08,0x00,0x08,0x0F,0x00,0x09,0x00,0x0F,0x0E,0x0A,0x00,0x0F,0x00,0x0C,0x0B,0x0C,
	0x06,0x0F,0x00,0x02,0x0E,0x0C,0x0F,0x0D,0x08,0x0F,0x00,0x0E,0x06,0x0D,0x02,0x08,
	0x06,0x08,0x0F,0x02,0x0B,0x0D,0x00,0x0F,0x0E,0x00,0x08,0x08,0x0A,0x0C,0x0C,0x0E,
	/* B-1N - sprite palette green component */
	0x00,0x07,0x0C,0x0B,0x0C,0x0F,0x09,0x0F,0x00,0x00,0x0C,0x0B,0x0C,0x0D,0x0F,0x0F,
	0x00,0x0C,0x09,0x0B,0x0C,0x0D,0x00,0x0F,0x00,0x00,0x0F,0x0C,0x00,0x07,0x09,0x0B,
	0x00,0x09,0x0B,0x0D,0x00,0x0A,0x0B,0x0C,0x00,0x00,0x0B,0x0D,0x00,0x0A,0x0B,0x0F,
	0x00,0x0D,0x0B,0x0E,0x09,0x08,0x0D,0x0F,0x00,0x0F,0x0F,0x0A,0x0D,0x0C,0x08,0x0F,
	0x00,0x0B,0x0C,0x0E,0x0D,0x09,0x08,0x0B,0x00,0x0E,0x0C,0x0E,0x0D,0x09,0x08,0x0F,
	0x00,0x0C,0x0B,0x0D,0x00,0x0F,0x09,0x0F,0x00,0x00,0x0F,0x0B,0x07,0x0F,0x0A,0x0F,
	0x00,0x00,0x0C,0x0F,0x0A,0x0C,0x0E,0x0F,0x00,0x00,0x0F,0x0F,0x00,0x0A,0x08,0x0C,
	0x00,0x0C,0x09,0x00,0x08,0x0C,0x0B,0x0F,0x00,0x0C,0x09,0x0F,0x0A,0x0C,0x0B,0x0F,
	0x00,0x0C,0x09,0x0F,0x08,0x0C,0x0B,0x0F,0x00,0x00,0x0F,0x0B,0x0D,0x09,0x08,0x0C,
	0x00,0x00,0x0B,0x0F,0x09,0x09,0x0D,0x0C,0x00,0x08,0x0D,0x0E,0x0E,0x0B,0x0F,0x0E,
	0x00,0x08,0x0C,0x07,0x0E,0x0B,0x0F,0x0E,0x00,0x00,0x07,0x0F,0x00,0x0F,0x09,0x0F,
	0x00,0x09,0x0A,0x0C,0x09,0x0F,0x0C,0x0D,0x00,0x0B,0x0A,0x0F,0x09,0x0D,0x0C,0x0D,
	0x00,0x00,0x0D,0x0F,0x0A,0x0F,0x0B,0x0E,0x00,0x08,0x0B,0x0F,0x07,0x0B,0x0D,0x0D,
	0x00,0x08,0x0A,0x0F,0x07,0x0B,0x0B,0x0D,0x00,0x00,0x0C,0x0D,0x00,0x09,0x07,0x0F,
	0x00,0x00,0x0C,0x0D,0x00,0x09,0x0C,0x0F,0x00,0x0F,0x0C,0x0F,0x0C,0x0F,0x0F,0x0F,
	0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,
	/* G-1H - character palette blue component */
	0x00,0x00,0x00,0x00,0x0F,0x0F,0x0F,0x0F,0x0D,0x08,0x07,0x03,0x0C,0x00,0x08,0x0E,
	0x0B,0x0F,0x08,0x0C,0x06,0x05,0x05,0x0A,0x00,0x00,0x00,0x0F,0x0F,0x08,0x0A,0x0C,
	0x0D,0x04,0x08,0x0B,0x00,0x0C,0x00,0x08,0x08,0x0C,0x0F,0x07,0x0C,0x0D,0x0C,0x07,
	0x0D,0x0F,0x0E,0x07,0x07,0x0C,0x07,0x08,0x0C,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x03,0x00,0x00,0x08,0x07,0x07,0x0E,0x0F,0x0F,0x07,0x08,0x00,0x00,0x0A,0x0E,0x0F,
	0x00,0x07,0x07,0x0C,0x0F,0x0E,0x0C,0x07,0x0D,0x0F,0x0F,0x03,0x0D,0x08,0x00,0x0F,
	0x0D,0x0C,0x00,0x07,0x09,0x08,0x0C,0x0C,0x0F,0x00,0x08,0x0C,0x09,0x0F,0x00,0x0B,
	0x09,0x00,0x0A,0x09,0x09,0x08,0x00,0x0B,0x09,0x0B,0x0A,0x09,0x0F,0x08,0x0D,0x0B,
	0x09,0x0B,0x00,0x0C,0x00,0x0D,0x0B,0x0B,0x0D,0x00,0x08,0x0C,0x00,0x0B,0x0D,0x08,
	0x0D,0x00,0x08,0x0C,0x08,0x0B,0x0F,0x00,0x0D,0x00,0x08,0x0C,0x08,0x0B,0x08,0x00,
	0x00,0x0F,0x07,0x0A,0x0C,0x0B,0x00,0x00,0x00,0x0F,0x0F,0x0A,0x0F,0x0C,0x0A,0x0B,
	0x0D,0x09,0x0C,0x0C,0x0F,0x09,0x0E,0x08,0x0F,0x0F,0x0D,0x0F,0x00,0x0F,0x0F,0x0F,
	0x0F,0x0F,0x00,0x0F,0x00,0x0F,0x0F,0x0F,0x0D,0x00,0x0D,0x00,0x00,0x00,0x0A,0x0F,
	0x0D,0x00,0x0D,0x0F,0x00,0x09,0x00,0x0F,0x0D,0x0A,0x00,0x00,0x00,0x0B,0x09,0x0A,
	0x06,0x00,0x00,0x0C,0x0C,0x08,0x0F,0x0A,0x0D,0x00,0x00,0x0C,0x06,0x0A,0x0C,0x00,
	0x06,0x00,0x00,0x0C,0x00,0x0A,0x00,0x0F,0x0D,0x00,0x0B,0x00,0x0A,0x08,0x0B,0x0C,
	/* B-1L - sprite palette blue component */
	0x00,0x00,0x0C,0x09,0x0A,0x0F,0x09,0x0F,0x00,0x00,0x0C,0x09,0x0A,0x0E,0x0F,0x0F,
	0x00,0x0C,0x09,0x09,0x0A,0x0E,0x00,0x0F,0x00,0x00,0x0F,0x0A,0x00,0x00,0x07,0x09,
	0x00,0x0C,0x0D,0x0F,0x0D,0x0D,0x09,0x0A,0x00,0x00,0x0D,0x0F,0x0D,0x0D,0x09,0x00,
	0x00,0x0F,0x0C,0x0E,0x09,0x00,0x0B,0x0F,0x00,0x00,0x0F,0x00,0x0B,0x0A,0x00,0x0B,
	0x00,0x09,0x0A,0x0E,0x0F,0x07,0x08,0x0D,0x00,0x08,0x0A,0x0E,0x0F,0x07,0x08,0x0F,
	0x00,0x09,0x07,0x09,0x00,0x0F,0x07,0x0F,0x00,0x00,0x08,0x07,0x0B,0x0F,0x0F,0x0F,
	0x00,0x00,0x07,0x00,0x07,0x07,0x0E,0x0F,0x00,0x00,0x0F,0x00,0x0B,0x07,0x0F,0x07,
	0x00,0x00,0x08,0x00,0x0B,0x0C,0x09,0x0F,0x00,0x00,0x08,0x00,0x00,0x0C,0x09,0x0F,
	0x00,0x00,0x08,0x00,0x0B,0x0C,0x09,0x0F,0x00,0x00,0x09,0x0B,0x00,0x09,0x00,0x0A,
	0x00,0x00,0x0B,0x0F,0x09,0x09,0x0D,0x0A,0x00,0x00,0x0B,0x00,0x0A,0x0B,0x0B,0x0E,
	0x00,0x00,0x08,0x00,0x0A,0x0B,0x0B,0x0E,0x00,0x00,0x07,0x00,0x0E,0x0F,0x0C,0x0F,
	0x00,0x07,0x0A,0x09,0x09,0x0F,0x0C,0x0A,0x00,0x0C,0x0A,0x0F,0x09,0x0D,0x0C,0x0A,
	0x00,0x00,0x0D,0x00,0x08,0x0F,0x09,0x0E,0x00,0x08,0x08,0x09,0x08,0x09,0x0B,0x0D,
	0x00,0x08,0x0A,0x09,0x08,0x09,0x0B,0x0D,0x00,0x09,0x09,0x0B,0x00,0x00,0x08,0x0F,
	0x00,0x09,0x09,0x0B,0x00,0x00,0x0C,0x0F,0x00,0x0F,0x00,0x00,0x0C,0x0F,0x0F,0x0F,
	0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x00,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F,0x0F
};



static struct MachineDriver machine_driver =
{
	/* basic machine hardware */
	{
		{
			CPU_Z80,
			4000000,	/* 4 Mhz (?) */
			0,
			readmem,writemem,readport, writeport,
			interrupt,1
		},
		{
			CPU_M6803,
			1000000,	/* 1.0 Mhz ? */
			2,
			sound_readmem,sound_writemem,0,0,
			mpatrol_sh_interrupt,68	/* 68 ints per frame = 4080 ints/sec */
		}
	},
	60,
	10,	/* 10 CPU slices per frame - enough for the sound CPU to read all commands */
	0,

	/* video hardware */
	32*8, 32*8, { 0*8, 32*8-1, 0*8, 32*8-1 },
	gfxdecodeinfo,
	256,32*8+32*8,
	kungfum_vh_convert_color_prom,

	VIDEO_TYPE_RASTER,
	0,
	kungfum_vh_start,
	kungfum_vh_stop,
	kungfum_vh_screenrefresh,

	/* sound hardware */
	0,
	mpatrol_sh_init,
	mpatrol_sh_start,
	AY8910_sh_stop,
	AY8910_sh_update
};



/***************************************************************************

  Game driver(s)

***************************************************************************/

ROM_START( kungfum_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "a-4e-c.bin", 0x0000, 0x4000, 0x2f0e3ee2 )
	ROM_LOAD( "a-4d-c.bin", 0x4000, 0x4000, 0x8cba3ca0 )

	ROM_REGION(0x1e000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "g-4c-a.bin", 0x00000, 0x2000, 0x039d270f )	/* characters */
	ROM_LOAD( "g-4d-a.bin", 0x02000, 0x2000, 0x63ea9db4 )
	ROM_LOAD( "g-4e-a.bin", 0x04000, 0x2000, 0x8844653c )
	ROM_LOAD( "b-4k-.bin",  0x06000, 0x2000, 0x8d7ed674 )	/* sprites */
	ROM_LOAD( "b-4f-.bin",  0x08000, 0x2000, 0x5b150b93 )
	ROM_LOAD( "b-4l-.bin",  0x0a000, 0x2000, 0xec6d1b3f )
	ROM_LOAD( "b-4h-.bin",  0x0c000, 0x2000, 0x1a4951cf )
	ROM_LOAD( "b-3n-.bin",  0x0e000, 0x2000, 0x914a85c8 )
	ROM_LOAD( "b-4n-.bin",  0x10000, 0x2000, 0xc75445d4 )
	ROM_LOAD( "b-4m-.bin",  0x12000, 0x2000, 0x7397e287 )
	ROM_LOAD( "b-3m-.bin",  0x14000, 0x2000, 0x97089d1e )
	ROM_LOAD( "b-4c-.bin",  0x16000, 0x2000, 0x21d4b868 )
	ROM_LOAD( "b-4e-.bin",  0x18000, 0x2000, 0x01e029aa )
	ROM_LOAD( "b-4d-.bin",  0x1a000, 0x2000, 0x1ae251dc )
	ROM_LOAD( "b-4a-.bin",  0x1c000, 0x2000, 0x64f6568c )

	ROM_REGION(0x10000)	/* 64k for the audio CPU (6803) */
	ROM_LOAD( "a-3e-.bin", 0xa000, 0x2000, 0x5d39e85b )	/* samples (ADPCM 4-bit) */
	ROM_LOAD( "a-3f-.bin", 0xc000, 0x2000, 0x52c61b44 )	/* samples (ADPCM 4-bit) */
	ROM_LOAD( "a-3h-.bin", 0xe000, 0x2000, 0x9d1c669e )
ROM_END

ROM_START( kungfub_rom )
	ROM_REGION(0x10000)	/* 64k for code */
	ROM_LOAD( "kf4", 0x0000, 0x4000, 0xe189358b )
	ROM_LOAD( "kf5", 0x4000, 0x4000, 0x3f93ee29 )

	ROM_REGION(0x1e000)	/* temporary space for graphics (disposed after conversion) */
	ROM_LOAD( "kf8",  0x00000, 0x2000, 0x039d270f )	/* characters */
	ROM_LOAD( "kf7",  0x02000, 0x2000, 0x63ea9db4 )
	ROM_LOAD( "kf6",  0x04000, 0x2000, 0x8844653c )
	ROM_LOAD( "kf11", 0x06000, 0x4000, 0xe893dde7 )	/* sprites */
	ROM_LOAD( "kf12", 0x0a000, 0x4000, 0x06b64af0 )
	ROM_LOAD( "kf9",  0x0e000, 0x4000, 0x589ec01c )
	ROM_LOAD( "kf10", 0x12000, 0x4000, 0x0a9f7f99 )
	ROM_LOAD( "kf14", 0x16000, 0x4000, 0x23b491c2 )
	ROM_LOAD( "kf13", 0x1a000, 0x4000, 0x7fd80750 )

	ROM_REGION(0x10000)	/* 64k for the audio CPU (6803) */
	ROM_LOAD( "kf3", 0xa000, 0x2000, 0x5d39e85b )	/* samples (ADPCM 4-bit) */
	ROM_LOAD( "kf2", 0xc000, 0x2000, 0x52c61b44 )	/* samples (ADPCM 4-bit) */
	ROM_LOAD( "kf1", 0xe000, 0x2000, 0x9d1c669e )
ROM_END



static int hiload(void)
{
	/* get RAM pointer (this game is multiCPU, we can't assume the global */
	/* RAM pointer is pointing to the right place) */
	unsigned char *RAM = Machine->memory_region[0];


	/* check if the hi score table has already been initialized */
	if (memcmp(&RAM[0xea06],"\x00\x14\x95",3) == 0 &&
			memcmp(&RAM[0xea78],"\x00\x48\x52",3) == 0)
	{
		void *f;


		if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,0)) != 0)
		{
			osd_fread(f,&RAM[0xea06],6*20);
			RAM[0xe980] = RAM[0xea7a];
			RAM[0xe981] = RAM[0xea79];
			RAM[0xe982] = RAM[0xea78];
			osd_fclose(f);
		}

		return 1;
	}
	else return 0;	/* we can't load the hi scores yet */
}



static void hisave(void)
{
	void *f;
	/* get RAM pointer (this game is multiCPU, we can't assume the global */
	/* RAM pointer is pointing to the right place) */
	unsigned char *RAM = Machine->memory_region[0];


	if ((f = osd_fopen(Machine->gamedrv->name,0,OSD_FILETYPE_HIGHSCORE,1)) != 0)
	{
		osd_fwrite(f,&RAM[0xea06],6*20);
		osd_fclose(f);
	}
}



struct GameDriver kungfum_driver =
{
	"Kung Fu Master",
	"kungfum",
	"Mirko Buffoni\nNicola Salmoria\nIshmair\nPaul Swan\nAaron Giles (sound)",
	&machine_driver,

	kungfum_rom,
	0, 0,
	0,

	input_ports, 0, trak_ports, dsw, keys,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave
};

struct GameDriver kungfub_driver =
{
	"Kung Fu Master (bootleg)",
	"kungfub",
	"Mirko Buffoni\nNicola Salmoria\nIshmair\nPaul Swan\nAaron Giles (sound)",
	&machine_driver,

	kungfub_rom,
	0, 0,
	0,

	input_ports, 0, trak_ports, dsw, keys,

	color_prom, 0, 0,
	ORIENTATION_DEFAULT,

	hiload, hisave
};
