/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *  
 */

/* This file has been automatically generated --- DO NOT EDIT */

#include <fftw.h>
#include "konst.h"

/* Generated by $Id: genfft.ml,v 1.31 1997/08/27 20:46:08 fftw Exp $ */

/* This function contains 438 FP additions and 212 FP multiplications */

void fftw_twiddle_32(FFTW_COMPLEX *A, const FFTW_COMPLEX *W, int stride, int m, int dist)
{
     int i;
     COMPLEX *inout;
     inout = A;
     for (i = 0; i < m; i = i + 1, inout = inout + dist, W = W + 31) {
	  FFTW_REAL tre0_0_0;
	  FFTW_REAL tim0_0_0;
	  FFTW_REAL tre0_0_1;
	  FFTW_REAL tim0_0_1;
	  FFTW_REAL tre0_0_2;
	  FFTW_REAL tim0_0_2;
	  FFTW_REAL tre0_0_3;
	  FFTW_REAL tim0_0_3;
	  FFTW_REAL tre0_0_4;
	  FFTW_REAL tim0_0_4;
	  FFTW_REAL tre0_0_5;
	  FFTW_REAL tim0_0_5;
	  FFTW_REAL tre0_0_6;
	  FFTW_REAL tim0_0_6;
	  FFTW_REAL tre0_0_7;
	  FFTW_REAL tim0_0_7;
	  FFTW_REAL tre0_1_0;
	  FFTW_REAL tim0_1_0;
	  FFTW_REAL tre0_1_1;
	  FFTW_REAL tim0_1_1;
	  FFTW_REAL tre0_1_2;
	  FFTW_REAL tim0_1_2;
	  FFTW_REAL tre0_1_3;
	  FFTW_REAL tim0_1_3;
	  FFTW_REAL tre0_1_4;
	  FFTW_REAL tim0_1_4;
	  FFTW_REAL tre0_1_5;
	  FFTW_REAL tim0_1_5;
	  FFTW_REAL tre0_1_6;
	  FFTW_REAL tim0_1_6;
	  FFTW_REAL tre0_1_7;
	  FFTW_REAL tim0_1_7;
	  FFTW_REAL tre0_2_0;
	  FFTW_REAL tim0_2_0;
	  FFTW_REAL tre0_2_1;
	  FFTW_REAL tim0_2_1;
	  FFTW_REAL tre0_2_2;
	  FFTW_REAL tim0_2_2;
	  FFTW_REAL tre0_2_3;
	  FFTW_REAL tim0_2_3;
	  FFTW_REAL tre0_2_4;
	  FFTW_REAL tim0_2_4;
	  FFTW_REAL tre0_2_5;
	  FFTW_REAL tim0_2_5;
	  FFTW_REAL tre0_2_6;
	  FFTW_REAL tim0_2_6;
	  FFTW_REAL tre0_2_7;
	  FFTW_REAL tim0_2_7;
	  FFTW_REAL tre0_3_0;
	  FFTW_REAL tim0_3_0;
	  FFTW_REAL tre0_3_1;
	  FFTW_REAL tim0_3_1;
	  FFTW_REAL tre0_3_2;
	  FFTW_REAL tim0_3_2;
	  FFTW_REAL tre0_3_3;
	  FFTW_REAL tim0_3_3;
	  FFTW_REAL tre0_3_4;
	  FFTW_REAL tim0_3_4;
	  FFTW_REAL tre0_3_5;
	  FFTW_REAL tim0_3_5;
	  FFTW_REAL tre0_3_6;
	  FFTW_REAL tim0_3_6;
	  FFTW_REAL tre0_3_7;
	  FFTW_REAL tim0_3_7;
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = c_re(inout[0]);
		    tim2_0_0 = c_im(inout[0]);
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[16 * stride]);
			 ti = c_im(inout[16 * stride]);
			 twr = c_re(W[15]);
			 twi = c_im(W[15]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[8 * stride]);
			 ti = c_im(inout[8 * stride]);
			 twr = c_re(W[7]);
			 twi = c_im(W[7]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[24 * stride]);
			 ti = c_im(inout[24 * stride]);
			 twr = c_re(W[23]);
			 twi = c_im(W[23]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_0 = tre1_0_0 + tre1_0_1;
	       tim0_0_0 = tim1_0_0 + tim1_0_1;
	       tre0_2_0 = tre1_0_0 - tre1_0_1;
	       tim0_2_0 = tim1_0_0 - tim1_0_1;
	       tre0_1_0 = tre1_1_0 + tim1_1_1;
	       tim0_1_0 = tim1_1_0 - tre1_1_1;
	       tre0_3_0 = tre1_1_0 - tim1_1_1;
	       tim0_3_0 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[stride]);
			 ti = c_im(inout[stride]);
			 twr = c_re(W[0]);
			 twi = c_im(W[0]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[17 * stride]);
			 ti = c_im(inout[17 * stride]);
			 twr = c_re(W[16]);
			 twi = c_im(W[16]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[9 * stride]);
			 ti = c_im(inout[9 * stride]);
			 twr = c_re(W[8]);
			 twi = c_im(W[8]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[25 * stride]);
			 ti = c_im(inout[25 * stride]);
			 twr = c_re(W[24]);
			 twi = c_im(W[24]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_1 = tre1_0_0 + tre1_0_1;
	       tim0_0_1 = tim1_0_0 + tim1_0_1;
	       tre0_2_1 = tre1_0_0 - tre1_0_1;
	       tim0_2_1 = tim1_0_0 - tim1_0_1;
	       tre0_1_1 = tre1_1_0 + tim1_1_1;
	       tim0_1_1 = tim1_1_0 - tre1_1_1;
	       tre0_3_1 = tre1_1_0 - tim1_1_1;
	       tim0_3_1 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[2 * stride]);
			 ti = c_im(inout[2 * stride]);
			 twr = c_re(W[1]);
			 twi = c_im(W[1]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[18 * stride]);
			 ti = c_im(inout[18 * stride]);
			 twr = c_re(W[17]);
			 twi = c_im(W[17]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[10 * stride]);
			 ti = c_im(inout[10 * stride]);
			 twr = c_re(W[9]);
			 twi = c_im(W[9]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[26 * stride]);
			 ti = c_im(inout[26 * stride]);
			 twr = c_re(W[25]);
			 twi = c_im(W[25]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_2 = tre1_0_0 + tre1_0_1;
	       tim0_0_2 = tim1_0_0 + tim1_0_1;
	       tre0_2_2 = tre1_0_0 - tre1_0_1;
	       tim0_2_2 = tim1_0_0 - tim1_0_1;
	       tre0_1_2 = tre1_1_0 + tim1_1_1;
	       tim0_1_2 = tim1_1_0 - tre1_1_1;
	       tre0_3_2 = tre1_1_0 - tim1_1_1;
	       tim0_3_2 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[3 * stride]);
			 ti = c_im(inout[3 * stride]);
			 twr = c_re(W[2]);
			 twi = c_im(W[2]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[19 * stride]);
			 ti = c_im(inout[19 * stride]);
			 twr = c_re(W[18]);
			 twi = c_im(W[18]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[11 * stride]);
			 ti = c_im(inout[11 * stride]);
			 twr = c_re(W[10]);
			 twi = c_im(W[10]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[27 * stride]);
			 ti = c_im(inout[27 * stride]);
			 twr = c_re(W[26]);
			 twi = c_im(W[26]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_3 = tre1_0_0 + tre1_0_1;
	       tim0_0_3 = tim1_0_0 + tim1_0_1;
	       tre0_2_3 = tre1_0_0 - tre1_0_1;
	       tim0_2_3 = tim1_0_0 - tim1_0_1;
	       tre0_1_3 = tre1_1_0 + tim1_1_1;
	       tim0_1_3 = tim1_1_0 - tre1_1_1;
	       tre0_3_3 = tre1_1_0 - tim1_1_1;
	       tim0_3_3 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[4 * stride]);
			 ti = c_im(inout[4 * stride]);
			 twr = c_re(W[3]);
			 twi = c_im(W[3]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[20 * stride]);
			 ti = c_im(inout[20 * stride]);
			 twr = c_re(W[19]);
			 twi = c_im(W[19]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[12 * stride]);
			 ti = c_im(inout[12 * stride]);
			 twr = c_re(W[11]);
			 twi = c_im(W[11]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[28 * stride]);
			 ti = c_im(inout[28 * stride]);
			 twr = c_re(W[27]);
			 twi = c_im(W[27]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_4 = tre1_0_0 + tre1_0_1;
	       tim0_0_4 = tim1_0_0 + tim1_0_1;
	       tre0_2_4 = tre1_0_0 - tre1_0_1;
	       tim0_2_4 = tim1_0_0 - tim1_0_1;
	       tre0_1_4 = tre1_1_0 + tim1_1_1;
	       tim0_1_4 = tim1_1_0 - tre1_1_1;
	       tre0_3_4 = tre1_1_0 - tim1_1_1;
	       tim0_3_4 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[5 * stride]);
			 ti = c_im(inout[5 * stride]);
			 twr = c_re(W[4]);
			 twi = c_im(W[4]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[21 * stride]);
			 ti = c_im(inout[21 * stride]);
			 twr = c_re(W[20]);
			 twi = c_im(W[20]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[13 * stride]);
			 ti = c_im(inout[13 * stride]);
			 twr = c_re(W[12]);
			 twi = c_im(W[12]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[29 * stride]);
			 ti = c_im(inout[29 * stride]);
			 twr = c_re(W[28]);
			 twi = c_im(W[28]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_5 = tre1_0_0 + tre1_0_1;
	       tim0_0_5 = tim1_0_0 + tim1_0_1;
	       tre0_2_5 = tre1_0_0 - tre1_0_1;
	       tim0_2_5 = tim1_0_0 - tim1_0_1;
	       tre0_1_5 = tre1_1_0 + tim1_1_1;
	       tim0_1_5 = tim1_1_0 - tre1_1_1;
	       tre0_3_5 = tre1_1_0 - tim1_1_1;
	       tim0_3_5 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[6 * stride]);
			 ti = c_im(inout[6 * stride]);
			 twr = c_re(W[5]);
			 twi = c_im(W[5]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[22 * stride]);
			 ti = c_im(inout[22 * stride]);
			 twr = c_re(W[21]);
			 twi = c_im(W[21]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[14 * stride]);
			 ti = c_im(inout[14 * stride]);
			 twr = c_re(W[13]);
			 twi = c_im(W[13]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[30 * stride]);
			 ti = c_im(inout[30 * stride]);
			 twr = c_re(W[29]);
			 twi = c_im(W[29]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_6 = tre1_0_0 + tre1_0_1;
	       tim0_0_6 = tim1_0_0 + tim1_0_1;
	       tre0_2_6 = tre1_0_0 - tre1_0_1;
	       tim0_2_6 = tim1_0_0 - tim1_0_1;
	       tre0_1_6 = tre1_1_0 + tim1_1_1;
	       tim0_1_6 = tim1_1_0 - tre1_1_1;
	       tre0_3_6 = tre1_1_0 - tim1_1_1;
	       tim0_3_6 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[7 * stride]);
			 ti = c_im(inout[7 * stride]);
			 twr = c_re(W[6]);
			 twi = c_im(W[6]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[23 * stride]);
			 ti = c_im(inout[23 * stride]);
			 twr = c_re(W[22]);
			 twi = c_im(W[22]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[15 * stride]);
			 ti = c_im(inout[15 * stride]);
			 twr = c_re(W[14]);
			 twi = c_im(W[14]);
			 tre2_0_0 = (tr * twr) - (ti * twi);
			 tim2_0_0 = (tr * twi) + (ti * twr);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[31 * stride]);
			 ti = c_im(inout[31 * stride]);
			 twr = c_re(W[30]);
			 twi = c_im(W[30]);
			 tre2_1_0 = (tr * twr) - (ti * twi);
			 tim2_1_0 = (tr * twi) + (ti * twr);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       tre0_0_7 = tre1_0_0 + tre1_0_1;
	       tim0_0_7 = tim1_0_0 + tim1_0_1;
	       tre0_2_7 = tre1_0_0 - tre1_0_1;
	       tim0_2_7 = tim1_0_0 - tim1_0_1;
	       tre0_1_7 = tre1_1_0 + tim1_1_1;
	       tim0_1_7 = tim1_1_0 - tre1_1_1;
	       tre0_3_7 = tre1_1_0 - tim1_1_1;
	       tim0_3_7 = tim1_1_0 + tre1_1_1;
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       tre1_0_0 = tre0_0_0 + tre0_0_4;
	       tim1_0_0 = tim0_0_0 + tim0_0_4;
	       tre1_1_0 = tre0_0_0 - tre0_0_4;
	       tim1_1_0 = tim0_0_0 - tim0_0_4;
	       tre1_0_1 = tre0_0_1 + tre0_0_5;
	       tim1_0_1 = tim0_0_1 + tim0_0_5;
	       tre1_1_1 = tre0_0_1 - tre0_0_5;
	       tim1_1_1 = tim0_0_1 - tim0_0_5;
	       tre1_0_2 = tre0_0_2 + tre0_0_6;
	       tim1_0_2 = tim0_0_2 + tim0_0_6;
	       tre1_1_2 = tre0_0_2 - tre0_0_6;
	       tim1_1_2 = tim0_0_2 - tim0_0_6;
	       tre1_0_3 = tre0_0_3 + tre0_0_7;
	       tim1_0_3 = tim0_0_3 + tim0_0_7;
	       tre1_1_3 = tre0_0_3 - tre0_0_7;
	       tim1_1_3 = tim0_0_3 - tim0_0_7;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[0]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[0]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[16 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[16 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[8 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[8 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[24 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[24 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 + tim1_1_2;
		    tim2_0_0 = tim1_1_0 - tre1_1_2;
		    tre2_1_0 = tre1_1_0 - tim1_1_2;
		    tim2_1_0 = tim1_1_0 + tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 + tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 - tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 - tre1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 + tre1_1_3);
			 tre2_0_1 = tre3_0_0 + tre3_1_0;
			 tim2_0_1 = tim3_0_0 - tim3_1_0;
			 tre2_1_1 = tre3_0_0 - tre3_1_0;
			 tim2_1_1 = tim3_0_0 + tim3_1_0;
		    }
		    c_re(inout[4 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[4 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[20 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[20 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[12 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[12 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[28 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[28 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_1_4 + tim0_1_4);
		    tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_1_4 - tre0_1_4);
		    tre1_0_0 = tre0_1_0 + tre2_1_0;
		    tim1_0_0 = tim0_1_0 + tim2_1_0;
		    tre1_1_0 = tre0_1_0 - tre2_1_0;
		    tim1_1_0 = tim0_1_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_1_1) + (((FFTW_REAL) FFTW_K195090322) * tim0_1_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tim0_1_1) - (((FFTW_REAL) FFTW_K195090322) * tre0_1_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tre0_1_5) + (((FFTW_REAL) FFTW_K831469612) * tim0_1_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_1_5) - (((FFTW_REAL) FFTW_K831469612) * tre0_1_5);
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_1_2) + (((FFTW_REAL) FFTW_K382683432) * tim0_1_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_1_2) - (((FFTW_REAL) FFTW_K382683432) * tre0_1_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_1_6) + (((FFTW_REAL) FFTW_K923879532) * tim0_1_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_1_6) - (((FFTW_REAL) FFTW_K923879532) * tre0_1_6);
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_1_3) + (((FFTW_REAL) FFTW_K555570233) * tim0_1_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_1_3) - (((FFTW_REAL) FFTW_K555570233) * tre0_1_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_1_7) + (((FFTW_REAL) FFTW_K980785280) * tim0_1_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tim0_1_7) - (((FFTW_REAL) FFTW_K980785280) * tre0_1_7);
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[17 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[17 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[9 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[9 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[25 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[25 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 + tim1_1_2;
		    tim2_0_0 = tim1_1_0 - tre1_1_2;
		    tre2_1_0 = tre1_1_0 - tim1_1_2;
		    tim2_1_0 = tim1_1_0 + tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 + tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 - tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 - tre1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 + tre1_1_3);
			 tre2_0_1 = tre3_0_0 + tre3_1_0;
			 tim2_0_1 = tim3_0_0 - tim3_1_0;
			 tre2_1_1 = tre3_0_0 - tre3_1_0;
			 tim2_1_1 = tim3_0_0 + tim3_1_0;
		    }
		    c_re(inout[5 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[5 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[21 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[21 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[13 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[13 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[29 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[29 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       tre1_0_0 = tre0_2_0 + tim0_2_4;
	       tim1_0_0 = tim0_2_0 - tre0_2_4;
	       tre1_1_0 = tre0_2_0 - tim0_2_4;
	       tim1_1_0 = tim0_2_0 + tre0_2_4;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_2_1) + (((FFTW_REAL) FFTW_K382683432) * tim0_2_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_2_1) - (((FFTW_REAL) FFTW_K382683432) * tre0_2_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_2_5) - (((FFTW_REAL) FFTW_K382683432) * tre0_2_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_2_5) + (((FFTW_REAL) FFTW_K923879532) * tre0_2_5);
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 - tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_2_2 + tim0_2_2);
		    tim2_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_2_2 - tre0_2_2);
		    tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_2_6 - tre0_2_6);
		    tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_2_6 + tre0_2_6);
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 - tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_2_3) + (((FFTW_REAL) FFTW_K923879532) * tim0_2_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_2_3) - (((FFTW_REAL) FFTW_K923879532) * tre0_2_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_2_7) - (((FFTW_REAL) FFTW_K923879532) * tre0_2_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_2_7) + (((FFTW_REAL) FFTW_K382683432) * tre0_2_7);
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 - tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[2 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[2 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[18 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[18 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[10 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[10 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[26 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[26 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 + tim1_1_2;
		    tim2_0_0 = tim1_1_0 - tre1_1_2;
		    tre2_1_0 = tre1_1_0 - tim1_1_2;
		    tim2_1_0 = tim1_1_0 + tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 + tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 - tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 - tre1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 + tre1_1_3);
			 tre2_0_1 = tre3_0_0 + tre3_1_0;
			 tim2_0_1 = tim3_0_0 - tim3_1_0;
			 tre2_1_1 = tre3_0_0 - tre3_1_0;
			 tim2_1_1 = tim3_0_0 + tim3_1_0;
		    }
		    c_re(inout[6 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[6 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[22 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[22 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[14 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[14 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[30 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[30 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_3_4 - tre0_3_4);
		    tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_3_4 + tre0_3_4);
		    tre1_0_0 = tre0_3_0 + tre2_1_0;
		    tim1_0_0 = tim0_3_0 - tim2_1_0;
		    tre1_1_0 = tre0_3_0 - tre2_1_0;
		    tim1_1_0 = tim0_3_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_3_1) + (((FFTW_REAL) FFTW_K555570233) * tim0_3_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_3_1) - (((FFTW_REAL) FFTW_K555570233) * tre0_3_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tim0_3_5) - (((FFTW_REAL) FFTW_K980785280) * tre0_3_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K980785280) * tim0_3_5) + (((FFTW_REAL) FFTW_K195090322) * tre0_3_5);
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 - tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_3_2) + (((FFTW_REAL) FFTW_K923879532) * tim0_3_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_3_2) - (((FFTW_REAL) FFTW_K923879532) * tre0_3_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_3_6) + (((FFTW_REAL) FFTW_K382683432) * tim0_3_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_3_6) - (((FFTW_REAL) FFTW_K923879532) * tim0_3_6);
		    tre1_0_2 = tre2_0_0 - tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 + tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tim0_3_3) - (((FFTW_REAL) FFTW_K195090322) * tre0_3_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K195090322) * tim0_3_3) + (((FFTW_REAL) FFTW_K980785280) * tre0_3_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tre0_3_7) + (((FFTW_REAL) FFTW_K831469612) * tim0_3_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_3_7) - (((FFTW_REAL) FFTW_K555570233) * tim0_3_7);
		    tre1_0_3 = tre2_0_0 - tre2_1_0;
		    tim1_0_3 = tim2_1_0 - tim2_0_0;
		    tre1_1_3 = tre2_0_0 + tre2_1_0;
		    tim1_1_3 = (-(tim2_0_0 + tim2_1_0));
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[3 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[3 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[19 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[19 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[11 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[11 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[27 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[27 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 + tim1_1_2;
		    tim2_0_0 = tim1_1_0 - tre1_1_2;
		    tre2_1_0 = tre1_1_0 - tim1_1_2;
		    tim2_1_0 = tim1_1_0 + tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 + tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 - tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 - tre1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_3 + tre1_1_3);
			 tre2_0_1 = tre3_0_0 + tre3_1_0;
			 tim2_0_1 = tim3_0_0 - tim3_1_0;
			 tre2_1_1 = tre3_0_0 - tre3_1_0;
			 tim2_1_1 = tim3_0_0 + tim3_1_0;
		    }
		    c_re(inout[7 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[7 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[23 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[23 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[15 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[15 * stride]) = tim2_1_0 - tre2_1_1;
		    c_re(inout[31 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[31 * stride]) = tim2_1_0 + tre2_1_1;
	       }
	  }
     }
}
