/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *  
 */

/* This file has been automatically generated --- DO NOT EDIT */

#include <fftw.h>
#include "konst.h"

/* Generated by $Id: genfft.ml,v 1.31 1997/08/27 20:46:08 fftw Exp $ */

/* This function contains 1054 FP additions and 500 FP multiplications */

void fftwi_twiddle_64(FFTW_COMPLEX *A, const FFTW_COMPLEX *W, int stride, int m, int dist)
{
     int i;
     COMPLEX *inout;
     inout = A;
     for (i = 0; i < m; i = i + 1, inout = inout + dist, W = W + 63) {
	  FFTW_REAL tre0_0_0;
	  FFTW_REAL tim0_0_0;
	  FFTW_REAL tre0_0_1;
	  FFTW_REAL tim0_0_1;
	  FFTW_REAL tre0_0_2;
	  FFTW_REAL tim0_0_2;
	  FFTW_REAL tre0_0_3;
	  FFTW_REAL tim0_0_3;
	  FFTW_REAL tre0_0_4;
	  FFTW_REAL tim0_0_4;
	  FFTW_REAL tre0_0_5;
	  FFTW_REAL tim0_0_5;
	  FFTW_REAL tre0_0_6;
	  FFTW_REAL tim0_0_6;
	  FFTW_REAL tre0_0_7;
	  FFTW_REAL tim0_0_7;
	  FFTW_REAL tre0_1_0;
	  FFTW_REAL tim0_1_0;
	  FFTW_REAL tre0_1_1;
	  FFTW_REAL tim0_1_1;
	  FFTW_REAL tre0_1_2;
	  FFTW_REAL tim0_1_2;
	  FFTW_REAL tre0_1_3;
	  FFTW_REAL tim0_1_3;
	  FFTW_REAL tre0_1_4;
	  FFTW_REAL tim0_1_4;
	  FFTW_REAL tre0_1_5;
	  FFTW_REAL tim0_1_5;
	  FFTW_REAL tre0_1_6;
	  FFTW_REAL tim0_1_6;
	  FFTW_REAL tre0_1_7;
	  FFTW_REAL tim0_1_7;
	  FFTW_REAL tre0_2_0;
	  FFTW_REAL tim0_2_0;
	  FFTW_REAL tre0_2_1;
	  FFTW_REAL tim0_2_1;
	  FFTW_REAL tre0_2_2;
	  FFTW_REAL tim0_2_2;
	  FFTW_REAL tre0_2_3;
	  FFTW_REAL tim0_2_3;
	  FFTW_REAL tre0_2_4;
	  FFTW_REAL tim0_2_4;
	  FFTW_REAL tre0_2_5;
	  FFTW_REAL tim0_2_5;
	  FFTW_REAL tre0_2_6;
	  FFTW_REAL tim0_2_6;
	  FFTW_REAL tre0_2_7;
	  FFTW_REAL tim0_2_7;
	  FFTW_REAL tre0_3_0;
	  FFTW_REAL tim0_3_0;
	  FFTW_REAL tre0_3_1;
	  FFTW_REAL tim0_3_1;
	  FFTW_REAL tre0_3_2;
	  FFTW_REAL tim0_3_2;
	  FFTW_REAL tre0_3_3;
	  FFTW_REAL tim0_3_3;
	  FFTW_REAL tre0_3_4;
	  FFTW_REAL tim0_3_4;
	  FFTW_REAL tre0_3_5;
	  FFTW_REAL tim0_3_5;
	  FFTW_REAL tre0_3_6;
	  FFTW_REAL tim0_3_6;
	  FFTW_REAL tre0_3_7;
	  FFTW_REAL tim0_3_7;
	  FFTW_REAL tre0_4_0;
	  FFTW_REAL tim0_4_0;
	  FFTW_REAL tre0_4_1;
	  FFTW_REAL tim0_4_1;
	  FFTW_REAL tre0_4_2;
	  FFTW_REAL tim0_4_2;
	  FFTW_REAL tre0_4_3;
	  FFTW_REAL tim0_4_3;
	  FFTW_REAL tre0_4_4;
	  FFTW_REAL tim0_4_4;
	  FFTW_REAL tre0_4_5;
	  FFTW_REAL tim0_4_5;
	  FFTW_REAL tre0_4_6;
	  FFTW_REAL tim0_4_6;
	  FFTW_REAL tre0_4_7;
	  FFTW_REAL tim0_4_7;
	  FFTW_REAL tre0_5_0;
	  FFTW_REAL tim0_5_0;
	  FFTW_REAL tre0_5_1;
	  FFTW_REAL tim0_5_1;
	  FFTW_REAL tre0_5_2;
	  FFTW_REAL tim0_5_2;
	  FFTW_REAL tre0_5_3;
	  FFTW_REAL tim0_5_3;
	  FFTW_REAL tre0_5_4;
	  FFTW_REAL tim0_5_4;
	  FFTW_REAL tre0_5_5;
	  FFTW_REAL tim0_5_5;
	  FFTW_REAL tre0_5_6;
	  FFTW_REAL tim0_5_6;
	  FFTW_REAL tre0_5_7;
	  FFTW_REAL tim0_5_7;
	  FFTW_REAL tre0_6_0;
	  FFTW_REAL tim0_6_0;
	  FFTW_REAL tre0_6_1;
	  FFTW_REAL tim0_6_1;
	  FFTW_REAL tre0_6_2;
	  FFTW_REAL tim0_6_2;
	  FFTW_REAL tre0_6_3;
	  FFTW_REAL tim0_6_3;
	  FFTW_REAL tre0_6_4;
	  FFTW_REAL tim0_6_4;
	  FFTW_REAL tre0_6_5;
	  FFTW_REAL tim0_6_5;
	  FFTW_REAL tre0_6_6;
	  FFTW_REAL tim0_6_6;
	  FFTW_REAL tre0_6_7;
	  FFTW_REAL tim0_6_7;
	  FFTW_REAL tre0_7_0;
	  FFTW_REAL tim0_7_0;
	  FFTW_REAL tre0_7_1;
	  FFTW_REAL tim0_7_1;
	  FFTW_REAL tre0_7_2;
	  FFTW_REAL tim0_7_2;
	  FFTW_REAL tre0_7_3;
	  FFTW_REAL tim0_7_3;
	  FFTW_REAL tre0_7_4;
	  FFTW_REAL tim0_7_4;
	  FFTW_REAL tre0_7_5;
	  FFTW_REAL tim0_7_5;
	  FFTW_REAL tre0_7_6;
	  FFTW_REAL tim0_7_6;
	  FFTW_REAL tre0_7_7;
	  FFTW_REAL tim0_7_7;
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = c_re(inout[0]);
		    tim2_0_0 = c_im(inout[0]);
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[32 * stride]);
			 ti = c_im(inout[32 * stride]);
			 twr = c_re(W[31]);
			 twi = c_im(W[31]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[8 * stride]);
			 ti = c_im(inout[8 * stride]);
			 twr = c_re(W[7]);
			 twi = c_im(W[7]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[40 * stride]);
			 ti = c_im(inout[40 * stride]);
			 twr = c_re(W[39]);
			 twi = c_im(W[39]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[16 * stride]);
			 ti = c_im(inout[16 * stride]);
			 twr = c_re(W[15]);
			 twi = c_im(W[15]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[48 * stride]);
			 ti = c_im(inout[48 * stride]);
			 twr = c_re(W[47]);
			 twi = c_im(W[47]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[24 * stride]);
			 ti = c_im(inout[24 * stride]);
			 twr = c_re(W[23]);
			 twi = c_im(W[23]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[56 * stride]);
			 ti = c_im(inout[56 * stride]);
			 twr = c_re(W[55]);
			 twi = c_im(W[55]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_0 = tre2_0_0 + tre2_0_1;
		    tim0_0_0 = tim2_0_0 + tim2_0_1;
		    tre0_4_0 = tre2_0_0 - tre2_0_1;
		    tim0_4_0 = tim2_0_0 - tim2_0_1;
		    tre0_2_0 = tre2_1_0 - tim2_1_1;
		    tim0_2_0 = tim2_1_0 + tre2_1_1;
		    tre0_6_0 = tre2_1_0 + tim2_1_1;
		    tim0_6_0 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_0 = tre2_0_0 + tre2_0_1;
		    tim0_1_0 = tim2_0_0 + tim2_0_1;
		    tre0_5_0 = tre2_0_0 - tre2_0_1;
		    tim0_5_0 = tim2_0_0 - tim2_0_1;
		    tre0_3_0 = tre2_1_0 - tim2_1_1;
		    tim0_3_0 = tim2_1_0 + tre2_1_1;
		    tre0_7_0 = tre2_1_0 + tim2_1_1;
		    tim0_7_0 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[stride]);
			 ti = c_im(inout[stride]);
			 twr = c_re(W[0]);
			 twi = c_im(W[0]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[33 * stride]);
			 ti = c_im(inout[33 * stride]);
			 twr = c_re(W[32]);
			 twi = c_im(W[32]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[9 * stride]);
			 ti = c_im(inout[9 * stride]);
			 twr = c_re(W[8]);
			 twi = c_im(W[8]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[41 * stride]);
			 ti = c_im(inout[41 * stride]);
			 twr = c_re(W[40]);
			 twi = c_im(W[40]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[17 * stride]);
			 ti = c_im(inout[17 * stride]);
			 twr = c_re(W[16]);
			 twi = c_im(W[16]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[49 * stride]);
			 ti = c_im(inout[49 * stride]);
			 twr = c_re(W[48]);
			 twi = c_im(W[48]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[25 * stride]);
			 ti = c_im(inout[25 * stride]);
			 twr = c_re(W[24]);
			 twi = c_im(W[24]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[57 * stride]);
			 ti = c_im(inout[57 * stride]);
			 twr = c_re(W[56]);
			 twi = c_im(W[56]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_1 = tre2_0_0 + tre2_0_1;
		    tim0_0_1 = tim2_0_0 + tim2_0_1;
		    tre0_4_1 = tre2_0_0 - tre2_0_1;
		    tim0_4_1 = tim2_0_0 - tim2_0_1;
		    tre0_2_1 = tre2_1_0 - tim2_1_1;
		    tim0_2_1 = tim2_1_0 + tre2_1_1;
		    tre0_6_1 = tre2_1_0 + tim2_1_1;
		    tim0_6_1 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_1 = tre2_0_0 + tre2_0_1;
		    tim0_1_1 = tim2_0_0 + tim2_0_1;
		    tre0_5_1 = tre2_0_0 - tre2_0_1;
		    tim0_5_1 = tim2_0_0 - tim2_0_1;
		    tre0_3_1 = tre2_1_0 - tim2_1_1;
		    tim0_3_1 = tim2_1_0 + tre2_1_1;
		    tre0_7_1 = tre2_1_0 + tim2_1_1;
		    tim0_7_1 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[2 * stride]);
			 ti = c_im(inout[2 * stride]);
			 twr = c_re(W[1]);
			 twi = c_im(W[1]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[34 * stride]);
			 ti = c_im(inout[34 * stride]);
			 twr = c_re(W[33]);
			 twi = c_im(W[33]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[10 * stride]);
			 ti = c_im(inout[10 * stride]);
			 twr = c_re(W[9]);
			 twi = c_im(W[9]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[42 * stride]);
			 ti = c_im(inout[42 * stride]);
			 twr = c_re(W[41]);
			 twi = c_im(W[41]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[18 * stride]);
			 ti = c_im(inout[18 * stride]);
			 twr = c_re(W[17]);
			 twi = c_im(W[17]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[50 * stride]);
			 ti = c_im(inout[50 * stride]);
			 twr = c_re(W[49]);
			 twi = c_im(W[49]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[26 * stride]);
			 ti = c_im(inout[26 * stride]);
			 twr = c_re(W[25]);
			 twi = c_im(W[25]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[58 * stride]);
			 ti = c_im(inout[58 * stride]);
			 twr = c_re(W[57]);
			 twi = c_im(W[57]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_2 = tre2_0_0 + tre2_0_1;
		    tim0_0_2 = tim2_0_0 + tim2_0_1;
		    tre0_4_2 = tre2_0_0 - tre2_0_1;
		    tim0_4_2 = tim2_0_0 - tim2_0_1;
		    tre0_2_2 = tre2_1_0 - tim2_1_1;
		    tim0_2_2 = tim2_1_0 + tre2_1_1;
		    tre0_6_2 = tre2_1_0 + tim2_1_1;
		    tim0_6_2 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_2 = tre2_0_0 + tre2_0_1;
		    tim0_1_2 = tim2_0_0 + tim2_0_1;
		    tre0_5_2 = tre2_0_0 - tre2_0_1;
		    tim0_5_2 = tim2_0_0 - tim2_0_1;
		    tre0_3_2 = tre2_1_0 - tim2_1_1;
		    tim0_3_2 = tim2_1_0 + tre2_1_1;
		    tre0_7_2 = tre2_1_0 + tim2_1_1;
		    tim0_7_2 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[3 * stride]);
			 ti = c_im(inout[3 * stride]);
			 twr = c_re(W[2]);
			 twi = c_im(W[2]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[35 * stride]);
			 ti = c_im(inout[35 * stride]);
			 twr = c_re(W[34]);
			 twi = c_im(W[34]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[11 * stride]);
			 ti = c_im(inout[11 * stride]);
			 twr = c_re(W[10]);
			 twi = c_im(W[10]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[43 * stride]);
			 ti = c_im(inout[43 * stride]);
			 twr = c_re(W[42]);
			 twi = c_im(W[42]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[19 * stride]);
			 ti = c_im(inout[19 * stride]);
			 twr = c_re(W[18]);
			 twi = c_im(W[18]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[51 * stride]);
			 ti = c_im(inout[51 * stride]);
			 twr = c_re(W[50]);
			 twi = c_im(W[50]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[27 * stride]);
			 ti = c_im(inout[27 * stride]);
			 twr = c_re(W[26]);
			 twi = c_im(W[26]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[59 * stride]);
			 ti = c_im(inout[59 * stride]);
			 twr = c_re(W[58]);
			 twi = c_im(W[58]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_3 = tre2_0_0 + tre2_0_1;
		    tim0_0_3 = tim2_0_0 + tim2_0_1;
		    tre0_4_3 = tre2_0_0 - tre2_0_1;
		    tim0_4_3 = tim2_0_0 - tim2_0_1;
		    tre0_2_3 = tre2_1_0 - tim2_1_1;
		    tim0_2_3 = tim2_1_0 + tre2_1_1;
		    tre0_6_3 = tre2_1_0 + tim2_1_1;
		    tim0_6_3 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_3 = tre2_0_0 + tre2_0_1;
		    tim0_1_3 = tim2_0_0 + tim2_0_1;
		    tre0_5_3 = tre2_0_0 - tre2_0_1;
		    tim0_5_3 = tim2_0_0 - tim2_0_1;
		    tre0_3_3 = tre2_1_0 - tim2_1_1;
		    tim0_3_3 = tim2_1_0 + tre2_1_1;
		    tre0_7_3 = tre2_1_0 + tim2_1_1;
		    tim0_7_3 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[4 * stride]);
			 ti = c_im(inout[4 * stride]);
			 twr = c_re(W[3]);
			 twi = c_im(W[3]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[36 * stride]);
			 ti = c_im(inout[36 * stride]);
			 twr = c_re(W[35]);
			 twi = c_im(W[35]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[12 * stride]);
			 ti = c_im(inout[12 * stride]);
			 twr = c_re(W[11]);
			 twi = c_im(W[11]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[44 * stride]);
			 ti = c_im(inout[44 * stride]);
			 twr = c_re(W[43]);
			 twi = c_im(W[43]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[20 * stride]);
			 ti = c_im(inout[20 * stride]);
			 twr = c_re(W[19]);
			 twi = c_im(W[19]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[52 * stride]);
			 ti = c_im(inout[52 * stride]);
			 twr = c_re(W[51]);
			 twi = c_im(W[51]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[28 * stride]);
			 ti = c_im(inout[28 * stride]);
			 twr = c_re(W[27]);
			 twi = c_im(W[27]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[60 * stride]);
			 ti = c_im(inout[60 * stride]);
			 twr = c_re(W[59]);
			 twi = c_im(W[59]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_4 = tre2_0_0 + tre2_0_1;
		    tim0_0_4 = tim2_0_0 + tim2_0_1;
		    tre0_4_4 = tre2_0_0 - tre2_0_1;
		    tim0_4_4 = tim2_0_0 - tim2_0_1;
		    tre0_2_4 = tre2_1_0 - tim2_1_1;
		    tim0_2_4 = tim2_1_0 + tre2_1_1;
		    tre0_6_4 = tre2_1_0 + tim2_1_1;
		    tim0_6_4 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_4 = tre2_0_0 + tre2_0_1;
		    tim0_1_4 = tim2_0_0 + tim2_0_1;
		    tre0_5_4 = tre2_0_0 - tre2_0_1;
		    tim0_5_4 = tim2_0_0 - tim2_0_1;
		    tre0_3_4 = tre2_1_0 - tim2_1_1;
		    tim0_3_4 = tim2_1_0 + tre2_1_1;
		    tre0_7_4 = tre2_1_0 + tim2_1_1;
		    tim0_7_4 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[5 * stride]);
			 ti = c_im(inout[5 * stride]);
			 twr = c_re(W[4]);
			 twi = c_im(W[4]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[37 * stride]);
			 ti = c_im(inout[37 * stride]);
			 twr = c_re(W[36]);
			 twi = c_im(W[36]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[13 * stride]);
			 ti = c_im(inout[13 * stride]);
			 twr = c_re(W[12]);
			 twi = c_im(W[12]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[45 * stride]);
			 ti = c_im(inout[45 * stride]);
			 twr = c_re(W[44]);
			 twi = c_im(W[44]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[21 * stride]);
			 ti = c_im(inout[21 * stride]);
			 twr = c_re(W[20]);
			 twi = c_im(W[20]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[53 * stride]);
			 ti = c_im(inout[53 * stride]);
			 twr = c_re(W[52]);
			 twi = c_im(W[52]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[29 * stride]);
			 ti = c_im(inout[29 * stride]);
			 twr = c_re(W[28]);
			 twi = c_im(W[28]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[61 * stride]);
			 ti = c_im(inout[61 * stride]);
			 twr = c_re(W[60]);
			 twi = c_im(W[60]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_5 = tre2_0_0 + tre2_0_1;
		    tim0_0_5 = tim2_0_0 + tim2_0_1;
		    tre0_4_5 = tre2_0_0 - tre2_0_1;
		    tim0_4_5 = tim2_0_0 - tim2_0_1;
		    tre0_2_5 = tre2_1_0 - tim2_1_1;
		    tim0_2_5 = tim2_1_0 + tre2_1_1;
		    tre0_6_5 = tre2_1_0 + tim2_1_1;
		    tim0_6_5 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_5 = tre2_0_0 + tre2_0_1;
		    tim0_1_5 = tim2_0_0 + tim2_0_1;
		    tre0_5_5 = tre2_0_0 - tre2_0_1;
		    tim0_5_5 = tim2_0_0 - tim2_0_1;
		    tre0_3_5 = tre2_1_0 - tim2_1_1;
		    tim0_3_5 = tim2_1_0 + tre2_1_1;
		    tre0_7_5 = tre2_1_0 + tim2_1_1;
		    tim0_7_5 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[6 * stride]);
			 ti = c_im(inout[6 * stride]);
			 twr = c_re(W[5]);
			 twi = c_im(W[5]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[38 * stride]);
			 ti = c_im(inout[38 * stride]);
			 twr = c_re(W[37]);
			 twi = c_im(W[37]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[14 * stride]);
			 ti = c_im(inout[14 * stride]);
			 twr = c_re(W[13]);
			 twi = c_im(W[13]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[46 * stride]);
			 ti = c_im(inout[46 * stride]);
			 twr = c_re(W[45]);
			 twi = c_im(W[45]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[22 * stride]);
			 ti = c_im(inout[22 * stride]);
			 twr = c_re(W[21]);
			 twi = c_im(W[21]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[54 * stride]);
			 ti = c_im(inout[54 * stride]);
			 twr = c_re(W[53]);
			 twi = c_im(W[53]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[30 * stride]);
			 ti = c_im(inout[30 * stride]);
			 twr = c_re(W[29]);
			 twi = c_im(W[29]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[62 * stride]);
			 ti = c_im(inout[62 * stride]);
			 twr = c_re(W[61]);
			 twi = c_im(W[61]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_6 = tre2_0_0 + tre2_0_1;
		    tim0_0_6 = tim2_0_0 + tim2_0_1;
		    tre0_4_6 = tre2_0_0 - tre2_0_1;
		    tim0_4_6 = tim2_0_0 - tim2_0_1;
		    tre0_2_6 = tre2_1_0 - tim2_1_1;
		    tim0_2_6 = tim2_1_0 + tre2_1_1;
		    tre0_6_6 = tre2_1_0 + tim2_1_1;
		    tim0_6_6 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_6 = tre2_0_0 + tre2_0_1;
		    tim0_1_6 = tim2_0_0 + tim2_0_1;
		    tre0_5_6 = tre2_0_0 - tre2_0_1;
		    tim0_5_6 = tim2_0_0 - tim2_0_1;
		    tre0_3_6 = tre2_1_0 - tim2_1_1;
		    tim0_3_6 = tim2_1_0 + tre2_1_1;
		    tre0_7_6 = tre2_1_0 + tim2_1_1;
		    tim0_7_6 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[7 * stride]);
			 ti = c_im(inout[7 * stride]);
			 twr = c_re(W[6]);
			 twi = c_im(W[6]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[39 * stride]);
			 ti = c_im(inout[39 * stride]);
			 twr = c_re(W[38]);
			 twi = c_im(W[38]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_0 = tre2_0_0 + tre2_1_0;
		    tim1_0_0 = tim2_0_0 + tim2_1_0;
		    tre1_1_0 = tre2_0_0 - tre2_1_0;
		    tim1_1_0 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[15 * stride]);
			 ti = c_im(inout[15 * stride]);
			 twr = c_re(W[14]);
			 twi = c_im(W[14]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[47 * stride]);
			 ti = c_im(inout[47 * stride]);
			 twr = c_re(W[46]);
			 twi = c_im(W[46]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[23 * stride]);
			 ti = c_im(inout[23 * stride]);
			 twr = c_re(W[22]);
			 twi = c_im(W[22]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[55 * stride]);
			 ti = c_im(inout[55 * stride]);
			 twr = c_re(W[54]);
			 twi = c_im(W[54]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[31 * stride]);
			 ti = c_im(inout[31 * stride]);
			 twr = c_re(W[30]);
			 twi = c_im(W[30]);
			 tre2_0_0 = (tr * twr) + (ti * twi);
			 tim2_0_0 = (ti * twr) - (tr * twi);
		    }
		    {
			 FFTW_REAL tr;
			 FFTW_REAL ti;
			 FFTW_REAL twr;
			 FFTW_REAL twi;
			 tr = c_re(inout[63 * stride]);
			 ti = c_im(inout[63 * stride]);
			 twr = c_re(W[62]);
			 twi = c_im(W[62]);
			 tre2_1_0 = (tr * twr) + (ti * twi);
			 tim2_1_0 = (ti * twr) - (tr * twi);
		    }
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    tre0_0_7 = tre2_0_0 + tre2_0_1;
		    tim0_0_7 = tim2_0_0 + tim2_0_1;
		    tre0_4_7 = tre2_0_0 - tre2_0_1;
		    tim0_4_7 = tim2_0_0 - tim2_0_1;
		    tre0_2_7 = tre2_1_0 - tim2_1_1;
		    tim0_2_7 = tim2_1_0 + tre2_1_1;
		    tre0_6_7 = tre2_1_0 + tim2_1_1;
		    tim0_6_7 = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    tre0_1_7 = tre2_0_0 + tre2_0_1;
		    tim0_1_7 = tim2_0_0 + tim2_0_1;
		    tre0_5_7 = tre2_0_0 - tre2_0_1;
		    tim0_5_7 = tim2_0_0 - tim2_0_1;
		    tre0_3_7 = tre2_1_0 - tim2_1_1;
		    tim0_3_7 = tim2_1_0 + tre2_1_1;
		    tre0_7_7 = tre2_1_0 + tim2_1_1;
		    tim0_7_7 = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       tre1_0_0 = tre0_0_0 + tre0_0_4;
	       tim1_0_0 = tim0_0_0 + tim0_0_4;
	       tre1_1_0 = tre0_0_0 - tre0_0_4;
	       tim1_1_0 = tim0_0_0 - tim0_0_4;
	       tre1_0_1 = tre0_0_1 + tre0_0_5;
	       tim1_0_1 = tim0_0_1 + tim0_0_5;
	       tre1_1_1 = tre0_0_1 - tre0_0_5;
	       tim1_1_1 = tim0_0_1 - tim0_0_5;
	       tre1_0_2 = tre0_0_2 + tre0_0_6;
	       tim1_0_2 = tim0_0_2 + tim0_0_6;
	       tre1_1_2 = tre0_0_2 - tre0_0_6;
	       tim1_1_2 = tim0_0_2 - tim0_0_6;
	       tre1_0_3 = tre0_0_3 + tre0_0_7;
	       tim1_0_3 = tim0_0_3 + tim0_0_7;
	       tre1_1_3 = tre0_0_3 - tre0_0_7;
	       tim1_1_3 = tim0_0_3 - tim0_0_7;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[0]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[0]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[32 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[32 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[16 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[16 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[48 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[48 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[8 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[8 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[40 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[40 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[24 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[24 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[56 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[56 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_1_4) - (((FFTW_REAL) FFTW_K382683432) * tim0_1_4);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_1_4) + (((FFTW_REAL) FFTW_K382683432) * tre0_1_4);
		    tre1_0_0 = tre0_1_0 + tre2_1_0;
		    tim1_0_0 = tim0_1_0 + tim2_1_0;
		    tre1_1_0 = tre0_1_0 - tre2_1_0;
		    tim1_1_0 = tim0_1_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K995184726) * tre0_1_1) - (((FFTW_REAL) FFTW_K098017140) * tim0_1_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K995184726) * tim0_1_1) + (((FFTW_REAL) FFTW_K098017140) * tre0_1_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_1_5) - (((FFTW_REAL) FFTW_K471396736) * tim0_1_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K881921264) * tim0_1_5) + (((FFTW_REAL) FFTW_K471396736) * tre0_1_5);
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_1_2) - (((FFTW_REAL) FFTW_K195090322) * tim0_1_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tim0_1_2) + (((FFTW_REAL) FFTW_K195090322) * tre0_1_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_1_6) - (((FFTW_REAL) FFTW_K555570233) * tim0_1_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_1_6) + (((FFTW_REAL) FFTW_K555570233) * tre0_1_6);
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tre0_1_3) - (((FFTW_REAL) FFTW_K290284677) * tim0_1_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_1_3) + (((FFTW_REAL) FFTW_K290284677) * tre0_1_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K773010453) * tre0_1_7) - (((FFTW_REAL) FFTW_K634393284) * tim0_1_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K773010453) * tim0_1_7) + (((FFTW_REAL) FFTW_K634393284) * tre0_1_7);
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[33 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[33 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[17 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[17 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[49 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[49 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[9 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[9 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[41 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[41 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[25 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[25 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[57 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[57 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_2_4 - tim0_2_4);
		    tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_2_4 + tre0_2_4);
		    tre1_0_0 = tre0_2_0 + tre2_1_0;
		    tim1_0_0 = tim0_2_0 + tim2_1_0;
		    tre1_1_0 = tre0_2_0 - tre2_1_0;
		    tim1_1_0 = tim0_2_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_2_1) - (((FFTW_REAL) FFTW_K195090322) * tim0_2_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tim0_2_1) + (((FFTW_REAL) FFTW_K195090322) * tre0_2_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tre0_2_5) - (((FFTW_REAL) FFTW_K831469612) * tim0_2_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_2_5) + (((FFTW_REAL) FFTW_K831469612) * tre0_2_5);
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_2_2) - (((FFTW_REAL) FFTW_K382683432) * tim0_2_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_2_2) + (((FFTW_REAL) FFTW_K382683432) * tre0_2_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_2_6) - (((FFTW_REAL) FFTW_K923879532) * tim0_2_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_2_6) + (((FFTW_REAL) FFTW_K923879532) * tre0_2_6);
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_2_3) - (((FFTW_REAL) FFTW_K555570233) * tim0_2_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_2_3) + (((FFTW_REAL) FFTW_K555570233) * tre0_2_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_2_7) - (((FFTW_REAL) FFTW_K980785280) * tim0_2_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tim0_2_7) + (((FFTW_REAL) FFTW_K980785280) * tre0_2_7);
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[2 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[2 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[34 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[34 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[18 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[18 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[50 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[50 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[10 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[10 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[42 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[42 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[26 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[26 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[58 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[58 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_3_4) - (((FFTW_REAL) FFTW_K923879532) * tim0_3_4);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_3_4) + (((FFTW_REAL) FFTW_K923879532) * tre0_3_4);
		    tre1_0_0 = tre0_3_0 + tre2_1_0;
		    tim1_0_0 = tim0_3_0 + tim2_1_0;
		    tre1_1_0 = tre0_3_0 - tre2_1_0;
		    tim1_1_0 = tim0_3_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tre0_3_1) - (((FFTW_REAL) FFTW_K290284677) * tim0_3_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_3_1) + (((FFTW_REAL) FFTW_K290284677) * tre0_3_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tre0_3_5) - (((FFTW_REAL) FFTW_K995184726) * tim0_3_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tim0_3_5) + (((FFTW_REAL) FFTW_K995184726) * tre0_3_5);
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_3_2) - (((FFTW_REAL) FFTW_K555570233) * tim0_3_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_3_2) + (((FFTW_REAL) FFTW_K555570233) * tre0_3_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_3_6) + (((FFTW_REAL) FFTW_K980785280) * tim0_3_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_3_6) - (((FFTW_REAL) FFTW_K195090322) * tim0_3_6);
		    tre1_0_2 = tre2_0_0 - tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 + tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K634393284) * tre0_3_3) - (((FFTW_REAL) FFTW_K773010453) * tim0_3_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K634393284) * tim0_3_3) + (((FFTW_REAL) FFTW_K773010453) * tre0_3_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K471396736) * tre0_3_7) + (((FFTW_REAL) FFTW_K881921264) * tim0_3_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_3_7) - (((FFTW_REAL) FFTW_K471396736) * tim0_3_7);
		    tre1_0_3 = tre2_0_0 - tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 + tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[3 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[3 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[35 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[35 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[19 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[19 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[51 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[51 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[11 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[11 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[43 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[43 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[27 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[27 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[59 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[59 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       tre1_0_0 = tre0_4_0 - tim0_4_4;
	       tim1_0_0 = tim0_4_0 + tre0_4_4;
	       tre1_1_0 = tre0_4_0 + tim0_4_4;
	       tim1_1_0 = tim0_4_0 - tre0_4_4;
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_4_1) - (((FFTW_REAL) FFTW_K382683432) * tim0_4_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_4_1) + (((FFTW_REAL) FFTW_K382683432) * tre0_4_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_4_5) + (((FFTW_REAL) FFTW_K923879532) * tim0_4_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_4_5) - (((FFTW_REAL) FFTW_K382683432) * tim0_4_5);
		    tre1_0_1 = tre2_0_0 - tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 + tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_4_2 - tim0_4_2);
		    tim2_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim0_4_2 + tre0_4_2);
		    tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_4_6 + tim0_4_6);
		    tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_4_6 - tim0_4_6);
		    tre1_0_2 = tre2_0_0 - tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 + tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_4_3) - (((FFTW_REAL) FFTW_K923879532) * tim0_4_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_4_3) + (((FFTW_REAL) FFTW_K923879532) * tre0_4_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_4_7) + (((FFTW_REAL) FFTW_K382683432) * tim0_4_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_4_7) - (((FFTW_REAL) FFTW_K923879532) * tim0_4_7);
		    tre1_0_3 = tre2_0_0 - tre2_1_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = tre2_0_0 + tre2_1_0;
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[4 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[4 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[36 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[36 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[20 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[20 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[52 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[52 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[12 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[12 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[44 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[44 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[28 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[28 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[60 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[60 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_5_4) + (((FFTW_REAL) FFTW_K923879532) * tim0_5_4);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_5_4) - (((FFTW_REAL) FFTW_K382683432) * tim0_5_4);
		    tre1_0_0 = tre0_5_0 - tre2_1_0;
		    tim1_0_0 = tim0_5_0 + tim2_1_0;
		    tre1_1_0 = tre0_5_0 + tre2_1_0;
		    tim1_1_0 = tim0_5_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_5_1) - (((FFTW_REAL) FFTW_K471396736) * tim0_5_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K881921264) * tim0_5_1) + (((FFTW_REAL) FFTW_K471396736) * tre0_5_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K773010453) * tre0_5_5) + (((FFTW_REAL) FFTW_K634393284) * tim0_5_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K634393284) * tre0_5_5) - (((FFTW_REAL) FFTW_K773010453) * tim0_5_5);
		    tre1_0_1 = tre2_0_0 - tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 + tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K555570233) * tre0_5_2) - (((FFTW_REAL) FFTW_K831469612) * tim0_5_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_5_2) + (((FFTW_REAL) FFTW_K831469612) * tre0_5_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_5_6) + (((FFTW_REAL) FFTW_K195090322) * tim0_5_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_5_6) - (((FFTW_REAL) FFTW_K980785280) * tim0_5_6);
		    tre1_0_2 = tre2_0_0 - tre2_1_0;
		    tim1_0_2 = tim2_0_0 + tim2_1_0;
		    tre1_1_2 = tre2_0_0 + tre2_1_0;
		    tim1_1_2 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K098017140) * tre0_5_3) - (((FFTW_REAL) FFTW_K995184726) * tim0_5_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K098017140) * tim0_5_3) + (((FFTW_REAL) FFTW_K995184726) * tre0_5_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K290284677) * tim0_5_7) - (((FFTW_REAL) FFTW_K956940335) * tre0_5_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_5_7) + (((FFTW_REAL) FFTW_K290284677) * tre0_5_7);
		    tre1_0_3 = tre2_0_0 + tre2_1_0;
		    tim1_0_3 = tim2_0_0 - tim2_1_0;
		    tre1_1_3 = tre2_0_0 - tre2_1_0;
		    tim1_1_3 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[5 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[5 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[37 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[37 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[21 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[21 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[53 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[53 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[13 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[13 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[45 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[45 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[29 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[29 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[61 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[61 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_6_4 + tim0_6_4);
		    tim2_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre0_6_4 - tim0_6_4);
		    tre1_0_0 = tre0_6_0 - tre2_1_0;
		    tim1_0_0 = tim0_6_0 + tim2_1_0;
		    tre1_1_0 = tre0_6_0 + tre2_1_0;
		    tim1_1_0 = tim0_6_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tre0_6_1) - (((FFTW_REAL) FFTW_K555570233) * tim0_6_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_6_1) + (((FFTW_REAL) FFTW_K555570233) * tre0_6_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_6_5) + (((FFTW_REAL) FFTW_K195090322) * tim0_6_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_6_5) - (((FFTW_REAL) FFTW_K980785280) * tim0_6_5);
		    tre1_0_1 = tre2_0_0 - tre2_1_0;
		    tim1_0_1 = tim2_0_0 + tim2_1_0;
		    tre1_1_1 = tre2_0_0 + tre2_1_0;
		    tim1_1_1 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_6_2) - (((FFTW_REAL) FFTW_K923879532) * tim0_6_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_6_2) + (((FFTW_REAL) FFTW_K923879532) * tre0_6_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tim0_6_6) - (((FFTW_REAL) FFTW_K923879532) * tre0_6_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tim0_6_6) + (((FFTW_REAL) FFTW_K382683432) * tre0_6_6);
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 - tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_6_3) + (((FFTW_REAL) FFTW_K980785280) * tim0_6_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K980785280) * tre0_6_3) - (((FFTW_REAL) FFTW_K195090322) * tim0_6_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_6_7) - (((FFTW_REAL) FFTW_K555570233) * tre0_6_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_6_7) + (((FFTW_REAL) FFTW_K831469612) * tre0_6_7);
		    tre1_0_3 = tre2_1_0 - tre2_0_0;
		    tim1_0_3 = tim2_0_0 - tim2_1_0;
		    tre1_1_3 = (-(tre2_0_0 + tre2_1_0));
		    tim1_1_3 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[6 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[6 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[38 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[38 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[22 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[22 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[54 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[54 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[14 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[14 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[46 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[46 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[30 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[30 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[62 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[62 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
	  {
	       FFTW_REAL tre1_0_0;
	       FFTW_REAL tim1_0_0;
	       FFTW_REAL tre1_0_1;
	       FFTW_REAL tim1_0_1;
	       FFTW_REAL tre1_0_2;
	       FFTW_REAL tim1_0_2;
	       FFTW_REAL tre1_0_3;
	       FFTW_REAL tim1_0_3;
	       FFTW_REAL tre1_1_0;
	       FFTW_REAL tim1_1_0;
	       FFTW_REAL tre1_1_1;
	       FFTW_REAL tim1_1_1;
	       FFTW_REAL tre1_1_2;
	       FFTW_REAL tim1_1_2;
	       FFTW_REAL tre1_1_3;
	       FFTW_REAL tim1_1_3;
	       {
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_1_0 = (((FFTW_REAL) FFTW_K923879532) * tre0_7_4) + (((FFTW_REAL) FFTW_K382683432) * tim0_7_4);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K382683432) * tre0_7_4) - (((FFTW_REAL) FFTW_K923879532) * tim0_7_4);
		    tre1_0_0 = tre0_7_0 - tre2_1_0;
		    tim1_0_0 = tim0_7_0 + tim2_1_0;
		    tre1_1_0 = tre0_7_0 + tre2_1_0;
		    tim1_1_0 = tim0_7_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K773010453) * tre0_7_1) - (((FFTW_REAL) FFTW_K634393284) * tim0_7_1);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K773010453) * tim0_7_1) + (((FFTW_REAL) FFTW_K634393284) * tre0_7_1);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K290284677) * tim0_7_5) - (((FFTW_REAL) FFTW_K956940335) * tre0_7_5);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K956940335) * tim0_7_5) + (((FFTW_REAL) FFTW_K290284677) * tre0_7_5);
		    tre1_0_1 = tre2_0_0 + tre2_1_0;
		    tim1_0_1 = tim2_0_0 - tim2_1_0;
		    tre1_1_1 = tre2_0_0 - tre2_1_0;
		    tim1_1_1 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K195090322) * tre0_7_2) - (((FFTW_REAL) FFTW_K980785280) * tim0_7_2);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K195090322) * tim0_7_2) + (((FFTW_REAL) FFTW_K980785280) * tre0_7_2);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K831469612) * tim0_7_6) - (((FFTW_REAL) FFTW_K555570233) * tre0_7_6);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K555570233) * tim0_7_6) + (((FFTW_REAL) FFTW_K831469612) * tre0_7_6);
		    tre1_0_2 = tre2_0_0 + tre2_1_0;
		    tim1_0_2 = tim2_0_0 - tim2_1_0;
		    tre1_1_2 = tre2_0_0 - tre2_1_0;
		    tim1_1_2 = tim2_0_0 + tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    tre2_0_0 = (((FFTW_REAL) FFTW_K471396736) * tre0_7_3) + (((FFTW_REAL) FFTW_K881921264) * tim0_7_3);
		    tim2_0_0 = (((FFTW_REAL) FFTW_K881921264) * tre0_7_3) - (((FFTW_REAL) FFTW_K471396736) * tim0_7_3);
		    tre2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tre0_7_7) + (((FFTW_REAL) FFTW_K995184726) * tim0_7_7);
		    tim2_1_0 = (((FFTW_REAL) FFTW_K098017140) * tim0_7_7) - (((FFTW_REAL) FFTW_K995184726) * tre0_7_7);
		    tre1_0_3 = tre2_1_0 - tre2_0_0;
		    tim1_0_3 = tim2_0_0 + tim2_1_0;
		    tre1_1_3 = (-(tre2_0_0 + tre2_1_0));
		    tim1_1_3 = tim2_0_0 - tim2_1_0;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_0_0 + tre1_0_2;
		    tim2_0_0 = tim1_0_0 + tim1_0_2;
		    tre2_1_0 = tre1_0_0 - tre1_0_2;
		    tim2_1_0 = tim1_0_0 - tim1_0_2;
		    tre2_0_1 = tre1_0_1 + tre1_0_3;
		    tim2_0_1 = tim1_0_1 + tim1_0_3;
		    tre2_1_1 = tre1_0_1 - tre1_0_3;
		    tim2_1_1 = tim1_0_1 - tim1_0_3;
		    c_re(inout[7 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[7 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[39 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[39 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[23 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[23 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[55 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[55 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	       {
		    FFTW_REAL tre2_0_0;
		    FFTW_REAL tim2_0_0;
		    FFTW_REAL tre2_0_1;
		    FFTW_REAL tim2_0_1;
		    FFTW_REAL tre2_1_0;
		    FFTW_REAL tim2_1_0;
		    FFTW_REAL tre2_1_1;
		    FFTW_REAL tim2_1_1;
		    tre2_0_0 = tre1_1_0 - tim1_1_2;
		    tim2_0_0 = tim1_1_0 + tre1_1_2;
		    tre2_1_0 = tre1_1_0 + tim1_1_2;
		    tim2_1_0 = tim1_1_0 - tre1_1_2;
		    {
			 FFTW_REAL tre3_0_0;
			 FFTW_REAL tim3_0_0;
			 FFTW_REAL tre3_1_0;
			 FFTW_REAL tim3_1_0;
			 tre3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_1 - tim1_1_1);
			 tim3_0_0 = ((FFTW_REAL) FFTW_K707106781) * (tim1_1_1 + tre1_1_1);
			 tre3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 + tim1_1_3);
			 tim3_1_0 = ((FFTW_REAL) FFTW_K707106781) * (tre1_1_3 - tim1_1_3);
			 tre2_0_1 = tre3_0_0 - tre3_1_0;
			 tim2_0_1 = tim3_0_0 + tim3_1_0;
			 tre2_1_1 = tre3_0_0 + tre3_1_0;
			 tim2_1_1 = tim3_0_0 - tim3_1_0;
		    }
		    c_re(inout[15 * stride]) = tre2_0_0 + tre2_0_1;
		    c_im(inout[15 * stride]) = tim2_0_0 + tim2_0_1;
		    c_re(inout[47 * stride]) = tre2_0_0 - tre2_0_1;
		    c_im(inout[47 * stride]) = tim2_0_0 - tim2_0_1;
		    c_re(inout[31 * stride]) = tre2_1_0 - tim2_1_1;
		    c_im(inout[31 * stride]) = tim2_1_0 + tre2_1_1;
		    c_re(inout[63 * stride]) = tre2_1_0 + tim2_1_1;
		    c_im(inout[63 * stride]) = tim2_1_0 - tre2_1_1;
	       }
	  }
     }
}
