/*
 * Copyright (c) 1997 Massachusetts Institute of Technology
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to use, copy, modify, and distribute the Software without
 * restriction, provided the Software, including any modified copies made
 * under this license, is not distributed for a fee, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE MASSACHUSETTS INSTITUTE OF TECHNOLOGY BE LIABLE
 * FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of the Massachusetts
 * Institute of Technology shall not be used in advertising or otherwise
 * to promote the sale, use or other dealings in this Software without
 * prior written authorization from the Massachusetts Institute of
 * Technology.
 *  
 */

/* $Id: konst.h,v 1.3 1997/08/26 23:15:27 fftw Exp $ */

/*
 * this file contains many floating-point constants in with 40 digits
 * of precision.
 *
 * The constants are sin(pi/2 * i / j) for all relatively prime i and
 * j, i < j, 1 <= i,j <= 64.
 *
 * These constants should be enough to compute any FFT of radix up to
 * 64.
 *
 * The name of the constant is FFTW_K + the first nine digits
 * of the constant.
 */

/* First, a few hand-added constants for the hard-coded
   small-prime routines from Nussbaumer: */

#define FFTW_K1_499999999 1.5
#define FFTW_K1_500000000 1.5
#define FFTW_K1_538841768 1.538841768587626701285145288018454912004
#define FFTW_K363271264 0.3632712640026804429477333787403093748078
#define FFTW_K559016994 0.5590169943749474241022934171828190588601
#define FFTW_K1_250000000 1.25

/* Now, the sin(pi/2 * i / j) constants: */

#define FFTW_K024541228 0.02454122852291228803173452945928292506546
#define FFTW_K024930691 0.02493069173807287528153113172264899347886
#define FFTW_K025332714 0.02533271431318792626715014547444662011749
#define FFTW_K025747913 0.02574791365498855709400812038783297868791
#define FFTW_K026176948 0.02617694830787315261061168555411266379339
#define FFTW_K026620521 0.02662052143777476692526640921682759077404
#define FFTW_K027079384 0.02707938467613449510053273360969360284220
#define FFTW_K027554342 0.02755434236816199651390270841655868519675
#define FFTW_K028046256 0.02804625627586895837690032595826009306718
#define FFTW_K028556050 0.02855605079369625384817304701047898542810
#define FFTW_K029084718 0.02908471874311140688857775001359604786349
#define FFTW_K029633327 0.02963332782255974048476287916054822494737
#define FFTW_K030203027 0.03020302780088884696469629411308802751337
#define FFTW_K030795058 0.03079505855617035387456489497623829357293
#define FFTW_K031410759 0.03141075907812829383918367381782938975792
#define FFTW_K032051577 0.03205157757165517423355052534564389799926
#define FFTW_K032719082 0.03271908282177614206365992631728812611496
#define FFTW_K033414977 0.03341497700767457087526435763745330726371
#define FFTW_K034141110 0.03414111018596789528264900547320423176481
#define FFTW_K034899496 0.03489949670250097164599518162533293735482
#define FFTW_K035692333 0.03569233383898045576004959432178492172990
#define FFTW_K036522023 0.03652202305765883496849494009839034350519
#define FFTW_K037391194 0.03739119427632562109582828094423927302680
#define FFTW_K038302733 0.03830273369003534880305423883905735073019
#define FFTW_K039259815 0.03925981575906860902080336379833358968018
#define FFTW_K040265940 0.04026594010941514336195447585729928046597
#define FFTW_K041324974 0.04132497424881321193833038091793631399735
#define FFTW_K042441203 0.04244120319614830587806918753450720196596
#define FFTW_K043619387 0.04361938736533599978175307720994442711267
#define FFTW_K044864830 0.04486483035051492545809033680196091713385
#define FFTW_K046183458 0.04618345864573959194897001797523264272366
#define FFTW_K047581915 0.04758191582374229744978724403148683485453
#define FFTW_K049067674 0.04906767432741801425495497694268265831474
#define FFTW_K049845885 0.04984588566069716295040714449394960588257
#define FFTW_K050649168 0.05064916883871271227875185748519952674658
#define FFTW_K051478754 0.05147875477034653381895970590186645379975
#define FFTW_K052335956 0.05233595624294383272211862960907841873101
#define FFTW_K053222174 0.05322217484217865465892175510110189963137
#define FFTW_K054138908 0.05413890858541752614990832597459869261258
#define FFTW_K055087760 0.05508776035586544311472166247114340920868
#define FFTW_K056070447 0.05607044723719178819071956605945621966287
#define FFTW_K057088810 0.05708881086276798374853641012211283431406
#define FFTW_K058144828 0.05814482891047582853874801684707152363411
#define FFTW_K059240627 0.05924062789371428721946459254200354944517
#define FFTW_K060378497 0.06037849742228605343802003158079274972614
#define FFTW_K061560906 0.06156090613394283745053467245960896573106
#define FFTW_K062790519 0.06279051952931337607617822456563113312248
#define FFTW_K064070219 0.06407021998071292342141653382538247166027
#define FFTW_K065403129 0.06540312923014306681531555877517544144063
#define FFTW_K066792633 0.06679263374512155398142808167595869283750
#define FFTW_K068242413 0.06824241336467097592118847902245902393309
#define FFTW_K069756473 0.06975647374412530077595883519414332860090
#define FFTW_K071339183 0.07133918319923234032733775265783793276596
#define FFTW_K072995314 0.07299531466090752529007863065550023575340
#define FFTW_K073564563 0.07356456359966742352946562157523432181330
#define FFTW_K074730093 0.07473009358642425429093974573476665337355
#define FFTW_K075933114 0.07593311422524628957116630520938078420417
#define FFTW_K076549252 0.07654925283649564686667574398250835581272
#define FFTW_K077175462 0.07717546212664635123484042864263765610620
#define FFTW_K078459095 0.07845909572784494503296024599345969868195
#define FFTW_K079786105 0.07978610555308308193969075555986694480713
#define FFTW_K080466568 0.08046656871672588043623283523605058814445
#define FFTW_K081158725 0.08115872552743127025162162134332521448309
#define FFTW_K082579345 0.08257934547233232460034393423744022769858
#define FFTW_K084050524 0.08405052492924754505111842927022800243161
#define FFTW_K084805924 0.08480592447550919108850144833189828879530
#define FFTW_K085575008 0.08557500847883974285443620323245675643992
#define FFTW_K087155742 0.08715574274765817355806427083747355137770
#define FFTW_K088795895 0.08879589532293479712937356569797262395585
#define FFTW_K089639308 0.08963930890343349976547043684523300801112
#define FFTW_K090498875 0.09049887582963782754801984544037132033177
#define FFTW_K092268359 0.09226835946330199523965110715450648036301
#define FFTW_K094108313 0.09410831331851431847326684888547588974551
#define FFTW_K095056043 0.09505604330418266363210430415931109734405
#define FFTW_K096023025 0.09602302590768176305366495784331455593243
#define FFTW_K098017140 0.09801714032956060199419556388864184586113
#define FFTW_K099567846 0.09956784659581665718622086379104323229043
#define FFTW_K100095691 0.1000956916240983451177672842105318430707
#define FFTW_K101168321 0.1011683219874321777860407155854228233862
#define FFTW_K102264148 0.1022641489420342371412709255326958104552
#define FFTW_K102820997 0.1028209971373604031806320868342052679487
#define FFTW_K104528463 0.1045284632676534713998341548024981190806
#define FFTW_K106293485 0.1062934856473654067394496659573273763461
#define FFTW_K106895121 0.1068951215651127844145864534883570813393
#define FFTW_K108119018 0.1081190184239417630308083269836870058627
#define FFTW_K109371208 0.1093712083778743869853209878362391474250
#define FFTW_K110008220 0.1100082209940792950410059556544367917515
#define FFTW_K111964476 0.1119644761033078584687059352720242032581
#define FFTW_K113991409 0.1139914098905406252992389774304161634389
#define FFTW_K114683425 0.1146834253984004343275380130470373859191
#define FFTW_K116092914 0.1160929141252302296756665233807114688534
#define FFTW_K117537397 0.1175373974578376441055682668404856236723
#define FFTW_K118273170 0.1182731709213658039500508663092468403330
#define FFTW_K120536680 0.1205366802553230533490676874525435822736
#define FFTW_K122410675 0.1224106751992161984987044741509457875752
#define FFTW_K122888290 0.1228882906647141222666013492105836037724
#define FFTW_K123692631 0.1236926312693476160249117865542554850472
#define FFTW_K124343704 0.1243437046474851743089045920543714991045
#define FFTW_K125333233 0.1253332335643042453731187598165087939429
#define FFTW_K126338594 0.1263385949221291894904811173099765440334
#define FFTW_K127017819 0.1270178197468787473745739656594515054988
#define FFTW_K127877161 0.1278771616845060105905627222310365268112
#define FFTW_K128398355 0.1283983551465509444517094699699360502290
#define FFTW_K130526192 0.1305261922200515915484062278954890101937
#define FFTW_K132725527 0.1327255272837219725719487965069416073282
#define FFTW_K133286955 0.1332869553737788428006966907749246477199
#define FFTW_K134233265 0.1342332658176554760370186415106700491221
#define FFTW_K135000013 0.1350000138532901039432785388369663768285
#define FFTW_K136166649 0.1361666490962465907607258333878729914503
#define FFTW_K137353557 0.1373535578184081750962293169450719150194
#define FFTW_K138156354 0.1381563549518821982285452297396081025637
#define FFTW_K139173100 0.1391731009600654441124966633011052754559
#define FFTW_K139790339 0.1397903395354994779261757065854075728448
#define FFTW_K142314838 0.1423148382732851404437926686163696687910
#define FFTW_K144931859 0.1449318593072467375406813031778968151579
#define FFTW_K145601167 0.1456011677350048723993394166411729066078
#define FFTW_K146730474 0.1467304744553617516588501296467178197062
#define FFTW_K147646564 0.1476465640024812314941125712317733092252
#define FFTW_K149042266 0.1490422661761744469293547152772175569096
#define FFTW_K150464503 0.1504645032747830094280823110511156957377
#define FFTW_K151427777 0.1514277775045766636574676467272196523057
#define FFTW_K152649284 0.1526492842188744985382798067894893515166
#define FFTW_K153391654 0.1533916548786853726487552712140729945838
#define FFTW_K153890576 0.1538905767040617933823856197344647265033
#define FFTW_K156434465 0.1564344650402308690101053194671668923139
#define FFTW_K159063496 0.1590634960190720532010083008860924909668
#define FFTW_K159599895 0.1595998950333792234665111684813029413298
#define FFTW_K160411280 0.1604112808577602403702298186769163785229
#define FFTW_K161781996 0.1617819965527647265442600643364213138441
#define FFTW_K162895473 0.1628954733945887394808006397082655595151
#define FFTW_K164594590 0.1645945902807338941436520590879384195121
#define FFTW_K166329354 0.1663293545831300328593301814704603689804
#define FFTW_K167506223 0.1675062233047364080900562064755421518657
#define FFTW_K169000820 0.1690008203218490740930355553844306062607
#define FFTW_K169910385 0.1699103850286666621064277790456711366916
#define FFTW_K170522192 0.1705221926326237844029624838779488814032
#define FFTW_K170961888 0.1709618887603012263636423572082635319663
#define FFTW_K173648177 0.1736481776669303488517166267693147960003
#define FFTW_K176419766 0.1764197662578084553148843684896065607169
#define FFTW_K176890275 0.1768902751225729626566607665047223570045
#define FFTW_K177553196 0.1775531962543032681443899399620956620757
#define FFTW_K178556894 0.1785568947986366480137183675903137598662
#define FFTW_K179280758 0.1792807588107356641700983494684076980694
#define FFTW_K180255037 0.1802550378139057401698714976814164183253
#define FFTW_K181636850 0.1816368509794364397019702088022006165809
#define FFTW_K182235525 0.1822355254921474566025733714374098829561
#define FFTW_K183749517 0.1837495178165703315744088396207275824891
#define FFTW_K185288724 0.1852887240871143248809536106633607262036
#define FFTW_K185911607 0.1859116071629145811067063130899319181384
#define FFTW_K187381314 0.1873813145857246305425507344472914693386
#define FFTW_K188445323 0.1884453238783182943037067928415765684352
#define FFTW_K189251244 0.1892512443604102036174993987003794963886
#define FFTW_K190391109 0.1903911091646683687060801363670975059804
#define FFTW_K191158628 0.1911586287013723021585445882022354575073
#define FFTW_K191710631 0.1917106319237384206124231501600573332271
#define FFTW_K195090322 0.1950903220161282678482848684770222409276
#define FFTW_K198146143 0.1981461431993975833714472747416084106726
#define FFTW_K198590466 0.1985904666457454649825982338832459220562
#define FFTW_K199185985 0.1991859851038360988453201397948964743053
#define FFTW_K200025693 0.2000256937760444275302791839461314924582
#define FFTW_K201298520 0.2012985200886600791415289683390134818534
#define FFTW_K202217572 0.2022175723320379311800611091313733641995
#define FFTW_K203456013 0.2034560130526337898780287220615784267778
#define FFTW_K204552066 0.2045520661262008192326881916211885127837
#define FFTW_K205215342 0.2052153421956342913242144590999144259414
#define FFTW_K205978618 0.2059786187410983794560099523629392761584
#define FFTW_K207911690 0.2079116908177593371017422844051251662165
#define FFTW_K209881102 0.2098811020648475664288490675128024697633
#define FFTW_K210679269 0.2106792699957263203605157515044546621513
#define FFTW_K211382623 0.2113826236296243207085529083770849382000
#define FFTW_K212565289 0.2125652895529766738829101740168861225007
#define FFTW_K213933083 0.2139330832064974399064939935426070792397
#define FFTW_K214970440 0.2149704402110240671819534770820757537978
#define FFTW_K216439613 0.2164396139381028797595536696179407286733
#define FFTW_K217430175 0.2174301755815569683483334697013744130646
#define FFTW_K218143241 0.2181432413965425520241529749432464294629
#define FFTW_K218681091 0.2186810912063758065815451063216740840845
#define FFTW_K219101240 0.2191012401568697972277375474973577988483
#define FFTW_K222520933 0.2225209339563144042889025644967947594663
#define FFTW_K226048070 0.2260480705837348469528011887515101798955
#define FFTW_K226496767 0.2264967674257643803937744783433568234439
#define FFTW_K227076263 0.2270762630343732075856966925770880866157
#define FFTW_K227853508 0.2278535089031375755972602599574454122751
#define FFTW_K228950549 0.2289505499501340769087585503449667718434
#define FFTW_K229687742 0.2296877421317955508629587031855238968422
#define FFTW_K230615870 0.2306158707424401784501983492929391024576
#define FFTW_K231820150 0.2318201502675282692634378233857375282786
#define FFTW_K233445363 0.2334453638559054117677444302028708487857
#define FFTW_K234886045 0.2348860457809836794344735309665486913327
#define FFTW_K235758935 0.2357589355094272282505103203014875844263
#define FFTW_K236764420 0.2367644204664467369934485993258031509443
#define FFTW_K237326699 0.2373266998711148178062315108453953280872
#define FFTW_K239315664 0.2393156642875577671487537262602118952031
#define FFTW_K241337891 0.2413378912997056469191530270185379193926
#define FFTW_K241921895 0.2419218955996677225604423741003529652950
#define FFTW_K242980179 0.2429801799032638899482741620774711183209
#define FFTW_K243913720 0.2439137201083771486571152797107074577474
#define FFTW_K245485487 0.2454854871407991489222909177963705562718
#define FFTW_K246757397 0.2467573976902936383701134811922532799265
#define FFTW_K247306500 0.2473065005542155019896448542641991067685
#define FFTW_K248689887 0.2486898871648547882422837460064479684175
#define FFTW_K249776478 0.2497764781672268499591643699129970495240
#define FFTW_K250652532 0.2506525322587205393148020352659594949328
#define FFTW_K251978061 0.2519780613851251944452590335089271028724
#define FFTW_K252933382 0.2529333823916807465585823300480383661425
#define FFTW_K253654583 0.2536545839095073878469674038123833536072
#define FFTW_K254218334 0.2542183341934869302181946799708040944181
#define FFTW_K254671120 0.2546711202412287479786428236449119383343
#define FFTW_K258819045 0.2588190451025207623488988376240483283490
#define FFTW_K263102564 0.2631025642275212511495477637383127381948
#define FFTW_K263587166 0.2635871660690676452850324043464993370036
#define FFTW_K264195401 0.2641954018712860094526428604782256719351
#define FFTW_K264981502 0.2649815021966616823313383138368166609255
#define FFTW_K266036845 0.2660368455666751073822760245929750947101
#define FFTW_K266712757 0.2667127574748983863252865151164363940421
#define FFTW_K267528338 0.2675283385292208211946262052833413401837
#define FFTW_K268531867 0.2685318674743767514444181482437582231209
#define FFTW_K269796771 0.2697967711570242712453285226025705364752
#define FFTW_K270840468 0.2708404681430051173825276728313745513853
#define FFTW_K271440449 0.2714404498650742533437874012956754728913
#define FFTW_K272103464 0.2721034648453350043477078027786879151380
#define FFTW_K273662990 0.2736629900720828635390779354368134316248
#define FFTW_K275096112 0.2750961127544780934575888098987339713079
#define FFTW_K275637355 0.2756373558169991856499715746113041477124
#define FFTW_K276835511 0.2768355114248493876262772692158242788007
#define FFTW_K278217463 0.2782174639164526345546182439651524382026
#define FFTW_K278991106 0.2789911060392292518532508950584493874953
#define FFTW_K279485634 0.2794856348516094581371390778942150551101
#define FFTW_K281732556 0.2817325568414296977114179153466168990357
#define FFTW_K284015344 0.2840153447039226174443896906991853505161
#define FFTW_K284527586 0.2845275866310324418705029934626948723724
#define FFTW_K285336224 0.2853362242491053090667449649265463487414
#define FFTW_K286803232 0.2868032327110902531032801731671579370202
#define FFTW_K288099099 0.2880990993652375689266931264899107353051
#define FFTW_K288691947 0.2886919473396210094452906211327828963305
#define FFTW_K290284677 0.2902846772544623676361923758173952746914
#define FFTW_K292056770 0.2920567706369758204437390072356032915605
#define FFTW_K292822771 0.2928227712765503799533928156354034200205
#define FFTW_K293522573 0.2935225731039347541446271583891850734356
#define FFTW_K294755174 0.2947551744109042168307729819601909732057
#define FFTW_K296275580 0.2962755808856339773191629695178234257829
#define FFTW_K297503053 0.2975030538552029766545272343836168141915
#define FFTW_K298514811 0.2985148110016945481161981570821534393776
#define FFTW_K299363122 0.2993631229733579540081126169766754622404
#define FFTW_K300705799 0.3007057995042731216225471359310733948570
#define FFTW_K301720598 0.3017205985951923159681622307862467380143
#define FFTW_K302514550 0.3025145508810757874902189631473865052465
#define FFTW_K303152674 0.3031526741130434999087207406797943019405
#define FFTW_K303676745 0.3036767451096147308106077254328536766584
#define FFTW_K304114832 0.3041148323275178942148291736201549317983
#define FFTW_K309016994 0.3090169943749474241022934171828190588601
#define FFTW_K313681740 0.3136817403988914766564788459941003099933
#define FFTW_K314076712 0.3140767120219488154165234158283970375988
#define FFTW_K314544756 0.3145447561516136728017265820394227561963
#define FFTW_K315108218 0.3151082180236206884739997772913635477845
#define FFTW_K315799587 0.3157995876150249155281530748686182849130
#define FFTW_K316667993 0.3166679938014724990938464926070593078727
#define FFTW_K317791419 0.3177914195819016261653495764591287854944
#define FFTW_K318486650 0.3184866502516844273818275725699376031734
#define FFTW_K319301530 0.3193015301359799731972335422795273269786
#define FFTW_K320269853 0.3202698538628376311280745853886316208567
#define FFTW_K321439465 0.3214394653031615807010576240789015860584
#define FFTW_K322880404 0.3228804047714462166317487451277830603309
#define FFTW_K323437987 0.3234379871492380979025474833971787876719
#define FFTW_K324699469 0.3246994692046834874075727165465870379355
#define FFTW_K326202789 0.3262027892208693378961868432839339339875
#define FFTW_K327067963 0.3270679633174216363417493701584524078072
#define FFTW_K328024857 0.3280248578395690989840510558626828114495
#define FFTW_K328542381 0.3285423819108347330233652537686684647414
#define FFTW_K330279061 0.3302790619551670817748776125965723703131
#define FFTW_K332354799 0.3323547994796596645618863109731018350510
#define FFTW_K333139794 0.3331397947420575668009190940208649269071
#define FFTW_K333806859 0.3338068592337709288283112855367461082971
#define FFTW_K334879612 0.3348796121709861519581150708478901575074
#define FFTW_K336049393 0.3360493932154301264002038813057431950992
#define FFTW_K336889853 0.3368898533922200506892532126191475704777
#define FFTW_K338016878 0.3380168784085027582801184913755462388755
#define FFTW_K338737920 0.3387379202452913812222843549667764425455
#define FFTW_K339238866 0.3392388661180302873463200874425587375464
#define FFTW_K342020143 0.3420201433256687330440996146822595807630
#define FFTW_K344846302 0.3448463026279704341701015644183431449540
#define FFTW_K345365054 0.3453650544213076319521147752559623304845
#define FFTW_K346117057 0.3461170570774929764682149949282125051507
#define FFTW_K347305252 0.3473052528448202855418543554810122464619
#define FFTW_K348201635 0.3482016354343987872360551297332894837702
#define FFTW_K349464179 0.3494641795990983367054385007091167841299
#define FFTW_K350637555 0.3506375551927543753252906248597856202531
#define FFTW_K351374824 0.3513748240813427048873232705101784160143
#define FFTW_K352250047 0.3522500479212335065317523197587126718279
#define FFTW_K352752086 0.3527520865490947802113466208444908167556
#define FFTW_K354604887 0.3546048870425356259696378926000184743163
#define FFTW_K356621532 0.3566215326623130243556992802935517782847
#define FFTW_K357230889 0.3572308898011327811970544491665739772808
#define FFTW_K358367949 0.3583679495453002734841377894134668341915
#define FFTW_K359407772 0.3594077728375128365978369922382092764921
#define FFTW_K359895036 0.3598950365349881487751045723267564202023
#define FFTW_K361241666 0.3612416661871529487447145961837001637245
#define FFTW_K362807705 0.3628077053506410086067015071723732383626
#define FFTW_K363507970 0.3635079705638298484830911630066710945698
#define FFTW_K364160575 0.3641605752528221783209334379434903294574
#define FFTW_K365341024 0.3653410243663950145447379989297688024329
#define FFTW_K366854218 0.3668542188130565156995449132831306900092
#define FFTW_K368124552 0.3681245526846779591569471474929608308988
#define FFTW_K369206147 0.3692061473126844511998878300716878438711
#define FFTW_K370138155 0.3701381553399143568639806676151644570979
#define FFTW_K370949600 0.3709496008697677795187832504613714657766
#define FFTW_K371662455 0.3716624556603275191518049611285091938479
#define FFTW_K372856477 0.3728564777803086108306500487961622518678
#define FFTW_K373817071 0.3738170718407687913912982304163231070236
#define FFTW_K374606593 0.3746065934159120354149637745011951310001
#define FFTW_K375267004 0.3752670048793741338875592256739963144508
#define FFTW_K375827582 0.3758275821142381678666440272552022706104
#define FFTW_K376309371 0.3763093719478354580854128826607312195378
#define FFTW_K376727893 0.3767278936351850994385423912048126363986
#define FFTW_K382683432 0.3826834323650897717284599840303988667613
#define FFTW_K388434796 0.3884347962746947118923318303095684709959
#define FFTW_K388824175 0.3888241754733206472331483352233858759953
#define FFTW_K389270106 0.3892701063173914903895747264449321369261
#define FFTW_K389785873 0.3897858732926793690828678991204515658461
#define FFTW_K390389275 0.3903892751634948132202383101205617972359
#define FFTW_K391104720 0.3911047204901560157361797932002389820702
#define FFTW_K391966609 0.3919666098600750758836817751475364086730
#define FFTW_K393025031 0.3930250316539236181879675098179335770069
#define FFTW_K394355855 0.3943558551133185801016261030214455736355
#define FFTW_K395158538 0.3951585385301554551973223050248713719112
#define FFTW_K396079766 0.3960797660391568236960433916097445675084
#define FFTW_K397147890 0.3971478906347806137543773600194770636112
#define FFTW_K398401089 0.3984010898462414579978803999696789656499
#define FFTW_K399892024 0.3998920243197409718830580631715817256097
#define FFTW_K400453905 0.4004539056512664881900757918031049168799
#define FFTW_K401695424 0.4016954246529694575168416597426171522567
#define FFTW_K403123429 0.4031234292879722141928847864308575941774
#define FFTW_K403921004 0.4039210048718949626390971462228293575194
#define FFTW_K404783343 0.4047833431223938171559229929865110885458
#define FFTW_K405241314 0.4052413140049898709084813055050524665119
#define FFTW_K406736643 0.4067366430758002077539859903414976129231
#define FFTW_K408444256 0.4084442569359961354585130645868912825289
#define FFTW_K409068637 0.4090686371713398883621478572702527811569
#define FFTW_K410412805 0.4104128054527567964242959438829223418615
#define FFTW_K411287103 0.4112871031306115394563645794677849305108
#define FFTW_K411901248 0.4119012482439926753830399595163634298154
#define FFTW_K412707029 0.4127070298043947370477021860733674718905
#define FFTW_K413212185 0.4132121857683781796177459756612098495079
#define FFTW_K415415013 0.4154150130018864255292741492296232035240
#define FFTW_K417508992 0.4175089922850631204988983925715332880857
#define FFTW_K417960344 0.4179603448867834197609712699154881891189
#define FFTW_K418659737 0.4186597375374280866755652051218860503788
#define FFTW_K419889101 0.4198891015602645769737108950291563357023
#define FFTW_K420934762 0.4209347624283349696253509429280529945866
#define FFTW_K422618261 0.4226182617406994361869784896477301815631
#define FFTW_K423914390 0.4239143907098606887419042651814927925410
#define FFTW_K424456698 0.4244566988758150853990378624175550294483
#define FFTW_K425779291 0.4257792915650726488625024457442517039799
#define FFTW_K426776435 0.4267764354964036681347859720543011341509
#define FFTW_K427555093 0.4275550934302820943209668568887985343045
#define FFTW_K428692561 0.4286925614030541830734336648482434287056
#define FFTW_K429483443 0.4294834430300819004044761443765364092055
#define FFTW_K430065202 0.4300652022765204603469796350767522768615
#define FFTW_K430511096 0.4305110968082951443761483565082794876402
#define FFTW_K433883739 0.4338837391175581204757683328483587546100
#define FFTW_K437307320 0.4373073204588553906127706057564501702361
#define FFTW_K437767705 0.4377677051653404809109457323247945767254
#define FFTW_K438371146 0.4383711467890774174527345406582657390627
#define FFTW_K439196588 0.4391965888473703654544278324316179454814
#define FFTW_K440394151 0.4403941515576343095161715337137760630174
#define FFTW_K441221101 0.4412211012432212932561177149092889833885
#define FFTW_K442288690 0.4422886902190012819952389773242447301569
#define FFTW_K443719837 0.4437198378669596859957300716487510074805
#define FFTW_K444311706 0.4443117063539035508920534834793903341199
#define FFTW_K445738355 0.4457383557765382673964575493794868554276
#define FFTW_K447093792 0.4470937929851139085878077015499424448310
#define FFTW_K447617210 0.4476172100627125493354635123469121632099
#define FFTW_K448799180 0.4487991802004621727850403347331436164243
#define FFTW_K449611329 0.4496113296546066000462945794242270758831
#define FFTW_K450203744 0.4502037448176732924559998305063153741703
#define FFTW_K451010119 0.4510101192161018402829405689831741061912
#define FFTW_K451533358 0.4515333583108893507637632100198611342712
#define FFTW_K453990499 0.4539904997395467915604083663578711989830
#define FFTW_K456210657 0.4562106573531629639774980773788514351385
#define FFTW_K456629237 0.4566292373937130644452233125091948196962
#define FFTW_K457242323 0.4572423233046385228159706386386358177793
#define FFTW_K458226521 0.4582265217274103945550366255897399668032
#define FFTW_K458981864 0.4589818644675376813624520888264711922214
#define FFTW_K460065037 0.4600650377311521260415757598109517955579
#define FFTW_K461092501 0.4610925014493258460911917550660284882441
#define FFTW_K461748613 0.4617486132350339305629306731356229872678
#define FFTW_K462538290 0.4625382902408352776971056464298681702475
#define FFTW_K462996644 0.4629966441051207667179520124020620021145
#define FFTW_K464723172 0.4647231720437685456560153351331047775577
#define FFTW_K466667323 0.4666673232256736976711189168781572674051
#define FFTW_K467268628 0.4672686282730619891421497069463566255380
#define FFTW_K468408440 0.4684084406997901392162396741494573562814
#define FFTW_K469471562 0.4694715627858907759594622882278432957232
#define FFTW_K469976743 0.4699767430273200448803201882849598306672
#define FFTW_K471396736 0.4713967368259976485563876259052543776574
#define FFTW_K473093556 0.4730935568360100744212386756923100796709
#define FFTW_K473868662 0.4738686624729986707083830096659750872704
#define FFTW_K474600369 0.4746003697476404014444030521845052424142
#define FFTW_K475947393 0.4759473930370735444313529194551153377644
#define FFTW_K477158760 0.4771587602596084150488630081893860525344
#define FFTW_K477719818 0.4777198185122629226714738291795566445794
#define FFTW_K478253978 0.4782539786213182117281992257619655845446
#define FFTW_K479248986 0.4792489867200568311976566004526127683333
#define FFTW_K480581755 0.4805817551866837805188145730989093322125
#define FFTW_K481753674 0.4817536741017152749871915028721296535285
#define FFTW_K482792202 0.4827922027307448748732654364456006331007
#define FFTW_K483718887 0.4837188871052397910711613404089728511353
#define FFTW_K484550870 0.4845508703326501661482589827850659897206
#define FFTW_K485301962 0.4853019625310810252145722292597299794313
#define FFTW_K486604478 0.4866044785668562872908560142642961120006
#define FFTW_K487694943 0.4876949438136345453546358573087530741093
#define FFTW_K488621241 0.4886212414969549474201908878388776372536
#define FFTW_K489417847 0.4894178478110855091620714559474840496853
#define FFTW_K490110217 0.4901102171780172253599534345284315254418
#define FFTW_K490717552 0.4907175520039378866875617032247567784897
#define FFTW_K491254611 0.4912546110838773740027218272702905763288
#define FFTW_K491732924 0.4917329246456037728350634796082138236387
#define FFTW_K492161631 0.4921616313890073350656423325950721684747
#define FFTW_K492548067 0.4925480679538644138390568320545344677720
#define FFTW_K492898192 0.4928981922297840368730266887588092682396
#define FFTW_K500000000 0.5000000000000000000000000000000000000000
#define FFTW_K499999999 0.5000000000000000000000000000000000000000
#define FFTW_K507295790 0.5072957901801073367475366123379857519655
#define FFTW_K507665800 0.5076658003388399581093093048575938349538
#define FFTW_K508075345 0.5080753452465294585428491475669648936485
#define FFTW_K508531118 0.5085311186492204850105948124297554981888
#define FFTW_K509041415 0.5090414157503713002834427138653056527808
#define FFTW_K509616642 0.5096166425919174293666674157223672698804
#define FFTW_K510270033 0.5102700330608996133204856818145824161513
#define FFTW_K511018679 0.5110186794471103662576250033662606123172
#define FFTW_K511885049 0.5118850490896010021737274853303109596843
#define FFTW_K512899277 0.5128992774059061439084936529403118044651
#define FFTW_K514102744 0.5141027441932217265936938389688157726080
#define FFTW_K514792801 0.5147928015098307273142233930965266875226
#define FFTW_K515553857 0.5155538571770217397098664966397134305304
#define FFTW_K516397461 0.5163974616389619233199213987888180697670
#define FFTW_K517337814 0.5173378141776567710362946754733118933788
#define FFTW_K518392568 0.5183925683105250315384743146752592400898
#define FFTW_K519583950 0.5195839500354335781330010113237876331492
#define FFTW_K520940340 0.5209403404879302861762814495347146459259
#define FFTW_K521435203 0.5214352033794980724261075391331443334846
#define FFTW_K522498564 0.5224985647159488649878978801782938234153
#define FFTW_K523672913 0.5236729139878778613113179353244932106015
#define FFTW_K524307283 0.5243072835572316877977574563473161566248
#define FFTW_K524976580 0.5249765803345601755182577112207755871671
#define FFTW_K526432162 0.5264321628773558002446077991406995661709
#define FFTW_K528067850 0.5280678506503679958734488203376055682261
#define FFTW_K528964010 0.5289640103269624573654923939122347256678
#define FFTW_K529919264 0.5299192642332049540467811518160866687720
#define FFTW_K530420908 0.5304209081197424901275539775477963937120
#define FFTW_K532032076 0.5320320765153365635576303672303707301645
#define FFTW_K533823377 0.5338233779647906819709106917246609497097
#define FFTW_K534465826 0.5344658261278010920448916115059631779908
#define FFTW_K534997619 0.5349976198870972106630769046370179155602
#define FFTW_K535826794 0.5358267949789966182713087678676399780635
#define FFTW_K536696193 0.5366961939916004804283904754877204814678
#define FFTW_K537299608 0.5372996083468238318407855462677067680826
#define FFTW_K538082353 0.5380823531633726744432314599446075951185
#define FFTW_K538567961 0.5385679615609043184417452731084601648522
#define FFTW_K540640817 0.5406408174555975821076359543186916954317
#define FFTW_K542546263 0.5425462638657594057764972215610247085012
#define FFTW_K542948982 0.5429489822014786701886277535350098429865
#define FFTW_K543567550 0.5435675500012211507281151902424756896932
#define FFTW_K544639035 0.5446390350150270822240836920815653816079
#define FFTW_K545534901 0.5455349012105486651327077633824745393135
#define FFTW_K546948158 0.5469481581224268747117627466961884997788
#define FFTW_K548451871 0.5484518712493187136368616554921198282836
#define FFTW_K549508978 0.5495089780708060352627803740501339165127
#define FFTW_K550292715 0.5502927152373913716928201431260802030025
#define FFTW_K550896981 0.5508969814521025226871043191204105871852
#define FFTW_K551767740 0.5517677407704459049547942137195885263307
#define FFTW_K552364972 0.5523649729605058107631005229003669921116
#define FFTW_K552800065 0.5528000653611933830479607237660836570846
#define FFTW_K555570233 0.5555702330196022247428308139485328743749
#define FFTW_K558243722 0.5582437220268647591526404027462258729266
#define FFTW_K558646765 0.5586467658036524568622720968872277915579
#define FFTW_K559192903 0.5591929034707468301604281399859892873066
#define FFTW_K559974786 0.5599747861375953903804362399881110256799
#define FFTW_K561187065 0.5611870653623823692699409283736092029758
#define FFTW_K562083377 0.5620833778521306000972520013088883538429
#define FFTW_K563320058 0.5633200580636220277492615380297605110458
#define FFTW_K564443218 0.5644432188667691804433731669421321560933
#define FFTW_K565136414 0.5651364144225918889815679062534626407621
#define FFTW_K565947094 0.5659470943305951647768230619336659850687
#define FFTW_K566406236 0.5664062369248328318216250522337649325187
#define FFTW_K568064746 0.5680647467311558025118075591275166245335
#define FFTW_K569808057 0.5698080575102661816845660286961865846296
#define FFTW_K570322636 0.5703226369349640602140881497060451205684
#define FFTW_K571268215 0.5712682150947922791574245436284554823534
#define FFTW_K572116660 0.5721166601221696498132192034370527016364
#define FFTW_K573576436 0.5735764363510460961080319128261578646204
#define FFTW_K574787410 0.5747874102144068850436978464129713348833
#define FFTW_K575318660 0.5753186602186205995927072726495191736474
#define FFTW_K575808191 0.5758081914178453007459724538157308417760
#define FFTW_K576680322 0.5766803221148671412510482752668528239788
#define FFTW_K577773831 0.5777738314082511021102199089899935947837
#define FFTW_K578671296 0.5786712961798057416349117556513751600107
#define FFTW_K579421098 0.5794210982045636845678607582146469698519
#define FFTW_K580056909 0.5800569095711981791969811319003074122335
#define FFTW_K581076815 0.5810768154019382799971629059056750994902
#define FFTW_K581858915 0.5818589155579528384237390755893130777775
#define FFTW_K582477696 0.5824776968678021491971347670361124496849
#define FFTW_K582979479 0.5829794791144720768317634478275581254656
#define FFTW_K583394579 0.5833945791074939474110439755476610699679
#define FFTW_K583743672 0.5837436722347898704535849173602861862334
#define FFTW_K587785252 0.5877852522924731291687059546390727685976
#define FFTW_K591877046 0.5918770467870172636974905748868801823425
#define FFTW_K592235252 0.5922352526649800217394881554148630285607
#define FFTW_K592662191 0.5926621913640168354692868591503568120595
#define FFTW_K593179744 0.5931797447293552110980879105045366390442
#define FFTW_K593820185 0.5938201855735016116500901787757969715429
#define FFTW_K594633176 0.5946331763042866161328284577790955529530
#define FFTW_K595699304 0.5956993044924333434670365288299698895119
#define FFTW_K596367358 0.5963673585385014139115331297600029152330
#define FFTW_K597158591 0.5971585917027861648518521605839597728406
#define FFTW_K598110530 0.5981105304912159620592663549050390073657
#define FFTW_K599277666 0.5992776665113469345300241464975926115075
#define FFTW_K600214280 0.6002142805483682182892439332026327230385
#define FFTW_K600742264 0.6007422642379789169170698743449837706706
#define FFTW_K601317091 0.6013170912984058082408764754369813163847
#define FFTW_K602634636 0.6026346363792563891785881549868406216189
#define FFTW_K603804410 0.6038044103254773687416432135874339982464
#define FFTW_K604236389 0.6042363895210945207619697322884734664490
#define FFTW_K605174215 0.6051742151937651659242801329801084792646
#define FFTW_K606225410 0.6062254109666380182743756853644417577991
#define FFTW_K606800145 0.6068001458185933703817660523085167627397
#define FFTW_K608761429 0.6087614290087206394160975428981640045164
#define FFTW_K610647879 0.6106478796354381306932542723821207732355
#define FFTW_K611173714 0.6111737140978492922481400688827063108551
#define FFTW_K612105982 0.6121059825476628441467056202598600662486
#define FFTW_K612907053 0.6129070536529764933643860565186920014861
#define FFTW_K614212712 0.6142127126896678174443358335144494567519
#define FFTW_K615231590 0.6152315905806268454849135634139842776594
#define FFTW_K615661475 0.6156614753256582796688110928436556282509
#define FFTW_K616718872 0.6167188726285430584574009602667958339961
#define FFTW_K617524614 0.6175246149461919150332079754986842314714
#define FFTW_K618158986 0.6181589862206052132242870766482095935286
#define FFTW_K619093949 0.6190939493098339869415608562461182062175
#define FFTW_K619749888 0.6197498889602448854708069331948698244808
#define FFTW_K620235491 0.6202354912682600677739492348652510534689
#define FFTW_K620609481 0.6206094818274227951118685588824422384550
#define FFTW_K623489801 0.6234898018587335305250048840042398106322
#define FFTW_K626509999 0.6265099998359866294090460453355545190924
#define FFTW_K626923805 0.6269238058941064650171695366099533004747
#define FFTW_K627469007 0.6274690073808519692459461113376089475503
#define FFTW_K628219997 0.6282199972956423167888571244982907776990
#define FFTW_K629320391 0.6293203910498374527059024582799704265668
#define FFTW_K630087843 0.6300878435817110813020457226223099127413
#define FFTW_K631087944 0.6310879443260527893674001301433105742008
#define FFTW_K631942038 0.6319420384463039980812672705334167368491
#define FFTW_K632445375 0.6324453755953772378210421356243774316157
#define FFTW_K633012453 0.6330124538088703887271152762762650288323
#define FFTW_K634393284 0.6343932841636454982151716132254933706757
#define FFTW_K635723748 0.6357237482099679982772185699592814904753
#define FFTW_K636242442 0.6362424423265598332563914426192972085437
#define FFTW_K637423989 0.6374239897486897101767128116760161954349
#define FFTW_K638244183 0.6382441836448200939919339938994422817340
#define FFTW_K638846805 0.6388468056519613170701714797131712501021
#define FFTW_K639673021 0.6396730215588912736376413785400172119839
#define FFTW_K640212840 0.6402128404624880139089127673149144443273
#define FFTW_K640593178 0.6405931786981751555801787491064955966940
#define FFTW_K642787609 0.6427876096865393263226434099072634329075
#define FFTW_K645171983 0.6451719835420876332916589890067163479062
#define FFTW_K645627851 0.6456278515588023976509609942805170886061
#define FFTW_K646299237 0.6462992378609408919872782945589183784725
#define FFTW_K647386284 0.6473862847818276391816601341861462687573
#define FFTW_K648228395 0.6482283953077884016265676818920522589008
#define FFTW_K649448048 0.6494480483301836557263207708937628792775
#define FFTW_K650618300 0.6506183002042421137200625338820968810477
#define FFTW_K651372482 0.6513724827222222074539996146910164660920
#define FFTW_K652287411 0.6522874112781211543709918892277518756944
#define FFTW_K652822118 0.6528221181905216240058867193362104152324
#define FFTW_K653172842 0.6531728429537767640842030136563054150768
#define FFTW_K654860733 0.6548607339452850640569250724662935531838
#define FFTW_K656752024 0.6567520240477344067154384346008419370839
#define FFTW_K657203678 0.6572036788179724611572838276890770109395
#define FFTW_K657938725 0.6579387259397126123701191819931188157209
#define FFTW_K658511379 0.6585113790650386427945048286629364391494
#define FFTW_K659345815 0.6593458151000688684251246120553374509154
#define FFTW_K660152120 0.6601521206712317513451242124324233897176
#define FFTW_K660674723 0.6606747233900814419084029992842146796392
#define FFTW_K661311865 0.6613118653236518765686217371023240621957
#define FFTW_K661685837 0.6616858375968594152403677203172028537185
#define FFTW_K663122658 0.6631226582407952023767854926667662795247
#define FFTW_K664795865 0.6647958656139378287087022425974990458408
#define FFTW_K665325700 0.6653257001655653635571413398480420351878
#define FFTW_K666346577 0.6663465779520039455829121186875666953965
#define FFTW_K667318811 0.6673188112222394158299466460967518615170
#define FFTW_K667787758 0.6677877587886956156678714244522237437632
#define FFTW_K669130606 0.6691306063588582138262733306867804735995
#define FFTW_K670384843 0.6703848439562785276102304567161121618440
#define FFTW_K670784730 0.6707847301392234490950123366082160122035
#define FFTW_K671558954 0.6715589548470184006253768504274218032287
#define FFTW_K672300890 0.6723008902613167880864184616374229315599
#define FFTW_K673695643 0.6736956436465572117126919124256946158624
#define FFTW_K674983001 0.6749830015182105320655112776739346328419
#define FFTW_K675590207 0.6755902076156602443483393536743541823082
#define FFTW_K676174900 0.6761749002740194352804986161659714461903
#define FFTW_K677281571 0.6772815716257410747621509844956257184155
#define FFTW_K678311836 0.6783118362696160847748068699856585450415
#define FFTW_K678800745 0.6788007455329417413938555542417347670587
#define FFTW_K679273338 0.6792733388972931155862949904270503180450
#define FFTW_K680172737 0.6801727377709193901873587010337402440270
#define FFTW_K681417939 0.6814179395938911071752870865417535631154
#define FFTW_K682553143 0.6825531432186540828745375453725405780987
#define FFTW_K683592302 0.6835923020228712805134975943161551170438
#define FFTW_K684547105 0.6845471059286886737322833576212092698895
#define FFTW_K685427422 0.6854274223350397681993662181891218368258
#define FFTW_K686241637 0.6862416378687335857296049996175379830146
#define FFTW_K686996926 0.6869969260349016335361463414661483035462
#define FFTW_K687699458 0.6876994588534232930838768523753670644636
#define FFTW_K688354575 0.6883545756937539843892561434196122934864
#define FFTW_K688966919 0.6889669190756865678008668038181416871299
#define FFTW_K689540544 0.6895405447370669246167306299574847028455
#define FFTW_K690079011 0.6900790114821119896680022393860466831042
#define FFTW_K691062648 0.6910626489868646759049354256591699817466
#define FFTW_K691938868 0.6919388689775462000100916668541419889185
#define FFTW_K692724353 0.6927243535095993926023640323286367890472
#define FFTW_K693432500 0.6934325007922417286259483972875805939519
#define FFTW_K694074195 0.6940741952206338743562373929183182498191
#define FFTW_K694658370 0.6946583704589972866564062994226862299198
#define FFTW_K695192427 0.6951924276746422635493018952393936461260
#define FFTW_K695682550 0.6956825506034863980123038192788602156570
#define FFTW_K696133945 0.6961339459629266082804580802171441972963
#define FFTW_K696551029 0.6965510290629970275685644956080105169444
#define FFTW_K696937568 0.6969375686552934513687343434240100437094
#define FFTW_K697296801 0.6972968010939954123883995190174803108192
#define FFTW_K697631521 0.6976315211349847088683553934221612826295
#define FFTW_K697944154 0.6979441547663435525141697077142117061923
#define FFTW_K698236818 0.6982368180860728303443788766343622359181
#define FFTW_K707106781 0.7071067811865475244008443621048490392848
#define FFTW_K715866849 0.7158668492597184358325495667351529571818
#define FFTW_K716152188 0.7161521883143933244871695467834148450420
#define FFTW_K716456740 0.7164567402983151385899735430616918149233
#define FFTW_K716782513 0.7167825131684512560287415441946047504647
#define FFTW_K717131804 0.7171318047589634877970500299385526785307
#define FFTW_K717507257 0.7175072570443311343681755891326858548995
#define FFTW_K717911923 0.7179119230644419217516810110208110922839
#define FFTW_K718349350 0.7183493500977275799770853713340482116475
#define FFTW_K718823683 0.7188236838779293347704518118723688496542
#define FFTW_K719339800 0.7193398003386511393560546744567119082307
#define FFTW_K719903473 0.7199034737579958486390645343470509553063
#define FFTW_K720521593 0.7205215936007870086417952013179792194347
#define FFTW_K721202447 0.7212024473438145312912178776909015417372
#define FFTW_K721956093 0.7219560939545244623539160604710216653225
#define FFTW_K722794863 0.7227948638273915285452633514998522610902
#define FFTW_K723734038 0.7237340381050701616398577367648401146360
#define FFTW_K724247082 0.7242470829514669209410692432905531674831
#define FFTW_K724792787 0.7247927872291199588654846624405482525919
#define FFTW_K725374371 0.7253743710122876379932841111897274422634
#define FFTW_K725995491 0.7259954919231308581383348989285119089043
#define FFTW_K726660322 0.7266603220340270471615222876385396255744
#define FFTW_K727373641 0.7273736415730486959871764176638155218003
#define FFTW_K728140953 0.7281409538757884113627136381609143278784
#define FFTW_K728968627 0.7289686274214115231467303190552591113725
#define FFTW_K729864072 0.7298640726978356573501011944031818828671
#define FFTW_K730835964 0.7308359642781241016508331160835884644009
#define FFTW_K731894522 0.7318945221817254249995908196165164482138
#define FFTW_K733051871 0.7330518718298263285224314892706719069732
#define FFTW_K733885366 0.7338853664321991204758701610226706020529
#define FFTW_K734322509 0.7343225094356855356361262221870633391234
#define FFTW_K734774150 0.7347741508630672705517472711052032451697
#define FFTW_K735723910 0.7357239106731316247742076119610924993214
#define FFTW_K736741137 0.7367411378764049113081712804175510630885
#define FFTW_K737277336 0.7372773368101240413842933949823167074783
#define FFTW_K737833279 0.7378332790417272840054057907426797687494
#define FFTW_K739008917 0.7390089172206591159245343098726481057599
#define FFTW_K740277997 0.7402779970753155388739455189600782362008
#define FFTW_K740951125 0.7409511253549590911756168974951627297289
#define FFTW_K741652105 0.7416521056479575401050298834696252306095
#define FFTW_K742013585 0.7420135854509107900562897491988128499895
#define FFTW_K743144825 0.7431448254773942350146970489742569771891
#define FFTW_K744351737 0.7443517375622702753223079406751082310911
#define FFTW_K744772182 0.7447721827437818541801075535542228384922
#define FFTW_K745642164 0.7456421648831656094855517544592784043106
#define FFTW_K746553221 0.7465532216119626505430821259987599991059
#define FFTW_K747025071 0.7470250712409959770813061511833665718690
#define FFTW_K748510748 0.7485107481711010986346305997013513838464
#define FFTW_K749781202 0.7497812029677341725472752431791603229768
#define FFTW_K750111069 0.7501110696304595415116318903602243084582
#define FFTW_K750672305 0.7506723052527243552853714132129325824726
#define FFTW_K751131930 0.7511319308705198908719336792015250259316
#define FFTW_K751839807 0.7518398074789773964075194063769614427711
#define FFTW_K752570769 0.7525707698561385039345058991616619849640
#define FFTW_K753071466 0.7530714660036109335328981126967543453011
#define FFTW_K753713025 0.7537130253273611135174409504536276492985
#define FFTW_K754106609 0.7541066097768962584072425641248841945967
#define FFTW_K755749574 0.7557495743542582837740358439723444201797
#define FFTW_K757208846 0.7572088465064845475754640536057844730404
#define FFTW_K757511242 0.7575112421616200777921492788026149650951
#define FFTW_K757971723 0.7579717231454529817885572940611047033822
#define FFTW_K758758122 0.7587581226927909019132546363634371874187
#define FFTW_K759404916 0.7594049166547071324830192475886597898185
#define FFTW_K760405965 0.7604059656000309381745943648449019998887
#define FFTW_K761445958 0.7614459583691344354059827794359096182151
#define FFTW_K762162055 0.7621620551276364632557304138001066169968
#define FFTW_K763084068 0.7630840681998065061370822576584453862969
#define FFTW_K763652196 0.7636521965473320213761899200454104141096
#define FFTW_K764037375 0.7640373758216074366584418224732236328521
#define FFTW_K766044443 0.7660444431189780352023926505554166739358
#define FFTW_K767880446 0.7678804460366000439108131759354179442125
#define FFTW_K768197578 0.7681975780402805136696963323797498461191
#define FFTW_K768647139 0.7686471397785320711672309487157031840488
#define FFTW_K769333970 0.7693339709828789081165579311348793444580
#define FFTW_K769833983 0.7698339834299062446400585995897523594467
#define FFTW_K770513242 0.7705132427757892308030096363961778472716
#define FFTW_K771489179 0.7714891798219429236333137852557419058307
#define FFTW_K771916650 0.7719166509163208938857372713158033849885
#define FFTW_K773010453 0.7730104533627369608109066097584698009710
#define FFTW_K774141610 0.7741416106390824490643725637222281648702
#define FFTW_K774604961 0.7746049618276545830695547811609143505275
#define FFTW_K775015651 0.7750156514834587774905671515508743070762
#define FFTW_K775711290 0.7757112907044198070411010109695368955877
#define FFTW_K776523862 0.7765238627180424194178981071015438682470
#define FFTW_K777145961 0.7771459614569708799799377436724038490920
#define FFTW_K778035754 0.7780357543184395071379034311358886990222
#define FFTW_K778641538 0.7786415380497551756216347075406753784977
#define FFTW_K779080574 0.7790805745256704319243606206074903916787
#define FFTW_K779413382 0.7794133820415916066406766395486940072562
#define FFTW_K781831482 0.7818314824680298087084445266740577502323
#define FFTW_K784119806 0.7841198065767104288007771818131996408643
#define FFTW_K784415664 0.7844156649195757164147347243863789879656
#define FFTW_K784799385 0.7847993852786609660467986845419951971886
#define FFTW_K785316930 0.7853169308807449274703402789474438465742
#define FFTW_K786053094 0.7860530947427874697567960561472203660398
#define FFTW_K786551555 0.7865515558026424811142105001200600923644
#define FFTW_K787183480 0.7871834806090501817971553081772994121428
#define FFTW_K788010753 0.7880107536067219566939777878358516666417
#define FFTW_K788346427 0.7883464276266062620091647053596892826565
#define FFTW_K789140509 0.7891405093963935992189811493990907424327
#define FFTW_K790155012 0.7901550123756903651583739005191500716562
#define FFTW_K790775736 0.7907757369376985820782204594612615906186
#define FFTW_K791496488 0.7914964884292541024484192534757154670595
#define FFTW_K791902245 0.7919022459222750967567379392185911277200
#define FFTW_K793353340 0.7933533402912351645797769615012992766286
#define FFTW_K794854441 0.7948544414133532553739957580767734022432
#define FFTW_K795292871 0.7952928712734264419747999587861323112984
#define FFTW_K796093065 0.7960930657056437459980762465098682421823
#define FFTW_K796805111 0.7968051114159045953017786484229447858314
#define FFTW_K797132507 0.7971325072229224793372837601652378546732
#define FFTW_K798017227 0.7980172272802395033328051127962613693613
#define FFTW_K799010485 0.7990104853582490339189956088648939776689
#define FFTW_K799442763 0.7994427634035011497843129165366612315496
#define FFTW_K799839244 0.7998392447397193882383350307398838367966
#define FFTW_K800541240 0.8005412409243604039694861948940174149851
#define FFTW_K801413621 0.8014136218679566597869832895333147708145
#define FFTW_K802123192 0.8021231927550437850832948919339251336279
#define FFTW_K802711637 0.8027116379309636648857701593460559768659
#define FFTW_K803207531 0.8032075314806449098066765129631419238795
#define FFTW_K803997130 0.8039971303669405448263546938160337037246
#define FFTW_K804597779 0.8045977797666683273479469589870672086575
#define FFTW_K805070053 0.8050700531275629237964644458284235283226
#define FFTW_K805451132 0.8054511325509459412018817468525086560274
#define FFTW_K805765105 0.8057651056609781448783432800395721783251
#define FFTW_K806028263 0.8060282634540050525485951357692559600329
#define FFTW_K809016994 0.8090169943749474241022934171828190588601
#define FFTW_K811938005 0.8119380057158564945968154707997246072052
#define FFTW_K812188872 0.8121888727802111341842463443864419315001
#define FFTW_K812486878 0.8124868780056812804083249549706806424640
#define FFTW_K812846684 0.8128466845916152165790961432719088000368
#define FFTW_K813289740 0.8132897407355653520077715387689353346970
#define FFTW_K813848717 0.8138487172701949671014723968817952735703
#define FFTW_K814575952 0.8145759520503357077796110789197173627162
#define FFTW_K815028337 0.8150283375168113542809178737613989382610
#define FFTW_K815560868 0.8155608689592601713495029594534251284932
#define FFTW_K816196912 0.8161969123562216908718525404314132261743
#define FFTW_K816969893 0.8169698930104420169734140372449881772467
#define FFTW_K817584813 0.8175848131515836965049208841306338094710
#define FFTW_K817929360 0.8179293607667176652958167850895491664995
#define FFTW_K818302775 0.8183027759081690562813923055156721567774
#define FFTW_K819152044 0.8191520442889917896844883859168434318900
#define FFTW_K820172254 0.8201722545969558802093426246966592359901
#define FFTW_K820763441 0.8207634412072763263635445613553707767234
#define FFTW_K821420775 0.8214207751204915613062020704361611380444
#define FFTW_K821777815 0.8217778152252451671574450614136543968389
#define FFTW_K822983865 0.8229838658936563945796174234393819906550
#define FFTW_K824126188 0.8241261886220156617296849031023120581344
#define FFTW_K824441560 0.8244415603417603172395375008020188385297
#define FFTW_K824997474 0.8249974745983023155379937789444219618160
#define FFTW_K825471896 0.8254718969627739569806123728687672821516
#define FFTW_K826238774 0.8262387743159948719451625737726783977923
#define FFTW_K827080574 0.8270805742745618249178521862153294255631
#define FFTW_K827688998 0.8276889981568905561357816231375032629304
#define FFTW_K828509649 0.8285096492438421235308184341918643175695
#define FFTW_K829037572 0.8290375725550416920063368415016420263290
#define FFTW_K829405685 0.8294056854502017964409300836351034222685
#define FFTW_K829677013 0.8296770135526188902704259673870759766830
#define FFTW_K831469612 0.8314696123025452370787883776179057567385
#define FFTW_K833313919 0.8333139190825149799338497823040738779341
#define FFTW_K833602385 0.8336023852211194846164818272941764912595
#define FFTW_K833997817 0.8339978178898779396182802893240929133492
#define FFTW_K834573253 0.8345732537213026509332106768737349045847
#define FFTW_K834971812 0.8349718124324073791989500778051524105744
#define FFTW_K835487811 0.8354878114129364196538261700195835937419
#define FFTW_K836182124 0.8361821242547108702206976219550553416196
#define FFTW_K837166478 0.8371664782625285748060612009369102474987
#define FFTW_K838088104 0.8380881048918406577111979492710431086713
#define FFTW_K838670567 0.8386705679454240296375909418045478940395
#define FFTW_K839365426 0.8393654261319499596375221301924238843327
#define FFTW_K839765683 0.8397656832273979021124385277222164103972
#define FFTW_K840025923 0.8400259231507714427435891533712282132058
#define FFTW_K841253532 0.8412535328311811688618116489193677175133
#define FFTW_K842582073 0.8425820736166491030403155344809671036641
#define FFTW_K842892271 0.8428922714167970616253021027431752417750
#define FFTW_K843391445 0.8433914458128857012728568058275720937337
#define FFTW_K843775559 0.8437755598231856492381035650969764103387
#define FFTW_K844327925 0.8443279255020150785485580639666815053816
#define FFTW_K844853565 0.8448535652497070732595712051049570977198
#define FFTW_K845190085 0.8451900855437947525384210461577995981395
#define FFTW_K845596003 0.8455960035018260599096401021741480733078
#define FFTW_K846724199 0.8467241992282841683527758162629652715100
#define FFTW_K847734427 0.8477344278896709378979078108963493518662
#define FFTW_K848048096 0.8480480961564259703861761786903864487287
#define FFTW_K848644257 0.8486442574947509504641043389938084539825
#define FFTW_K849202181 0.8492021815265788876490969373431002233934
#define FFTW_K850217135 0.8502171357296141521341439229493520584706
#define FFTW_K851116672 0.8511166724369997244053230155948839997322
#define FFTW_K851529137 0.8515291377333112998870022534009853476003
#define FFTW_K851919408 0.8519194088383270748769520464652824320111
#define FFTW_K852640164 0.8526401643540922215193834581304121358172
#define FFTW_K853290881 0.8532908816321556602859841530744174889494
#define FFTW_K853593089 0.8535930890373464483418460304073336603452
#define FFTW_K854419404 0.8544194045464885525482156195502508000478
#define FFTW_K855142763 0.8551427630053461657188369620377883134776
#define FFTW_K855781272 0.8557812723014475226428751870717647816026
#define FFTW_K856349030 0.8563490302515889746335454168038935447319
#define FFTW_K856857176 0.8568571761675892445230765519053744460274
#define FFTW_K857314628 0.8573146280763323254728913071983536155226
#define FFTW_K857728610 0.8577286100002720699022699842847701370425
#define FFTW_K858448793 0.8584487936018661185256909553391418597076
#define FFTW_K859053954 0.8590539543698851819025917736107901459966
#define FFTW_K859569606 0.8595696069872011600426288131227073044970
#define FFTW_K860014240 0.8600142402077005233981293105137709830115
#define FFTW_K860401579 0.8604015792601393698695982953288507392950
#define FFTW_K860742027 0.8607420270039436371645764888171186033396
#define FFTW_K861043611 0.8610436117673555084585595060301225131232
#define FFTW_K861312628 0.8613126282324089409969539854169889092899
#define FFTW_K861554081 0.8615540813938061097287323042306235949835
#define FFTW_K861772000 0.8617720007435496349698180347969737605395
#define FFTW_K866025403 0.8660254037844386467637231707529361834714
#define FFTW_K870086991 0.8700869911087114186522924044838488439108
#define FFTW_K870285241 0.8702852410301552181879425663868640291029
#define FFTW_K870503836 0.8705038360561720522112540977190092812503
#define FFTW_K870746077 0.8707460771197771877217507835501149827317
#define FFTW_K871016019 0.8710160199955155735930822648109600128714
#define FFTW_K871318704 0.8713187041233893515466254843890811801214
#define FFTW_K871660470 0.8716604700327512208196316756206218352705
#define FFTW_K872049408 0.8720494081438076081277840260926609267766
#define FFTW_K872496007 0.8724960070727971145251610992220606750668
#define FFTW_K873014113 0.8730141131611881587490998015817489306733
#define FFTW_K873622390 0.8736223906463695371317751603403871753524
#define FFTW_K874346616 0.8743466161445821188274846642006517855751
#define FFTW_K874763084 0.8747630845319612851774127792561794433059
#define FFTW_K875223421 0.8752234219087536975047322807456399773275
#define FFTW_K875734942 0.8757349421956368077335331364008557877370
#define FFTW_K876306680 0.8763066800438635873081159039220625833990
#define FFTW_K876949928 0.8769499282066715222872466054001294856266
#define FFTW_K877678989 0.8776789895672556152144819341043752955765
#define FFTW_K878221573 0.8782215733702285355675152847970664824282
#define FFTW_K878512250 0.8785122509109423770324441012904022125743
#define FFTW_K878817112 0.8788171126619653741299951436845247996106
#define FFTW_K879473751 0.8794737512064890713908547548818411172079
#define FFTW_K880201391 0.8802013911801111312939007656084800475957
#define FFTW_K880595531 0.8805955318567379951929100621071846598466
#define FFTW_K881012194 0.8810121942857845060087088179255903520436
#define FFTW_K881921264 0.8819212643483550297127568636603883495084
#define FFTW_K882678798 0.8826787983255474000126255959521373235657
#define FFTW_K882947592 0.8829475928589269420321713603157193860835
#define FFTW_K883512044 0.8835120444460229228273168942218641218895
#define FFTW_K884115393 0.8841153935046097894486040972072045445368
#define FFTW_K884432930 0.8844329309978143222381222066254039736375
#define FFTW_K885456025 0.8854560256532098959003755220150988786055
#define FFTW_K886360032 0.8863600326884082489319680620575687435341
#define FFTW_K886599306 0.8865993063730000600561492865169439780362
#define FFTW_K887010833 0.8870108331782217010546098830375165208464
#define FFTW_K887352075 0.8873520750565715798425605640019506703212
#define FFTW_K887885218 0.8878852184023752349842692774195844835989
#define FFTW_K888445635 0.8884456359788723003064024832079566539738
#define FFTW_K888835448 0.8888354486549234663115988929508545523678
#define FFTW_K889342148 0.8893421488825189034181645031537721365929
#define FFTW_K889657090 0.8896570909947472780924836875303123734246
#define FFTW_K889871808 0.8898718088114686056939962978651778190884
#define FFTW_K891006524 0.8910065241883678623597095714136263127705
#define FFTW_K892254238 0.8922542386183940179207828634080536567074
#define FFTW_K892518835 0.8925188358598812258172950673579982916784
#define FFTW_K892925858 0.8929258581495684897301089783029903371682
#define FFTW_K893224301 0.8932243011955153203424164474933979780006
#define FFTW_K893632640 0.8936326403234122481925741868666551173761
#define FFTW_K894225269 0.8942252698597112823960628785193238212484
#define FFTW_K894487082 0.8944870822287955820318233216497337670451
#define FFTW_K895163291 0.8951632913550623220670164997537854569905
#define FFTW_K895872260 0.8958722607586879531165149908123770853627
#define FFTW_K896165556 0.8961655569610556111428812574074225463776
#define FFTW_K896872741 0.8968727415326883038941039363930811981792
#define FFTW_K897398428 0.8973984286913583989856569596882832674134
#define FFTW_K897804539 0.8978045395707416571368028976620412024434
#define FFTW_K898390981 0.8983909818919788715724772004503877322352
#define FFTW_K898794046 0.8987940462991669927822956766957853549299
#define FFTW_K899088113 0.8990881137654259575573009403311324039869
#define FFTW_K899312130 0.8993121301712192281267728278439957438859
#define FFTW_K900968867 0.9009688679024191262361023195074450511659
#define FFTW_K902585284 0.9025852843498606067626451490957717568164
#define FFTW_K902797829 0.9027978299657435157159434879211280035795
#define FFTW_K903074732 0.9030747323245327046634600051435581145958
#define FFTW_K903450434 0.9034504346103822750158502586754325787995
#define FFTW_K903989293 0.9039892931234433315862002972305370487101
#define FFTW_K904357160 0.9043571606975774917577889956510946245375
#define FFTW_K904827052 0.9048270524660195277136686479326975939704
#define FFTW_K905448237 0.9054482374931466157217925560288827802948
#define FFTW_K905702263 0.9057022630804714831454571042369241665150
#define FFTW_K906307787 0.9063077870366499632425526567543169832677
#define FFTW_K907090913 0.9070909137343407425834416725781145590933
#define FFTW_K907575419 0.9075754196709570536201612900285178073502
#define FFTW_K908143173 0.9081431738250812992580858365718675308412
#define FFTW_K908465271 0.9084652718195236861115036475859197065373
#define FFTW_K908672791 0.9086727911416249200241224067716522862116
#define FFTW_K909631995 0.9096319953545183714117153830790284600602
#define FFTW_K910634772 0.9106347728549131795432779003164790771901
#define FFTW_K910863824 0.9108638249211758185732917071605506458979
#define FFTW_K911228490 0.9112284903881357028266050899228384756870
#define FFTW_K911505852 0.9115058523116731517830363345907678394956
#define FFTW_K911899845 0.9118998459920900771751693987314744889449
#define FFTW_K912503616 0.9125036164765500159680850800074193201110
#define FFTW_K912783265 0.9127832650613189089239580059304432421433
#define FFTW_K913545457 0.9135454576426008955021275719853171779408
#define FFTW_K914209755 0.9142097557035306546350148293935774010447
#define FFTW_K914412623 0.9144126230158124813216621552768982013708
#define FFTW_K914793868 0.9147938684880209699974625808573866803804
#define FFTW_K915145617 0.9151456172430184708919922968074955054838
#define FFTW_K915773326 0.9157733266550574399193492356940089700766
#define FFTW_K916316904 0.9163169044870047347483910891303247178132
#define FFTW_K916562255 0.9165622558699761858166528942590914119157
#define FFTW_K917211301 0.9172113015054530178438054479656154936903
#define FFTW_K917754625 0.9177546256839811411456038575494850645302
#define FFTW_K918216106 0.9182161068802740147589614153146366024813
#define FFTW_K918612937 0.9186129377636217717227839432978941276582
#define FFTW_K918957811 0.9189578116202306291271881732781545512765
#define FFTW_K919527772 0.9195277725514506383219765907863572139881
#define FFTW_K919979443 0.9199794436588242031333806039892048138233
#define FFTW_K920346183 0.9203461835691594463070513006835656710894
#define FFTW_K920649886 0.9206498866764287674701863104116332022322
#define FFTW_K920905517 0.9209055179449536255994064620068449731338
#define FFTW_K921123653 0.9211236531148501159329021282782128071959
#define FFTW_K921311977 0.9213119778704129896905480715839225965944
#define FFTW_K921476211 0.9214762118704076536461883522196093537778
#define FFTW_K923879532 0.9238795325112867561281831893967882868224
#define FFTW_K926323968 0.9263239682514949705912905047270639912213
#define FFTW_K926494067 0.9264940672148017743152104663441626574522
#define FFTW_K926689607 0.9266896074318334380530112475652589383520
#define FFTW_K926916757 0.9269167573460217630248384996993891944013
#define FFTW_K927183854 0.9271838545667874008064744511369569420976
#define FFTW_K927502451 0.9275024511020946646050826878721451949727
#define FFTW_K927889027 0.9278890272965093271272407498585829086596
#define FFTW_K928367933 0.9283679330160726102005887247635900348309
#define FFTW_K928652999 0.9286529995722621793338215070602379216189
#define FFTW_K928976719 0.9289767198167914417896296010855542620841
#define FFTW_K929347524 0.9293475242268224539554160275642758031236
#define FFTW_K929776485 0.9297764858882514036609425562219907295871
#define FFTW_K930278443 0.9302784433378331543856301730081308574415
#define FFTW_K930873748 0.9308737486442042556377992419512753071420
#define FFTW_K931336177 0.9313361774523384395875688031090437233347
#define FFTW_K931591088 0.9315910880512789729395061972269616864428
#define FFTW_K931864029 0.9318640292114523161883811474964361005778
#define FFTW_K932472229 0.9324722294043558045731158918215633862626
#define FFTW_K932992798 0.9329927988347388877116602555433024982950
#define FFTW_K933180611 0.9331806110416025837525594317989553113908
#define FFTW_K933580426 0.9335804264972017489900430631395707414059
#define FFTW_K934016108 0.9340161087325479993506852910851617783859
#define FFTW_K934248940 0.9342489402945998550750225109270206586844
#define FFTW_K935016242 0.9350162426854148234397845998378307290505
#define FFTW_K935716819 0.9357168190404936530452206735763588980841
#define FFTW_K935905926 0.9359059267573257002917072494667353604862
#define FFTW_K936234870 0.9362348706397372095087557244681174697775
#define FFTW_K936511241 0.9365112411970547880293893304037418045007
#define FFTW_K936949724 0.9369497249997617358215340023800922029264
#define FFTW_K937419661 0.9374196611341208896823459233762131843021
#define FFTW_K937752132 0.9377521321470804584291761743123298881308
#define FFTW_K938191335 0.9381913359224841344523397266860115488320
#define FFTW_K938468422 0.9384684220497604029667155343105113540832
#define FFTW_K938659164 0.9386591647471505040724405750138456370676
#define FFTW_K939692620 0.9396926207859083840541092773247314699362
#define FFTW_K940700266 0.9407002666710332778144147138258163847213
#define FFTW_K940880768 0.9408807689542254723241184190970210354205
#define FFTW_K941140047 0.9411400479795615741432348245881724850480
#define FFTW_K941544065 0.9415440651830207784125094025995023571856
#define FFTW_K941844363 0.9418443636395246934886599986368180673483
#define FFTW_K942260922 0.9422609221188204956176842253179721336254
#define FFTW_K942641491 0.9426414910921783947771677362823118828448
#define FFTW_K942877445 0.9428774454610841700409712864144146678198
#define FFTW_K943154434 0.9431544344712774640574280872093873723077
#define FFTW_K943883330 0.9438833303083675628952636071510366215206
#define FFTW_K944489228 0.9444892287836612562119467742722171807155
#define FFTW_K944669091 0.9446690916079188006659540817282152326248
#define FFTW_K945000818 0.9450008187146684873915352426727239165683
#define FFTW_K945299815 0.9452998150346402616705143998997016607838
#define FFTW_K945817241 0.9458172417006346790196657142849415278238
#define FFTW_K946249369 0.9462493690718368405241967976805762668189
#define FFTW_K946439773 0.9464397731576093538703011154574776795266
#define FFTW_K946930129 0.9469301294951056642558042748539836836988
#define FFTW_K947326353 0.9473263538541913844327283048776780232015
#define FFTW_K947653171 0.9476531711828024442740040119711601634623
#define FFTW_K947927346 0.9479273461671317559187225179207687336495
#define FFTW_K948160647 0.9481606475909658589306343094708234149340
#define FFTW_K948536441 0.9485364419471455261649097836474828763046
#define FFTW_K948825916 0.9488259168373196381387831532597734947289
#define FFTW_K949055747 0.9490557470106686677560247808577723846680
#define FFTW_K949242643 0.9492426435730339082613672603147399360686
#define FFTW_K949397608 0.9493976084683812981670710293175487404773
#define FFTW_K949528180 0.9495281805930366671959360741893450282522
#define FFTW_K951056516 0.9510565162951535721164393333793821434057
#define FFTW_K952635380 0.9526353808033825473157607370981429062638
#define FFTW_K952775122 0.9527751227228962896620281580565795070492
#define FFTW_K952942000 0.9529420004271565558310283034152551849996
#define FFTW_K953144766 0.9531447668141608217276037452354468061606
#define FFTW_K953396392 0.9533963920549305459532780713869375485036
#define FFTW_K953716950 0.9537169507482269211438470646002574361517
#define FFTW_K954139256 0.9541392564000488514758967202113007469136
#define FFTW_K954405001 0.9544050018795074313557527182827665834059
#define FFTW_K954720866 0.9547208665085456260632257187577027324935
#define FFTW_K955102497 0.9551024972069124260581615872080246655679
#define FFTW_K955572805 0.9555728057861407328113340537674666664396
#define FFTW_K955952142 0.9559521426716116096201124770282868790124
#define FFTW_K956166734 0.9561667347392509355062530712604052072035
#define FFTW_K956400984 0.9564009842765224267816104574942389408587
#define FFTW_K956940335 0.9569403357322088649357978869802699694828
#define FFTW_K957422038 0.9574220383620054784219814066701634108048
#define FFTW_K957600599 0.9576005999084059522314160387302455826259
#define FFTW_K957989512 0.9579895123154888744373747669567546242580
#define FFTW_K958427482 0.9584274824582527002251773197822330882206
#define FFTW_K958667853 0.9586678530366606221509833883096862227102
#define FFTW_K958819734 0.9588197348681930497610285413925982910492
#define FFTW_K959492973 0.9594929736144973898903680570663276990624
#define FFTW_K960149873 0.9601498736716017631384943454019255716108
#define FFTW_K960293685 0.9602936856769430717520688004889952933058
#define FFTW_K960518111 0.9605181116313722984399716039511134369404
#define FFTW_K960917321 0.9609173219450995432119881422930318860934
#define FFTW_K961261695 0.9612616959383188619164970485570648735257
#define FFTW_K961416730 0.9614167300122124852309898043387424113665
#define FFTW_K961825643 0.9618256431728190704087962907315185500314
#define FFTW_K962268000 0.9622680003092504049510324619909753067365
#define FFTW_K962455236 0.9624552364536472876302664051852632909944
#define FFTW_K962624246 0.9626242469500120742026630479274062371083
#define FFTW_K962917287 0.9629172873477992950152235973732387993550
#define FFTW_K963270801 0.9632708010475163164004074245844491050914
#define FFTW_K963549992 0.9635499925192229600433361810024919509632
#define FFTW_K963776065 0.9637760657954398666864643555078351536631
#define FFTW_K963962860 0.9639628606958532918885659525499857760906
#define FFTW_K964253495 0.9642534954531409838529948264870398702492
#define FFTW_K964469175 0.9644691750543765745192646181812789566372
#define FFTW_K964635581 0.9646355819083586729132710036114158221655
#define FFTW_K964767868 0.9647678688145159485146378868261663336703
#define FFTW_K965925826 0.9659258262890682867497431997288973676339
#define FFTW_K967027724 0.9670277247913203491918621498323771774221
#define FFTW_K967146854 0.9671468547019571390593240593318965996643
#define FFTW_K967294863 0.9672948630390294157758746656854387201623
#define FFTW_K967483697 0.9674836970574252545056551754955779856175
#define FFTW_K967732946 0.9677329469334988386884628287513969373382
#define FFTW_K968077118 0.9680771188662043051530076728012907428347
#define FFTW_K968303522 0.9683035221222614393926671480238885087824
#define FFTW_K968583161 0.9685831611286311194901683754647358138360
#define FFTW_K968937301 0.9689373017815073299549272178752194446760
#define FFTW_K969077286 0.9690772862290779477269065494657367873034
#define FFTW_K969400265 0.9694002659393304167361073217961682259573
#define FFTW_K969796936 0.9697969360350094718195360156539576289212
#define FFTW_K970031253 0.9700312531945439926039842072861002514568
#define FFTW_K970295726 0.9702957262759964723063778740339903776322
#define FFTW_K970441148 0.9704411482532114174890399562715796811572
#define FFTW_K970941817 0.9709418174260520271569822762937892272498
#define FFTW_K971429893 0.9714298932647099623746131301214786871614
#define FFTW_K971567089 0.9715670893979414829343695558577052136741
#define FFTW_K971811568 0.9718115683235416873794201547326635821400
#define FFTW_K972022914 0.9720229140804107808510859601443895664086
#define FFTW_K972369920 0.9723699203976766018336458341187976440025
#define FFTW_K972758663 0.9727586637650371566638855431106228008872
#define FFTW_K973044870 0.9730448705798238388328851727846959200348
#define FFTW_K973264373 0.9732643737003824959312345137172719428005
#define FFTW_K973438054 0.9734380543606928258135514267061557560963
#define FFTW_K973695423 0.9736954238777790443618756632395424075067
#define FFTW_K973876979 0.9738769792773336481496899701335503917353
#define FFTW_K974011916 0.9740119169423335138154695987232315341728
#define FFTW_K974116147 0.9741161479953870616712023593468831967519
#define FFTW_K974927912 0.9749279121818236070181316829939312172328
#define FFTW_K975702130 0.9757021300385285444603957664195279716440
#define FFTW_K975796382 0.9757963826274356228783491415777791577932
#define FFTW_K975916761 0.9759167619387473989575160319010275841997
#define FFTW_K976075877 0.9760758775559271590070457564913246259691
#define FFTW_K976296007 0.9762960071199333659708864896054275771653
#define FFTW_K976620555 0.9766205557100866832082279628778633517990
#define FFTW_K976848317 0.9768483177596007116214126531054889178029
#define FFTW_K977146865 0.9771468659711595194867185493399910586943
#define FFTW_K977403389 0.9774033898178666485587216924073730415593
#define FFTW_K977555238 0.9775552389476861943402493547982576354464
#define FFTW_K977726916 0.9777269163708468952746194417086665766233
#define FFTW_K978147600 0.9781476007338056379285667478695995324597
#define FFTW_K978556492 0.9785564922995040021441569982979483175857
#define FFTW_K978716845 0.9787168453273544836415447921951226189869
#define FFTW_K978855685 0.9788556850953578475488459902421741595530
#define FFTW_K979084087 0.9790840876823228756328148847602371349846
#define FFTW_K979340621 0.9793406217655515015104288246369218020372
#define FFTW_K979529941 0.9795299412524944939380064428117707242914
#define FFTW_K979790652 0.9797906520422677014706319852738255873975
#define FFTW_K979961705 0.9799617050365868167949249404815421840498
#define FFTW_K980082561 0.9800825610923934085579115422063699191729
#define FFTW_K980172487 0.9801724878485438426221952928871404568919
#define FFTW_K980785280 0.9807852804032304491261822361342390369739
#define FFTW_K981451493 0.9814514932524178941230111511474289750195
#define FFTW_K981559156 0.9815591569910653538492430476851306890594
#define FFTW_K981708319 0.9817083199968549376776858998806597451093
#define FFTW_K981928697 0.9819286972627067003986744426247459609910
#define FFTW_K982083682 0.9820836827421560010932038226168804103451
#define FFTW_K982287250 0.9822872507286886810856417428652684163884
#define FFTW_K982566473 0.9825664732332882361458695018243242460076
#define FFTW_K982684124 0.9826841245925209408606988628810258780288
#define FFTW_K982973099 0.9829730996839017782819488448551987160987
#define FFTW_K983254907 0.9832549075639545845546320564305089875746
#define FFTW_K983365676 0.9833656768294661196753671326297494335829
#define FFTW_K983619906 0.9836199069471435884212429322426942302141
#define FFTW_K983797951 0.9837979515735163526446952978240676138119
#define FFTW_K983929588 0.9839295885986296553956360939899698965200
#define FFTW_K984111204 0.9841112043361161061416962408560232630074
#define FFTW_K984230577 0.9842305779475968124404416073840495619445
#define FFTW_K984315023 0.9843150237975341546618492275637931110120
#define FFTW_K984807753 0.9848077530122080593667430245895230136706
#define FFTW_K985277642 0.9852776423889412447740184331785477871601
#define FFTW_K985353835 0.9853538358476930122394797176177663749267
#define FFTW_K985459517 0.9854595177171968680142498259365517811271
#define FFTW_K985615910 0.9856159103477084622647702939762184573686
#define FFTW_K985871018 0.9858710185182358739239575569680608455649
#define FFTW_K986070253 0.9860702539900285422933352225912048513788
#define FFTW_K986361303 0.9863613034027223736025091948190671107285
#define FFTW_K986643332 0.9866433320848790047469239329842060425036
#define FFTW_K986826522 0.9868265225415261517686243504388935079839
#define FFTW_K987050262 0.9870502626379128637906800282243959059321
#define FFTW_K987181783 0.9871817834144501341077945503208892301209
#define FFTW_K987268354 0.9872683547213445699907431277816711317672
#define FFTW_K987688340 0.9876883405951377261900402476934372607584
#define FFTW_K988087896 0.9880878960910771492992690811307084884358
#define FFTW_K988165472 0.9881654720812594137618841327936534641992
#define FFTW_K988280423 0.9882804237803485263249493778325853582721
#define FFTW_K988468324 0.9884683243281113991621906894031537749210
#define FFTW_K988615412 0.9886154122075342261549440645140983788437
#define FFTW_K988830826 0.9888308262251285450697428829340086130652
#define FFTW_K989040187 0.9890401873221639791098880794573835995058
#define FFTW_K989176509 0.9891765099647809734516737380162430639837
#define FFTW_K989343368 0.9893433680751101977923535631123350883204
#define FFTW_K989441638 0.9894416385809445189738370649369388973400
#define FFTW_K989821441 0.9898214418809327323760920377767187873765
#define FFTW_K990181125 0.9901811253364455904432628100327605252812
#define FFTW_K990268068 0.9902680687415703150837748673448507592511
#define FFTW_K990410430 0.9904104308752051583495612400629094294845
#define FFTW_K990522084 0.9905220846375032755297487161751806762898
#define FFTW_K990685946 0.9906859460363307523423229600962060051400
#define FFTW_K990845596 0.9908455965788067627878172563691414037669
#define FFTW_K990949761 0.9909497617679347552486867131683644064606
#define FFTW_K991077488 0.9910774881547800989077028808834981789933
#define FFTW_K991152831 0.9911528310040071586383345991233567829241
#define FFTW_K991444861 0.9914448613738104111445575269285628712777
#define FFTW_K991722674 0.9917226741361015058214790070582345607756
#define FFTW_K991790013 0.9917900138232461089574427772187849280190
#define FFTW_K991900435 0.9919004352588768873144078072665135340842
#define FFTW_K991987177 0.9919871770507430065166704184575838095046
#define FFTW_K992114701 0.9921147013144778310497930427857785214530
#define FFTW_K992239206 0.9922392066001720806339750438970024692424
#define FFTW_K992320579 0.9923205797370450627452009318759713711174
#define FFTW_K992420509 0.9924205096719357582614560541072921874651
#define FFTW_K992479534 0.9924795345987099981567672516611178200108
#define FFTW_K992708874 0.9927088740980539928007516494925201793436
#define FFTW_K992981096 0.9929810960135169614675928693736574381005
#define FFTW_K993068456 0.9930684569549262956374372478102157228837
#define FFTW_K993238357 0.9932383577419429885478955521937043403491
#define FFTW_K993402089 0.9934020897596750687947423983479637156807
#define FFTW_K993481735 0.9934817353485502085180496808547969202400
#define FFTW_K993712209 0.9937122098932425835331482419473786971526
#define FFTW_K993930677 0.9939306773179494792563298151574801808174
#define FFTW_K994000975 0.9940009752399459187884342036497682765393
#define FFTW_K994137957 0.9941379571543596089553027158795515668545
#define FFTW_K994270301 0.9942703017718973183669165054181572463000
#define FFTW_K994334800 0.9943348002101371309920980500642722883465
#define FFTW_K994521895 0.9945218953682733369226919449805703815208
#define FFTW_K994699875 0.9946998756145890479762568067220906149617
#define FFTW_K994757278 0.9947572788580948291790636723123688992574
#define FFTW_K994869323 0.9948693233918951463213533098837194930039
#define FFTW_K994977815 0.9949778150885040755354075401441960635882
#define FFTW_K995030775 0.9950307753654014099099494968280711167442
#define FFTW_K995184726 0.9951847266721968862448369531094799215754
#define FFTW_K995379112 0.9953791129491982046051034132093649871861
#define FFTW_K995471922 0.9954719225730846047262552811299306157575
#define FFTW_K995561964 0.9955619646030800128976780442146194187237
#define FFTW_K995734176 0.9957341762950345218711911789054817839027
#define FFTW_K995896557 0.9958965576170909700362686366938831171748
#define FFTW_K995974293 0.9959742939952390295817189937211678685354
#define FFTW_K996049842 0.9960498426152169249788048954440014509192
#define FFTW_K996194698 0.9961946980917455322950104024738880461835
#define FFTW_K996331730 0.9963317308626913876242320559879490045416
#define FFTW_K996397488 0.9963974885425265016515427736575384585731
#define FFTW_K996461494 0.9964614941176191465297827729475896395564
#define FFTW_K996584493 0.9965844930066698498193520007504877187805
#define FFTW_K996701189 0.9967011895602227462429879020699209472138
#define FFTW_K996757308 0.9967573081342099855852412239757600532391
#define FFTW_K996812007 0.9968120070307501492577958043253480021674
#define FFTW_K996917333 0.9969173337331279761977734087420444201589
#define FFTW_K997017526 0.9970175264485266683508923434628785416228
#define FFTW_K997065801 0.9970658011837404621446414104254119713626
#define FFTW_K997112913 0.9971129134476474623595146912637885801501
#define FFTW_K997203797 0.9972037971811801482250298708781192656558
#define FFTW_K997290456 0.9972904566786902161355971401825678211717
#define FFTW_K997332283 0.9973322836635516728058606115895235926462
#define FFTW_K997452114 0.9974521146102535413623057568371267046549
#define FFTW_K997564050 0.9975640502598242476131626806442550263694
#define FFTW_K997668769 0.9976687691905391984535782806992783166368
#define FFTW_K997766878 0.9977668786231531595627548884062599817399
#define FFTW_K997858923 0.9978589232386035067380697912727776045318
#define FFTW_K997945392 0.9979453927503363420088404809579925550286
#define FFTW_K998026728 0.9980267284282715619523368068634505533369
#define FFTW_K998103328 0.9981033287370440781595580722798538475393
#define FFTW_K998175554 0.9981755542233174708416597487435284042144
#define FFTW_K998243731 0.9982437317643214135795104790047750439576
#define FFTW_K998308158 0.9983081582712682080478207087832775329371
#define FFTW_K998369103 0.9983691039261356791012880254984185496026
#define FFTW_K998426815 0.9984268150178165621314250714948528394090
#define FFTW_K998481516 0.9984815164333162254755259567160496340501
#define FFTW_K998533413 0.9985334138511238645717905110783489569243
#define FFTW_K998582695 0.9985826956767619481118898673784527334232
#define FFTW_K998629534 0.9986295347545738737844920584394365805909
#define FFTW_K998674089 0.9986740898848305076057717645316607303307
#define FFTW_K998716507 0.9987165071710528071463114367595140457475
#define FFTW_K998756921 0.9987569212189223697539952989398761436398
#define FFTW_K998795456 0.9987954562051723927147716047591006944432
#define FFTW_K998867339 0.9988673391830079766626725799084316622350
#define FFTW_K998932974 0.9989329748023724444057615270546990770867
#define FFTW_K998993066 0.9989930665413146473720559084446391440926
#define FFTW_K999048221 0.9990482215818577624037162194033297553505
#define FFTW_K999098966 0.9990989662046814723577027912279173440084
#define FFTW_K999145758 0.9991457583873010291856105308946378568012
#define FFTW_K999188998 0.9991889981715696377009069466390679555486
#define FFTW_K999229036 0.9992290362407229347371262603414616252706
#define FFTW_K999266181 0.9992661810508100203932244590995250044712
#define FFTW_K999300704 0.9993007047883985526997800741767273557026
#define FFTW_K999332848 0.9993328483702393720704821228710461134067
#define FFTW_K999362825 0.9993628256569916913056650851375650424587
#define FFTW_K999390827 0.9993908270190957300062434400439299644952
#define FFTW_K999417022 0.9994170223661740289494017247549951505277
#define FFTW_K999441563 0.9994415637302546063156399140856621311902
#define FFTW_K999464587 0.9994645874763656444298364462428599458836
#define FFTW_K999486216 0.9994862162006878676974893970113697242550
#define FFTW_K999506560 0.9995065603657315570006908367092536671784
#define FFTW_K999525719 0.9995257197133658746658464748330096458419
#define FFTW_K999543784 0.9995437844895333725476836898291665684873
#define FFTW_K999560836 0.9995608365087943494271135836565668351702
#define FFTW_K999576950 0.9995769500822005769626607634052808295813
#define FFTW_K999592192 0.9995921928281892296257285154349983157366
#define FFTW_K999606626 0.9996066263830528855052742630847215222778
#define FFTW_K999620307 0.9996203070249514057426708547796085483660
#define FFTW_K999633286 0.9996332862232839494682650720821574004171
#define FFTW_K999645611 0.9996456111234525767555760293242736879144
#define FFTW_K999657324 0.9996573249755572800367608883676798759498
#define FFTW_K999668467 0.9996684675143130940321877350828094000117
#define FFTW_K999679075 0.9996790752964305212076609008127490933988
#define FFTW_K999689182 0.9996891820008162841543067648951099180292
#define FFTW_K999698818 0.9996988186962042201157656496661721968500
