/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Paul Taylor                             */
/*                     Date   :  April 1996                              */
/*-----------------------------------------------------------------------*/
/*                        Matrix class                                   */
/*                                                                       */
/*=======================================================================*/
#ifndef __FMatrix_H__
#define __FMatrix_H__

#include "EST_TMatrix.h"
#include "EST_TVector.h"

class EST_FVector;

class EST_FMatrix: public EST_TMatrix<float> {
private:
public:
    EST_FMatrix(int m, int n):EST_TMatrix<float>(m, n)  {def_val = 0.0;}
    EST_FMatrix(const EST_FMatrix &a):EST_TMatrix<float>(a)  {def_val = 0.0;}
//    EST_FMatrix(EST_FMatrix &a, int b):EST_TMatrix<float>(a.num_rows(), a.num_columns()){;}
    EST_FMatrix(const EST_FMatrix &a, int b);
    EST_FMatrix():EST_TMatrix<float>()  {def_val = 0.0;}

    EST_write_status save(const EST_String &file);
    EST_read_status load(const EST_String &file);
    EST_write_status binsave(const EST_String &file);
    EST_read_status binload(const EST_String &file);

    void fill(float v);
    
    void copyin(float **x, int rows, int cols);
    EST_FMatrix &operator+=(const EST_FMatrix &a);

    friend EST_FMatrix operator*(const EST_FMatrix &a, const float x);
    friend EST_FVector operator*(const EST_FMatrix &a, const EST_FVector &v);
    friend EST_FMatrix operator*(const EST_FMatrix &a, const EST_FMatrix &b);


};

class IMatrix: public EST_TMatrix<int> {
private:
public:
    IMatrix(int m, int n):EST_TMatrix<int>(m, n) {def_val = 0;}
    IMatrix(IMatrix &a):EST_TMatrix<int>(a) {def_val = 0;}
    IMatrix(IMatrix &a, int b);
    IMatrix():EST_TMatrix<int>() {def_val = 0;}

//    int save(class EST_String);
//    int load(class EST_String);

    void fill(int v);
    
//    void copyin(float **x, int rows, int cols);

//    friend EST_FMatrix operator*(EST_FMatrix &a, float x);
//    friend EST_FMatrix operator*(EST_FMatrix &a, EST_FMatrix &b);
};

class EST_FVector: public EST_TVector<float> {
public:
    EST_FVector(int n): EST_TVector<float>(n) {def_val = 0.0;}
    EST_FVector(const EST_FVector &a): EST_TVector<float>(a) {def_val = 0.0;}
    EST_FVector(): EST_TVector<float>() {def_val = 0.0;}

    EST_FVector &operator*=(const EST_FVector &s); /// elementwise multiply

    EST_read_status load(EST_String filename);
};

class EST_DVector: public EST_TVector<double> {
public:
    EST_DVector(int n): EST_TVector<double>(n) {def_val = 0.0;}
    EST_DVector(EST_DVector &a): EST_TVector<double>(a) {def_val = 0.0;}
    EST_DVector(): EST_TVector<double>() {def_val = 0.0;}

    EST_read_status load(EST_String filename);
};


int matrix_max(const IMatrix &a);
float matrix_max(const EST_FMatrix &a);


int square(const EST_FMatrix &a);
EST_FMatrix inverse(EST_FMatrix &a);
EST_FMatrix pseudo_inverse(EST_FMatrix &a); // for non-square matrices
float determinant(const EST_FMatrix &a);
int singular(EST_FMatrix &a);
EST_FMatrix transpose(const EST_FMatrix &a);
EST_FMatrix triangulate(const EST_FMatrix &a);

EST_FMatrix diagonalise(const EST_FMatrix &a);
float sum(const EST_FMatrix &a);


EST_FMatrix operator*(const EST_FMatrix &a, const EST_FMatrix &b);
EST_FMatrix operator-(const EST_FMatrix &a, const EST_FMatrix &b);
EST_FMatrix operator+(const EST_FMatrix &a, const EST_FMatrix &b);

EST_FMatrix sub(const EST_FMatrix &a, int row, int col);
EST_FMatrix fmatrix_abs(const EST_FMatrix &a);


EST_FMatrix row(const EST_FMatrix &a, int row);
EST_FMatrix column(const EST_FMatrix &a, int col);


// in FMatrix_aux.C



bool
polynomial_fit(EST_FVector &x, EST_FVector &y, EST_FVector &co_effs, int order);

bool
polynomial_fit(EST_FVector &x, EST_FVector &y, EST_FVector &co_effs, 
	       EST_FVector &weights, int order);


#endif
