/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                        Author :  Paul Taylor                          */
/*                        Date   :  April 1995                           */
/*-----------------------------------------------------------------------*/
/*                        Compare Labels main                            */
/*                                                                       */
/*=======================================================================*/
#include "EST.h"
#include "EST_TMatrix.h"
#include "EST_stream_aux.h"
#include "EST_stream_compare.h"

int main(int argc, char *argv[])
{
    EST_StrList files;
    EST_Option al, op;
    EST_Stream ref, test, testpos, refpos,s;
    EST_FMatrix m;
    EST_StreamList rplist, tplist;
    EST_String refdir, reffile;
    EST_TBI *p;

    print_help(argc, argv); 

    parse_command_line(argc, argv, "-I:s -N -c:s -elr -elt -irtype:s \n\
                -ittype:s -m -method:i -o:s -ops -r:s -rpos:s -t:f \n\
                -tpos:s -v:i", files, al, 0);

    init_lib_ops(al, op);

    if (al.present("-I"))
	load_StreamList(al.val("-I"), rplist);
    else if (al.present("-L"))
	refdir = al.val("-L");
    else if (al.present("-r"))
    {
	if (ref.load_type(al.val("-r"), al.val("-irtype", 0)) != read_ok)
	    exit (0);
	cout << "ref name: " << ref.name()<< endl;
	rplist.append(ref);
    }

    if (al.val("-ittype", 0) == "mlf")
	load_StreamList(files.first(), tplist);
    else
	for (p = files.head(); p ; p = next(p))
	{
	    s.clear();
	    if (s.load_type(files(p), al.val("-ittype", 0)) == misc_read_error)
	    {
		cerr << "error: in reading test label file "<<files(p)<< "\n";
		exit(0);
	    }
	    tplist.append(s);
	}

    multiple_matrix_compare(rplist, tplist, m, al.val("-rpos"),
		al.val("-tpos"), (al.present("-method") ?
		al.ival("-method") : 1), (al.present("-t") ? al.fval("-t") :
		1.0), al.ival("-v", 0));

    if (al.present("-elt"))
    {
	EST_Stream etest;
	etest = tplist.first();
	pos_only(etest);
	cout << etest;
	error_location(etest, m, 0);
	etest.save("etest");
    }
    if (al.present("-elr"))
    {
	EST_Stream eref;
	eref = rplist.first();
	error_location(eref, m, 1);
	eref.save("eref");
    }

/*
    refpos = ref;
    testpos = test;
//    cout << "X:Ref labels " << refpos;
//    cout << "X:Test labels " << testpos;

    if (al.present("-rpos"))
	convert_to_broad(refpos, al.val("-rpos"));
    if (al.present("-tpos"))
	convert_to_broad(testpos, al.val("-tpos"));

    refpos.set_pos_name("pos");
    testpos.set_pos_name("pos");

    refpos.set_stream_name("ref");
    testpos.set_stream_name("test");

    if (al.val("-itype") == "mlf")
    else if (al.present("-m"))
    {
	m = matrix_compare(refpos, testpos, 
		       (al.present("-method") ? al.ival("-method") : 1),
		       (al.present("-t") ? al.fval("-t") : 1.0),
		       al.present("-v"));

	print_i_d_scores(m);
	if (al.present("-v"))
	    print_matrix_scores(refpos, testpos, m);
	if (al.present("-o")) // save labels with scores
	  refpos.save(al.val("-o"), "", 2);
    }
    else
	compare_labels(refpos, testpos);
*/
    return 0;
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{
    a_list.override_val("ref_file_type", al.val("-rtype", 0));
    a_list.override_val("test_file_type", al.val("-ttype", 0));
}

void print_help(int argc, char *argv[])
{
    for (int i = 0; i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "comp_lab <ref file> <test file> <options>\n";
	    cout << "use \"-\" to make input and output files stdin/out\n";
	    cout << "-h      options help\n";
	    cout << "-N      do NOT read environment operations file\n";
	    cout << "-c      <operations file> for system params \n";
	    cout << "-itype  <input file type 'esps' 'htk'>\n";
	    cout << "-m      Use matrix comparison\n";
	    cout << "-method matrix comparison method\n";
	    cout << "-ops    print relevant system operations\n";
	    cout << "-o      output file\n";
	    cout << "-rpos   list of names of labels to be counted as\n";
	    cout << "        positive in reference file\n";
	    cout << "-tpos   list of names of labels to be counted as\n";
	    cout << "        positive in test file\n";
	    cout << "-v      verbose\n";
	    exit (0);
	}
}
