(***********************************************************************)
(*                                                                     *)
(*                           Calves                                    *)
(*                                                                     *)
(*          Francois Rouaix, projet Cristal, INRIA Rocquencourt        *)
(*                                                                     *)
(*  Copyright 1996 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

module Capabilities = Capabilities

open Capabilities
open Document
open Hyper
open Url
open Www

module Retrieval(C: sig val capabilities: Capabilities.t end) = struct

(* Since this is computed at initialisation time, it should be correct *)
let refdid = C.capabilities.browser_private
let ask = ask C.capabilities

(* Protect on the continuation, in case the initial request
   gets redirected by an accomplice server 
    e.g. http://accomplice.com/goto?someurl
     returns Location: someurl
  *)
let rec retrieve wr cont = 
  let retry hlink = retrieve (Www.make hlink) cont
  and real_cont = {
    document_process = (fun dh ->
      let url = Url.string_of dh.document_id.document_url in
       if ask (DocumentR url) then cont.document_process dh);
    document_finish = cont.document_finish
    }
  in
  match wr.www_url.protocol with
    MAILTO -> ()
  | _ ->
    if Nav.dont_check_cache wr then (Retrieve.f wr retry real_cont;())
    else 
      let did = {document_url = wr.www_url; document_stamp = no_stamp} in
      try
	let doc = Cache.find did in
	  real_cont.document_process (Cache.make_handle wr doc)
      with 
	Not_found -> (* we don't have the document *)
	  (Retrieve.f wr retry real_cont; ())

(* Images are public, although they also may contain private information *)
let get_image url cont =
  Img.get refdid
          {h_uri = Url.string_of url; h_context = None; h_method = GET}
          cont
end



module Mstring = Mstring
module Mlist = Mlist
module Feed = Feed 
module Error = Error
module Hyper = Hyper
module Www = Www
module Url = Url
module Lexurl = Lexurl
module Document = Document 
module Applets = Applets 
module Viewers = Viewers
