/*****************************************************************************
 *                                                                           *
 *  This file is part of the BeanShell Java Scripting distribution.          *
 *  Documentation and updates may be found at http://www.beanshell.org/      *
 *                                                                           *
 *  BeanShell is distributed under the terms of the LGPL:                    *
 *  GNU Library Public License http://www.gnu.org/copyleft/lgpl.html         *
 *                                                                           *
 *  Patrick Niemeyer (pat@pat.net)                                           *
 *  Author of Exploring Java, O'Reilly & Associates                          *
 *  http://www.pat.net/~pat/                                                 *
 *                                                                           *
 *****************************************************************************/


/* Generated By:JJTree: Do not edit this line. SimpleNode.java */

package bsh;
/*
	Note: great care (and lots of typing) must be taken to insure that the
	namespace and interpreter references are passed on the stack and not 
	(as they were erroneously before) installed in instance variables...
	Each of these node objects must be re-entrable to allow for recursive 
	situations.

	The only data which should really be stored in instance vars here should 
	be parse tree data... features of the node which should never change (e.g.
	the number of arguments, etc.)
	
	Exceptions would be public fields of simple classes that just publish
	data produced by the last eval()... data that is used immediately. We'll
	try to remember to mark these as transient to highlight them.

*/
class SimpleNode implements Node {
	protected Node parent;
	protected Node[] children;
	protected int id;
	Token firstToken, lastToken;

	public SimpleNode(int i)
	{
		id = i;
	}

	public void jjtOpen() { }
	public void jjtClose() { }

	public void jjtSetParent(Node n) { parent = n; }
	public Node jjtGetParent() { return parent; }

	public void jjtAddChild(Node n, int i)
	{
		if(children == null)
		{
			children = new Node[i + 1];
		}
		else
		{
			if(i >= children.length)
			{
				Node c[] = new Node[i + 1];
				System.arraycopy(children, 0, c, 0, children.length);
				children = c;
			}
		}

		children[i] = n;
	}

	public Node jjtGetChild(int i) { return children[i]; }

	public int jjtGetNumChildren()
	{
		return (children == null) ? 0 : children.length;
	}

/*
	You can override these two methods in subclasses of SimpleNode to
	customize the way the node appears when the tree is dumped.  If
	your output uses more than one line you should override
	toString(String), otherwise overriding toString() is probably all
	you need to do.
*/

	public String toString() { return InterpreterTreeConstants.jjtNodeName[id]; }
	public String toString(String prefix) { return prefix + toString(); }

/*
	Override this method if you want to customize how the node dumps
	out its children.
*/

	public void dump(String prefix)
	{
		System.out.println(toString(prefix));
		if(children != null)
		{
			for(int i = 0; i < children.length; ++i)
			{
				SimpleNode n = (SimpleNode)children[i];
				if (n != null)
				{
					n.dump(prefix + " ");
				}
			}
		}
	}

	//  ---- BeanShell specific stuff hereafter ----  //

	/*
		Chop this node from its parent.
		This is primarily useful in node serialization.
		(see BSHMethodDeclaration)
	*/
	public void prune() {
		jjtSetParent( null );
	}

	public Object eval(NameSpace namespace, Interpreter interpreter) throws EvalError
	{
		throw new EvalError("Unimplemented or inappropriate for " + getClass().getName());
	}

	/*
    private synchronized void writeObject(java.io.ObjectOutputStream s)
        throws java.io.IOException
    {
		s.defaultWriteObject();
		System.out.println("serializing: "+this);
	}
	*/
}

