// Copyright (c) 1997,1998,1999,2000 Albrecht Kleine    All rights reserved
// Copyright (c) 1998 Artur Biesiadowski
// file version #300

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>

#ifdef JDK12
#include <jit.h>
#endif

#include "tya.h"

// you may uncomment this for more "compatibility", but I prefer compiling....
#define IGNORE_DISABLE	// .. because it's just more stuff for testing the JIT

#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

#ifdef EXCEPTIONS_BY_SIGNALS
#ifdef JDK12
#include <signal.h>
#endif
#include <asm/sigcontext.h>

static unsigned short gsReg;
static unsigned short fsReg;
static unsigned short esReg;
static unsigned short dsReg;
#endif

#ifdef VERBOSE
static int totalCompByte = 0;
#endif

static int JitCompCode=1;
static int ExtendCodeSpace(struct CINFO *cinfo);
#ifndef JDK12
int jLOinitID;
#endif


// ------------ some helpers for compilation-----------------------

int getint16U(int *j, struct CINFO* cinfo)
{
#if 0
   int x;
   x =*(cinfo->bptr+(*j)++)<<8;
   x+=*(cinfo->bptr+(*j)++);
#else
   register int x asm ("%eax");
   x=*(unsigned short int*)(cinfo->bptr+*j);
   (*j)+=2;
   asm ("xchg %al,%ah");
#endif
   return x;  
}

int getint16S(int *j, struct CINFO* cinfo)
{
#if 0   
   int x;
   x =*(signed char*) (cinfo->bptr+(*j)++) << 8;
   x+=*(cinfo->bptr+(*j)++);
#else
   register int x asm ("%eax");
   x=*(unsigned short int*)(cinfo->bptr+*j);
   (*j)+=2;
   asm ("xchg %al,%ah");
   asm ("cwde");
#endif   
   return x;
}

int getint32(int *j, struct CINFO* cinfo)
{
#if 1 		// #if 1 --> IF YOU HAVE 386 CPU: no "bswap" available
   int x;
   x =*(cinfo->bptr+(*j)++)<<24;
   x+=*(cinfo->bptr+(*j)++)<<16;
   x+=*(cinfo->bptr+(*j)++)<<8;
   x+=*(cinfo->bptr+(*j)++);
#else
   int x=*(int*)(cinfo->bptr+*j);
   (*j)+=4;
   asm ("bswap %0": : "r" (x));		// little big endian stuff
#endif   
   return x;
}

//----------------- access to classes -------------------------------------

// look for a method in array during compilation
//
int GetMethNr(struct methodblock *mbp)
{
  int u;
  Classjava_lang_Class *klazz=unhand(mbp->fb.clazz);
  int anz=klazz->methods_count;
  for (u=0;u<anz;u++)
#ifndef JDK12
   if (klazz->methods[u].fb.ID == mbp->fb.ID)
       return u;
#else
     if (NAMETYPE_MATCH(&((struct methodblock *)(&klazz->methods[u]))->fb,&mbp->fb))
     {
	dprintf(stderr," GetMethNr found in tab %u: %s.%s\n",u,klazz->name,klazz->methods[u].fb.name);
	return u;
     }
#endif     
   fprintf(stderr,"TYA: assert GetMethNr not found in tab\n");
   return 0;	// should never happen
}

// look for a method in methodtable or field during compilation
//
//
int GetMethodNumber(struct methodblock* mb,Classjava_lang_Class *klazz)
{
   int i;
   struct methodblock **xmethods=klazz->methodtable->methods;
   for (i=klazz->methodtable_size-1;i;i--)
   {
      if (xmethods[i] == mb)
      {
	 dprintf(stderr,"\nfound in tab %d: %s.%s\n",i,klazz->name,xmethods[i]->fb.name);
	 return i;
      }
    }
   dprintf(stderr,"\ndid not find in tab\n");
   return 0;
}
	  
static int CheckException(struct execenv *ee,int code)
{
   if (exceptionOccurred(ee))
     {
      ClassClass *clazz=obj_classblock(ee->exception.exc);
      dprintf(stderr,"TYA: *** Resolver (op=%x) exc: %s\n",code,unha11(clazz)->name);
      if (ee->current_frame->current_method)
        dprintf(stderr,"     in compiling %s\n",ee->current_frame->current_method->fb.name);
      else
	dprintf(stderr,"     in compiling <unknown>\n");
      ee->exceptionKind=0;
      ee->exception.exc=NULL;
      return 1;
     }
   return 0;
}
#if RESOLVE_FT==1
static int IgnoreBadClass(Classjava_lang_Class *klazz,Classjava_lang_Class *clazz)
{
   int i;	
   dprintf(stderr,"TYA: ignoring bad class in R-FT level1\n");
#ifndef JDK12
   lock_classes();
#endif   
   for (i=0;i<clazz->methods_count;i++)
   {
     if (clazz->methods[i].CompiledCodeFlags & CCF_invokeJavaMethod)
	clazz->methods[i].invoker=invokeJavaMethod;
     else
       if (clazz->methods[i].CompiledCodeFlags & CCF_invokeSynchronizedJavaMethod) 
 	 clazz->methods[i].invoker= invokeSynchronizedJavaMethod ;
      
     clazz->methods[i].CompiledCodeFlags=0;
     clazz->methods[i].CompiledCode=NULL;
   }
#ifndef JDK12   
   unlock_classes();
#endif   
   return klazz==clazz;
}
#endif

#ifndef JDK12
#ifdef EXT_COMPAT
void InitClass(ClassClass *cla)
{
   int i;
   Classjava_lang_Class *klass=unha11(cla);
   if (unhand(cla)->flags & CCF_CLINITPENDS)
     for (i=0;i<klass->methods_count;i++)
     {
 	if (!strcmp(klass->methods[i].fb.name,"<clinit>"))
	  {
	     ////fprintf(stderr,"TYA's classinit invoker %s  %x\n",unhand(cla)->name,unhand(cla)->flags);
	     InvokeCompiledMethod_Hook(NULL,&klass->methods[i],0,EE());
	     return;
	  }
     }
}
#endif
#endif


void* GetBlock(int *nr,int is_new,unsigned char code,int *pj,Classjava_lang_Class *klass,
				 struct CINFO* cinfo,int quick)
{

   unsigned int wop;
   int ipool;
   int i;
   Classjava_lang_Class *kla;
   wop=getint16U(pj,cinfo);
   if (!quick)
     {
      dprintf(stderr,"RESL0: in opcode %x   %x %s\n",code,wop,klass->name);
      i=ResolveClassConstantFromClass(klass->HandleToSelf,wop,cinfo->ee,(unsigned)-1);
      if (!i)
     {
      struct fieldblock* fb;
    #if RESOLVE_FT>=1
     {
	fb = klass->constantpool[wop].fb;
        CheckException(cinfo->ee,code);
	dprintf(stderr,"RESolve1: in opcode %x   %x %s.%s\n",code,wop,klass->name,cinfo->mb->fb.name);
	if (CONSTANT_POOL_TYPE_TABLE_IS_RESOLVED(klass->constantpool[CONSTANT_POOL_TYPE_TABLE_INDEX].type,wop))
	  {	  
	  if (is_new==1)
	       dprintf(stderr,"     wop=%04x class = %p %s\n",wop,unha11((ClassClass*)fb), unha11((ClassClass*)fb)->name);
	     else
	       dprintf(stderr,"     %s.%s  (%s)\n",unha11(fb->clazz)->name,  fb->name,fb->signature);
	  }
	
	else
	{
	  dprintf(stderr,"     unknown fb or class %p\n",fb);
	  return NULL;
	}
     }
   #endif
   #if RESOLVE_FT==1
     if (IgnoreBadClass(klass,unha11(fb->clazz)))
       return NULL;
    #endif
    #if RESOLVE_FT==0
      return NULL;
    #endif
    }
    ipool=klass->constantpool[wop].i;
    if (is_new==1)
	kla=unha11((ClassClass*)ipool);
    else
	kla=unha11(((struct fieldblock*)ipool)->clazz);
	
    if  (!(   (kla->flags & DEF_CCF_IsInitialized ) != 0)) // suboptimal
    {
#ifdef EXT_COMPAT
       int what=0;
       if (is_new)
	  what++;
       for (i=0;i<kla->methods_count;i++)
	 if (kla->methods[i].fb.access & ACC_NATIVE)
	 {
	    what++;
	    break;
	 }
       if (what)
	 InitClass(kla->HandleToSelf);
       else
	 if (!kla->reserved_for_jit)
	   CompileClass_Hook(kla->HandleToSelf);	// care about CCF flags set
#else
       if (is_new!=1)
	 InitClass(kla->HandleToSelf);
#endif	   
    }
   }
   else
     ipool=klass->constantpool[wop].i;
   
  if (is_new==1)
     return (void*)ipool;
   
  if (quick || 
       (CONSTANT_POOL_TYPE_TABLE_IS_RESOLVED(klass->constantpool[CONSTANT_POOL_TYPE_TABLE_INDEX].type,wop)))
   {
     if (nr)
	{	
	   *nr=GetMethodNumber((struct methodblock*)ipool, unha11(((struct methodblock*)ipool)->fb.clazz));
	   #ifdef NOGUA_WORKAROUND
	   if (!*nr)
	     return NULL;
	   #endif
	}
     dprintf(stderr," GetBlock quick ipool=%08x %s\n",ipool,((struct fieldblock*)ipool)->name);
     dprintf(stderr,"          array=%d GetBlock quick ipool=%s %x \n",fieldIsArray(((struct fieldblock*)ipool)),
	     	((struct fieldblock*)ipool)->signature,((struct fieldblock*)ipool)->access);
     dprintf(stderr,"\n");
     return (void*)ipool; // could be  struct fieldblock*  or  struct methodblock*
   }
   fprintf(stderr,"TYA: assert in GetBlock!!!!!!\n");
   abort();      
   return NULL;
}

// -----------------------------------------------------------------------

#ifndef COMBINEOP

// look for some typical code snippets:
// replace .... with x NOPs etc,
//
# define GW(a) (*((unsigned short *) (a)))
static void TinyPeepHoleOpt(struct CINFO* cinfo)
{
 int i;
 unsigned short int *ptr; 
 for (i=0;i<cinfo->ipcnt;i++)
 {
    if (cinfo->iptab[i].isdest)
     continue;
   // 
   // Eliminate Stack operation for doubles
   //
   if  ((GW(cinfo->iptab[i].x86-4) == FSTPQW_MSP) && 
   	(GW(cinfo->iptab[i].x86-1) == POPPUSHAX) && 
	(GW(cinfo->iptab[i].x86+1) == FLDQW_MSP) )
	{
      	 dprintf(stderr,"++ %x   %d ++++ %x %x\n" , GW((cinfo->iptab[i].x86))
	 	 ,cinfo->iptab[i].x86 - cinfo->codebase,
		 *cinfo->iptab[i-1].java,*cinfo->iptab[i].java);
	 ptr = (unsigned short *) (cinfo->iptab[i].x86-4);
	 *ptr++ = NOP2;
	 *ptr++ = NOP2;
	 *ptr++ = NOP2;
	 *ptr   = NOP2;// 8 Byte at all
	 //dprintf(stderr,"Tiny\n");
	}
 }
}
#else

static int CheckOpt(struct CINFO* cinfo)
{
 int i;
 for (i=0;i<cinfo->ipcnt;i++)
   if (cinfo->iptab[i].isdest & DF_ISDEST)
     if (cinfo->iptab[i].isdest & (~DF_ISDEST))
       {
	 dprintf(stderr,"TYA: checkopt alert %x %x\n",cinfo->iptab[i].isdest,cinfo->iptab[i-1].isdest);
	 return -1;
       }
 return 0;
}
#endif


#ifndef JDK12
static int getObjConstructorHash(void)
{
 int i;
  for (i=0;i<unha11(classJavaLangObject)->methods_count;i++)
     if (!strcmp("<init>",unha11(classJavaLangObject)->methods[i].fb.name))
       return unha11(classJavaLangObject)->methods[i].fb.ID;
  return 0;
}
#endif

// ----------------------------------INTERFACE & HOOKS ----------------------------------
//
// this function does the init
//
#ifndef JDK12
// this is the oldstyle part / newer version follows below
void java_lang_Compiler_start(void **XX)
{
   void* (*CCLinkVector)=*XX;

   static int initialized = 0;
   if (initialized) return;
   initialized = 1;

   lopen();				// logfile
   lprintf(" TYA %s (J11) Copyright (c) 1997-2000 Albrecht Kleine\n",TYAVER);
   dprintf(stderr,"------------ start java_lang_Compiler_start ---------\n");

#ifdef EXCEPTIONS_BY_SIGNALS
  __asm__("movw %%gs,%0" : "=m" (gsReg));
  __asm__("movw %%fs,%0" : "=m" (fsReg));
  __asm__("movw %%es,%0" : "=m" (esReg));
  __asm__("movw %%ds,%0" : "=m" (dsReg));
#endif
   CCLinkVector[CCLbase+2] =InitializeForCompiler_Hook;
   CCLinkVector[CCLbase+3] =CompilerFreeClass_hook;
   CCLinkVector[CCLbase+4] =InvokeCompiledMethod_Hook;
#ifdef EXCEPTIONS_BY_SIGNALS
   CCLinkVector[CCLbase+5] =CompiledCodeSignalHandler_hook;
#endif   
   CCLinkVector[CCLbase+6] =CompileClass_Hook;
   CCLinkVector[CCLbase+7] =CompileClasses_Hook;
   CCLinkVector[CCLbase+8] =CompilerCommand_hook;
   CCLinkVector[CCLbase+9] =Enable_hook;
   CCLinkVector[CCLbase+10]=Disable_hook;
   CCLinkVector[CCLbase+11]=PCinCompiledCode_Hook;
   CCLinkVector[CCLbase+12]=CompiledCodePC_Hook;
#ifndef NOCOMPPREL
   {
    int i;
    lock_classes();
    for (i= 0  ;i<nbinclasses;i++) 
     { 
	dprintf(stderr,"preloaded class:  %s\n",unha11(binclasses[i])->name);
	CompileClass_Hook(binclasses[i]);
     }
    unlock_classes();
   }
#endif
   jLOinitID=getObjConstructorHash();
   PrepareExceptions();
   return;
}
#else
//
// completely rewritten for JITInterface6 structure: new in <jit.h>
//
void java_lang_Compiler_start(JITInterface6 *XX)
{
   static int initialized = 0;
   if (initialized) return;
   initialized = 1;

   lopen();				// logfile
   lprintf(" TYA %s (J%s) Copyright (c) 1997-2000 Albrecht Kleine\n",TYAVER,JVER);
   if (XX->base.JavaVersion)
     dprintf(stderr,"JavaVersion %x\n",*XX->base.JavaVersion);
   dprintf(stderr,"------------ start java_lang_Compiler_start ---------\n");
#ifdef EXCEPTIONS_BY_SIGNALS
  __asm__("movw %%gs,%0" : "=m" (gsReg));
  __asm__("movw %%fs,%0" : "=m" (fsReg));
  __asm__("movw %%es,%0" : "=m" (esReg));
  __asm__("movw %%ds,%0" : "=m" (dsReg));
#endif   

    *XX->p_InitializeForCompiler=InitializeForCompiler_Hook;
    *XX->p_invokeCompiledMethod =InvokeCompiledMethod_Hook;
   #ifdef EXCEPTIONS_BY_SIGNALS
    *XX->p_CompiledCodeSignalHandler=CompiledCodeSignalHandler_hook;
   #endif  
    *XX->p_CompilerFreeClass =CompilerFreeClass_hook;
    *XX->p_CompilerRegisterNatives=CompilerRegisterNatives_hook;
    *XX->p_CompilerUnregisterNatives=CompilerUnregisterNatives_hook;
    *XX->p_CompilerCompileClass=CompileClass_Hook;
    *XX->p_CompilerCompileClasses=CompileClasses_Hook;
    *XX->p_CompilerEnable=Enable_hook;
    *XX->p_CompilerDisable=Disable_hook;
    *XX->p_CompiledFramePrev=CompiledFramePrev_hook;
    *XX->p_CompiledFrameID=CompiledFrameID_hook;
    *XX->p_PCinCompiledCode=PCinCompiledCode_Hook;
    *XX->p_CompiledCodePC=CompiledCodePC_Hook;

#ifndef NOCOMPPREL
   {
    int i;
#ifndef JDK12      
    lock_classes();
#endif      
    for (i= 0  ;i<nbinclasses;i++)
     { 
	dprintf(stderr,"preloaded class:  %s\n",unha11(binclasses[i])->name);
	CompileClass_Hook(binclasses[i]);
     }
#ifndef JDK12      
    unlock_classes();
#endif      
   }
#endif
#ifndef JDK12   
   jLOinitID=getObjConstructorHash();
#endif
   PrepareExceptions();
#ifdef DEBUG
   verbosegc=1;
   verboseclassdep=1;
#endif
   dprintf(stderr,"TYA: VM memo =%Lx %Lx\n",TotalObjectMemory(),TotalHandleMemory());
   // MakeClassSticky(FindClass(NULL,"java/lang/Compiler",FALSE));
   dprintf(stderr,"%p %s\n",invokeJavaMethod,"invokeJavaMethod");
   dprintf(stderr,"%p %s\n",invokeSynchronizedJavaMethod,"invokeSynchronizedJavaMethod");
   dprintf(stderr,"%p %s\n",invokeAbstractMethod,"invokeAbstractMethod");
   dprintf(stderr,"%p %s\n",invokeNativeMethod,"invokeNativeMethod");
   dprintf(stderr,"%p %s\n",invokeLazyNativeMethod,"invokeLazyNativeMethod");
   dprintf(stderr,"%p %s\n",invokeSynchronizedNativeMethod,"invokeSynchronizedNativeMethod");
   dprintf(stderr,"%p %s\n",invokeCompiledMethod,"invokeCompiledMethod");
   dprintf(stderr,"%p %s\n",invokeJNINativeMethod,"invokeJNINativeMethod");
   return;     
}

#endif			 
			
#ifdef DEBUG
void ShowPreInvokeInfo(struct methodblock *mb,int args_size,struct execenv *ee,int noncom)
{
  int i;
  dprintf(stderr,"***** INVOKN %sCOMPILED",noncom?"NON":"");
  dprintf(stderr," %s.%s\t %s  (%d args)\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature,args_size);
  if (ee->current_frame->prev && ee->current_frame->prev->current_method)
    dprintf(stderr,"        CALLED BY %s.%s\n",
	    unha11(ee->current_frame->prev->current_method->fb.clazz)->name,
	    ee->current_frame->prev->current_method->fb.name);
  else   
    dprintf(stderr,"        CALLED BY (unknown)\n");
  dprintf(stderr,"        %p %p\n",ee->current_frame->javastack->data,ee->current_frame);
  dprintf(stderr,"        maxstack=%d  nlocals=%d  asize=%d\n", mb->maxstack,mb->nlocals,mb->args_size);
  dprintf(stderr,"Stack:\n");

   for (i=0;i<args_size;i++)
     {
     dprintf(stderr,"  %d. %p=\t%d\t=%x\t=%f\n",i,&ee->current_frame->optop[i],
	     ee->current_frame->optop[i].i,
	     ee->current_frame->optop[i].i,*(float*)&ee->current_frame->optop[i]);
     }
}

void ShowPostInvokeInfo(struct methodblock *mb,struct execenv *ee,int noncom)
{
   dprintf(stderr,"***** RETURN from %sCOMPILED %s.%s\n",noncom?"NON":"",
	   unha11(mb->fb.clazz)->name,mb->fb.name);
   if (exceptionOccurred(ee))
     {
       dprintf(stderr,"*** exceptionOccurred ******\n");
       // DumpThreads();
     }
   
}
#endif

//---------------------------------------------------------------------------------

//  called by InvokeCompiledMethod_Hook()
//
			
static void ReverseCopyViaReversedScript(stack_item *loc,char *currch,int anz,stack_item *args,int maxvaroffs)
{
   int i;
   maxvaroffs--;
   for (i=0;i<anz;i++)
	if (*currch-- != 0x64)
          loc[maxvaroffs-i]=args[i];
        else
	  {
	     loc[maxvaroffs-i]=args[i+1];
	     loc[maxvaroffs-i-1]=args[i];
	     i++;
	  }
}

// hook #4
//
bool_t InvokeCompiledMethod_Hook(JHandle *thiso, struct methodblock *mb, int args_size, struct execenv *ee)
{
#define EXTRALOCAL 3   
#define EXTRAARGS  1
   int allspace=mb->nlocals+args_size;
#ifndef JDK12   
   struct methodblock *mbcaller;
   stack_item *oldvar;
#else   
   JavaFrame *JF;
   JavaStack *JS;
#endif
   stack_item *args=ee->current_frame->optop;
   stack_item *local=alloca(( EXTRALOCAL+EXTRAARGS+ allspace )*SIS4);
#ifndef JDK12
#ifdef EXT_COMPAT
   if (!strcmp( mb->fb.name, "<clinit>"))   
   {
      if ( unhand(mb->fb.clazz)->flags & CCF_CLINITPENDS)	// is pending anyway?
      {
	 ///fprintf(stderr,"TYA running p clinit %s.%s\n",unha11(mb->fb.clazz)->name,mb->fb.name);
	 unhand(mb->fb.clazz)->flags &= ~CCF_CLINITPENDS;	// reset pendflag
	 unhand(mb->fb.clazz)->flags |= CCF_CLINITRUN;		// set initedflag
      }
      else
      {
	 ///fprintf(stderr,"TYA let clinit pend %s.%s\n",unha11(mb->fb.clazz)->name,mb->fb.name);
	 unhand(mb->fb.clazz)->flags |= CCF_CLINITPENDS;	// set pendflag and exit
	 return 1;
      }
   }
#endif
#endif   
   //
   // "local" is later used by machine code...
   // ...for storing the local variables (addressed via ebp+LOCSTART+xx )
   // FYI: this was changed in TYA 0.4, 0.7, 1.2
   //
   //         DATA            EBP+OFFS   LOCSTART-OFFSET, DESCRIPTION 
   //         ============    ========   ============================
   //         Local_Data_0    x  <------ maybe "this" (as first local data)
   //         Local_Data_1    x+1
   //		.........
   //         Local_Data_x    36 <------ LOCSTART (the last java local data)
   //	      cw87, calld st size 32     =LOCSTART-4  (used for invocation, dtoi,ftoi)
   //         DI storage      28         =LOCSTART-8  (used for inlining)
   //         SI storage      24         =LOCSTART-12 (used for inlining)
   //	      ExecEnv         20 <------ =LOCSTART-16 (used everywhere)
   //         return Adress   16
   //	      caller EBX      12
   //         caller ESI      8
   //         caller EDI      4
   // EBP=ESP-> EBP on Stack  0
   //         (...used for private buffer and calls...)
   //
#ifdef DEBUG
   ShowPreInvokeInfo(mb,args_size,ee,0);
#endif
   switch ((int)mb->CompiledCodeInfo)
     {
      case 257:break;
      case 1:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[0];
	break;
      case 2:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[0];
	     local[ EXTRALOCAL+EXTRAARGS +allspace -1 -1]=args[1];
	break;
      case 3:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[0];
	     local[ EXTRALOCAL+EXTRAARGS +allspace -1 -1]=args[1];
	     local[ EXTRALOCAL+EXTRAARGS +allspace -1 -2]=args[2];
	break;
      case 256:local[ EXTRALOCAL+EXTRAARGS +allspace -1]=args[1];
	       local[ EXTRALOCAL+EXTRAARGS +allspace -2]=args[0];
	break;
      default:// reverse instruction string here we go from end back to start
              ReverseCopyViaReversedScript(&local[EXTRALOCAL+EXTRAARGS],
			&((char*)mb->CompiledCodeInfo)[(mb->CompiledCodeFlags>>8)], /* last char RI-string*/
	      		args_size,args,allspace);
	break;
     }
   local[0].h=(JHandle*)ee;  		// 1 additional parameter

   
#ifndef JDK12
   mbcaller= ee->current_frame->current_method;
   ee->current_frame->current_method=mb;
   oldvar=ee->current_frame->vars;	// stor old value
   ee->current_frame->vars=&local[EXTRALOCAL+EXTRAARGS];
#else
   // 	ExpandJavaStack() could to the trick ??
   JF=ee->current_frame;
   JS=JF->javastack;
   JF=(JavaFrame*)(JF->optop /*+mb->nlocals*/);
  if (JF->ostack+mb->maxstack+16 > JS->end_data)
     {
	if (!JS->next)
	  {
	     JS=CreateNewJavaStack(ee,JS, min_javastack_chunk_size);
	     dprintf(stderr,"TYA:CreateNewJavaStack\n");
	  }
	else
	  {
	     JS=JS->next;
	  }
	JF=(JavaFrame*)(JS->data  /*+mb->nlocals*/);
   }
   JF->javastack=JS;
   JF->prev=ee->current_frame;
   JF->current_method=mb;
   JF->vars= &local[EXTRALOCAL+EXTRAARGS];
   JF->optop=JF->ostack;

   JF->constant_pool=NULL;	// important for a clean stackframe dump
//   JF->returnpc=NULL;
//   JF->lastpc=NULL;
//   JF->monitor=NULL;
   
   ee->current_frame=JF;
#endif
   // invoke.....
   if (mb->CompiledCodeFlags & CCF_VOID)	// void result
   {
      ((void(*)(void))mb->CompiledCode)();
    }
   else
     if (mb->CompiledCodeFlags & CCF_R64)	// pseudo result type 64bit
     {
#ifndef JDK12     
	*(long long *)(&ee->current_frame->optop[0])=((long long(*)(void)) mb->CompiledCode)();     
	ee->current_frame->optop+=2;
#else	
	*(long long *)(&ee->current_frame->prev->optop[0])=((long long(*)(void)) mb->CompiledCode)();
	ee->current_frame->prev->optop+=2;
#endif	
     }
     else 					// int, float etc results 
     {
#ifndef JDK12     
	ee->current_frame->optop[0].i=((int(*)(void)) mb->CompiledCode)();
	ee->current_frame->optop++;
#else
	ee->current_frame->prev->optop[0].i=((int(*)(void)) mb->CompiledCode)();
	ee->current_frame->prev->optop++;
#endif	
     }
#ifndef JDK12
   ee->current_frame->vars=oldvar;	// reset to old variable
   ee->current_frame->current_method=mbcaller;
#else
   ee->current_frame=ee->current_frame->prev;
#endif

#ifdef DEBUG
   ShowPostInvokeInfo(mb,ee,0);
#endif
#if RESOLVE_FT==4			// unused by default
   if (!exceptionOccurred(ee))
     return TRUE;
   if (mb->fb.name[0]=='<' && mb->fb.name[1]=='c') // <clinit>
   {
	fprintf(stderr,"TYA: ign %s @RFT4 in %s.%s\n",
	 	unha11(obj_classblock(ee->exception.exc))->name,
	 	unha11(mb->fb.clazz)->name,mb->fb.name);
	exceptionClear(ee);
	return TRUE;
   }
   return FALSE;
#else   
     return !exceptionOccurred(ee);
#endif   
}


//hook #3
//
#ifndef JDK12     
void* CompilerFreeClass_hook(ClassClass *clazz)
#else
void CompilerFreeClass_hook(ClassClass *clazz)      
#endif
{
  int i;
  dprintf(stderr,"------- CompilerFreeClass_hook called for %s ---------\n",unha11(clazz)->name);
  for (i=0;i<unha11(clazz)->methods_count;i++)
     {
	if (unha11(clazz)->methods[i].CompiledCode)
	  sysFree((unha11(clazz)->methods[i].CompiledCode)-ENTRYPOINT);
	unha11(clazz)->methods[i].CompiledCode=NULL;

	if (unha11(clazz)->methods[i].CompiledCodeFlags & CCF_invokeJavaMethod)
	  unha11(clazz)->methods[i].invoker=invokeJavaMethod;
        else
          if (unha11(clazz)->methods[i].CompiledCodeFlags & CCF_invokeSynchronizedJavaMethod) 
 	    unha11(clazz)->methods[i].invoker= invokeSynchronizedJavaMethod ;
	
	unha11(clazz)->methods[i].CompiledCodeFlags=0;
	if ((int)unha11(clazz)->methods[i].CompiledCodeInfo > 0x10000)
	  sysFree((char*)unha11(clazz)->methods[i].CompiledCodeInfo);
	unha11(clazz)->methods[i].CompiledCodeInfo=0;
     }
#ifndef JDK12   
  return NULL;
#endif
}

// hook #5
//
#ifdef EXCEPTIONS_BY_SIGNALS
void dumpSigcontext( TYA_SIGCONTEXT * ptr )
{
	dprintf(stderr, "sigcontext:\n");
	dprintf(stderr, "edi=%8.8lX esi=%8.8lX ebp=%8.8lX esp=%8.8lX\n",
		ptr->edi, ptr->esi, ptr->ebp, ptr->esp);	
	dprintf(stderr, "ebx=%8.8lX edx=%8.8lX ecx=%8.8lX eax=%8.8lX\n", 
		ptr->ebx, ptr->edx,ptr->ecx, ptr->eax);
	dprintf(stderr, "err=%lu\n", ptr->err);	
	dprintf(stderr, "eip=%lX\n", ptr->eip);
	dprintf(stderr, "esp_at_signal %8.8lX\n", ptr->esp_at_signal);
	return;
}

unsigned long  oldeip asm("anOldip");
unsigned long  oldesp asm("anOldsp");
unsigned long  oldebp asm("anOldbp");
unsigned long  jumpTo asm("aJumpTo");
#endif EXCEPTIONS_BY_SIGNALS

#define NEWGETCONTEXT
#define OFF116v5 4	// 0 for 114v4a
// at all it is impossible to estimate the correct jdk 
// sub version,  so this is undefined since build #201
#undef NEWGETCONTEXT	

#ifndef JDK12
#define HOOKRETVAL
void CompiledCodeSignalHandler_hook(int sig,void *info,void *uc)
#else      
#define HOOKRETVAL FALSE	/* FIXME: return TRUE ? */
bool_t CompiledCodeSignalHandler_hook(int sig,void *info,void *uc)
#endif
{
#ifdef EXCEPTIONS_BY_SIGNALS
   void * startOfCode;
#ifdef EASYEX
   TYA_SIGCONTEXT * context = (TYA_SIGCONTEXT *)
                                        (((char *)uc)- sizeof(TYA_SIGCONTEXT));
   struct execenv * ee = *(struct execenv**)((char*)info+20);
#else   
   struct execenv * ee = EE();
   TYA_SIGCONTEXT * context=NULL;
#ifndef NEWGETCONTEXT
   // at all FIXME: unknown uc pointer
   #define MAXSEARCH 100
   int *ptr=(int*)&uc;	// starting point for search sigcontext on stack
   int i;
#endif
   if ( sig != SIGFPE && sig != SIGSEGV)
   {
      lprintf("TYA: Signal %d, returning to default handler;\n",sig);
      return HOOKRETVAL;
   }   
   asm ("pushl %esp");
   asm ("popl anOldsp");
#ifndef NEWGETCONTEXT
   // grep for a sigcontext_struct
   for (i=0;i<MAXSEARCH;i++) 
   {
     if (*((unsigned short *)(ptr+i))==gsReg &&
	 *((unsigned short *)(ptr+i+1))==fsReg && 
	 *((unsigned short *)(ptr+i+2))==esReg &&
	 *((unsigned short *)(ptr+i+3))==dsReg)
       break;
   }
   if (i>=MAXSEARCH)
   {
      char *msg="TYA:EXCEPTIONS_BY_SIGNALS problem\n";
      lprintf(msg);
	     //panic(msg);
      return HOOKRETVAL;
   }
   context=(void*)&ptr[i];
//   lprintf("TYA:CompiledCodeSignalHandler_hook--context at offset =%d  %p %p\n",100-i,context,info);
//   lprintf("TYA:context at offset = entry_esp + 0x%xh\n",(void*)context-(void*)oldesp);      
    
//   {  int z; for (z=0;z<50;z++)
  //    lprintf("context %p %d.  %x\n",&((int*)oldesp)[z],z,((int*)oldesp)[z]);}   
#else
   context=(TYA_SIGCONTEXT *)(oldesp+64 + OFF116v5);
   lprintf("TYA:CompiledCodeSignalHandler_hook--context at %p \n",context);
   if (!(context->gs==gsReg && context->fs==fsReg && 
         context->es==esReg && context->ds==dsReg))
   {
	     char *msg="TYA:EXCEPTIONS_BY_SIGNALS problem\n";
	     lprintf(msg);
             //panic(msg);
	     return HOOKRETVAL;
   }
#endif
   
#endif   
   if (!ee->current_frame)
     {  
       lprintf("TYA: Signal %d, returning to default handler: no frame found\n",sig);
	
       return HOOKRETVAL;
     }
   if (!ee->current_frame->current_method)
     {  
       lprintf("TYA: Signal %d, returning to default handler: no current method found\n",sig);
       return HOOKRETVAL;
     }
   if (!ee->current_frame->current_method->CompiledCode)
     {  
       lprintf("TYA: Signal %d, returning to default handler: no compiled code found\n",sig);
       return HOOKRETVAL;
     }
   if (0x55575653!=*(int*)ee->current_frame->current_method->CompiledCode)
     {  
       lprintf("TYA: Signal %d, returning to default handler: no code signature found\n",sig);
       return HOOKRETVAL;
     }

   // compute start of offending method
   startOfCode = ee->current_frame->current_method->CompiledCode - ENTRYPOINT;
   // get NullPointerHandler/DivZeroHandler adress
   if ( sig == SIGSEGV )
        jumpTo = ((unsigned long) startOfCode) +
                LINKAGEERRHSIZE+DIVZEROHANDSIZE+ARROUTOFFSIZE+NEGARRSIZESIZE;
   else    // is ( sig == SIGFPE )
        jumpTo = ((unsigned long) startOfCode) + LINKAGEERRHSIZE;

//   lprintf("TYA:Signal %d in %s\n",sig,ee->current_frame->current_method->fb.name);
//   lprintf("TYA:Signal %d in %s.%s\n",sig,
//	   unha11(ee->current_frame->current_method->fb.clazz)->name,
//	   ee->current_frame->current_method->fb.name);
//      DumpThreads();

#ifdef DEBUG
   dumpSigcontext(context);
   dprintf(stderr, "info = %8.8lX\n", (unsigned long) info);
   dprintf(stderr, "execenv = %p\n",ee);
   dprintf(stderr, "current_frame = %p\n",ee->current_frame);
   dprintf(stderr, "current_method =%p\n",ee->current_frame->current_method);
   dprintf(stderr, "CompiledCode = %p\n",startOfCode);
#endif
 // all this global variables could be locals, but how can I reference locals
 // in AT&T asm ?

   // registers at the moment of exception
   oldeip=context->eip;
   oldebp=context->ebp;
   oldesp=context->esp;
   
   // restore old ebp and esp, push old eip on stack for exception handler
   // and jump there
   asm volatile( "
   movl $anOldbp, %eax
   movl (%eax), %ebp
   movl $anOldsp, %eax
   movl (%eax), %esp
   movl $anOldip, %eax
   movl (%eax),%eax
   pushl %eax
   movl $aJumpTo, %eax
   movl (%eax), %eax
   jmp *%eax" );
#endif // EXCEPTIONS_BY_SIGNALS
   return HOOKRETVAL;		     
}


// hook #8
//
// could be used for some difficult debug problems...
//
JHandle *CompilerCommand_hook(JHandle *x)
{
 dprintf(stderr,"----------CompileCommand_hook-------->handle= %p\n",x);
 return x;
}


// hook #9
//
void Enable_hook(void)
{
   if (!JitCompCode)
      lprintf("TYA: *** JIT compiling switched  ON  by Enable_hook request***\n");
   JitCompCode=1;
   dprintf(stderr,"----------Enable_hook-----EE=%p----\n",EE());
}


// hook #10
//
void Disable_hook(void)
{
   #ifdef IGNORE_DISABLE
    // lprintf("TYA: Disable_hook call ignored\n");
   #else
     {     
      lprintf("TYA: *** JIT compiling switched  OFF   by Disable_hook request***\n");
      JitCompCode=0;
     }
   #endif
   dprintf(stderr,"----------Disable_hook--------\n");
}


// hook #11
#ifndef JDK12
int PCinCompiledCode_Hook(unsigned char *pc,struct methodblock *mb)
#else
bool_t PCinCompiledCode_Hook(unsigned char *pc,struct methodblock *mb)
#endif
{
   dprintf(stderr,"-------- PCinCompiledCode_Hook -------- %s.%s  %p %p\n",
	   unha11(mb->fb.clazz)->name,mb->fb.name,pc,mb->code);
   return pc==mb->CompiledCode;
   //FIXME??????
}

// hook #12
unsigned char *CompiledCodePC_Hook(JavaFrame *frame,struct methodblock *mb)
{
   dprintf(stderr,"-------- CompiledCodePC_Hook ---------- %s.%s\n",
	   unha11(mb->fb.clazz)->name,mb->fb.name);
   return (is_subclass_of(mb->fb.clazz, classJavaLangThrowable, 
		  frame->javastack->execenv)) ? NULL : mb->CompiledCode;
}

// hook #7
#ifndef JDK12
long CompileClasses_Hook(Hjava_lang_String *hclname)
#else
bool_t CompileClasses_Hook(Hjava_lang_String *hclname)
#endif
{
   ClassClass *class;
   char clbuf[254];			// FIXME: max len?
   char *clp=clbuf;
   int i;
   javaString2CString(hclname,clbuf,sizeof clbuf);
   dprintf(stderr,"----------CompileClasses_Hook--------- %s\n",clbuf);
   while(*clp)
     {
	if (*clp=='.') *clp='/';
	clp++;
     }
   class=FindClass(NULL,clbuf,FALSE);
   dprintf(stderr,"          class = %p\n",class);
   if (!class)
     i=0;
   else
     i=CompileClass_Hook(class);
   if (i)
     {    
      struct CINFO cinfo;
      int i;
      for (i=0;i<unha11(class)->methods_count;i++)
      {
	if (unha11(class)->methods[i].invoker==MYInvokeCompiledMethod)
	  {
	     dprintf(stderr,"Compilation requested by java code\n");
             CompiliereMethode(&unha11(class)->methods[i], &cinfo,EE());
	  }
      }
     }
   dprintf(stderr,"----------Ende CompileClasses_Hook-----Erg=%d\n",i);
   return i;  
}

 
int  ProcessExceptionTab(struct methodblock* mbp,struct CINFO* cinfo)
{
   register int n,o;
   #ifdef DEBUG
   char* excclassname;
   #endif
   ClassClass *class=mbp->fb.clazz;
#ifdef JDK12
   dprintf(stderr,"Exception handler of method %s  = %d\n",
#else   
   dprintf(stderr,"Exception handler of method %s  = %ld\n",
#endif   
   	   mbp->fb.name,mbp->exception_table_length);
   for (n=0;n<mbp->exception_table_length;n++)
     {
	if ((o=mbp->exception_table[n].catchType))
	  {
	     if (!DEF_ResolveClassConstantFromClass(class,o,cinfo->ee,(unsigned)-1))
		return 0;
	     cinfo->exclazz[n]=( ClassClass *) unha11(class)->constantpool[o].p;
	     #ifdef DEBUG
	     excclassname= unha11(cinfo->exclazz[n])->name;
	     #endif
	  }
	else
	  {
	     cinfo->exclazz[n]=NULL;
	     #ifdef DEBUG
	     excclassname="";
	     #endif
	  }
	#ifdef DEBUG
#ifndef JDK12
	dprintf(stderr,"Exc tab from %ld to %ld, handler %ld  %p %s\n",
#else
	dprintf(stderr,"Exc tab from %d to %d, handler %d  %p %s\n",
#endif		
		mbp->exception_table[n].start_pc,
		mbp->exception_table[n].end_pc,
	        mbp->exception_table[n].handler_pc,
		cinfo->exclazz[n], excclassname);
	#endif
     }
   dflush(stderr);
   return 1;
}

void BackPatchJumpDists(struct CINFO* cinfo)
{
   int k,l,diff;
   for (k=0;k<cinfo->backcnt;k++)
   {   
      diff =cinfo->backp[k].javadist>0 ? 1:-1;		// jump forward or backward
      for (l=cinfo->backp[k].currcnt;;l+=diff)
	{  
	     if ((cinfo->backp[k].java+cinfo->backp[k].javadist) ==cinfo->iptab[l].java)
	     {
		int dist = cinfo->iptab[l].x86-cinfo->backp[k].x86-4;
		// dist -4 is because the x86 jump itself is counted out
		// .. ..  jj  | xx xx xx xx  | op op op op .. ..
		// jmpopcode  | patchaddress | destinationX
		//
		// for example: distance between destinationX and patchadress is 4!
		//              but we patch 0, for "jmp 0" as jump to next instruction
		*(int*)cinfo->backp[k].x86= dist; 
		cinfo->backp[k].destcnt=l;
		cinfo->iptab[l].isdest|=DF_ISDEST;
		break;
             }
	}
   }
}




int ExtendCodeSpace(struct CINFO *cinfo)
{
   int relocate,n;
   unsigned char *temp=cinfo->codebase;
   cinfo->codebase=sysRealloc(cinfo->codebase,MAXCOMPILEDSIZE);
   cinfo->maxspace=MAXCOMPILEDSIZE;	// set new space limit
   // adjust all helper data for code we have already compiled:
   if ((relocate=cinfo->codebase-temp))
     {
	for (n=0;n<cinfo->mb->exception_table_length;n++)
	  {
	     if (cinfo->start[n])
	       {
		  cinfo->adrstart[n]+=relocate;
		  cinfo->start[n]+=relocate;
	       }
	     if (cinfo->end[n])
	       {
		  cinfo->adrend[n]+=relocate;
		  cinfo->end[n]+=relocate;
	       }
	     if (cinfo->handler[n])
	       {
		  cinfo->adrhandler[n]+=relocate;
		  cinfo->handler[n]+=relocate;
	       }
	   }
	for (n=0;n<cinfo->ipcnt;n++)
	  cinfo->iptab[n].x86+=relocate;
	for (n=0;n<cinfo->backcnt;n++)
	  cinfo->backp[n].x86+=relocate;
	cinfo->cptr+=relocate;
     }
  dprintf(stderr,"code space extended (moved +%x byte)\n",relocate);
  return relocate;
}
					  

		 
int  CompiliereMethode(struct methodblock* mb, struct CINFO *cinfo,ExecEnv *ee)
{
   Classjava_lang_Class *klass=unha11(mb->fb.clazz);
   register int j,n;
   int erg=0,zz;
   unsigned char *compex;
   int relocate=0;
   size_t  l_BlockSize;
   size_t l_ExceptionTableLength = sizeof(void *)   * mb->exception_table_length;
   size_t l_IpTransLength   = sizeof(struct iptrans)* mb->code_length;
   size_t l_BackLength    = sizeof(struct back) * mb->code_length;
   void  * l_Block;
 
#ifdef VERBOSE_ASM86
   lprintf("%%%% START JITCOMP: %s.%s ( %s )%%%%\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature);
#endif
   
   //printHexDump(mb->code,mb->code_length,"Byte code");
  
   l_BlockSize  = 7 * l_ExceptionTableLength + l_IpTransLength + l_BackLength;
   l_Block = sysMalloc(l_BlockSize);

   if (!l_Block)
     {
	lprintf("*************** not enough memory ***************\n");
	JitCompCode=0;
	return -1;
     }
   cinfo->start = l_Block;
   cinfo->end  = l_Block + l_ExceptionTableLength;
   cinfo->handler = l_Block + l_ExceptionTableLength * 2;
   
   cinfo->adrstart = l_Block + l_ExceptionTableLength * 3;
   cinfo->adrend  = l_Block + l_ExceptionTableLength * 4;
   cinfo->adrhandler = l_Block + l_ExceptionTableLength * 5;
   
   cinfo->exclazz = l_Block + l_ExceptionTableLength * 6;
   cinfo->iptab = l_Block + l_ExceptionTableLength * 7;
   cinfo->backp = l_Block + l_ExceptionTableLength * 7 + l_IpTransLength;
#ifdef COMBINEOP   
asdf:
#endif   
   memset(cinfo->iptab,0,l_IpTransLength);
   cinfo->ee  = ee;
   cinfo->isinline = 0;
   cinfo->ipcnt = 0;
   cinfo->backcnt = 0;
   cinfo->wide  = FALSE;
   cinfo->inlineerr = mb->exception_table_length!=0;
   // don't inline if there are catchframes on caller side
   
   if (!ProcessExceptionTab(mb ,cinfo))
     {
      sysFree(l_Block);
      lprintf("ProcessExceptionTab aborted!\n");
      return -1;
     }
   
   cinfo->codebase=cinfo->cptr=sysMalloc(DEFCOMPILEDSIZE);
   if (!cinfo->codebase)
     {
	sysFree(l_Block);
	JitCompCode=0;
	lprintf("*************** not enough memory 2 ***************\n");
	return -1;
     }
   // our JIT compilate..
   cinfo->bptr=(unsigned char*)mb->code;
   cinfo->mb=mb;
   cinfo->maxspace=DEFCOMPILEDSIZE;
   //
   cinfo->resspace= (mb->exception_table_length * 75 + 60) + 150 + 64 ;
   //  max size for exception_handler2 + one opcode + startup (cmp: tyaexc.c,tyarecode.c)

   compex=CompExceptionHandlerPart1(cinfo);
   //
   dprintf(stderr,"soc= %d %d\n",cinfo->cptr-cinfo->codebase,ENTRYPOINT-4);
   while (cinfo->cptr-cinfo->codebase < ENTRYPOINT-4)
     CB(NOP);		// get aligned (currently [#278] useless)
   CL(____METHOD_STARTS_HERE____);	// RESERVED2 (4byte mark)
   //
   CB(PUSHBX);
   CB(PUSHSI);      
   CB(PUSHDI);
   CB(PUSHBP);
   CW(MOV_BPSP);
#ifndef NOCOMPSYNC
   if ((int)cinfo->mb->CompiledCodeFlags & CCF_invokeSynchronizedJavaMethod)
   {
      if (cinfo->mb->fb.access & ACC_STATIC)
        {
	   CB(PUSHLONG);
	   CL(cinfo->mb->fb.clazz);
        }
        else
	{
           Comp_PUSH_LocalVarToReg(0,cinfo,EAX);
	   CB(PUSHAX);
	}  
      CB(MOV_BX);
      CL(monitorEnter);
      CW(CALL_EBX);
      CB(POPAX);
   }
#endif
   // outer compilation loop
   for (j=0;j<mb->code_length ;)
     {
       for (n=0;n<mb->exception_table_length;n++)
       {
 	if (j == mb->exception_table[n].start_pc)
	  cinfo->start[n]=cinfo->cptr;
	if (j == mb->exception_table[n].end_pc)
	  cinfo->end[n]=cinfo->cptr;
	if (j == mb->exception_table[n].handler_pc)
	  cinfo->handler[n]=cinfo->cptr;
       }
       erg=recode(j,klass,cinfo);
#ifdef INLINING
       if (erg==INLINE_ERROR)
       {
         lprintf("TYA: 2nd try: not compiling INLINEs\n");
	 cinfo->inlineerr = TRUE;
	 continue;	// try again, but do not use INLINING
       }
#endif
       if (erg==NOSPACE_ERROR && cinfo->maxspace < MAXCOMPILEDSIZE)
       {
	  relocate=ExtendCodeSpace(cinfo);
	  continue;
       }
       if (erg<=0)
       {
         lprintf("TYA: recode aborted!  %s   (at %d)\n",mb->fb.name,cinfo->cptr - cinfo->codebase);
         break;
       }
       else
        j+=erg;
     }
#ifdef VERBOSE
    if (cinfo->maxspace!=DEFCOMPILEDSIZE)
      lprintf("TYA: #### %d byte for %s.%s (%s)\n",cinfo->cptr - cinfo->codebase,
	      unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature);
#endif
   if (erg>0)
   {
      dprintf(stderr,"translated commands: %d\n",cinfo->ipcnt);
      BackPatchJumpDists(cinfo);
#ifdef COMBINEOP
      if (CheckOpt(cinfo))
	{
	  dprintf(stderr,"TYA: checkop  %s   (at %d)\n",mb->fb.name,cinfo->cptr - cinfo->codebase);
	   cinfo->mb->CompiledCodeFlags &= (~CCF_COMBOK);	// don't try twice
	  goto asdf;
	}
#endif     
      if (compex)
	{
	   compex+=relocate;
	   *((int*)compex)=(int)cinfo->cptr;	// backpatch start of part2
           CompExceptionHandlerPart2(cinfo);
	}
      zz=cinfo->cptr - cinfo->codebase;	// produced byte
#ifdef VERBOSE
      totalCompByte+=zz;
#endif
      cinfo->cptr=cinfo->codebase;
#ifndef COMBINEOP      
      TinyPeepHoleOpt(cinfo);
#endif      

#ifdef PASS2
      if ((j=LoopFinder(cinfo))!=0)
      {
#ifdef DEBUG
	 if (cinfo->backp[j].loop>2)
	   {
	 lprintf("TYA: #### %s.%s (%s) max loop %d->%d  @level %d\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature,
	      cinfo->backp[j].currcnt-1,cinfo->backp[j].destcnt,  cinfo->backp[j].loop);
	   }
#endif
      }
      if (cinfo->backp[j].loop>0)
	Pass2(cinfo);
#endif


      mb->CompiledCode=sysRealloc(cinfo->codebase,zz);
      relocate=(char*)mb->CompiledCode-(char*)cinfo->codebase;
      if (compex && relocate)
	{
	  int n;
	  //fprintf(stderr,"Realloc moved %d byte\n",relocate);
	  compex+=relocate;
	  *((int*)compex) +=relocate;
	  // backpatch 
	  for (n=0;n<cinfo->mb->exception_table_length;n++)
	  {
	     if (cinfo->start[n])
	       {
		  cinfo->adrstart[n]+=relocate;
		  *((int*)cinfo->adrstart[n])+=relocate;
	       }
	     if (cinfo->end[n])
	       {
		  cinfo->adrend[n]+=relocate;
		  *((int*)cinfo->adrend[n])+=relocate;
	       }
	     if (cinfo->handler[n])
	       {
		  cinfo->adrhandler[n]+=relocate;
		  *((int*)cinfo->adrhandler[n])+=relocate;
	       }
	   }
	}
      
      //printHexDump(mb->CompiledCode,zz,"i386 code");
#ifdef VERBOSE_ASM86   
      lprintf("%%%% END JITCOMP: %s.%s ( %s )%%%%\n",unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature);
#endif
      dprintf(stderr,"compiled %d byte realloc to %p   for %s.%s\n",
           zz,mb->CompiledCode,unha11(mb->fb.clazz)->name,mb->fb.name  );
      dflush(stderr);
      mb->CompiledCode+=ENTRYPOINT;
      mb->fb.access |= ACC_MACHINE_COMPILED;
      mb->invoker=InvokeCompiledMethod_Hook;
   } 
   else		// error during compilation
   {
      sysFree(cinfo->codebase);
      dprintf(stderr,"    --------> method could not be compiled\n");	 
      // could be: java.lang.IncompatibleClassChangeError: ......: 
      //           "method ..... did not used to be static" 
      //           and maybe more such stuff
   }
   sysFree(l_Block);
   return erg;
}

// here we have a shell around CompiliereMethode()
//
bool_t JITCompileMethod(struct methodblock *mb, struct execenv *ee)
{
#ifdef VERBOSE
   static int 	s_Level			= 0;
   static int 	s_HyperFastCount	= 0;
   static long	l_TotalJitTime 		= 0;
   long 	l_StartTime 		= 0;
   long		l_EndTime		= 0;
#endif
   struct CINFO cinfo;
   register int i;

   if (! (mb->CompiledCodeFlags & CCF_invokeMask))
    return FALSE;
   
#ifdef VERBOSE
	if (! s_Level++)
           #ifndef JDK12
		l_StartTime = now();
	   #else
	     	l_StartTime = 0;
	   #endif
	else
		iprintf("Recursif call of JITCompileMethod\n");
#endif
   dprintf(stderr,"----------start JITCompileMethod- METHOD=%s.%s  %s %p\n",
	   unha11(mb->fb.clazz)->name,mb->fb.name,mb->fb.signature,mb->invoker);

   
   if ( ee->current_frame->optop+mb->args_size < ee->current_frame->javastack->end_data )
     {
	// no more copy of frame&stack, but reserving space
	ee->current_frame->optop+=mb->args_size;
	i = CompiliereMethode(mb,&cinfo,ee);
	ee->current_frame->optop-=mb->args_size;
     }
   else
     abort();				// should not be
#ifdef VERBOSE
	if (! --s_Level)
	{
	   #ifndef JDK12
		l_EndTime = now();
	   #else
	     	l_EndTime = 0;
	   #endif
		l_TotalJitTime += l_EndTime - l_StartTime;
		if ((l_EndTime - l_StartTime) == 0)
			s_HyperFastCount ++;
		
		lprintf("JitCompiled %s.%s in %ldms (total: %ldms (+ %d / 2) / %dbyte)\n",
				unha11(mb->fb.clazz)->name,mb->fb.name,
				(l_EndTime-l_StartTime), l_TotalJitTime,s_HyperFastCount, totalCompByte);
	}	
#endif
   if (i<=0)
   {
     if (JitCompCode)
      lprintf("TYA: !!! Can't Compile method %s.%s\n",unha11(mb->fb.clazz)->name,mb->fb.name);
#ifndef JDK12      
     lock_classes();
#endif      
     // if an error occured: so we exclude this method from machine code execution
     if (mb->CompiledCodeFlags & CCF_invokeJavaMethod)
	mb->invoker=invokeJavaMethod;
     else
       if (mb->CompiledCodeFlags & CCF_invokeSynchronizedJavaMethod)
 	 mb->invoker=invokeSynchronizedJavaMethod ;
     mb->CompiledCode=NULL;
     // even if the method is not compiled we need some of the CCF flags...
     // .. so we won't set to 0 anymore (Wed Sep 22 21:13:09 1999 ak)
#ifndef JDK12      
     unlock_classes();
#endif
//     // not interested in handling any exceptions, because we have aborted
//     ee->exceptionKind=0;	
//     ee->exception.exc=NULL;
     return FALSE; 
   }
   else
     return TRUE;
}

bool_t MYInvokeCompiledMethod(JHandle *thiso, struct methodblock *mb, int args_size, struct execenv *ee)
{
  #ifdef DEBUG
   static unsigned int JITcompID;
   bool_t i;
   int id=JITcompID++;
   dprintf(stderr,"----------start MYInvokeCompiledMethod-CID=%08x METHOD=%s.%s %p\n",id,unha11(mb->fb.clazz)->name,mb->fb.name,mb->invoker);
   JITCompileMethod(mb,ee);
   dprintf(stderr,"----------part2 MYInvokeCompiledMethod-CID=%08x METHOD=%s.%s\n",id,unha11(mb->fb.clazz)->name,mb->fb.name);
   i=mb->invoker(thiso, mb, args_size, ee);
   dprintf(stderr,"res=%d\n",i);
   dprintf(stderr,"----------retu3 MYInvokeCompiledMethod-CID=%08x METHOD=%s.%s\n",id,unha11(mb->fb.clazz)->name,mb->fb.name);
   return i;
  #else
   JITCompileMethod(mb,ee);
   return mb->invoker(thiso, mb, args_size, ee);
  #endif
}
   
//-------------------------------------------------------------------
// hook #6
// called by java-VM
// also called by InitializeForCompiler_Hook(), CompileClasses_Hook, user's program
//
#ifndef JDK12
long CompileClass_Hook(ClassClass *class)
#else
bool_t CompileClass_Hook(ClassClass *class)
#endif
{
 int i,m;
  char j;
 void* inv;
 Classjava_lang_Class *klass=unha11(class);
   
#ifdef DEBUG
 char* invName="unknown";
#endif
   
dprintf(stderr,"----------CompileClass_Hook----------------- classname: %s\n",unha11(class)->name);
#ifdef DEBUG   
{
   int t;
   for   (t=1;t<klass->methodtable_size ;t++)
     fprintf(stderr,"%d.\t%p %s\n",t,klass->methodtable->methods[t],klass->methodtable->methods[t]->fb.name);
}
#endif   
   
#ifndef JDK12
 if (klass->flags&CCF_IsResolved)
   if (klass->flags&CCF_IsInitialized)
     if (klass->flags&CCF_IsLinked)
       if (klass->flags&CCF_IsSysLock)
         klass->flags |= CCF_CLINITRUN;		// set initedflag
#endif   
  for (i=0;i<klass->methods_count;i++)
     {
	// note result type into a flag
	m=0;
	while (klass->methods[i].fb.signature[m]!=SIGNATURE_ENDFUNC)
  	 m++;
	m++;
	j=klass->methods[i].fb.signature[ m ];
	
	if (j ==SIGNATURE_LONG || j ==SIGNATURE_DOUBLE)
          klass->methods[i].CompiledCodeFlags |= CCF_R64;	// pseudo result type 64bit
	else
	  if (j==SIGNATURE_VOID)
	    klass->methods[i].CompiledCodeFlags |= CCF_VOID;	// void result
	  else
	    klass->methods[i].CompiledCodeFlags |= CCF_R32;	// 32 bit
        MakeStackRevInstruction(&klass->methods[i], !(klass->methods[i].fb.access & ACC_STATIC));
	inv=klass->methods[i].invoker;

#ifdef INLINING
	if (invokeJavaMethod ==inv)			// no synchron, no native
	  if (klass->methods[i].code)			// some code present?
	     if (klass->methods[i].nlocals+klass->methods[i].args_size <=2)// have only two free registers
		if (!klass->methods[i].exception_table_length)	// no exception handling
		  if (klass->methods[i].maxstack<=2) //re-intro Tue Sep  7 19:37:42 1999 (#271)
		    klass->methods[i].CompiledCodeFlags |= CCF_INLINEOK;
#endif
#ifdef COMBINEOP	
	klass->methods[i].CompiledCodeFlags |= CCF_COMBOK;
#endif	
#ifdef DEBUG	
	if (inv==invokeJavaMethod)
	  invName="invokeJavaMethod";
	else
	  if (inv==invokeSynchronizedJavaMethod)
	    invName="invokeSynchronizedJavaMethod";
	else
	  if (inv==invokeAbstractMethod)
	    invName="invokeAbstractMethod";
	else
	  if (inv==invokeLazyNativeMethod)
	    invName="invokeLazyNativeMethod";
	else
	  if (inv==invokeSynchronizedNativeMethod)
	    invName="invokeSynchronizedNativeMethod";
	else
	  if (inv==invokeCompiledMethod)
	    invName="invokeCompiledMethod";
	dprintf(stderr,"%d.\tClass.Meth: %s.%s  FL=%x\n",i,klass->name,klass->methods[i].fb.name,klass->flags);
	dprintf(stderr,"\tSig: %s   Invoker: %s %p\n",klass->methods[i].fb.signature,invName,inv);
///	dprintf(stderr,"INVOKERS  %p %p %p %p\n",MYInvokeCompiledMethod,inv,invokeJavaMethod,invokeSynchronizedJavaMethod);
//	dprintf(stderr,"\tTeSig: -%x-%x-",klass->methods[i].terse_signature[0],
//		klass->methods[i].terse_signature[1]);
#endif
	if (inv==invokeCompiledMethod || inv==InvokeCompiledMethod_Hook)
	{    
	     dprintf(stderr,"\t<<<<< IS ALREADY COMPILED.\n");
	     continue;	
	}


#ifndef NOCOMPSYNC
        if (invokeJavaMethod !=inv && invokeSynchronizedJavaMethod !=inv)
#else
        if (invokeJavaMethod !=inv)
#endif        
	  {
	     dprintf(stderr,"\t<<<<< NOT TO COMPILE.\n");
#ifdef FAST_FPARITH
	     if (!strcmp(klass->name,"java/lang/Math"))
	       {
		  // get code addresses into mb->code (perhaps not the best way)
		  // but important for usage of FAST_FPARITH
		  #if 0
		   uint32_t x;
		   dynoLink(&klass->methods[i],&x);
		  #else
		  execute_java_static_method(EE(),class,
		       klass->methods[i].fb.name,klass->methods[i].fb.signature);
		  #endif
	       }
#endif		 
	     continue;
	  }
	  else
	     dprintf(stderr,"\n");
	
	
	if (invokeJavaMethod ==inv)
	  {
  	   if (!klass->methods[i].exception_table_length)	// no exception handling
	     klass->methods[i].CompiledCodeFlags|=CCF_RESERVED;
	      
	  klass->methods[i].CompiledCodeFlags|=CCF_invokeJavaMethod;
	  }
	if (invokeSynchronizedJavaMethod ==inv)
	  klass->methods[i].CompiledCodeFlags|=CCF_invokeSynchronizedJavaMethod;

	if (JitCompCode)
          klass->methods[i].invoker=MYInvokeCompiledMethod;
     }

// next is good but somewhat verbose, so uncomment if you like
//   if (!JitCompCode)
//     lprintf("TYA: !!! Won't compile (switched OFF) class %s\n",klass->name);

#ifdef EXT_COMPAT   
  ((int)klass->reserved_for_jit)++;
#endif
   
  dprintf(stderr,"---------------END CompileClass_Hook-----------------------\n");
  return 1;		
  // 0 if error
}

			     
void InitializeForCompiler_Hook(ClassClass *class)
{
 dprintf(stderr,"----------InitializeForCompiler_Hook----------- name: %s\n",unha11(class)->name);
 dprintf(stderr,"LOADED: ClassName = %s  SuperClass = %s  Sourcefile= %s\n",
	 unha11(class)->name,unha11(class)->super_name,unha11(class)->source_name);
 if (unha11(class)->access & ACC_INTERFACE)
    dprintf(stderr,"Interface class: no compilation\n");
 if (unha11(class)->access & ACC_ABSTRACT)
    dprintf(stderr,"Abstract class\n");
 else
    dprintf(stderr,"\n");
 CompileClass_Hook(class);	// prepare compilation of all methods of this class
 dprintf(stderr,"----------END InitializeForCompiler_Hook--- name: %s\n",unha11(class)->name);
}


//--------hooks added new in JDK1.2, unused due lack of documentaion


//
// subject of interest in build #285/#286 (not contained in public releases)
//
JavaFrame *CompiledFramePrev_hook(JavaFrame *frame, JavaFrame *buf)
{				 
  dprintf(stderr,"----------CompiledFramePrev_hook---%s %p\n",frame->current_method->fb.name,buf);
  return frame->prev;
}


void *CompiledFrameID_hook(JavaFrame *frame)
{
   dprintf(stderr,"----------CompiledFrameID_hook---%s\n",frame->current_method->fb.name);
   return frame;
}


bool_t CompilerRegisterNatives_hook(ClassClass *clazz)
{
  dprintf(stderr,"----------CompilerRegisterNatives_hook %s\n",unha11(clazz)->name);
  return TRUE;
}


bool_t CompilerUnregisterNatives_hook(ClassClass *clazz)
{
  dprintf(stderr,"----------CompilerUnRegisterNatives_hook %s\n",unha11(clazz)->name);
  return TRUE;   
}
