// Copyright (c) 1998 Albrecht Kleine    All rights reserved
// file version #300

#define TYAASM_S
#include "tyaconfig.h"
#include "tya.h"

#undef  TYAASM_S

.text

#ifdef USEASM

.globl FastInvPrepare
//
// this looks from C side as follows: 
//
// void* FastInvPrepare(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp);
//                                = ecx                   = eax          = 12(%esp)
//
	.type	FastInvPrepare,@function
	.align 16
FastInvPrepare:
	movl CFR_OFF(%ecx),%edx	// cfr
	leal 44(%edx),%ebx	// new JF
//
//	if ((char*)JF > (char*)ee->current_frame->javastack->end_data)
// 	  StOvExcHandler();
//
	movl 20(%edx),%edx	// cfr->jstc
	//
	movl 12(%edx),%edx	// end_data @ 12
	subl $100,%edx
	cmpl %ebx,%edx
	movl CFR_OFF(%ecx),%edx	// == ee->current_frame
	//
	jb .FICheckStackOver	// stackoverflow handling
	// ====== ebx is the desired new JF ========
	movl %edx,16(%ebx)	// JF->prev=ee->current_frame;
	movl 20(%edx),%edx	//
	movl %eax,28(%ebx)	// JF->current_method=mbpcalled;	
	movl %edx,20(%ebx)	// JF->javastack=ee->current_frame->javastack;
	leal 40(%ebx),%edx	// 
	movl %edx,8(%ebx)	// JF->optop=JF->ostack;
	
	movl 12(%esp),%edx	// == stack_item *sp
	movl %edx,12(%ebx)	// JF->vars=sp;
	
	movl %ebx,CFR_OFF(%ecx)	// ee->current_frame=JF
	movl 16(%ebx),%ebx	// == now the prev frame
	ret


.globl FastInvCheck32,FastInvNoCheck32
//
// this looks from C side as follows: 
//
// void* FastInvCheck(struct execenv *ee,struct methodblock *mbpcalled,stack_item *sp);
//                                = ecx                   = eax          = 12(%esp)
//
	.type	FastInvCheck32,@function
	
	.align 16
FastInvCheck32:
	movl 68(%eax),%edx
	testl %edx,%edx

	je FICheck32_2	
FastInvNoCheck32:
	movl CFR_OFF(%ecx),%edx	// cfr
	leal 44(%edx),%ebx	// new JF
//
//	if ((char*)JF > (char*)ee->current_frame->javastack->end_data)
// 	  StOvExcHandler();
//
	movl 20(%edx),%edx	// cfr->jstc
	//// OLD: cmpl %ebx,12(%edx)	// end_data @ 12
	//
	movl 12(%edx),%edx	// end_data @ 12
	subl $100,%edx
	cmpl %ebx,%edx
	movl CFR_OFF(%ecx),%edx	// == ee->current_frame
	//
	jb .FICheckStackOver	// stackoverflow handling
	// ====== ebx is the desired new JF ========
	movl %edx,16(%ebx)	// JF->prev=ee->current_frame;
	movl 20(%edx),%edx	//
	movl %eax,28(%ebx)	// JF->current_method=mbpcalled;	
	movl %edx,20(%ebx)	// JF->javastack=ee->current_frame->javastack;
	leal 40(%ebx),%edx	// 
	movl %edx,8(%ebx)	// JF->optop=JF->ostack;
	
	movl 12(%esp),%edx	// == stack_item *sp
	movl %edx,12(%ebx)	// JF->vars=sp;
	
	movw LV_OFF(%eax),%edx	// current_method->nlocals in lower 16 bit
	movl %ebx,CFR_OFF(%ecx)	// ee->current_frame=JF
	//
	shll $16,%edx
	movl 68(%eax),%eax	// == compiled code
	shrl $14,%edx		// shl,shr is for mul 4
	//	
	movl 16(%ebx),%ebx	// == now the prev frame
	ret
	
	// returning:
	// eax is mbpcalled->CompiledCode  /  ecx is ee   /  ebx is ee->current_frame->prev
//	
//	JF++;
//	JF->vars=sp;
//	JF->prev=ee->current_frame;
//	JF->current_method=mbpcalled;
//	JF->javastack=ee->current_frame->javastack;
//	JF->optop=JF->ostack;
//	ee->current_frame=JF;
//
	.align 16
FICheck32_2:
#ifndef JDK12
	testb $1,17(%eax)		// this is ACC_NATIVE's hibyte
#else	
	testb $1,13(%eax)		// this is ACC_NATIVE's hibyte
#endif
	jne FICheck32_3

	pushl %ecx 
	pushl %eax 
	call JITCompileMethod
	testl %eax,%eax
	popl %eax
	popl %ecx
	jne FastInvNoCheck32
FICheck32_3:
	movl CFR_OFF(%ecx),%ebx
	movl $CodeRunner32_withDummies,%eax
	movl $0,%edx
	ret

/////////////////////////////////////////////////////////////////

.globl FastInvCheck64,FastInvNoCheck64
	.type	 FastInvCheck64,@function
	.align 16
FastInvCheck64:
	movl 68(%eax),%edx
	testl %edx,%edx

	je FICheck64_2
FastInvNoCheck64:
	movl CFR_OFF(%ecx),%edx	// cfr
	leal 44(%edx),%ebx	// new JF
//
//	if ((char*)JF > (char*)ee->current_frame->javastack->end_data)
// 	  StOvExcHandler();
//
	movl 20(%edx),%edx	// cfr->jstc
	//// OLD: cmpl %ebx,12(%edx)	// end_data @ 12
	//
	movl 12(%edx),%edx	// end_data @ 12
	subl $100,%edx
	cmpl %ebx,%edx
	movl CFR_OFF(%ecx),%edx	// == ee->current_frame
	//
	jb .FICheckStackOver	// stackoverflow handling
	//
	movl %edx,16(%ebx)
	movl 20(%edx),%edx
	movl %eax,28(%ebx)	// JF->current_method=mbpcalled;	
	movl %edx,20(%ebx)
	leal 40(%ebx),%edx
	movl %edx,8(%ebx)	// ebx is ee->current_frame

	movl 12(%esp),%edx	// == stack_item *sp	
	movl %edx,12(%ebx)
	
	movw LV_OFF(%eax),%edx	// we need (short) current_method->nlocals
	movl %ebx,CFR_OFF(%ecx)	// ee->current_frame=JF
	//
	shll $16,%edx
	movl 68(%eax),%eax	// == compiled code
	//	
	shrl $14,%edx
	movl 16(%ebx),%ebx	// ...->prev    [ also via subl $44,%ebx ]
	ret
	// returning:
	// eax is mbpcalled->CompiledCode  /  ecx is ee   /  ebx is ee->current_frame->prev
//	
//	JF++;
//	JF->vars=sp;
//	JF->prev=ee->current_frame;
//	JF->current_method=mbpcalled;
//	JF->javastack=ee->current_frame->javastack;
//	JF->optop=JF->ostack;
//	ee->current_frame=JF;
//
	.align 16
FICheck64_2:
#ifndef JDK12
	testb $1,17(%eax)		// this is ACC_NATIVE's hibyte
#else	
	testb $1,13(%eax)		// this is ACC_NATIVE's hibyte
#endif
	jne FICheck64_3

	pushl %ecx 
	pushl %eax 
	call JITCompileMethod
	testl %eax,%eax
	popl %eax
	popl %ecx
	jne FastInvNoCheck64
	
FICheck64_3:
	movl $CodeRunner64_withDummies,%eax
	movl CFR_OFF(%ecx),%ebx
	movl $0,%edx
	ret

//////////////////////////////////////////////////////////////

//FIXME12

// special stack overflow handling: similar above, but not the same.....
// jmp'd by all FastInvCheckXX if no more space on Java stack condition

	.align 16
.FICheckStackOver:
	movl 20(%edx),%edx	// cfr->jstc

	cmpl $TYA_JSTACK,16(%edx)// stack_so_far @ 16 compared with max (def. in tya.h)
	jb  .FICSOver1
	call StOvExcHandler

.FICSOver1:
	pushl %eax		// save mbp
	movl 8(%edx),%eax 	// edx this_stack, eax nextstack
	testl %eax,%eax
	jnz nextstack

#ifdef JDK12
	pushl min_javastack_chunk_size
#endif	
	pushl %edx	// prev stac
	pushl %ecx	// ee
	call CreateNewJavaStack
	popl %ecx
	popl %edx
#ifdef JDK12	
	popl %ebx	// dummy
#endif	
nextstack:
	// eax = new stack
	leal 20(%eax),%ebx	// data @ 20
	// ====== ebx is the desired new JF ========
		
	movl 16(%esp),%edx	// == stack_item *sp
	/* ==16 because pushax above */

	movl %edx,12(%ebx)	// JF->vars=sp;
	movl CFR_OFF(%ecx),%edx	// 
	movl %edx,16(%ebx)	// JF->prev=ee->current_frame;
	movl %eax,20(%ebx)	// JF->javastack=NEW_created_java_stack;
	//	
	popl %eax		// restore mbp
	movl %eax,28(%ebx)	// JF->current_method=mbpcalled;
	leal 40(%ebx),%edx	// 
	movl %edx,8(%ebx)	// JF->optop=JF->ostack;
	movl %ebx,CFR_OFF(%ecx)	// ee->current_frame=JF
	//
	movzwl LV_OFF(%eax),%edx	// (short) current_method->nlocals
	shll $2,%edx		// * 4
	movl 68(%eax),%eax	// == compiled code
	//	
	movl 16(%ebx),%ebx	// == now the prev frame
	ret

#endif


//////////////////////////////////////////////////////////////
#ifdef USEASM
#ifdef INIT0
	.align 16
.globl MyObjAlloc
	.type	 MyObjAlloc,@function
MyObjAlloc:
	// expecting class in eax
	pushl $0
	pushl %eax
	call ObjAlloc
	popl %ebx
	popl %ecx
	testl %eax,%eax
	je .MyObjAlloc2
	movl (%ebx),%edx	// unhand(class)
	movl %edi,%ebx		// save edi
	movl (%eax),%edi	// unhand(object)

	movzwl 84(%edx),%ecx
	movl %eax,%edx
	shrl $0x2,%ecx
	xorl %eax,%eax
	cld
	rep 
	stosl %es:(%edi)
	movl %edx,%eax
	movl %ebx,%edi		// restore edi
	ret
.MyObjAlloc2:
	jmp out_of_memory
#endif
#endif
//////////////////////////////////////////////////////////////


	.align 16
.globl StOvExcHandler
	.type	 StOvExcHandler,@function
StOvExcHandler:

#ifndef USEASM
	movl %ebp,%esp			// discard caller's C stack frame
	popl %ebp			// for access to stack pointer
#endif
	call EE
	pushl StOvExc			// params for ExecExcep
	pushl %eax
	jmp SEH1			// exc is not catchable inside method


/////////////////////////////////////////////////////////////


	.align 16
.globl SimpleExcHandler
	.type	 SimpleExcHandler,@function
SimpleExcHandler:
	pushl %eax			// expecting in eax: ExcObject
	movl (LOCSTART-16)(%ebp),%edx	// get EE into ecx
	pushl %edx
SEH1:	
	call ExecExcep
	movl %ebp,%esp			// standard epilog
	popl %ebp
	popl %edi
	popl %esi
	popl %ebx
	ret
	

