/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#if 0
#define OLD_LINE
#define STACK_PUSHPOP
#define PUSHSORT
#define DUMPFILL
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "sarien.h"
#include "agi.h"
#include "gfx.h"
#include "picture.h"


#define gbyte data[foffs++]

AGI_PICTURE	pictures[MAX_DIRS];

UINT8	*data;
UINT32	flen;
UINT32	foffs;

UINT8	patCode;
UINT8	patNum;
UINT8	we_are_drawing;
UINT8	pri_on;
UINT8	scr_on;
UINT8	scr_colour;
UINT8	pri_colour;

UINT8	screen2[_WIDTH * _HEIGHT];
UINT8	screen_data[_WIDTH * _HEIGHT];
UINT8	priority_data[_WIDTH * _HEIGHT];
UINT8	control_data[_WIDTH * _HEIGHT];
UINT8	xdata_data[_WIDTH * _HEIGHT];

UINT8	layer1_data[320 * 200];
UINT8	layer2_data[320 * 200];

UINT8	pic_clear_flag=__TRUE;

void	clear_base		(void);
void	clear_priority		(void);
void	put_virt_pri_pixel	(UINT16 x, UINT16 y);
void	put_virt_screen_pixel	(UINT16 x, UINT16 y);
void	put_virt_pixel		(UINT16 x, UINT16 y);
UINT8	get_scr_pixel		(UINT16 x, UINT16 y);
UINT8	get_pri_pixel		(UINT16 x, UINT16 y);
void	draw_line		(UINT16 x1, UINT16 y1, UINT16 x2, UINT16 y2);
#ifdef OLD_LINE
SINT32	round			(float aNumber, float dirn);
#endif
void	dump_screen2		(void);
void	dump_screen		(UINT16 resnum);
void	dump_con		(UINT16 resnum);
void	dump_pri		(UINT16 resnum);
void	dump_x			(UINT16 resnum);
void	draw_picture		(void);
void	plot_brush		(void);
void	dump_x_screen		(void);
void	dump_con_screen		(void);

void	y_corner		(void);
void	x_corner		(void);
void	absolute_draw_line	(void);
void	dynamic_draw_line	(void);
void	fill			(void);
void	plot_pattern		(UINT16 x, UINT16 y);
UINT8	is_ok_fill_here		(UINT16 x, UINT16 y);
void	agiFill			(UINT16 x, UINT16 y);
void 	reset_graphics		(void);
void	splitPriority		(UINT16);

void	_POP			(CORD *);
void	_PUSH			(CORD *);

#ifdef STACK_PUSHPOP
#define STACK_SEG_SIZE 0x1000
#define MAX_STACK_SEGS 16
static CORD	*stack[MAX_STACK_SEGS];
static UINT32	stack_num_segs;
static UINT32	stack_seg;
static UINT32	stack_ptr;
#else
CORD	*root;
#endif


extern UINT8 old_prio;		/* Used in add_to_pic() */


void put_block_buffer(UINT8 *buff, UINT16 x1, UINT16 y1, UINT16 x2, UINT16 y2)
{
	UINT16 x;

	for ( ; y1 < y2; y1++)
		for(x = x1; x < x2; x++)
			put_pixel_buffer (x, y1, *(buff + (y1 * 160) + x));
}


void reset_graphics(void)
{
	screen_mode = GFX_MODE;

	txt_fg = 0x0F;
	txt_bg = 0x00;

	memset (screen2, 0, _WIDTH * _HEIGHT);
	memset (screen_data, 0, _WIDTH * _HEIGHT);
	memset (priority_data, 0, _WIDTH * _HEIGHT);
	memset (control_data, 0, _WIDTH * _HEIGHT);
	memset (xdata_data, 0, _WIDTH * _HEIGHT);

	memset (layer1_data, 0, 320 * 200);
	memset (layer2_data, 0, 320 * 200);
}


/* load a pic and decode it into the correct slot */
UINT16 decode_picture(UINT16 resnum)
{
	UINT16	ec=err_OK;

	_D (("(%d)", resnum));

#ifndef STACK_PUSHPOP
	root = (CORD*)calloc(1, sizeof(CORD));
#endif
	patCode = 0;
	patNum = 0;
	we_are_drawing = __FALSE;
	pri_on = __FALSE;
	scr_on = __FALSE;
	scr_colour = 0xF;
	pri_colour = 0x4;

	data = pictures[resnum].rdata;
	flen = dir_pic[resnum].len;
	foffs = 0;

	pictures[resnum].sdata = (UINT8*)malloc (_WIDTH * _HEIGHT);
	pictures[resnum].pdata = (UINT8*)malloc (_WIDTH * _HEIGHT);
	pictures[resnum].cdata = (UINT8*)malloc (_WIDTH * _HEIGHT);
	pictures[resnum].xdata = (UINT8*)malloc (_WIDTH * _HEIGHT);

	draw_picture ();

	memcpy (pictures[resnum].sdata, &screen_data, _WIDTH * _HEIGHT);
	memcpy (pictures[resnum].pdata, &priority_data, _WIDTH * _HEIGHT);
	memcpy (pictures[resnum].cdata, &control_data, _WIDTH * _HEIGHT);
	memcpy (pictures[resnum].xdata, &xdata_data, _WIDTH * _HEIGHT);

	splitPriority (resnum);

	/* FIXME: Ugh! */

	memcpy (&priority_data, pictures[resnum].pdata, _WIDTH * _HEIGHT);
	memcpy (&control_data, pictures[resnum].cdata, _WIDTH * _HEIGHT);


#ifndef STACK_PUSHPOP
	free(root);
#endif

	return ec;
}


UINT16 unload_picture(UINT16 resnum)
{
	if(pictures[resnum].pdata != NULL)
		free(pictures[resnum].pdata);	/* free priority image */
	if(pictures[resnum].sdata != NULL)
		free(pictures[resnum].sdata);	/* free screen image */
	if(pictures[resnum].cdata != NULL)
		free(pictures[resnum].cdata);	/* free control image */
	if(pictures[resnum].xdata != NULL)
		free(pictures[resnum].xdata);	/* free p+c image */

	pictures[resnum].xdata = NULL;
	pictures[resnum].sdata = NULL;
	pictures[resnum].pdata = NULL;
	pictures[resnum].cdata = NULL;

	return err_OK;
}


void dump_screen (UINT16 resnum)
{
	put_block_buffer (pictures[resnum].sdata, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void dump_screen2 (void)
{
	put_block_buffer (screen_data, 0, 0, _WIDTH, _HEIGHT);
	put_screen();
}


void dump_pri (UINT16 resnum)
{
	put_block_buffer (pictures[resnum].pdata, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void dump_con (UINT16 resnum)
{
	put_block_buffer (pictures[resnum].cdata, 0, 0, _WIDTH, _HEIGHT);
	put_screen();
}


void dump_x (UINT16 resnum)
{
	put_block_buffer (pictures[resnum].xdata, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void dump_screenX ()
{
	memmove (screen_data, screen2, _WIDTH*_HEIGHT);
	put_block_buffer (screen_data, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void dump_screen3 ()
{
	put_block_buffer (screen2, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void dump_pri_screen ()
{
	put_block_buffer (priority_data, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void dump_con_screen ()
{
	put_block_buffer (control_data, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void dump_x_screen ()
{
	put_block_buffer (xdata_data, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
}


void clear_base ()
{
	memset (&screen2, 0x0F, _WIDTH * _HEIGHT);
}


void clear_priority ()
{
	memset (&priority_data, 0x4, _WIDTH * _HEIGHT);
	memset (&control_data, 0x4, _WIDTH * _HEIGHT);
	memset (&xdata_data, 0x4, _WIDTH * _HEIGHT);
}


void put_virt_screen_pixel (UINT16 x, UINT16 y)
{
	screen2[y * _WIDTH + x] = scr_colour;
}


void put_virt_pri_pixel (UINT16 x, UINT16 y)
{
	xdata_data[y * _WIDTH + x] = pri_colour;

	if (pri_colour >= 0x4)
		priority_data[y * _WIDTH + x] = pri_colour;
#if 0
	/* This can't be done here. It doesn't understand control lines
	 * painted over with priority data.
	 */
	if (pri_colour >= 0x4)
		priority_data[y * _WIDTH + x] = pri_colour;
	else
		control_data[y * _WIDTH + x] = pri_colour;
#endif
}


UINT8 get_scr_pixel (UINT16 x, UINT16 y)
{
	return screen2[y * _WIDTH + x];
}


UINT8 get_pri_pixel (UINT16 x, UINT16 y)
{
	return xdata_data[y * _WIDTH + x];
}


void put_virt_pixel(UINT16 x, UINT16 y)
{
	if(x>_WIDTH-1 || y>_HEIGHT-1) return;

	if(pri_on == __TRUE)
		put_virt_pri_pixel (x, y);
	if(scr_on == __TRUE)
		put_virt_screen_pixel (x, y);
}


/* FIXME */
extern UINT8 show_screen_mode;

void draw_picture (void)
{
	UINT8	act;
#ifdef STACK_PUSHPOP
	int i;
#endif

	_D (("()"));
 	patCode = 0;
 	patNum = 0;
 	pri_on = __FALSE;
 	scr_on = __FALSE;
 	scr_colour = 0xF;
 	pri_colour = 0x4;
	old_prio = 4;

	if (optShowKeyPress == 3)
		optShowKeyPress = __TRUE;
	if (optShowScreenDraw == 3)
		optShowScreenDraw = __TRUE;

	if (pic_clear_flag == __TRUE) {
		clear_base ();
		clear_priority ();
	}

	we_are_drawing = 1;

#ifdef STACK_PUSHPOP
	stack[0] = calloc (sizeof (CORD), STACK_SEG_SIZE);
	stack_ptr = stack_seg = 0;
	stack_num_segs = 1;
#endif	

	for (we_are_drawing = 1; we_are_drawing && foffs < flen; )
	{
		act = gbyte;

		switch(act)
		{
		case 0xF0:			/* set colour on screen */
			scr_colour = gbyte;
			scr_colour &= 0xF;	/* for v3 drawing diff */
			scr_on = __TRUE;
			break;
		case 0xF1:			/* disable screen drawing */
			scr_on = __FALSE;
			break;
		case 0xF2:			/* set colour on priority */
			pri_colour = gbyte;
			pri_colour &= 0xF;	/* for v3 drawing diff */
			pri_on = __TRUE;
			break;
		case 0xF3:			/* disable priority screen */
			pri_on = __FALSE;
			break;
		case 0xF4:			/* y-corner */
			y_corner ();
			break;
		case 0xF5:			/* x-corner */
			x_corner ();
			break;
		case 0xF6:			/* absolute draw lines */
			absolute_draw_line ();
			break;
		case 0xF7:			/* dynamic draw lines */
			dynamic_draw_line ();
			break;
		case 0xF8:			/* fill */
			fill ();
			break;
		case 0xF9:			/* set pattern */
			patCode = gbyte;
			break;
		case 0xFA:			/* plot brush */
			plot_brush ();
			break;
		case 0xFF:			/* end of pic data */
		default:
/* printf ("%20x\n", act); */
			we_are_drawing = 0;
			break;
		}

#if 0
	/* Show priority screen drawing for Gold Rush debugging. Irghts */
	put_block_buffer (xdata_data, 0, 0, _WIDTH, _HEIGHT);
	put_screen ();
#endif

		if (optShowScreenDraw == __TRUE) {
			switch (show_screen_mode) {
			case 'x':
				put_block_buffer (xdata_data, 0, 0,
					_WIDTH, _HEIGHT);
				break;
			case 'p':
				put_block_buffer (priority_data, 0, 0,
					_WIDTH, _HEIGHT);
				break;
			case 'c':
				put_block_buffer (control_data, 0, 0,
					_WIDTH, _HEIGHT);
				break;
			default:
				dump_screen3 ();
				break;
			}

			put_screen ();
		}

		/* FIXME: ugh */
		if (optShowScreenDraw == __TRUE && optShowKeyPress == __TRUE)
		{
			act = gfx->get_key() & 0xFF;
			/*if (act == 0) getchar ();*/
			if(act == 'c')
				optShowKeyPress = 3;
			if(act == 'q' || act == 'Q')
				optShowScreenDraw = 3;
		}
	}

#ifdef STACK_PUSHPOP
	for (i = 0; i < stack_num_segs; i++)
		free (stack[i]);
#endif

	/* splitPriority (); */
}


INLINE void _PUSH(CORD *c)
{
#ifdef STACK_PUSHPOP
	if (stack_ptr >= STACK_SEG_SIZE)
	{
		/* Allocate new stack segment */
		if (stack_num_segs >= MAX_STACK_SEGS)
		{
			fprintf (stderr, "flood fill stack overflow\n");
			abort ();
		}
		if (stack_num_segs <= ++stack_seg) {
			_D ((": new stack (#%ld)", stack_num_segs));
			stack[stack_num_segs++] = malloc (sizeof (CORD) *
				STACK_SEG_SIZE);
		}
		stack_ptr = 0;
	}
	stack[stack_seg][stack_ptr].x = c->x;
	stack[stack_seg][stack_ptr].y = c->y;
	stack_ptr++;
#else
	CORD	*r, *p;
	UINT8	flag=0;

	r=root->next;

	/* search for same co-ord as in list */
#ifdef PUSHSORT
	while(r!=NULL && flag==0)
 	{
 		if(r->x==c->x && r->y==c->y)
 			flag=1;
		else
		    if(c->y < r->y)
		    	flag=2;
		    else
		    	r=r->next;
 	}
#else
 	while(r!=NULL && flag==0)
 	{
 		if(r->x==c->x && r->y==c->y)
 			flag=1;
 		else
 			r=r->next;
 	}
#endif

	if(flag==2 || r==NULL)
	{
		/* add co-ord */
		if(r==NULL)
		{
			r=root;
			while(r->next!=NULL)
				r=r->next;
		}

		p=(CORD*)calloc(1, sizeof(CORD));
		p->next=r->next;
		r->next=p;

		p->x=c->x;
		p->y=c->y;
	}

#endif
}

INLINE void _POP(CORD *c)
{
#ifdef STACK_PUSHPOP
	if (stack_ptr == 0)
	{
		if (stack_seg == 0)
			c->x = c->y = 0xffff;
		else
			stack_seg--, stack_ptr = STACK_SEG_SIZE - 1;

		return;
	}

	stack_ptr--;
	c->x = stack[stack_seg][stack_ptr].x;
	c->y = stack[stack_seg][stack_ptr].y;
#else
	CORD *p;

	if(root->next!=NULL)
	{
		p=root->next;

		c->x=p->x;
		c->y=p->y;

		root->next=p->next;
		free(p);
	}
	else
	{
		c->x=0xFFFF;
		c->y=0xFFFF;
	}
#endif
}


/**************************************************************************
** drawline
**
** Draws an AGI line.
**************************************************************************/
void draw_line(UINT16 x1, UINT16 y1, UINT16 x2, UINT16 y2)
{
#ifdef OLD_LINE
	SINT32 height, width;
	float x, y, addX, addY;

	height = (y2 - y1);
	width = (x2 - x1);
	addX = (height==0?height:(float)width/abs(height));
	addY = (width==0?width:(float)height/abs(width));

	if (abs(width) > abs(height))
	{
		y = y1;
		addX = (width == 0? 0 : (width/abs(width)));
      	for (x=x1; x!=x2; x+=addX)
      	{
			put_virt_pixel(round(x, addX), round(y, addY));
			y+=addY;
		}
			put_virt_pixel(x2,y2);
	}
	else
	{
		x = x1;
		addY = (height == 0? 0 : (height/abs(height)));
		for (y=y1; y!=y2; y+=addY)
		{
			put_virt_pixel(round(x, addX), round(y, addY));
			x+=addX;
		}
		put_virt_pixel(x2,y2);
	}

#else
/* line drawing routine sent to me by joshua neal */
/* modified by stuart george, fixed >>2 to >>1 and some other bugs
   like x1 instead of y1, etc */
	UINT32 x, y;
	SINT32 deltaX, deltaY;
	SINT32 stepX, stepY;
	SINT32 errorX, errorY;
	SINT32 detdelta;
	UINT32 count;

	/* CM: Do clipping */
#define clip(x, y) if((x)>=(y)) (x)=(y)
	clip (x1, _WIDTH-1);
	clip (x2, _WIDTH-1);
	clip (y1, _HEIGHT-1);
	clip (y2, _HEIGHT-1);

	/* Vertical line */

	if(x1 == x2)
	{
		if(y1 > y2) {
			y = y1;
			y1 = y2;
			y2 = y;
		}

		for( ; y1 <= y2; y1++)
			put_virt_pixel (x1, y1);

		return;
	}

	/* Horizontal line */

	if(y1 == y2)
	{
		if (x1 > x2) {
			x = x1;
			x1 = x2;
			x2 = x;
		}

   		for( ; x1 <= x2; x1++)
   			put_virt_pixel (x1, y1);

		return;
	}

	y = y1;
  	x = x1;
	put_virt_pixel (x1, y1);

	stepY = 1;
	deltaY = y2-y1;
	if (deltaY < 0)
	{
		stepY = -1;
		deltaY = -deltaY;
	}

	stepX = 1;
	deltaX = x2 - x1;
	if (deltaX < 0)
	{
		stepX = -1;
		deltaX = -deltaX;
	}

	if(deltaY > deltaX)
	{
		count=deltaY;
		detdelta=deltaY;
		errorX=deltaY/2;
		errorY=0;
	}
	else
	{
		count=deltaX;
		detdelta=deltaX;
		errorX=0;
		errorY=deltaX/2;
	}

	put_virt_pixel(x, y);
	do
	{
		/*errorY=(errorY+deltaY)%256;*/
		errorY=(errorY+deltaY);

		if(errorY>=detdelta)
		{
			errorY-=detdelta;
			y+=stepY;
		}

		/*errorX=(errorX+deltaX)%256;*/
		errorX=(errorX+deltaX);
		if(errorX>=detdelta)
		{
			errorX-=detdelta;
			x+=stepX;
		}
		put_virt_pixel(x, y);
		count--;
	} while((SINT32)count>0);

	put_virt_pixel(x, y);

#endif
}

/**************************************************************************
** relativeDraw
**
** Draws short lines relative to last position.  (drawing action 0xF7)
**************************************************************************/
void dynamic_draw_line(void)
{
	UINT8 x1, y1, disp;
	SINT8 dx, dy;

	x1=gbyte;
	y1=gbyte;

	put_virt_pixel(x1, y1);

	while (42)
	{
		if ((disp=gbyte) >= 0xF0)
			break;

		dx= ((disp & 0xF0) >> 4) & 0x0F;
		dy= (disp & 0x0F);

	      	if (dx & 0x08)
			dx= (-1)*(dx & 0x07);

	      	if (dy & 0x08)
			dy= (-1)*(dy & 0x07);

		draw_line(x1, y1, x1 + dx, y1 + dy);
		x1 += dx;
		y1 += dy;
	}
	foffs--;
}

/**************************************************************************
** absoluteLine
**
** Draws long lines to actual locations (cf. relative) (drawing action 0xF6)
**************************************************************************/
void absolute_draw_line(void)
{
	UINT8	x1, y1, x2, y2;

	x1= gbyte;
	y1= gbyte;
	put_virt_pixel(x1, y1);

	while (42)
	{
		if ((x2 = gbyte) >= 0xF0)
			break;

		if ((y2 = gbyte) >= 0xF0)
			break;

		draw_line(x1, y1, x2, y2);
		x1 = x2;
		y1 = y2;
	}
	foffs--;
}

#ifdef OLD_LINE
/**************************************************************************
** round
**
** Rounds a float to the closest int. Takes into actions which direction
** the current line is being drawn when it has a 50:50 decision about
** where to put a pixel.
**************************************************************************/
SINT32 round(float aNumber, float dirn)
{
	if (dirn < 0)
		return (SINT32)((aNumber - floor(aNumber) <= 0.501) ?
			floor(aNumber) : ceil(aNumber));

	return (SINT32)((aNumber - floor(aNumber) < 0.499) ?
		floor(aNumber) : ceil(aNumber));
}
#endif

/**************************************************************************
** okToFill
**************************************************************************/
INLINE UINT8 is_ok_fill_here(UINT16 x, UINT16 y)
{
	if(scr_on==__FALSE && pri_on==__FALSE)
		return __FALSE;

	if(pri_on==__FALSE && scr_on==__TRUE && scr_colour!=15)
	{
		if(get_scr_pixel(x, y)==15)
			return __TRUE;
		else
			return __FALSE;
	}

	if(pri_on==__TRUE && scr_on==__FALSE && pri_colour!=4)
	{
		if(get_pri_pixel(x, y)==4)
			return __TRUE;
		else
			return __FALSE;
	}

	if(get_scr_pixel(x, y)==15 && scr_colour!=15)
		return __TRUE;

	return __FALSE;
}

/**************************************************************************
** agiFill
**************************************************************************/
void agiFill(UINT16 x, UINT16 y)
{
	CORD c;

	/* _D (("(%d, %d)", x, y)); */
	c.x = x;
	c.y = y;
	_PUSH (&c);

	while (42) {
		_POP(&c);

		/* Exit if stack is empty */
		if ((c.x == 0xFFFF) || (c.y == 0xFFFF))
			break;

		if (is_ok_fill_here (c.x,c.y)) {
			put_virt_pixel (c.x, c.y);
			if (c.x > 0 && is_ok_fill_here (c.x-1, c.y)) {
				c.x--; _PUSH (&c); c.x++;
    			}
			if (c.x < _WIDTH - 1 && is_ok_fill_here (c.x+1, c.y)) {
				c.x++; _PUSH (&c); c.x--;
 			}
			if (c.y < _HEIGHT - 1 && is_ok_fill_here (c.x, c.y+1)) {
				c.y++; _PUSH (&c); c.y--;
    			}
			if (c.y > 0 && is_ok_fill_here (c.x, c.y-1)) {
				c.y--; _PUSH (&c); c.y++;
    			}
		}
#ifdef DUMPFILL
		if(optShowScreenDraw==__TRUE)
			dump_screen3();
#endif
	}
#ifdef STACK_PUSHPOP
	stack_ptr = 0;
	stack_seg = 0;
#endif
}

/**************************************************************************
** xCorner
**
** Draws an xCorner  (drawing action 0xF5)
**************************************************************************/
void x_corner(void)
{
	UINT8 x1, x2, y1, y2;

	x1 = gbyte;
	y1 = gbyte;
   	put_virt_pixel(x1,y1);

	while (42)
	{
		x2=gbyte;

		if(x2>=0xF0)
			break;

		draw_line(x1, y1, x2, y1);
		x1=x2;
		y2=gbyte;

		if(y2>=0xF0)
			break;

		draw_line(x1, y1, x1, y2);
		y1=y2;
	}
	foffs--;
}


/**************************************************************************
** yCorner
**
** Draws an yCorner  (drawing action 0xF4)
**************************************************************************/
void y_corner(void)
{
	UINT8 x1, x2, y1, y2;

	x1 = gbyte;
	y1 = gbyte;
	put_virt_pixel(x1, y1);

	while (42)
	{
		y2=gbyte;

		if(y2>=0xF0)
			break;

		draw_line(x1, y1, x1, y2);
		y1=y2;
		x2=gbyte;

		if(x2>=0xF0)
			break;

		draw_line(x1, y1, x2, y1);
		x1=x2;
	}

	foffs--;
}

/**************************************************************************
** fill
**
** AGI flood fill.  (drawing action 0xF8)
**************************************************************************/
void fill(void)
{
	UINT8 x1, y1;

	while ((x1 = gbyte) < 0xF0 && (y1 = gbyte) < 0xF0)
		agiFill (x1, y1);

	foffs--;
}


#define plotPatternPoint() do { \
   if (patCode & 0x20) { \
      if ((splatterMap[bitPos>>3] >> (7-(bitPos&7))) & 1) put_virt_pixel(x1, y1); \
      bitPos++; \
      if (bitPos == 0xff) bitPos=0; \
   } else put_virt_pixel(x1, y1); } while (0)

/**************************************************************************
** plotPattern
**
** Draws pixels, circles, squares, or splatter brush patterns depending
** on the pattern code.
**************************************************************************/
void plotPattern(UINT8 x, UINT8 y)
{
	static char circles[][15] =
	{ /* agi circle bitmaps */
		{0x80},
		{0xfc},
		{0x5f, 0xf4},
		{0x66, 0xff, 0xf6, 0x60},
		{0x23, 0xbf, 0xff, 0xff, 0xee, 0x20},
		{0x31, 0xe7, 0x9e, 0xff, 0xff, 0xde, 0x79, 0xe3, 0x00},
		{0x38, 0xf9, 0xf3, 0xef, 0xff, 0xff, 0xff, 0xfe, 0xf9, 0xf3, 0xe3, 0x80},
		{0x18, 0x3c, 0x7e, 0x7e, 0x7e, 0xff, 0xff, 0xff, 0xff, 0xff, 0x7e, 0x7e, 0x7e, 0x3c, 0x18}
	};

	static UINT8 splatterMap[32] =
	{ /* splatter brush bitmaps */
		0x20, 0x94, 0x02, 0x24, 0x90, 0x82, 0xa4, 0xa2,
		0x82, 0x09, 0x0a, 0x22, 0x12, 0x10, 0x42, 0x14,
		0x91, 0x4a, 0x91, 0x11, 0x08, 0x12, 0x25, 0x10,
		0x22, 0xa8, 0x14, 0x24, 0x00, 0x50, 0x24, 0x04
	};

	static UINT8 splatterStart[128] =
	{ /* starting bit position */
		0x00, 0x18, 0x30, 0xc4, 0xdc, 0x65, 0xeb, 0x48,
		0x60, 0xbd, 0x89, 0x05, 0x0a, 0xf4, 0x7d, 0x7d,
		0x85, 0xb0, 0x8e, 0x95, 0x1f, 0x22, 0x0d, 0xdf,
		0x2a, 0x78, 0xd5, 0x73, 0x1c, 0xb4, 0x40, 0xa1,
		0xb9, 0x3c, 0xca, 0x58, 0x92, 0x34, 0xcc, 0xce,
		0xd7, 0x42, 0x90, 0x0f, 0x8b, 0x7f, 0x32, 0xed,
		0x5c, 0x9d, 0xc8, 0x99, 0xad, 0x4e, 0x56, 0xa6,
		0xf7, 0x68, 0xb7, 0x25, 0x82, 0x37, 0x3a, 0x51,
		0x69, 0x26, 0x38, 0x52, 0x9e, 0x9a, 0x4f, 0xa7,
		0x43, 0x10, 0x80, 0xee, 0x3d, 0x59, 0x35, 0xcf,
		0x79, 0x74, 0xb5, 0xa2, 0xb1, 0x96, 0x23, 0xe0,
		0xbe, 0x05, 0xf5, 0x6e, 0x19, 0xc5, 0x66, 0x49,
		0xf0, 0xd1, 0x54, 0xa9, 0x70, 0x4b, 0xa4, 0xe2,
		0xe6, 0xe5, 0xab, 0xe4, 0xd2, 0xaa, 0x4c, 0xe3,
		0x06, 0x6f, 0xc6, 0x4a, 0xa4, 0x75, 0x97, 0xe1
	};

	SINT32 circlePos = 0;
	UINT32 x1, y1, penSize, bitPos = splatterStart[patNum];

	penSize = (patCode&7);

	if(x<penSize)
		x=penSize-1;
	if(y<penSize)
		y=penSize;

	for (y1=y-penSize; y1<=y+penSize; y1++)
	{
#if 0
		/* CM: who needs floating point? */
		for (x1=x-(UINT32)(ceil((float)penSize/2) );
			x1<=x+ (UINT32)(floor((float)penSize/2) ); x1++)
#endif

		for (x1 = x-(penSize+1)/2; x1<=x+penSize/2; x1++)
		{
			if (patCode & 0x10)
			{ /* Square */
				plotPatternPoint();
			}
			else
			{ /* Circle */
				if ((circles[patCode&7][circlePos>>3] >> (7-(circlePos&7)))&1)
					plotPatternPoint();
				circlePos++;
			}
		}
	}
}

/**************************************************************************
** plotBrush
**
** Plots points and various brush patterns.
**************************************************************************/
void plot_brush(void)
{
	UINT8 x1, y1;

	while (42)
	{
		if(patCode&0x20)
		{
			if((patNum=gbyte) >= 0xF0)
				break;
			patNum=(patNum>>1&0x7f);
		}

		if((x1=gbyte)>=0xF0)
			break;

		if((y1=gbyte)>=0xF0)
			break;

		plotPattern(x1, y1);
   	}
   	foffs--;
}


UINT8* convert_v2_v3_pic (UINT8 *data, UINT32 len)
{
	UINT8	d, old = 0, x, *in, *xdata, *out, mode = 0;
	UINT32	i, ulen;

	xdata = (UINT8*)malloc (len + len / 2);

	out = xdata;
	in = data;

	for (i = ulen = 0; i < len; i++, ulen++)
	{
		d = *in++;

		*out++ = x = mode ?
			((d & 0xF0) >> 4) + ((old & 0x0F) << 4) : d;

		if (x == 0xFF) {
			ulen++;
			break;
		}

		if (x == 0xF0 || x == 0xF2)
		{
			if (mode) {
				*out++ = d & 0x0F;
				ulen++;
			} else {
				d = *in++;
				*out++ = (d & 0xF0) >> 4;
				i++, ulen++;
			}

			mode = !mode;
		}

		old = d;
	}

	free (data);
	xdata = realloc (xdata, ulen);

	return xdata;
}


/**************************************************************************
** splitPriority
**
** Purpose: To split the priority colours from the control colours. It
** determines the priority information for pixels that are overdrawn by
** control lines by the same method used in Sierras interpreter (at this
** stage). This could change later on.
**************************************************************************/
void splitPriority (UINT16 resnum)
{
	UINT16 x, y;
	register UINT8 *p, *c;

	_D (("()"));

	p = pictures[resnum].xdata;
	c = pictures[resnum].cdata;

	for (x = 0; x < _WIDTH; x++) {
		for (y = 0; y < _HEIGHT; y++, p++, c++) {
			if (*p == 3) {
				*c = *p;
#if 0
				*p = 4;
#endif
		 	}

			if (*p >= 3)
				continue;

			*c = *p;
#if 0
			for (pp = p + _WIDTH, dy = y + 1;
				dy < _HEIGHT; dy++, pp += _WIDTH) {
				if (*pp > 3) {
					*p = *pp;
					break;
				}
			}
#endif
		}
	}
}

