/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __AGI
#define __AGI

#ifdef __cplusplus
extern "C"{
#endif

typedef struct AGI_DIR
{
	UINT8	volume;
	UINT32	offset;
	UINT32	len;
	UINT32	clen;
	UINT8	flags;	/*	0 = not in mem, can be freed
						1 = in mem, can be released
						2 = not in mem, cant be released
						3 = in mem, cant be released
						0x40 = was compressed
					*/
} AGI_DIR;

typedef struct AGI_LOADER
{
	UINT8	version;
	UINT32	int_version;

	UINT16	(*init)(void);
	UINT16	(*deinit)(void);
	UINT16	(*detect_game)(UINT8 *gname);
	UINT16	(*load_resource)(UINT8 restype, UINT16 resnum);
	UINT16	(*unload_resource)(UINT8 restype, UINT16 resnum);
} AGI_LOADER;

extern	UINT8	*null_msg;
extern	UINT8	*gdir;
extern	UINT8	*gname;
extern	UINT8	*gid;
extern	UINT8	path[];
extern	UINT8	horizon;

extern	AGI_LOADER	*loader;
extern	AGI_DIR		dir_logic[];
extern	AGI_DIR		dir_pic[];
extern	AGI_DIR		dir_view[];
extern	AGI_DIR		dir_sound[];

extern	UINT8		flags[];
extern	UINT8		vars[];

extern	UINT16		ego_in_new_room;
extern	UINT8		control_mode;
extern	UINT8		quit_prog_now;
extern	UINT8		status_line;
extern	UINT8		line_status;
extern	UINT8		line_user_input;
extern	UINT8		line_min_print;
extern	UINT8		allow_kyb_input;
extern	UINT8		clock_enabled;
extern	UINT8		timed_message_box;
extern	UINT16		message_box_key;
extern	UINT32		game_flags;

extern	UINT16		agi_init(void);
extern	UINT16		agi_deinit(void);


#ifdef __cplusplus
};
#endif
#endif
