/*
	config.c

	read .gxanimrc file and parse out details

*/

#include "header.h"

I8 get_config (xcontrol *control)
{
	FILE *fp;

	char *buf = _NULL;
	char *word = _NULL;

	/* set default defaults */

	control->defaults->xanimprog = dalloc(control->defaults->xanimprog, strlen(XANIMPROG));
	sprintf(control->defaults->xanimprog, "%s", XANIMPROG);

	control->defaults->defdir = dalloc(control->defaults->defdir, strlen(DEFDIR));
	sprintf(control->defaults->defdir, "%s", DEFDIR);
	
	control->defaults->volume = VOLUME;
	control->defaults->playonstart = PLAY_ON_START;
	control->defaults->gamma = GAMMA;
	control->defaults->scale = SCALE;
	control->defaults->holdonend = HOLDONEND;
	control->defaults->syncframe = SYNCFRAME;
	control->defaults->floydstein = FLOYDSTEIN;
	control->defaults->verbose = VERBOSE;

	if (buf = find_home_path(buf, RCFILE)) {
		if (!(fp = fopen(buf, "r"))) {
			fp = fopen(GLOBAL_RCFILE, "r");
		}
	} else
		fp = fopen(GLOBAL_RCFILE, "r");

	
	if (fp) {

		while (!feof(fp)) {

			fgets(buf, BUFLEN, fp);
									
			/* skip blank and comment lines */

			if (buf[0] != '#' && strlen(buf) > 0) {

				if (word = extr_string(buf, "syncframe", _NULL)) {
					control->defaults->syncframe = TRUE;
				}

				if (word = extr_string(buf, "xanimprog ", _NULL)) {
					control->defaults->xanimprog = dalloc(control->defaults->xanimprog, strlen(word));
					memcpy(control->defaults->xanimprog, word, strlen(word));
				}

				if (word = extr_string(buf, "playonstart", _NULL)) {
					control->defaults->playonstart = TRUE;
				}
				
				if (word = extr_string(buf, "floydstein", _NULL)) {
					control->defaults->floydstein = TRUE;
				}
				
				if (word = extr_string(buf, "defdir ", _NULL)) {
					control->defaults->defdir = dalloc(control->defaults->defdir, strlen(word));
					sprintf(control->defaults->defdir, "%s", word);
				}

				if (word = extr_string(buf, "scale ", _NULL)) {
					sscanf(word, "%f", &control->defaults->scale);
				}

				if (word = extr_string(buf, "gamma ", _NULL)) {
					sscanf(word, "%f", &control->defaults->gamma);
				}

				if (word = extr_string(buf, "holdonend", _NULL)) {
					control->defaults->holdonend = TRUE;
				}

				if (word = extr_string(buf, "verbose", _NULL)) {
					control->defaults->verbose = TRUE;
				}
								
			}
		}

		dfree(word);
		fclose(fp);
	} else	{
		fprintf(stderr, "\nUnable to locate %s file.\n", buf);
		return FALSE;		
	}

	dfree(buf);

	return TRUE;
}


I8 save_config (GtkWidget *window, xcontrol *control) 
{

	FILE *fp;
	char *buf = _NULL;

	get_prefs(window, control);
	move_defaults(control);
	buf = find_home_path(buf, RCFILE);
	
	
	/* write the .rc file if possible */

	if (fp = fopen(buf, "w")) {

		fprintf(fp, "##\n##  GXAnim Configuration File\n");
		fprintf(fp, "##  (c) 1999 by Rob Warren (http://www.iag.net/~aleris)\n");
		fprintf(fp, "##  Version 0.50\n");
		fprintf(fp, "##\n##  Do not edit - this file automatically generated!\n##\n\n");

		if (control->defaults->verbose)
			fprintf(fp, "verbose\n");
	
		if (control->defaults->syncframe) 
			fprintf(fp, "syncframe\n");

		if (control->defaults->floydstein)
			fprintf(fp, "floydstein\n");

		if (control->defaults->holdonend)
			fprintf(fp, "holdonend\n");

		if (control->defaults->playonstart)
			fprintf(fp, "playonstart\n");		

		fprintf(fp, "scale %6.2f\n", control->defaults->scale);
		fprintf(fp, "gamma %6.2f\n", control->defaults->gamma);
		fprintf(fp, "xanimprog %s\n", control->defaults->xanimprog);
		fprintf(fp, "defdir %s\n", control->defaults->defdir);
	}

	fclose(fp);
	dfree(buf);

	return TRUE;
}

