/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.openxml.DOMFactory;
import org.openxml.DTDDocument;
import org.openxml.dom.EntityImpl;
import org.openxml.dom.ParamEntity;
import org.openxml.parser.BaseParser;
import org.openxml.parser.ParseException;
import org.openxml.source.Holder;
import org.openxml.source.Source;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;

public class DTDParser
extends BaseParser {
    private boolean _internal;
    private int _includeLevel;
    private int _ignoreLevel;
    private boolean _ignoreAll;
    private DTDDocument _docType;

    public DTDParser(Reader reader, String string) {
        this(reader, string, 8, 0);
    }

    public DTDParser(Reader reader, String string, short s, short s2) {
        super(reader, string, s, s2);
    }

    public DTDParser(BaseParser baseParser, Reader reader, String string) {
        super(reader, string, baseParser.getMode(), (short)0);
        if (baseParser instanceof DTDParser) {
            this._document = ((DTDParser)baseParser)._document;
            this._docType = ((DTDParser)baseParser)._docType;
        }
        this.setErrorSink(baseParser);
    }

    private void allowMarkupPE() throws IOException {
        if (this.readChar() == 37) {
            if (this.readTokenName()) {
                String string;
                ParamEntity paramEntity;
                if (this.readChar() != 59) {
                    this.pushBack();
                }
                if ((paramEntity = this._docType.findParamEntity(string = this._tokenText.toString())) == null) {
                    this.error((short)1, "Parameter entity '" + string + "' not found.");
                } else if (paramEntity.isInternal()) {
                    this.pushBack(32);
                    string = paramEntity.getInternal();
                    int n = string.length();
                    while (n-- > 0) {
                        this.pushBack(string.charAt(n));
                    }
                    this.pushBack(32);
                } else {
                    this.error((short)1, "Cannot used external parameter entity '" + string + "' inside markup.");
                }
            } else {
                this.pushBack(37);
            }
        } else {
            this.pushBack();
        }
    }

    private boolean canDeclare() {
        return !this._ignoreAll && this._ignoreLevel == 0;
    }

    private boolean canStore() {
        return this.isMode((short)64) && !this._ignoreAll && this._ignoreLevel == 0;
    }

    protected Attr createAttribute(String string) {
        throw new IllegalStateException("Unexpected call to 'createAttribute' for DTDParser.");
    }

    private boolean isInternal() {
        return this._internal;
    }

    private final void parseDeclaration() throws ParseException, IOException {
        String string;
        String string2 = null;
        String string3 = null;
        Node node = null;
        if (this._tokenText.equals("ENTITY")) {
            boolean bl;
            while (this.isSpace(this.readChar())) {
            }
            boolean bl2 = bl = this._curChar == 37;
            if (bl) {
                bl = true;
                while (this.isSpace(this.readChar())) {
                }
            }
            this.pushBack();
            if (this.readTokenName()) {
                string = this._tokenText.toString();
                while (this.isSpace(this.readChar())) {
                }
                this.pushBack();
                if (this.canReadName("SYSTEM")) {
                    while (this.isSpace(this.readChar())) {
                    }
                    this.pushBack();
                    if (this.readTokenQuotedPE()) {
                        string2 = this._tokenText.toString();
                    } else {
                        this.error((short)1, "Entity declaration missing system identifier.");
                    }
                } else if (this.canReadName("PUBLIC")) {
                    while (this.isSpace(this.readChar())) {
                    }
                    this.pushBack();
                    if (this.readTokenQuotedPE()) {
                        string3 = this._tokenText.toString();
                        while (this.isSpace(this.readChar())) {
                        }
                        this.pushBack();
                        if (this.readTokenQuotedPE()) {
                            string2 = this._tokenText.toString();
                        } else {
                            this.error((short)1, "Entity declaration missing system identifier.");
                        }
                    } else {
                        this.error((short)1, "Entity declaration missing public identifier.");
                    }
                } else {
                    if (this.canReadName("CDATA")) {
                        while (this.isSpace(this.readChar())) {
                        }
                        this.pushBack();
                    }
                    if (this.readTokenQuoted()) {
                        if (this.canDeclare()) {
                            if (bl) {
                                node = this._docType.createParamEntity(string, this._tokenText.toString());
                            } else {
                                this.parseTokenPE();
                                node = this._docType.createEntity(string, this._tokenText.toString());
                            }
                        }
                    } else {
                        this.error((short)1, "Entity is improperly declared (missing quoted value or external identifiers).");
                    }
                }
                if (string2 != null && this.canDeclare()) {
                    if (bl) {
                        node = this._docType.createParamEntity(string, string2, string3);
                    } else {
                        while (this.isSpace(this.readChar())) {
                        }
                        this.pushBack();
                        if (this.canReadName("NDATA")) {
                            while (this.isSpace(this.readChar())) {
                            }
                            this.pushBack();
                            if (this.readTokenQuotedPE()) {
                                String string4 = this._tokenText.toString();
                                node = this._docType.createEntity(string, string2, string3, string4);
                                if (this._docType.findNotation(string4) == null) {
                                    this.error((short)1, "Unparsed entity declaration refers to an undeclared notation.");
                                }
                            } else {
                                this.error((short)1, "Unparsed entity declaration missing notation identifier.");
                            }
                        } else {
                            node = this._docType.createEntity(string, string2, string3);
                        }
                    }
                }
                if (node != null && this.canDeclare()) {
                    if (this.canStore()) {
                        this._document.appendChild(node);
                    }
                    if (bl) {
                        this._docType.declareParamEntity((ParamEntity)node);
                    } else {
                        this._docType.declareEntity((EntityImpl)node);
                    }
                }
            } else {
                this.error((short)1, "Entity declaration missing proper entity name.");
            }
        } else if (this._tokenText.equals("NOTATION")) {
            while (this.isSpace(this.readChar())) {
            }
            this.pushBack();
            this.allowMarkupPE();
            if (this.readTokenName()) {
                string = this._tokenText.toString();
                while (this.isSpace(this.readChar())) {
                }
                this.pushBack();
                if (this.canReadName("SYSTEM")) {
                    while (this.isSpace(this.readChar())) {
                    }
                    this.pushBack();
                    if (this.readTokenQuotedPE()) {
                        string2 = this._tokenText.toString();
                    } else {
                        this.error((short)1, "Notation declaration missing system identifier.");
                    }
                } else if (this.canReadName("PUBLIC")) {
                    while (this.isSpace(this.readChar())) {
                    }
                    this.pushBack();
                    if (this.readTokenQuotedPE()) {
                        string3 = this._tokenText.toString();
                        while (this.isSpace(this.readChar())) {
                        }
                        this.pushBack();
                        if (this.readTokenQuotedPE()) {
                            string2 = this._tokenText.toString();
                        }
                    } else {
                        this.error((short)1, "Notation declaration missing public identifier.");
                    }
                }
                if (string2 != null || string3 != null) {
                    node = this._docType.createNotation(string, string2, string3);
                    if (this.canDeclare()) {
                        if (this.canStore()) {
                            this._document.appendChild(node);
                        }
                        this._docType.declareNotation((Notation)node);
                    }
                }
            } else {
                this.error((short)1, "Notation declaration missing proper notation name.");
            }
        } else if (!this._tokenText.equals("ELEMENT") && !this._tokenText.equals("ATTLIST")) {
            this.error((short)1, "Unknown declaration type.");
        }
        this.skipDeclComment();
        this.readChar();
        while (this._curChar != -1 && this._curChar != 62) {
            this.skipDeclComment();
            this.readChar();
        }
        if (this._curChar == -1) {
            this.error((short)1, "DTD declaration terminated prematurely.");
        }
    }

    public Document parseDocument() throws ParseException {
        this._docType = DOMFactory.createDTDDocument();
        this._document = this._docType;
        this._internal = false;
        try {
            try {
                int n = this.readTokenDTD();
                if (n == 5 && this._tokenText.length() > 3 && this._tokenText.startsWith("xml")) {
                    this.parseDocumentDecl(false);
                    n = this.readTokenDTD();
                }
                while (this.parseNextDecl(n)) {
                    n = this.readTokenDTD();
                }
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (RuntimeException runtimeException) {
                this.error(runtimeException);
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var3_5 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.close();
            throw throwable;
        }
        return this._document;
    }

    public DTDDocument parseExternalSubset(DTDDocument dTDDocument) throws ParseException {
        if (dTDDocument == null) {
            throw new NullPointerException("Argument 'dtd' is null.");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        this._document = dTDDocument;
        this._docType = dTDDocument;
        this._internal = false;
        try {
            try {
                int n = this.readTokenDTD();
                while (this.parseNextDecl(n)) {
                    n = this.readTokenDTD();
                }
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var4_5 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.close();
            throw throwable;
        }
        return (DTDDocument)this._document;
    }

    public DTDDocument parseInternalSubset(DTDDocument dTDDocument) throws ParseException {
        if (dTDDocument == null) {
            throw new NullPointerException("Argument 'dtd' is null.");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        this._document = dTDDocument;
        this._docType = dTDDocument;
        this._internal = true;
        try {
            int n = this.readTokenDTD();
            while (this.parseNextDecl(n)) {
                n = this.readTokenDTD();
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            this.error(exception);
        }
        return (DTDDocument)this._document;
    }

    private boolean parseNextDecl(int n) throws ParseException, IOException {
        String string = null;
        if (n == -1) {
            if (this.isInternal() && (this._ignoreLevel > 0 || this._includeLevel > 0)) {
                this.error((short)1, "Conditional section terminated prematurely at end of file.");
            }
            return false;
        }
        if (n == 9) {
            if (this._ignoreLevel > 0) {
                --this._ignoreLevel;
            } else if (this._includeLevel > 0) {
                --this._includeLevel;
            } else {
                this.error((short)1, "Unbalanced ']]>' does not match an open conditional section.");
            }
        } else if (n == 10) {
            string = this._tokenText.toString();
            ParamEntity paramEntity = this._docType.findParamEntity(string);
            if (paramEntity == null) {
                this.error((short)1, "Parameter entity '" + string + "' not found.");
            } else if (this.isInternal() && !paramEntity.isInternal()) {
                this.error((short)1, "External parameter entity '" + string + "' cannot be used in internal subset.");
            } else if (paramEntity.getState() == 0) {
                this.parseParamEntity(paramEntity);
                if (paramEntity.getState() == 3) {
                    this._ignoreAll = true;
                }
            }
        } else if (n == 4) {
            if (this.canStore() && this.isMode((short)2)) {
                Comment comment = this._document.createComment(this._tokenText.toString());
                this._document.appendChild(comment);
            }
        } else if (n == 5) {
            if (this.canStore() && this.isMode((short)1)) {
                string = this.slicePITokenText();
                ProcessingInstruction processingInstruction = this._document.createProcessingInstruction(string, this._tokenText.toString());
                this._document.appendChild(processingInstruction);
            }
        } else if (n == 8 || n == 6) {
            if (n == 6) {
                this.error((short)1, "CDATA section not supported in DTD.");
            } else if (this.isInternal()) {
                this.error((short)1, "Conditional sections not supported in internal DTD subset.");
            } else {
                this.allowMarkupPE();
                while (this.isSpace(this.readChar())) {
                    this.allowMarkupPE();
                }
                this.pushBack();
                this.readTokenName();
                if (this._tokenText.equals("IGNORE")) {
                    ++this._ignoreLevel;
                } else {
                    if (!this._tokenText.equals("INCLUDE")) {
                        this.error((short)1, "Conditional section missing 'INCLUDE' or 'IGNORE' directive.");
                    }
                    if (this._ignoreLevel > 0) {
                        ++this._ignoreLevel;
                    } else {
                        ++this._includeLevel;
                    }
                }
                while (this.isSpace(this.readChar())) {
                }
                if (this._curChar != 91) {
                    this.error((short)1, "Condition section missing opening '['.");
                    this.pushBack();
                }
            }
        } else if (n == 7) {
            this.parseDeclaration();
        } else if (n != 0 || !this.isTokenAllSpace()) {
            this.error((short)1, "Character data not supported in DTD subset.");
        }
        return true;
    }

    public final Node parseNode(Node node) throws ParseException {
        throw new IllegalStateException("Node parsing not supported by DTDParser.");
    }

    public DTDDocument parseParamEntity(DTDDocument dTDDocument, boolean bl) throws ParseException {
        if (dTDDocument == null) {
            throw new NullPointerException("Argument 'dtd' is null.");
        }
        if (this.isClosed()) {
            throw new IllegalStateException("Parser has been closed and may not be used anymore.");
        }
        this._document = dTDDocument;
        this._docType = dTDDocument;
        this._internal = false;
        try {
            try {
                int n = this.readTokenDTD();
                if (bl && n == 5 && this._tokenText.length() > 3 && this._tokenText.startsWith("xml")) {
                    this.parseDocumentDecl(false);
                    n = this.readTokenDTD();
                }
                while (this.parseNextDecl(n)) {
                    n = this.readTokenDTD();
                }
            }
            catch (ParseException parseException) {
                throw parseException;
            }
            catch (Exception exception) {
                this.error(exception);
            }
            Object var5_6 = null;
            this.close();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.close();
            throw throwable;
        }
        return (DTDDocument)this._document;
    }

    protected final ParamEntity parseParamEntity(ParamEntity paramEntity) throws ParseException {
        Reader reader = null;
        switch (paramEntity.getState()) {
            case 2: {
                return paramEntity;
            }
            case 3: {
                return null;
            }
            case 1: {
                this.error((short)1, "Parameter entity '" + paramEntity.getNodeName() + "' contains circular reference.");
                return null;
            }
            case 0: {
                try {
                    DTDParser dTDParser;
                    if (paramEntity.isInternal()) {
                        reader = new StringReader(paramEntity.getInternal());
                        dTDParser = new DTDParser(this, reader, String.valueOf(this.getSourceURI()) + " Entity: " + paramEntity.getNodeName());
                    } else {
                        Source source = DOMFactory.newSource();
                        source.setURI(paramEntity.getSystemId());
                        source.setPublicId(paramEntity.getPublicId());
                        source.setDocClass(Source.DOCUMENT_DTD);
                        Holder holder = DOMFactory.getHolderFinder().findHolder(source, false);
                        if (holder != null) {
                            reader = holder.getReader();
                        }
                        if (reader == null || holder == null) {
                            paramEntity.setState((short)3);
                            this.error((short)1, "External parameter entity '" + paramEntity.getNodeName() + "' could not be found.");
                            return null;
                        }
                        dTDParser = new DTDParser(this, reader, source.toString());
                    }
                    paramEntity.setState((short)1);
                    dTDParser.parseParamEntity(this._docType, paramEntity.isInternal());
                    paramEntity.setState((short)2);
                }
                catch (ParseException parseException) {
                    paramEntity.setState((short)3);
                    return null;
                }
                catch (IOException iOException) {
                    paramEntity.setState((short)3);
                    this.error((short)1, "External parameter entity '" + paramEntity.getNodeName() + "' could not be found. Reason:" + iOException.getMessage());
                    return null;
                }
                return paramEntity;
            }
        }
        throw new IllegalStateException("Parameter entity in illegal state.");
    }

    private void parseTokenPE() throws ParseException {
        int n = 0;
        while (n < this._tokenText.length()) {
            int n2;
            if (this._tokenText.charAt(n) == '%' && (n2 = n + 1) < this._tokenText.length() && this.isNamePart(this._tokenText.charAt(n2), true)) {
                ParamEntity paramEntity;
                ++n2;
                while (n2 < this._tokenText.length() && this.isNamePart(this._tokenText.charAt(n2), false)) {
                    ++n2;
                }
                String string = this._tokenText.toString(n + 1, n2);
                if (n2 < this._tokenText.length() && this._tokenText.charAt(n2) == ';') {
                    ++n2;
                }
                if ((paramEntity = this._docType.findParamEntity(string)) == null) {
                    this.error((short)1, "Parameter entity '" + string + "' not found.");
                } else if (!paramEntity.isInternal()) {
                    this.error((short)1, "Cannot used external parameter entity '" + string + "' inside markup.");
                } else {
                    this._tokenText.replace(n, n2, paramEntity.getInternal());
                    --n;
                }
            }
            ++n;
        }
    }

    private final int readTokenDTD() throws ParseException, IOException {
        this.readChar();
        if (this._curChar == 60) {
            return this.readTokenMarkup();
        }
        if (this._curChar == 37) {
            return this.readTokenPERef();
        }
        if (this._curChar == -1) {
            return -1;
        }
        if (this._curChar == 93) {
            if (this.isInternal()) {
                this.pushBack();
                return -1;
            }
            if (this.readChar() == 93) {
                if (this.readChar() == 62) {
                    return 9;
                }
                this.pushBack();
                this._curChar = 93;
            }
            this.pushBack();
            this._curChar = 93;
            this._tokenText.setLength(1);
            this._tokenText.setCharAt(0, ']');
            return 0;
        }
        this._tokenText.setLength(0);
        while (this._curChar != -1 && this._curChar != 60 && this._curChar != 37 && this._curChar != 93) {
            this._tokenText.append((char)this._curChar);
            this.readChar();
        }
        if (this._curChar != -1) {
            this.pushBack();
        }
        return 0;
    }

    private boolean readTokenQuotedPE() throws ParseException, IOException {
        if (this.readTokenQuoted()) {
            this.parseTokenPE();
            return true;
        }
        return false;
    }

    private void skipDeclComment() throws ParseException, IOException {
        if (this.readChar() == 45) {
            if (this.readChar() == 45) {
                while (this.readChar() != -1) {
                    if (this._curChar != 45 || this.readChar() != 45) continue;
                    return;
                }
                this.error((short)1, "Declaration comment terminated permaturely.");
            }
            this.pushBack();
            this._curChar = 45;
        }
        this.pushBack();
    }
}

