/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.source.holders;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import org.openxml.source.Holder;
import org.openxml.source.Source;
import org.openxml.source.XCatalog;
import org.openxml.source.holders.HolderFactoryImpl;
import org.openxml.source.holders.SourceImpl;
import org.openxml.source.holders.XCatalogDelegate;
import org.openxml.source.holders.XCatalogFactory;
import org.openxml.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class XCatalogImpl
extends HolderFactoryImpl
implements XCatalog {
    private String _uri;
    private Hashtable _maps;
    private Hashtable _remaps;
    private Vector _extends;
    private Vector _delegates;

    XCatalogImpl() {
        this._uri = "Dummy catalog";
    }

    XCatalogImpl(String string) throws IOException {
        this._uri = string;
        SourceImpl sourceImpl = new SourceImpl(string, null, null, null);
        Document document = ((Source)sourceImpl).getDocument();
        if (document == null) {
            if (((Source)sourceImpl).getLastException() != null) {
                throw new IOException("Could not load the document [" + string + "] into memory - parser exception.");
            }
            throw new IOException("Could not load the document [" + string + "] into memory - document not found.");
        }
        if (((Source)sourceImpl).getLastException() != null) {
            Log.error("XCatalog: Encountered parsing errors while loading [" + string + "]");
            Log.error(((Source)sourceImpl).getLastException());
        }
        this.loadCatalog(document, string);
    }

    XCatalogImpl(Document document, String string) {
        this._uri = string;
        this.loadCatalog(document, string);
    }

    private String getAttribute(Element element, String string) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            Node node = namedNodeMap.item(n);
            if (node.getNodeName().equalsIgnoreCase(string)) {
                return node.getNodeValue();
            }
            ++n;
        }
        return null;
    }

    private void loadCatalog(Document document, String string) {
        Node node;
        Element element;
        URL uRL = null;
        if (string != null) {
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Log.debug("XCatalog.loadCatalog: Document [" + string + "]: URI cannot be used as base URL");
            }
        }
        if ((element = document.getDocumentElement()) != null && element.getTagName().equals("xcatalog")) {
            node = element.getFirstChild();
            if (element.getAttribute("title") != null) {
                Log.debug("XCatalog.loadCatalog: Catalog [" + string + "] described as: [" + element.getAttribute("title") + "]");
            }
        } else {
            Log.error("XCatalog.loadCatalog: Document [" + string + "]: Root element [xcatalog] not found");
            node = document.getFirstChild();
        }
        while (node != null) {
            if (node.getNodeType() == 1) {
                XCatalog xCatalog;
                String string2;
                String string3;
                element = (Element)node;
                if (element.getTagName().equals("base")) {
                    string3 = this.getAttribute(element, "href");
                    if (string3 != null) {
                        try {
                            uRL = new URL(string3);
                            Log.debug("XCatalog.loadCatalog: New base URL [" + uRL + "]");
                        }
                        catch (MalformedURLException malformedURLException) {
                            Log.error("XCatalog.loadCatalog: Document [" + string + "]: Malformed base URL [" + string3 + "] -- ignoring rest of document");
                            return;
                        }
                    } else {
                        Log.error("XCatalog.loadCatalog: Document [" + string + "]: <base> element missing required attribute");
                    }
                } else if (element.getTagName().equals("map")) {
                    string3 = this.getAttribute(element, "public");
                    string2 = this.makeURI(this.getAttribute(element, "href"), uRL);
                    if (string3 != null && string2 != null) {
                        if (this._maps == null) {
                            this._maps = new Hashtable();
                        }
                        Log.debug("XCatalog.loadCatalog: Added mapping from [" + string3 + "] to [" + string2 + "]");
                        this._maps.put(string3, string2);
                    } else {
                        Log.error("XCatalog.loadCatalog: Document [" + string + "]: <map> element missing required attribute");
                    }
                } else if (element.getTagName().equals("remap")) {
                    string3 = this.getAttribute(element, "system");
                    string2 = this.makeURI(this.getAttribute(element, "href"), uRL);
                    if (string3 != null && string2 != null) {
                        if (this._remaps == null) {
                            this._remaps = new Hashtable();
                        }
                        Log.debug("XCatalog.loadCatalog: Added re-mapping from  [" + string3 + "] to [" + string2 + "]");
                        this._remaps.put(string3, string2);
                    } else {
                        Log.error("XCatalog.loadCatalog: Document [" + string + "]: <remap> element missing required attribute");
                    }
                } else if (element.getTagName().equals("delegate")) {
                    string3 = this.getAttribute(element, "public");
                    string2 = this.makeURI(this.getAttribute(element, "href"), uRL);
                    if (string3 != null && string2 != null) {
                        if (this._delegates == null) {
                            this._delegates = new Vector();
                        }
                        Log.debug("XCatalog.loadCatalog: Added delegate [" + string2 + "] for prefixes [" + string3 + "]");
                        xCatalog = XCatalogFactory.findCatalog(string2);
                        if (xCatalog != null) {
                            this._delegates.addElement(new XCatalogDelegate(string3, xCatalog));
                        }
                    } else {
                        Log.error("XCatalog.loadCatalog: Document [" + string + "]: <delegate> element missing required attribute");
                    }
                } else if (element.getTagName().equals("extend")) {
                    string2 = this.makeURI(this.getAttribute(element, "href"), uRL);
                    if (string2 != null) {
                        if (this._extends == null) {
                            this._extends = new Vector();
                        }
                        Log.debug("XCatalog.loadCatalog: Added extending catalog [" + string2 + "]");
                        xCatalog = XCatalogFactory.findCatalog(string2);
                        if (xCatalog != null) {
                            this._extends.addElement(xCatalog);
                        }
                    } else {
                        Log.error("XCatalog.loadCatalog: Document [" + string + "]: <extend> element missing required attribute");
                    }
                } else {
                    Log.error("XCatalog.loadCatalog: Document [" + string + "]: Element [" + element.getTagName() + "] not recognized -- ignored");
                }
            }
            node = node.getNextSibling();
        }
        Log.debug("XCatalog.loadCatalog: Document [" + string + "]: Loaded catalog into memory");
    }

    private String makeURI(String string, URL uRL) {
        block5: {
            if (string != null) {
                try {
                    URL uRL2 = new URL(string);
                    return uRL2.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    if (uRL == null) break block5;
                    try {
                        URL uRL3 = new URL(uRL, string);
                        return uRL3.toString();
                    }
                    catch (MalformedURLException malformedURLException2) {}
                    {
                    }
                }
            }
        }
        return string;
    }

    public String mapPublicId(String string) {
        String string2;
        if (string != null && (string2 = this.mapPublicId2(string)) != null) {
            return this.remapURI(string2);
        }
        return null;
    }

    private String mapPublicId2(String string) {
        int n;
        String string2;
        if (this._maps != null && (string2 = (String)this._maps.get(string)) != null) {
            Log.debug("XCatalog.mapPublicId: Public id [" + string + "]: Mapped by catalog [" + this._uri + "] to [" + string2 + "]");
            return string2;
        }
        if (this._delegates != null) {
            n = 0;
            while (n < this._delegates.size()) {
                XCatalogDelegate xCatalogDelegate = (XCatalogDelegate)this._delegates.elementAt(n);
                if (xCatalogDelegate.doesMatch(string)) {
                    Log.debug("XCatalog.mapPublicId: Delegating search of [" + string + "] to catalog [" + xCatalogDelegate.getCatalog() + "]");
                    string2 = xCatalogDelegate.getCatalog().mapPublicId(string);
                    if (string2 != null) {
                        return string2;
                    }
                }
                ++n;
            }
        }
        if (this._extends != null) {
            n = 0;
            while (n < this._extends.size()) {
                string2 = ((XCatalog)this._extends.elementAt(n)).mapPublicId(string);
                if (string2 != null) {
                    return string2;
                }
                ++n;
            }
            Log.debug("XCatalog.mapPublicId: Public id [" + string + "]: Not matched in extended catalogs");
        } else {
            Log.debug("XCatalog.mapPublicId: Public id [" + string + "]: Not matched and no extended catalogs");
        }
        return null;
    }

    public String mapSource(String string, String string2) {
        String string3;
        if (string != null && (string3 = this.mapPublicId2(string)) != null) {
            return this.remapURI(string3);
        }
        if (string2 != null) {
            return this.remapURI(string2);
        }
        return null;
    }

    public Holder newHolder(Source source) {
        String string = this.mapSource(source.getPublicId(), source.getURI());
        if (string != null && !string.equals(source.getURI())) {
            source = new SourceImpl(string, null, source.getEncoding(), source.getDocClass());
            return this.findHolder(source);
        }
        return null;
    }

    public String remapURI(String string) {
        String string2;
        if (this._remaps != null && (string2 = (String)this._remaps.get(string)) != null) {
            Log.debug("XCatalog.remapURI: URI [" + string + "]: Remapped by catalog [" + this._uri + "] to [" + string2 + "]");
            return string2;
        }
        if (this._extends != null) {
            int n = 0;
            while (n < this._extends.size()) {
                string2 = ((XCatalog)this._extends.elementAt(n)).remapURI(string);
                if (string != string2) {
                    Log.debug("XCatalog.remapURI: URI [" + string + "]: Remapped by extended catalog to [" + string2 + "]");
                    return string2;
                }
                ++n;
            }
        }
        return string;
    }
}

