/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.x3p.processors;

import java.util.StringTokenizer;
import java.util.Vector;
import org.openxml.util.Log;
import org.openxml.util.Resources;
import org.openxml.x3p.ProcessContext;
import org.openxml.x3p.Processor;
import org.openxml.x3p.ProcessorEngine;
import org.openxml.x3p.ProcessorEngineCreator;
import org.openxml.x3p.processors.ChainProcessor;

public class ChainProcessorCreator
implements ProcessorEngineCreator {
    private Vector _factories;

    public ChainProcessorCreator(String string) {
        this.appendEngines(string);
    }

    public ChainProcessorCreator(ProcessorEngineCreator[] processorEngineCreatorArray) {
        int n = 0;
        while (n < processorEngineCreatorArray.length) {
            this.appendEngine(processorEngineCreatorArray[n]);
            ++n;
        }
    }

    public void appendEngine(ProcessorEngineCreator processorEngineCreator) {
        if (this._factories == null) {
            this._factories = new Vector();
        }
        this._factories.addElement(processorEngineCreator);
    }

    public void appendEngines(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";:");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                ProcessorEngineCreator processorEngineCreator = (ProcessorEngineCreator)Class.forName(string2).newInstance();
                this.appendEngine(processorEngineCreator);
            }
            catch (Exception exception) {
                Log.error(exception);
            }
        }
    }

    public ProcessorEngine createEngine(ProcessContext processContext) {
        return (ProcessorEngine)((Object)this.createProcessor(null));
    }

    public Processor createProcessor(Object object) {
        Object[] objectArray;
        if (this._factories == null) {
            objectArray = new ProcessorEngineCreator[]{};
        } else {
            objectArray = new ProcessorEngineCreator[this._factories.size()];
            this._factories.copyInto(objectArray);
        }
        return new ChainProcessor(object, (ProcessorEngineCreator[])objectArray);
    }

    public void insertEngine(ProcessorEngineCreator processorEngineCreator, int n) {
        if (this._factories == null) {
            this._factories = new Vector();
        }
        this._factories.insertElementAt(processorEngineCreator, n);
    }

    public ProcessorEngineCreator item(int n) {
        if (this._factories != null || n < 0 || n >= this._factories.size()) {
            return null;
        }
        return (ProcessorEngineCreator)this._factories.elementAt(n);
    }

    public int length() {
        if (this._factories != null) {
            return this._factories.size();
        }
        return 0;
    }

    public void removeEngine(ProcessorEngineCreator processorEngineCreator) {
        if (this._factories != null) {
            this._factories.removeElement(processorEngineCreator);
        }
    }

    public String toString() {
        if (this._factories.isEmpty()) {
            return Resources.message("Processor008");
        }
        String string = "ChainProcessorCreator [" + this._factories.firstElement().toString();
        int n = 0;
        while (n < this._factories.size()) {
            string = String.valueOf(string) + ", " + this._factories.elementAt(n).toString();
            ++n;
        }
        return String.valueOf(string) + "]";
    }
}

