/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.scripting;

import FESI.Data.ESWrapper;
import FESI.Data.FunctionPrototype;
import FESI.Data.JSWrapper;
import FESI.jslib.JSException;
import FESI.jslib.JSFunction;
import FESI.jslib.JSFunctionAdapter;
import FESI.jslib.JSGlobalObject;
import FESI.jslib.JSObject;
import FESI.jslib.JSUtil;
import com.kvisco.xsl.ProcessorCallback;
import com.kvisco.xsl.ScriptHandler;
import com.kvisco.xsl.XSLScript;
import java.util.Hashtable;
import org.w3c.dom.Node;

public class ECMAScriptHandler
implements ScriptHandler {
    private static final String NITIALIATION_ERROR = "ECMAScript initialization error";
    private static final String UNINITIALIZED_ERROR = "ECMAScript environment has not been initialized.";
    public static final String ECMASCRIPT = "ECMAScript";
    private static String[] jsExtensions = new String[]{"FESI.Extensions.JavaAccess", "FESI.Extensions.BasicIO", "FESI.Extensions.OptionalRegExp"};
    JSGlobalObject jsGlobal = null;
    ProcessorCallback pc = null;
    Hashtable namespaces = null;

    public ECMAScriptHandler() {
    }

    public ECMAScriptHandler(ProcessorCallback processorCallback) {
        this.initialize(processorCallback);
    }

    private void addToResultTree(Object object) {
        if (this.pc == null) {
            return;
        }
        if (object instanceof Node) {
            this.pc.addToResultTree((Node)object);
        }
    }

    public Object call(String string, Object[] objectArray) {
        return this.call(string, objectArray, null);
    }

    public Object call(String string, Object[] objectArray, String string2) {
        if (this.jsGlobal == null) {
            return UNINITIALIZED_ERROR;
        }
        JSGlobalObject jSGlobalObject = this.getNSObject(string2);
        try {
            return jSGlobalObject.call(string, objectArray);
        }
        catch (JSException jSException) {
            return jSException.getMessage();
        }
    }

    public boolean createNamespace(String string) {
        if (string == null) {
            return false;
        }
        JSGlobalObject jSGlobalObject = (JSGlobalObject)this.namespaces.get(string);
        if (jSGlobalObject == null) {
            try {
                jSGlobalObject = JSUtil.makeEvaluator((String[])jsExtensions);
                this.namespaces.put(string, jSGlobalObject);
            }
            catch (JSException jSException) {
                return false;
            }
        }
        return true;
    }

    public Object eval(XSLScript xSLScript, Node node) {
        return this.eval(xSLScript, node, null);
    }

    public Object eval(XSLScript xSLScript, Node node, String string) {
        if (this.jsGlobal == null) {
            return UNINITIALIZED_ERROR;
        }
        JSGlobalObject jSGlobalObject = this.getNSObject(string);
        JSObject jSObject = jSGlobalObject.makeObjectWrapper((Object)node);
        try {
            return jSObject.eval(xSLScript.getData());
        }
        catch (JSException jSException) {
            return jSException.getMessage();
        }
    }

    public Object evalAsFunction(XSLScript xSLScript, Node node) {
        return this.evalAsFunction(xSLScript, node, null);
    }

    public Object evalAsFunction(XSLScript xSLScript, Node node, String string) {
        if (this.jsGlobal == null) {
            return UNINITIALIZED_ERROR;
        }
        JSGlobalObject jSGlobalObject = this.getNSObject(string);
        JSObject jSObject = jSGlobalObject.makeObjectWrapper((Object)node);
        try {
            return jSObject.evalAsFunction(xSLScript.getData());
        }
        catch (JSException jSException) {
            return jSException.getMessage();
        }
    }

    public String getLanguage() {
        return ECMASCRIPT;
    }

    private JSGlobalObject getNSObject(String string) {
        if (string == null) {
            return this.jsGlobal;
        }
        JSGlobalObject jSGlobalObject = (JSGlobalObject)this.namespaces.get(string);
        return jSGlobalObject == null ? this.jsGlobal : jSGlobalObject;
    }

    public boolean hasDefinedFunction(String string, String string2) {
        if (this.jsGlobal == null) {
            return false;
        }
        JSGlobalObject jSGlobalObject = this.getNSObject(string2);
        try {
            Object object = jSGlobalObject.getMember(string);
            if (object instanceof JSWrapper) {
                object = ((JSWrapper)object).getESObject();
                return object instanceof FunctionPrototype;
            }
            return object instanceof JSFunction;
        }
        catch (JSException jSException) {
            return false;
        }
    }

    public void initialize(ProcessorCallback processorCallback) {
        this.namespaces = new Hashtable();
        this.pc = processorCallback;
        try {
            this.jsGlobal = JSUtil.makeEvaluator((String[])jsExtensions);
            JSObject jSObject = this.jsGlobal.makeJSObject();
            this.jsGlobal.setMember("XSLP", (Object)jSObject);
            jSObject.setMember("addToResultTree", (Object)new JSFunctionAdapter(){

                public Object doCall(JSObject jSObject, Object[] objectArray) throws JSException {
                    if (objectArray.length == 0) {
                        throw new JSException("addToResultTree: missing Node argument!");
                    }
                    ECMAScriptHandler.this.addToResultTree(((ESWrapper)objectArray[0]).toJavaObject());
                    return "";
                }
            });
            jSObject.setMember("createElement", (Object)new JSFunctionAdapter(){

                public Object doCall(JSObject jSObject, Object[] objectArray) throws JSException {
                    if (objectArray.length == 0) {
                        throw new JSException("createElement: missing name argument!");
                    }
                    return ECMAScriptHandler.this.pc.createElement(objectArray[0].toString());
                }
            });
            jSObject.setMember("createText", (Object)new JSFunctionAdapter(){

                public Object doCall(JSObject jSObject, Object[] objectArray) throws JSException {
                    if (objectArray.length == 0) {
                        throw new JSException("createText: missing name argument!");
                    }
                    return ECMAScriptHandler.this.pc.createText(objectArray[0].toString());
                }
            });
        }
        catch (JSException jSException) {
            this.pc.printError("Unable to create ECMAScript interpreter: " + (Object)((Object)jSException));
            this.pc.printError("-- xsl:script elements will be ignored.");
        }
    }
}

