/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xml;

import java.io.PrintWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLPrinter {
    public static final int DEFAULT_INDENT = 2;
    private int width = 80;
    private String entityTokens = "&<>";
    private final String AMP_ENTITY = "&amp;";
    private final String GT_ENTITY = "&gt;";
    private final String LT_ENTITY = "&lt;";
    private final String HEX_ENTITY = "&#";
    private final String QUOTE_ENTITY = "&quot;";
    private final String LINEFEED_ENTITY = "&#xA;";
    protected static final String CDATA_END = "]]>";
    protected static final String CDATA_START = "<![CDATA[";
    protected static final String COMMENT_START = "<!-- ";
    protected static final String COMMENT_END = " -->";
    protected static final String DOCTYPE = "DOCTYPE";
    protected static final String PI_START = "<?";
    protected static final String PI_END = "?>";
    protected static final String PUBLIC = "PUBLIC";
    protected static final String SYSTEM = "SYSTEM";
    protected final char AMPERSAND = (char)38;
    protected final char GT = (char)62;
    protected final char LT = (char)60;
    protected final char DASH = (char)45;
    protected final char NULL = '\u0000';
    private final char CR = (char)13;
    private final char LF = (char)10;
    private String version = "1.0";
    private String indent = null;
    private final char indentChar = (char)32;
    private int indentSize = 2;
    private PrintWriter pw = null;
    private boolean unescapeCDATA = false;
    private boolean useEmptyElementShorthand = true;
    private boolean useFormat = false;

    public XMLPrinter(PrintWriter printWriter) {
        this(printWriter, 2);
    }

    public XMLPrinter(PrintWriter printWriter, int n) {
        this.pw = printWriter;
        this.setIndentSize(n);
    }

    public void print(Node node) {
        this.print(node, "");
        this.pw.flush();
    }

    protected boolean print(Node node, String string) {
        if (node == null) {
            return false;
        }
        NodeList nodeList = null;
        switch (node.getNodeType()) {
            case 9: {
                this.printXMLDeclaration(this.version, "UTF-8");
                nodeList = node.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.print(nodeList.item(n), string);
                    ++n;
                }
                break;
            }
            case 2: {
                Attr attr = (Attr)node;
                this.pw.print(attr.getName());
                String string2 = attr.getValue();
                if (string2 == null) break;
                this.pw.print("=\"");
                this.printNormalizedAttrValue(string2);
                this.pw.print('\"');
                break;
            }
            case 1: {
                Node node2;
                Element element = (Element)node;
                String string3 = element.getNodeName();
                NodeList nodeList2 = element.getChildNodes();
                int n = nodeList2.getLength();
                if (n == 0 && this.useEmptyElementShorthand) {
                    this.printEmptyElement(string3, element.getAttributes());
                    break;
                }
                this.printStartTag(string3, element.getAttributes());
                boolean bl = false;
                if (this.useFormat && n > 0 && nodeList2.item(0).getNodeType() != 3) {
                    this.pw.println();
                    bl = true;
                }
                Node node3 = null;
                String string4 = String.valueOf(this.indent) + string;
                int n2 = 0;
                while (n2 < n) {
                    node3 = nodeList2.item(n2);
                    if (this.useFormat && bl) {
                        this.pw.print(string4);
                    }
                    bl = this.print(node3, string4);
                    ++n2;
                }
                if (this.useFormat && node3 != null && node3.getNodeType() != 3) {
                    this.pw.print(string);
                }
                this.printClosingTag(element.getNodeName());
                if (!this.useFormat || (node2 = node.getNextSibling()) != null && node2.getNodeType() == 3) break;
                this.pw.println();
                return true;
            }
            case 3: {
                String string5 = ((Text)node).getData();
                this.printWithXMLEntities(string5);
                break;
            }
            case 4: {
                String string6 = ((CharacterData)node).getData();
                if (this.unescapeCDATA) {
                    this.printWithXMLEntities(string6);
                    break;
                }
                this.printCDATASection(string6);
                break;
            }
            case 8: {
                this.printComment(((CharacterData)node).getData());
                if (!this.useFormat) break;
                return true;
            }
            case 5: {
                this.printEntityReference(node.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
                this.printProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                if (!this.useFormat) break;
                return true;
            }
            case 10: {
                this.printDoctype((DocumentType)node);
                break;
            }
        }
        return false;
    }

    public void printCDATASection(String string) {
        this.pw.print(CDATA_START);
        this.printUTF8Chars(string.toCharArray());
        this.pw.print(CDATA_END);
    }

    public void printClosingTag(String string) {
        this.pw.print("</");
        this.pw.print(string);
        this.pw.print('>');
    }

    public void printComment(String string) {
        this.pw.print(COMMENT_START);
        this.printCommentData(string);
        this.pw.print(COMMENT_END);
        if (this.useFormat) {
            this.pw.println();
        }
    }

    private void printCommentData(String string) {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            if (cArray[n4] == '-' && n3 == 45) {
                this.pw.write(cArray, n2, n);
                n2 = n4;
                this.pw.print(' ');
                n = 1;
            } else {
                n3 = cArray[n4];
                ++n;
            }
            ++n4;
        }
        if (n2 < cArray.length) {
            this.pw.write(cArray, n2, n);
        }
    }

    public void printDoctype(DocumentType documentType) {
        if (documentType == null) {
            return;
        }
        this.pw.print("<!");
        this.pw.print(DOCTYPE);
        this.pw.print(' ');
        this.pw.print(documentType.getName());
        int n = 0;
        NamedNodeMap namedNodeMap = documentType.getNotations();
        if (namedNodeMap != null) {
            n = namedNodeMap.getLength();
        }
        int n2 = 0;
        while (n2 < n) {
            Notation notation;
            String string;
            if (n2 > 0) {
                this.pw.println();
            }
            if ((string = (notation = (Notation)namedNodeMap.item(n2)).getSystemId()) != null) {
                this.pw.print(SYSTEM);
                this.pw.print(' ');
                this.pw.print(string);
            }
            if ((string = notation.getPublicId()) != null) {
                this.pw.print(PUBLIC);
                this.pw.print(' ');
                this.pw.print(string);
            }
            ++n2;
        }
        this.pw.println('>');
    }

    public void printEmptyElement(String string, NamedNodeMap namedNodeMap) {
        this.printOpenTag(string, namedNodeMap);
        this.pw.print("/>");
        if (this.useFormat) {
            this.pw.println();
        }
    }

    public void printEntityReference(String string) {
        this.pw.print('&');
        this.pw.print(string);
        this.pw.print(';');
    }

    protected void printNormalizedAttrValue(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            switch (c) {
                case '\"': {
                    this.pw.write(cArray, n, n2 - n);
                    n = n2 + 1;
                    this.pw.print("&quot;");
                    break;
                }
                case '\n': {
                    this.pw.write(cArray, n, n2 - n);
                    n = n2 + 1;
                    this.pw.print("&#xA;");
                    break;
                }
            }
            ++n2;
        }
        this.pw.write(cArray, n, n2 - n);
    }

    private void printOpenTag(String string, NamedNodeMap namedNodeMap) {
        this.pw.print('<');
        this.pw.print(string);
        if (namedNodeMap != null) {
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                Attr attr = (Attr)namedNodeMap.item(n);
                String string2 = attr.getValue();
                this.pw.print(' ');
                this.pw.print(attr.getName());
                if (string2 != null) {
                    this.pw.print('=');
                    this.pw.print('\"');
                    this.printNormalizedAttrValue(string2);
                    this.pw.print('\"');
                }
                ++n;
            }
        }
    }

    public void printProcessingInstruction(String string, String string2) {
        this.pw.print(PI_START);
        this.pw.print(string);
        this.pw.print(' ');
        this.pw.print(string2);
        this.pw.print(PI_END);
        if (this.useFormat) {
            this.pw.println();
        }
    }

    public void printStartTag(String string, NamedNodeMap namedNodeMap) {
        this.printOpenTag(string, namedNodeMap);
        this.pw.print('>');
    }

    public void printText(String string) {
        this.printWithXMLEntities(string);
    }

    protected void printUTF8Char(char c) {
        if (c >= '\u0080') {
            this.pw.print("&#");
            this.pw.print((int)c);
            this.pw.print(';');
        } else {
            this.pw.print(c);
        }
    }

    protected void printUTF8Chars(char[] cArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            if (cArray[n3] >= '\u0080') {
                this.pw.write(cArray, n, n2);
                n2 = 0;
                n = n3 + 1;
                this.pw.print("&#");
                this.pw.print((int)cArray[n3]);
                this.pw.print(';');
            } else {
                ++n2;
            }
            ++n3;
        }
        if (n < cArray.length) {
            this.pw.write(cArray, n, n2);
        }
    }

    private void printWithXMLEntities(String string) {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            switch (cArray[n3]) {
                case '&': {
                    this.pw.write(cArray, n2, n);
                    n = 0;
                    n2 = n3 + 1;
                    this.pw.print("&amp;");
                    break;
                }
                case '<': {
                    this.pw.write(cArray, n2, n);
                    n = 0;
                    n2 = n3 + 1;
                    this.pw.print("&lt;");
                    break;
                }
                case '>': {
                    this.pw.write(cArray, n2, n);
                    n = 0;
                    n2 = n3 + 1;
                    this.pw.print("&gt;");
                    break;
                }
                default: {
                    if (cArray[n3] >= '\u0080') {
                        this.pw.write(cArray, n2, n);
                        n = 0;
                        n2 = n3 + 1;
                        this.pw.print("&#");
                        this.pw.print((int)cArray[n3]);
                        this.pw.print(';');
                        break;
                    }
                    ++n;
                }
            }
            ++n3;
        }
        if (n2 < cArray.length) {
            this.pw.write(cArray, n2, n);
        }
    }

    public void printXMLDeclaration(String string, String string2) {
        this.pw.print("<?xml version=\"");
        this.pw.print(string);
        this.pw.print("\"");
        if (string2 != null) {
            this.pw.print(" encoding=\"");
            this.pw.print(string2);
            this.pw.print("\"");
        }
        this.pw.println(PI_END);
    }

    public void setIndentSize(int n) {
        this.indentSize = n;
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(' ');
            ++n2;
        }
        this.indent = stringBuffer.toString();
    }

    public void setUnescapeCDATA(boolean bl) {
        this.unescapeCDATA = bl;
    }

    public void setUseEmptyElementShorthand(boolean bl) {
        this.useEmptyElementShorthand = bl;
    }

    public void setUseFormat(boolean bl) {
        this.useFormat = bl;
    }
}

