/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NumberResult;
import com.kvisco.xsl.ProcessorState;
import java.util.Hashtable;
import org.w3c.dom.Node;

public class MultiplicativeExpr
implements Expr {
    public static final short MULTIPLY = 0;
    public static final short DIVIDE = 1;
    public static final short MODULUS = 2;
    public static final short QUOTIENT = 3;
    private Expr leftExpr = null;
    private Expr rightExpr = null;
    private short op = 0;
    private static Hashtable ops = null;

    static {
        ops = new Hashtable(4);
        ops.put("*", new Short(0));
        ops.put("div", new Short(1));
        ops.put("mod", new Short(2));
        ops.put("quo", new Short(3));
    }

    public MultiplicativeExpr(Expr expr, Expr expr2) {
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public MultiplicativeExpr(Expr expr, Expr expr2, String string) throws InvalidExprException {
        Short s;
        this.op = (short)-1;
        if (string != null && (s = (Short)ops.get(string)) != null) {
            this.op = s;
        }
        if (this.op < 0 || this.op > ops.size()) {
            throw new InvalidExprException("invalid operator for multiplicative expression");
        }
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public MultiplicativeExpr(Expr expr, Expr expr2, short s) throws InvalidExprException {
        this.leftExpr = expr;
        this.rightExpr = expr2;
        if (s < 0 || s > ops.size()) {
            throw new InvalidExprException("invalid operator for multiplicative expression");
        }
        this.op = s;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        double d = 0.0;
        if (this.leftExpr == null || this.rightExpr == null) {
            return new NumberResult(Double.NaN);
        }
        double d2 = this.leftExpr.evaluate(node, processorState).numberValue();
        double d3 = this.rightExpr.evaluate(node, processorState).numberValue();
        switch (this.op) {
            case 0: {
                d = d2 * d3;
                break;
            }
            case 1: {
                d = d2 / d3;
                break;
            }
            case 2: {
                d = d2 % d3;
                break;
            }
            case 3: {
                d = Math.floor(d2 / d3);
                break;
            }
        }
        return new NumberResult(d);
    }

    public short getExprType() {
        return 3;
    }

    public static boolean isMultiplicativeOperator(String string) {
        if (string == null) {
            return false;
        }
        return ops.get(string) != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        stringBuffer.append(" ");
        switch (this.op) {
            case 0: {
                stringBuffer.append("*");
                break;
            }
            case 1: {
                stringBuffer.append("div");
                break;
            }
            case 2: {
                stringBuffer.append("mod");
                break;
            }
            case 3: {
                stringBuffer.append("quo");
                break;
            }
        }
        stringBuffer.append(" ");
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append("null");
        }
        return stringBuffer.toString();
    }
}

