/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.ExpressionParser;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.XSLObject;
import org.w3c.dom.Node;

public class StringExpr
implements Expr {
    public static final char L_CURLY_BRACKET = '{';
    public static final char R_CURLY_BRACKET = '}';
    private Expr expr = null;

    public StringExpr(String string) throws InvalidExprException {
        this.parse(string);
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        if (this.expr != null) {
            ExprResult exprResult = this.expr.evaluate(node, processorState);
            return StringExpr.toStringResult(exprResult);
        }
        return new StringResult("");
    }

    protected Expr getExpr() {
        return this.expr;
    }

    public short getExprType() {
        return 4;
    }

    protected String getValue(Node node, ProcessorState processorState) {
        try {
            return this.evaluate(node, processorState).toString();
        }
        catch (InvalidExprException invalidExprException) {
            return "";
        }
    }

    private void parse(String string) throws InvalidExprException {
        this.expr = ExpressionParser.createExpr(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        if (this.expr != null) {
            stringBuffer.append(this.expr.toString());
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static StringResult toStringResult(ExprResult exprResult) {
        if (exprResult == null) {
            return new StringResult("null");
        }
        switch (exprResult.getResultType()) {
            case 0: 
            case 1: 
            case 4: {
                return new StringResult(exprResult.toString());
            }
            case 3: {
                return (StringResult)exprResult;
            }
            case 2: {
                String string = "";
                NodeSet nodeSet = (NodeSet)exprResult;
                if (nodeSet.size() > 0) {
                    string = XSLObject.getNodeValue(nodeSet.get(0));
                }
                return new StringResult(string);
            }
        }
        return new StringResult("null");
    }
}

