/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.ExpressionParser;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.MatchExpr;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.XSLException;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.XSLStylesheet;
import com.kvisco.xsl.functions.ErrorFunctionCall;
import org.mitre.tjt.xsl.XslNumberFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSLNumber
extends XSLObject {
    private Expr expr = null;
    private MatchExpr count = null;
    private MatchExpr from = null;
    private String level = "single";

    public XSLNumber(XSLStylesheet xSLStylesheet) {
        super(xSLStylesheet, (short)23);
    }

    private static int countPreceedingSiblings(MatchExpr matchExpr, Node node, ProcessorState processorState) throws InvalidExprException {
        int n = 1;
        if (node == null) {
            return 0;
        }
        Node node2 = node;
        while ((node2 = node2.getPreviousSibling()) != null) {
            if (node2.getNodeType() != 1 || !matchExpr.matches(node2, node2, processorState)) continue;
            ++n;
        }
        return n;
    }

    public int[] doNumbering(Element element, ProcessorState processorState) throws InvalidExprException {
        int[] nArray = null;
        if (this.expr != null) {
            nArray = new int[1];
            ExprResult exprResult = this.expr.evaluate(element, processorState);
            double d = this.expr.evaluate(element, processorState).numberValue();
            nArray[0] = (int)d;
            return nArray;
        }
        if (element == null) {
            return new int[0];
        }
        MatchExpr matchExpr = this.count;
        if (matchExpr == null) {
            matchExpr = ExpressionParser.createMatchExpr(element.getNodeName());
        }
        if ("multi".equals(this.level)) {
            NodeSet nodeSet = this.getAncestorsOrSelf(matchExpr, element, processorState, false);
            nArray = new int[nodeSet.size()];
            int n = 0;
            int n2 = nodeSet.size() - 1;
            while (n2 >= 0) {
                nArray[n++] = XSLNumber.countPreceedingSiblings(matchExpr, nodeSet.get(n2), processorState);
                --n2;
            }
        } else if ("any".equals(this.level)) {
            NodeSet nodeSet = this.getAnyPreviousNodes(matchExpr, element, processorState);
            nArray = new int[]{nodeSet.size()};
        } else {
            NodeSet nodeSet = this.getAncestorsOrSelf(matchExpr, element, processorState, true);
            nArray = new int[nodeSet.size()];
            if (nodeSet.size() > 0) {
                nArray[0] = XSLNumber.countPreceedingSiblings(matchExpr, nodeSet.get(0), processorState);
            }
        }
        return nArray;
    }

    private NodeSet getAncestorsOrSelf(MatchExpr matchExpr, Element element, ProcessorState processorState, boolean bl) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        Node node = element;
        while (node != null && node.getNodeType() == 1) {
            if (this.from != null && this.from.matches(node, node, processorState)) break;
            if (matchExpr.matches(node, node, processorState)) {
                nodeSet.add(node);
                if (bl) break;
            }
            node = node.getParentNode();
        }
        return nodeSet;
    }

    private NodeSet getAnyPreviousNodes(MatchExpr matchExpr, Element element, ProcessorState processorState) throws InvalidExprException {
        NodeSet nodeSet = new NodeSet();
        Element element2 = element;
        while (element2 != null) {
            if (this.from != null && this.from.matches(element2, element2, processorState)) {
                return nodeSet;
            }
            if (matchExpr.matches(element2, element2, processorState)) {
                nodeSet.add(element2);
            }
            Node node = element2;
            while ((node = node.getPreviousSibling()) != null) {
                if (node.getNodeType() == 1) break;
            }
            if (node == null) {
                Node node2 = element2.getParentNode();
                if (node2.getNodeType() != 1) break;
                element2 = (Element)node2;
                continue;
            }
            element2 = (Element)node;
        }
        return nodeSet;
    }

    public String getFormattedNumber(Element element, ProcessorState processorState) {
        try {
            int[] nArray = this.doNumbering(element, processorState);
            String string = this.getAttribute("format");
            if (string == null) {
                string = "1";
            }
            return XslNumberFormat.format(nArray, string);
        }
        catch (InvalidExprException invalidExprException) {
            return "";
        }
    }

    public void setAttribute(String string, String string2) throws XSLException {
        ErrorFunctionCall errorFunctionCall = null;
        if ("expr".equals(string)) {
            if (string2 == null) {
                this.expr = null;
            } else {
                try {
                    this.expr = ExpressionParser.createExpr(string2);
                }
                catch (InvalidExprException invalidExprException) {
                    errorFunctionCall = new ErrorFunctionCall();
                    errorFunctionCall.setError("invalid 'expr' attribute of xsl:number" + invalidExprException.getMessage());
                    this.expr = errorFunctionCall;
                }
            }
        } else if ("count".equals(string)) {
            if (string2 == null) {
                this.count = null;
            } else {
                try {
                    this.count = ExpressionParser.createMatchExpr(string2);
                }
                catch (InvalidExprException invalidExprException) {
                    errorFunctionCall = new ErrorFunctionCall();
                    errorFunctionCall.setError("invalid 'count' attribute of xsl:number" + invalidExprException.getMessage());
                    this.expr = errorFunctionCall;
                }
            }
        } else if ("from".equals(string)) {
            if (string2 == null) {
                this.from = null;
            } else {
                try {
                    this.from = ExpressionParser.createMatchExpr(string2);
                }
                catch (InvalidExprException invalidExprException) {
                    errorFunctionCall = new ErrorFunctionCall();
                    errorFunctionCall.setError("invalid 'from' attribute of xsl:number" + invalidExprException.getMessage());
                    this.expr = errorFunctionCall;
                }
            }
        } else if ("level".equals(string)) {
            this.level = string2;
        }
        super.setAttribute(string, string2);
    }

    public void setCountAttr(String string) {
        try {
            this.setAttribute("count", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setFormatAttr(String string) {
        try {
            this.setAttribute("format", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setFromAttr(String string) {
        try {
            this.setAttribute("from", string);
        }
        catch (XSLException xSLException) {}
    }

    public void setLevel(String string) {
        try {
            this.setAttribute("level", string);
        }
        catch (XSLException xSLException) {}
    }
}

