/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Node;

public abstract class FunctionCall
implements Expr {
    public static final String INVALID_NUMBER_PARAMS = "invalid number of parameters for function: ";
    public static final String INVALID_RESULT = "unexpected result for function: ";
    private static String START_PARAMLIST = "(";
    private static String END_PARAMLIST = ")";
    private static String EMPTY_PARAMLIST = "()";
    private static String PARAMETER_SEP = ",";
    private List params = new List();
    String name = "undefined";

    protected FunctionCall(String string) {
        this.name = string;
    }

    public void addExprParameter(Expr expr) {
        this.params.add(expr);
    }

    public abstract ExprResult evaluate(Node var1, ProcessorState var2) throws InvalidExprException;

    public short getExprType() {
        return 0;
    }

    public String getFunctionName() {
        return this.name;
    }

    protected List getParameterList() {
        return this.params;
    }

    public boolean removeExprParameter(Expr expr) {
        return this.params.remove(expr);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getFunctionName());
        stringBuffer.append(START_PARAMLIST);
        int n = 0;
        while (n < this.params.size()) {
            if (n > 0) {
                stringBuffer.append(PARAMETER_SEP);
            }
            stringBuffer.append(this.params.get(n));
            ++n;
        }
        stringBuffer.append(END_PARAMLIST);
        return stringBuffer.toString();
    }
}

