/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */
package com.kvisco.xsl;

import com.kvisco.util.List;

import org.w3c.dom.*;

/**
 * Simple interface for XSL Expressions
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public interface Expr {

    public static short PRIMARY    = 0;
    public static short BOOLEAN    = 1;
    public static short NODE_SET   = 2;
    public static short NUMBER     = 3;
    public static short STRING     = 4;
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Returns the type of Expr this Expr represents
     * @return the type of Expr this Expr represents
    **/
    public short getExprType();
    
    /**
     * Evaluates this Expr using the given context Node and ProcessorState
     * @param context the current context Node
     * @param ps the ProcessorState that contains the current processing 
     * environment
     * @return the ExprResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps)
        throws InvalidExprException;
    
    public String toString();
    
} //-- Expr