/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

/**
 * An interface the represents the result of evaluating an Expr
**/
public interface ExprResult {
    public static final short BOOLEAN         = 0;
    public static final short NUMBER          = 1;
    public static final short NODE_SET        = 2;
    public static final short STRING          = 3;
    public static final short TREE_FRAGMENT   = 4;
    
    /**
     * Returns the value of this ExprResult as a boolean
     * @return the value of this ExprResult as a boolean
    **/
    public boolean booleanValue();
    
    /**
     * Returns the type of result this ExprResult represents
     * @return the type of result this ExprResult represents
    **/
    public short getResultType();
    
    /**
     * Returns true if the given ExprResult is of the same type
     * of this ExprResult, and their values are equal.
     * @return true if the given ExprResult is of the same type
     * of this ExprResult, and their values are equal. otherwise
     * false.
    **/
    public boolean equals(ExprResult exprResult);
    
    /**
     * Returns the value of this ExprResult as a double
     * @return the value of this ExprResult as a double
    **/
    public double numberValue();
    
    /**
     * Returns the Java Object this ExprResult represents
     * @return the Java Object this ExprResult represents
    **/
    public Object toJavaObject();
    
    /**
     * Returns the value of this ExprResult as a String
     * @return the value of this ExprResult as a String
    **/
    public String toString();
    
        
} //-- ExprResult