/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl;

import org.w3c.dom.*;
import java.util.Hashtable;

/**
 * Represents a NodeExpr
 * @author <a href="kvisco@ziplink.net">Keith Visco</a>
**/
public interface NodeExpr extends Expr, MatchExpr {
    
    //public static final short ANCESTOR_EXPR  = 0;
    public static final short ATTRIBUTE_EXPR = 1;
    public static final short ELEMENT_EXPR   = 2;
    public static final short ID_EXPR        = 3;
    public static final short IDENTITY_EXPR  = 4;
    public static final short PARENT_EXPR    = 5;
    public static final short TEXT_EXPR      = 6;
    public static final short COMMENT_EXPR   = 7;
    public static final short PI_EXPR        = 8;
    public static final short WILDCARD_EXPR  = 9;
    
    
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Returns the type of this NodeExpr
     * @return the type of this NodeExpr
    **/
    public short getNodeExprType();
    
    /**
     * Determines if the given node is matched by this MatchExpr with
     * respect to the given context node.
     * @param node the node to determine a match for
     * @param context the Node which represents the current context
     * @param ps the current ProcessorState
     * @return true if the given node is matched by this MatchExpr
    **/
    public boolean matches(Node node, Node context, ProcessorState ps)
        throws InvalidExprException;
    
} //-- NodeExpr