/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The contents of this file are released under an Open Source 
 * Definition (OSD) compliant license; you may not use this file 
 * execpt in compliance with the license. Please see license.txt, 
 * distributed with this file. You may also obtain a copy of the
 * license at http://www.clc-marketing.com/xslp/license.txt
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 *
 * 
 */
 
package com.kvisco.xsl;

import org.w3c.dom.*;

/**
 * Represents the a CDATASection in the XSLStylesheet
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class XSLCData extends XSLObject {
    /**
     * The String data of this XSLCData
    **/
    private StringBuffer data;
    
      //----------------/
     //- Constructors -/
    //----------------/
    
    /**
     * Creates a new XSLCData 
     * @param parentStylesheet the XSL stylesheet that this CDATA
     * will be added to
    **/
    public XSLCData(XSLStylesheet parentStylesheet) {
        super(parentStylesheet, XSLObject.CDATA);
        this.data = new StringBuffer();
    } //-- XSLCData
    
    /**
     * Creates a new XSLCData with the given data
     * @param parentStylesheet the XSL stylesheet that this CDATA
     * will be added to
     * @param data the value of this CDATA section
    **/
    public XSLCData(XSLStylesheet parentStylesheet,String data) {
        this(parentStylesheet);
        this.data.append(data);
    } //-- XSLCData
    
      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Appends the given String to the existing data of
     * this XSLText
     * @param data the String to append
    **/
    public void appendData(String data) {
        this.data.append(data);
    } //-- appendData
    
    /**
     * Retrieves the data of this XSLCData
     * @return the data of this XSLCData
    **/
    public String getData() {
       return data.toString();
    } //-- getData
    
    /**
     * Sets the data of this XSLCData
     * @param data the String to set the data of this XSLCData
     * to.
    **/
    public void setData(String data) {
        this.data = new StringBuffer();
        this.data.append(data);
    } //--setData
    
} //-- XSLCData