/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.List;
import org.w3c.dom.Node;

/**
 * A implementation of the "concat" function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class Concat extends FunctionCall {
    
    /**
     * Creates a new Concat FunctionCall
    **/
    public Concat() {
        super(Names.CONCAT_FN);
    } //-- Concat
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always return a StringResult
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        List params = getParameterList();
        
        if (params.size() < 2)
            throw new InvalidExprException(INVALID_NUMBER_PARAMS+this);
            
        
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.size(); i++) {
            Expr expr = (Expr)params.get(i);
            StringResult strResult =  
                StringExpr.toStringResult(expr.evaluate(context, ps));
            sb.append(strResult.getValue());
        }
        return new StringResult(sb.toString());
    } //-- evaluate
    
} //-- Concat
