/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */

package com.kvisco.xsl.functions;
import com.kvisco.xsl.*;
import com.kvisco.util.List;
import org.w3c.dom.Node;

/**
 * A function to allow invalid expr's to go unnoticed until called. Since
 * XSL:P parses the expressions up front the FunctionCall is useful
 * in saving error messages for a later invocation!
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class ErrorFunctionCall extends FunctionCall {
    
    public static final String ERROR_FN = "invalid-expr-error";
    
    private static final String ERROR_MSG = 
        "An error occured while processing the following expr: ";
       
    
    private String error = "";
    
    /**
     * Creates a new ErrorFunctionCall
    **/
    public ErrorFunctionCall() {
        super(ERROR_FN);
    } //-- ErrorFunctionCall
    
    /**
     * Evalutes this FunctionCall using the given Node as
     * the context. This method will always throw and 
     * InvalidExprException
     * @exception InvalidExprException
    **/
    public ExprResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException
    {
        ExprResult exprResult = null;
        
        StringBuffer errorMsg = new StringBuffer(ERROR_MSG);
        errorMsg.append(error);
        if (true) throw new InvalidExprException(errorMsg.toString());
        
        return exprResult;
    } //-- evaluate
    
    public void setError(String error) {
        this.error = error;
    } //-- setError
    
} //-- ErrorFunctionCall