/*
 * THE AUTHOR MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT.
 *
 * Reuse in whole or part as you please.
 * 
 * Franck Mangin
 * Franck102@yahoo.com
 */

package xslp.formatters;

import java.io.*;
import java.util.Hashtable;

import com.kvisco.xsl.Formatter;
import org.w3c.dom.*;

public class PlainTextFormatter extends Formatter
{
	private static final int TEXT_NL = 0;
	private static final int TEXT_SP = 1;
	private static final int TEXT_TAB = 2;
	
	private Hashtable _tags;
	
	public PlainTextFormatter()
	{
		_tags = new Hashtable();
		_tags.put("text:nl", new Integer(TEXT_NL));
		_tags.put("text:sp", new Integer(TEXT_SP));
		_tags.put("text:tab", new Integer(TEXT_TAB));
	}
	
	public void process(Document doc, PrintWriter out)
	{
		Element root = doc.getDocumentElement();
		NodeList list = root.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			Node node = list.item(i);
			if (node.getNodeType() == Document.ELEMENT_NODE) {
				String tag = ((Element)node).getTagName();
				Integer tagType = (Integer)_tags.get(tag);
				if (tagType != null) {
					switch (tagType.intValue()) {
					case TEXT_NL:
						out.println();
						break;
					case TEXT_SP:
						out.print(' ');
						break;
					case TEXT_TAB:
						out.print('\t');
						break;
					default:
						throw new Error("Internal Error: unknown tag type " + tagType);
					}
				} // else ignore
			} else {
				out.print(node.getNodeValue());
			}
		}
		out.flush();
	}
}
