/* 
 * Apple // emulator for Linux: Common definitions
 *
 * Copyright 1994 Alexander Jean-Claude Bottema
 * Copyright 1995 Stephen Lee
 * Copyright 1997, 1998 Aaron Culliney
 * Copyright 1998, 1999 Michael Deutschmann
 *
 * This software package is subject to the GNU General Public License
 * version 2 or later (your choice) as published by the Free Software 
 * Foundation.
 *
 * THERE ARE NO WARRANTIES WHATSOEVER. 
 *
 */

#ifndef A2_H
#define A2_H

#ifdef _640x400
/* 640x400 mode really isn't what it advertises.  It's really 560x384 with 4
 * extra bytes on each side for color interpolation hack.  This is yet another
 * area where I've traded the optimization gain (especially on older slower
 * machines) for a standard resolution.
 */
#define SCANWIDTH 568
#define SCANHEIGHT 384
#define SCANSTEP SCANWIDTH-12
#else
#define SCANWIDTH 320
#define SCANHEIGHT 200
#define SCANSTEP SCANWIDTH-6
#endif

#ifdef __ASSEMBLY__
#define FLAG(a,b) a ## b
#else
#define FLAG(a,b) b
#endif

#define BANK2		FLAG($,0x10000)
#define RebootSig	FLAG($,0x01)
#define ResetSig	FLAG($,0x02)
#define DebugStepSig	FLAG($,0x04)
#define EnterDebugSig	FLAG($,0x08)


/* Note: These are *not* the bit positions used for the flags in the P 
 * register of a real 6502. Rather, they have been distorted so that C, 
 * V, N and Z match the analogous flags in the _80386_ flags register. 
 *
 * (actually V shouldn't match according to my 386 documentation, but the 
 * code works anyway...) 
 */
#define C_Flag		FLAG($,0x1)		/* 6502 Carry	 	   */
#define X_Flag		FLAG($,0x2)		/* 6502 Xtra		   */
#define I_Flag		FLAG($,0x4)		/* 6502 Interrupt disable  */
#define V_Flag		FLAG($,0x8)		/* 6502 Overflow	   */
#define B_Flag		FLAG($,0x10)		/* 6502 Break		   */
#define D_Flag		FLAG($,0x20)		/* 6502 Decimal mode	   */
#define Z_Flag		FLAG($,0x40)		/* 6502 Zero		   */
#define N_Flag		FLAG($,0x80)		/* 6502 Neg		   */

#define NZ_Flag		FLAG($,0xC0)
#define NZC_Flag	FLAG($,0xC1)
#define NVZC_Flag	FLAG($,0xC9)
#define NV_Flag		FLAG($,0x88)

#define C_Flag_Not	FLAG($,0xFE)
#define Z_Flag_Not      FLAG($,0xBF)
#define NZ_Flag_Not	FLAG($,0x3F)
#define NZC_Flag_Not	FLAG($,0x3E)
#define NVZC_Flag_Not	FLAG($,0x36)
#define NVZ_Flag_Not	FLAG($,0x37)
#define NV_Flag_Not	FLAG($,0x77)

#define C_Flag_Bit	FLAG($,8)		/* 6502 Carry		   */
#define X_Flag_Bit	FLAG($,9)		/* 6502 Xtra		   */
#define I_Flag_Bit	FLAG($,10)		/* 6502 Interrupt disable  */
#define V_Flag_Bit	FLAG($,11)		/* 6502 Overflow	   */
#define B_Flag_Bit	FLAG($,12)		/* 6502 Break		   */
#define D_Flag_Bit	FLAG($,13)		/* 6502 Decimal mode	   */
#define Z_Flag_Bit	FLAG($,14)		/* 6502 Zero		   */
#define N_Flag_Bit	FLAG($,15)		/* 6502 Neg		   */

#define X_Reg		%bl			/* 6502 X register in %bl  */
#define Y_Reg		%bh			/* 6502 Y register in %bh  */
#define A_Reg		%cl			/* 6502 A register in %cl  */
#define F_Reg		%ch			/* 6502 flags in %ch	   */
#define FF_Reg		%ecx			/* 6502 flags for bt	   */
#define SP_Reg		%edx			/* 6502 Stack pointer	   */
#define SP_Reg_L	%dl			/* 6502 Stack pointer low  */
#define SP_Reg_H	%dh			/* 6502 Stack pointer high */
#define PC_Reg		%si			/* 6502 Program Counter    */
#define PC_Reg_E	%esi			/* 6502 Program Counter    */
#define EffectiveAddr	%di			/* Effective address	   */
#define EffectiveAddr_E	%edi			/* Effective address	   */

#ifndef __ASSEMBLY__

#ifdef APPLE_IIE
void		*table_65c02_opcodes[256];
#endif

void		*table_6502_undoc_opcodes[256];
void 		*table_6502_opcodes[256];

unsigned char	read_keyboard();

void		cpu65x02(),
		update_video_screen(),
		ram_nop(),

		write_ram_default(),
		write_unmapped_softswitch(),
		write_ram_text_page0(),
		write_ram_text_mixed0(),
		write_ram_text_page1(),
		write_ram_text_mixed1(),
		write_ram_hires_page0_even(),
		write_ram_hires_page0_odd(),
		write_ram_hires_mixed0_even(),
		write_ram_hires_mixed0_odd(),
		write_ram_hires_page1_even(),
		write_ram_hires_page1_odd(),
		write_ram_hires_mixed1_even(),
		write_ram_hires_mixed1_odd(),

		read_ram_default(),
		read_random(),
		read_unmapped_softswitch(),
		read_keyboard_strobe(),
		read_speaker_toggle_pc(),
		read_switch_primary_page(),
		read_switch_secondary_page(),
		read_switch_graphics(),
		read_switch_text(),
		read_switch_no_mixed(),
		read_switch_mixed(),
		read_switch_lores(),
		read_switch_hires(),

		read_button0(),
		read_button1(),
		read_button2(),
		read_gc0(),
		read_gc1(),
		read_gc_strobe(),
    
		lc_c080(),
		lc_c081(),
		lc_c082(),
		lc_c083(),
		lc_c088(),
		lc_c089(),
		lc_c08a(),
		lc_c08b(),
		write_ram_bank(),
		read_ram_bank(),
		write_ram_lc(),
		read_ram_lc();

#ifdef APPLE_IIE
void		iie_write_ram_default(),
		iie_read_ram_default(),

		/* //e text pages */
		iie_read_ram_text_page0(),
		iie_write_ram_text_page0(),
		iie_write_ram_text_mixed0(),
		iie_read_screen_hole_text_page0(),
		iie_write_screen_hole_text_page0(),
		iie_write_ram_text_page1(),
		iie_write_ram_text_mixed1(),

		/* //e hires page 0 */
		iie_read_ram_hires_page0(),
		iie_write_ram_hires_page0_odd(),
		iie_write_ram_hires_page0_even(),
		iie_write_ram_hires_mixed0_odd(),
		iie_write_ram_hires_mixed0_even(),
		iie_read_screen_hole_hires_page0(),
		iie_write_screen_hole_hires_page0(),

		/* //e hires page 1 */
		iie_write_ram_hires_page1_odd(),
		iie_write_ram_hires_page1_even(),
		iie_write_ram_hires_mixed1_odd(),
		iie_write_ram_hires_mixed1_even(),

		/* //e zpage,stack, ram banks */
		iie_read_ram_zpage_and_stack(),
		iie_write_ram_zpage_and_stack(),
		iie_read_ram_lc(),
		iie_write_ram_lc(),
		iie_read_ram_bank(),
		iie_write_ram_bank(),
		iie_read_slot3(),
		iie_read_slot6(),
		iie_read_slotx(),
		iie_read_slot_expansion(),
		iie_disable_slot_expansion(),
		iie_read_gc2(),
		iie_read_gc3(),

		/* //e toggle softswitches */
		iie_ramrd_main(),
		iie_ramrd_aux(),
		iie_ramwrt_main(),
		iie_ramwrt_aux(),
		iie_80store_off(),
		iie_80store_on(),
		iie_altzp_main(),
		iie_altzp_aux(),
		iie_80col_off(),
		iie_80col_on(),
		iie_altchar_off(),
		iie_altchar_on(),
		iie_c3rom_peripheral(),
		iie_c3rom_internal(),
		iie_cxrom_peripheral(),
		iie_cxrom_internal(),
		iie_ioudis_on(),
		iie_ioudis_off(),
		iie_dhires_on(),
		iie_dhires_off(),
		iie_hires_off(),
		iie_hires_on(),
		iie_page2_on(),
		iie_page2_off(),

		/* //e check softswitche settings */
		iie_check_80store(),
		iie_check_bank(),
		iie_check_lcram(),
		iie_check_ramrd(),
		iie_check_ramwrt(),
		iie_check_altzp(),
		iie_check_c3rom(),
		iie_check_cxrom(),
		iie_check_80col(),
		iie_check_altchar(),
		iie_check_text(),
		iie_check_mixed(),
		iie_check_hires(),
		iie_check_page2(),
		iie_check_ioudis(),
		iie_check_dhires(),
		iie_check_vbl();

/* debugger hooks */
void do_step();
void do_write_memory();
void do_write_lc();

#endif/* __ASSEMBLY__ */

#endif/* APPLE_IIE */
#endif/* A2_H */
