/*
 * zfile.h - Transparent handling of compressed files.
 *
 * Written by
 *  Ettore Perazzoli (ettore@comm2000.it)
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef _ZFILE_H
#define _ZFILE_H

#ifdef STDC_HEADERS
#ifndef __riscos
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#endif
#include <stdio.h>
#endif

#if defined(WIN32) || defined(WINCE) || defined(__riscos)
#ifndef _MODE_T_
typedef int mode_t;
#endif
#endif

#ifdef OS2
#include <string.h>
#endif

file_desc_t zopen(const char *name, mode_t mode, int flags);
int zclose(file_desc_t fd);
FILE *zfopen(const char *name, const char *mode);
int zfclose(FILE *stream);
int zclose_all(void);

#endif /* _ZFILE_H */
